/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class SpeculatingPartition
extends AbstractPartition {
    private final @NonNull Set<@NonNull Node> tracedInputNodes = new HashSet<Node>();

    public SpeculatingPartition(@NonNull MappingPartitioner partitioner) {
        super(partitioner);
        this.resolveTraceNodes();
        this.resolvePredicatedMiddleNodes();
        this.resolvePredicatedOutputNodes();
        this.resolveMatchedPredicatedEdges();
        this.resolveRealizedEdges();
        this.resolveTrueNodes();
        this.resolvePrecedingNodes();
        this.resolveDisambiguations();
        this.resolveEdges();
    }

    private boolean isDownstreamFromCorrolary(@NonNull Node node) {
        if (this.isCorrolary(node)) {
            return true;
        }
        if (node.isOperation()) {
            boolean allReachable = true;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                Node sourceNode;
                if (!edge.isComputation() || !this.isDownstreamFromCorrolary(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge))) continue;
                allReachable = false;
                break;
            }
            if (allReachable) {
                return false;
            }
        }
        for (Node precedingNode : this.getPredecessors(node)) {
            if (this.isDownstreamFromCorrolary(precedingNode)) continue;
            return false;
        }
        return true;
    }

    private boolean isLocalCorrolary(@NonNull Node node) {
        assert (node.isRealized());
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            List<MappingRegion> corrolaryOfRegions;
            if (!edge.isRealized() || !edge.isNavigation() || this.partitioner.isCyclic(QVTscheduleUtil.getSourceNode((Edge)edge)) || (corrolaryOfRegions = this.partitioner.getCorrolaryOf(edge)) == null || corrolaryOfRegions.size() != 1 || !corrolaryOfRegions.contains(this.region)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Object edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED && this.partitioner.hasRealizedEdge(edge)) {
            edgeRole = edge.getEdgeTarget().isConstant() ? null : Role.PREDICATED;
        }
        return edgeRole;
    }

    protected void resolveMatchedPredicatedEdges() {
        for (Edge edge : this.partitioner.getPredicatedEdges()) {
            Node targetNode;
            Node sourceNode;
            if (!edge.isMatched() || this.partitioner.hasPredicatedEdge(edge) || this.partitioner.getCorrolaryOf(edge) != null || (sourceNode = edge.getEdgeSource()).isRealized() || (targetNode = edge.getEdgeTarget()).isRealized()) continue;
            if (!this.hasNode(sourceNode)) {
                this.addNode(sourceNode, QVTscheduleUtil.getNodeRole((Node)sourceNode));
            }
            if (this.hasNode(targetNode)) continue;
            this.addNode(targetNode, QVTscheduleUtil.getNodeRole((Node)targetNode));
        }
    }

    protected void resolvePredicatedMiddleNodes() {
        for (Node node : this.partitioner.getPredicatedMiddleNodes()) {
            if (this.hasNode(node) || !node.isMatched() || !this.partitioner.isCyclic(node)) continue;
            Role nodeRole = QVTscheduleUtil.getNodeRole((Node)node);
            if (node.isPattern() && node.isClass()) {
                nodeRole = QVTscheduleUtil.asSpeculated((Role)nodeRole);
            }
            this.addNode(node, QVTscheduleUtil.asSpeculated((Role)nodeRole));
        }
    }

    protected void resolvePredicatedOutputNodes() {
        for (Node node : this.partitioner.getPredicatedOutputNodes()) {
            if (this.hasNode(node) || this.isCorrolary(node) || this.isDownstreamFromCorrolary(node)) continue;
            this.addNode(node, QVTscheduleUtil.getNodeRole((Node)node));
        }
    }

    protected void resolveRealizedEdges() {
        for (Edge edge : this.partitioner.getRealizedEdges()) {
            Node targetNode;
            Node sourceNode;
            if (this.partitioner.hasRealizedEdge(edge) || this.partitioner.getCorrolaryOf(edge) != null || (sourceNode = edge.getEdgeSource()).isRealized() && !this.isLocalCorrolary(sourceNode) || (targetNode = edge.getEdgeTarget()).isRealized()) continue;
            if (!this.hasNode(sourceNode)) {
                this.addNode(sourceNode, QVTscheduleUtil.getNodeRole((Node)sourceNode));
            }
            if (this.hasNode(targetNode)) continue;
            this.addNode(targetNode, QVTscheduleUtil.getNodeRole((Node)targetNode));
        }
    }

    protected void resolveTraceNodes() {
        Iterable<@NonNull Node> traceNodes = this.partitioner.getTraceNodes();
        for (Node traceNode : traceNodes) {
            this.addNode(traceNode, Role.SPECULATED);
        }
        for (Node traceNode : traceNodes) {
            for (NavigableEdge edge : traceNode.getNavigationEdges()) {
                if (!this.partitioner.hasRealizedEdge((Edge)edge)) continue;
                this.tracedInputNodes.add(edge.getEdgeTarget());
            }
            Node statusNode = this.partitioner.getStatusNode(traceNode);
            if (statusNode == null) continue;
            this.addNode(statusNode, Role.REALIZED);
        }
    }
}

