/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class TraceClassAnalysis {
    protected final @NonNull TransformationPartitioner transformationPartitioner;
    protected final @NonNull CompleteClass traceClass;
    private final @NonNull List<@NonNull MappingPartitioner> consumers = new ArrayList<MappingPartitioner>();
    private final @NonNull List<@NonNull MappingPartitioner> producers = new ArrayList<MappingPartitioner>();
    private @Nullable List<@NonNull Property> discriminatingProperties = null;
    private @NonNull List<@NonNull TraceClassAnalysis> subTraceClassAnalyses = new ArrayList<TraceClassAnalysis>();
    private @NonNull List<@NonNull TraceClassAnalysis> superTraceClassAnalyses = new ArrayList<TraceClassAnalysis>();

    public TraceClassAnalysis(@NonNull TransformationPartitioner transformationPartitioner, @NonNull CompleteClass traceClass) {
        this.transformationPartitioner = transformationPartitioner;
        this.traceClass = traceClass;
        this.subTraceClassAnalyses.add(this);
        this.superTraceClassAnalyses.add(this);
    }

    public void addConsumer(@NonNull MappingPartitioner consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public void addProducer(@NonNull MappingPartitioner producer) {
        if (!this.producers.contains(producer)) {
            this.producers.add(producer);
        }
    }

    public void addSubTraceClassAnalysis(@NonNull TraceClassAnalysis traceClassAnalysis) {
        if (!this.subTraceClassAnalyses.contains(traceClassAnalysis)) {
            this.subTraceClassAnalyses.add(traceClassAnalysis);
        }
    }

    public void addSuperTraceClassAnalysis(@NonNull TraceClassAnalysis traceClassAnalysis) {
        if (!this.superTraceClassAnalyses.contains(traceClassAnalysis)) {
            this.superTraceClassAnalyses.add(traceClassAnalysis);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void discriminate() throws CompilerChainException {
        if (this.producers.size() <= 1) {
            TransformationPartitioner.DISCRIMINATION.println("Not required for " + this);
            return;
        }
        HashMap<@NonNull MappingPartitioner, @NonNull HashMap<@NonNull K, @NonNull V>> partitioner2property2edge = new HashMap();
        HashSet<@NonNull E> commonProperties = null;
        for (MappingPartitioner producer : this.producers) {
            HashMap<@NonNull Property, @NonNull Iterator<Object>> property2edge = new HashMap<Property, Iterator<Object>>();
            partitioner2property2edge.put(producer, property2edge);
            for (Node traceNode : producer.getTraceNodes()) {
                for (Iterator<Object> edge : traceNode.getRealizedNavigationEdges()) {
                    if (edge.getEdgeTarget().isRealized()) continue;
                    property2edge.put(QVTscheduleUtil.getProperty(edge), edge);
                }
            }
            Set partionerProperties = property2edge.keySet();
            if (commonProperties == null) {
                commonProperties = new HashSet(partionerProperties);
                continue;
            }
            commonProperties.retainAll(partionerProperties);
        }
        if (commonProperties == null || commonProperties.isEmpty()) {
            TransformationPartitioner.DISCRIMINATION.println("No common properties to disambiguate " + this);
            return;
        }
        ArrayList<@NonNull E> sortedProperties = new ArrayList(commonProperties);
        Collections.sort(sortedProperties, NameUtil.NAMEABLE_COMPARATOR);
        HashMap<@NonNull Property, @Nullable HashMap<@Nullable K, @NonNull @NonNull V>> property2completeClass2partitioners = new HashMap();
        for (Property property : sortedProperties) {
            for (MappingPartitioner producer : this.producers) {
                Node targetNode;
                CompleteClass completeClass;
                ArrayList<MappingPartitioner> partitioners;
                @NonNull @NonNull Map property2edge = (Map)partitioner2property2edge.get(producer);
                assert (property2edge != null);
                NavigableEdge edge = (NavigableEdge)property2edge.get(property);
                if (edge == null) {
                    property2completeClass2partitioners.put(property, null);
                    continue;
                }
                HashMap<@Nullable CompleteClass, @NonNull ArrayList<@NonNull MappingPartitioner>> completeClass2partitioners = (HashMap<CompleteClass, ArrayList<MappingPartitioner>>)property2completeClass2partitioners.get(property);
                if (completeClass2partitioners == null) {
                    completeClass2partitioners = new HashMap<CompleteClass, ArrayList<MappingPartitioner>>();
                    property2completeClass2partitioners.put(property, completeClass2partitioners);
                }
                if ((partitioners = (ArrayList<MappingPartitioner>)completeClass2partitioners.get(completeClass = (targetNode = QVTscheduleUtil.getTargetNode((Edge)edge)).isExplicitNull() ? null : targetNode.getCompleteClass())) == null) {
                    partitioners = new ArrayList<MappingPartitioner>();
                    completeClass2partitioners.put(completeClass, partitioners);
                }
                partitioners.add(producer);
            }
        }
        int bestSize = 0;
        Property bestProperty = null;
        for (Property property : property2completeClass2partitioners.keySet()) {
            int size;
            @Nullable @NonNull @NonNull Map completeClass2partitioners = (Map)property2completeClass2partitioners.get(property);
            if (completeClass2partitioners == null || (size = completeClass2partitioners.size()) <= bestSize) continue;
            bestSize = size;
            bestProperty = property;
        }
        if (TransformationPartitioner.DISCRIMINATION.isActive()) {
            StringBuilder s = new StringBuilder();
            s.append("property->completeClass->partitioners");
            for (Property property : property2completeClass2partitioners.keySet()) {
                s.append("\n\t" + property);
                @Nullable @NonNull @NonNull Map completeClass2partitioners = (Map)property2completeClass2partitioners.get(property);
                if (completeClass2partitioners == null) continue;
                for (CompleteClass completeClass : completeClass2partitioners.keySet()) {
                    s.append("\n\t\t" + completeClass);
                    @NonNull List partitioners = (List)completeClass2partitioners.get(completeClass);
                    assert (partitioners != null);
                    for (MappingPartitioner mappingPartitioner : partitioners) {
                        s.append("\n\t\t\t" + mappingPartitioner);
                    }
                }
            }
            TransformationPartitioner.DISCRIMINATION.println(s.toString());
        }
        if (bestProperty != null) {
            TransformationPartitioner.DISCRIMINATION.println("Best property : " + bestProperty);
            this.discriminatingProperties = Collections.singletonList(bestProperty);
            return;
        }
        throw new CompilerChainException("Unable to disambiguate " + this, new Object[0]);
    }

    public @NonNull Iterable<@NonNull MappingPartitioner> getConsumers() {
        return this.consumers;
    }

    public @Nullable Iterable<@NonNull Property> getDiscriminatingProperties() {
        return this.discriminatingProperties;
    }

    public @NonNull Iterable<@NonNull MappingPartitioner> getProducers() {
        return this.producers;
    }

    public @NonNull Iterable<@NonNull TraceClassAnalysis> getSubTraceClassAnalyses() {
        return this.subTraceClassAnalyses;
    }

    public @NonNull Iterable<@NonNull TraceClassAnalysis> getSuperTraceClassAnalyses() {
        return this.superTraceClassAnalyses;
    }

    public @NonNull CompleteClass getTraceClass() {
        return this.traceClass;
    }

    public boolean isCyclic() {
        for (TraceClassAnalysis subTraceClassAnalysis : this.subTraceClassAnalyses) {
            if (this.transformationPartitioner.getCycleAnalysis(subTraceClassAnalysis) == null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.traceClass.toString();
    }
}

