/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.qvtd.runtime.evaluation.AbstractInvocation;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationConstructor;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;

public abstract class AbstractInvocationConstructor
implements InvocationConstructor {
    protected final @NonNull Interval interval;
    protected final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IdResolver.IdResolverExtension idResolver;
    protected final @NonNull String name;
    protected final boolean isStrict;
    private final @NonNull Map<@NonNull Integer, @NonNull Object> hashCode2invocations = new HashMap<Integer, Object>();
    private int valuesCount = 0;
    private Consumer firstConsumer = null;
    private Appender firstAppender = null;
    private @NonNull Object[] values = null;
    private boolean propagating = false;
    private boolean repropagate = false;

    protected AbstractInvocationConstructor(@NonNull InvocationManager invocationManager, @NonNull String name, boolean isStrict) {
        this.interval = invocationManager.createInterval();
        Executor executor = invocationManager.getExecutor();
        this.idResolver = (IdResolver.IdResolverExtension)executor.getIdResolver();
        this.name = name;
        this.isStrict = isStrict;
        invocationManager.addInvoker(this);
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitInvocationConstructor(this);
    }

    @Override
    public synchronized void addAppendedConnection(@NonNull Connection connection) {
        assert (this.values == null);
        connection.addAppender(this);
        if (this.firstAppender != null) {
            this.firstAppender.appendAppender(this.valuesCount, connection);
        } else {
            this.firstAppender = new Appender(this.valuesCount, connection);
        }
        ++this.valuesCount;
    }

    @Override
    public synchronized void addConsumedConnection(@NonNull Connection connection) {
        assert (this.values == null);
        connection.addConsumer(this);
        if (this.firstConsumer != null) {
            this.firstConsumer.appendConsumer(this.valuesCount, connection);
        } else {
            this.firstConsumer = new Consumer(this, this.valuesCount, 0, connection);
        }
        connection.queue();
        ++this.valuesCount;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public synchronized void destroy(@NonNull AbstractInvocation.Incremental invocation, int invocationHashCode) {
        Object zeroOrMoreInvocations = this.hashCode2invocations.get(invocationHashCode);
        if (zeroOrMoreInvocations instanceof Invocation) {
            Invocation oneInvocation = (Invocation)zeroOrMoreInvocations;
            if (oneInvocation == invocation) {
                this.hashCode2invocations.remove(invocationHashCode);
            }
        } else if (zeroOrMoreInvocations instanceof List) {
            @NonNull @NonNull List zeroOrMoreInvocations2 = (List)zeroOrMoreInvocations;
            zeroOrMoreInvocations2.remove(invocation);
            if (zeroOrMoreInvocations2.size() == 1) {
                this.hashCode2invocations.put(invocationHashCode, zeroOrMoreInvocations2.get(0));
            }
        }
    }

    @Override
    public @NonNull Interval getInterval() {
        return this.interval;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Iterable<@NonNull Invocation> debugGetInvocations() {
        ArrayList<@NonNull Invocation> allInvocations = new ArrayList<Invocation>();
        for (Object zeroOrMoreInvocations : this.hashCode2invocations.values()) {
            if (zeroOrMoreInvocations instanceof Invocation) {
                allInvocations.add((Invocation)zeroOrMoreInvocations);
                continue;
            }
            if (!(zeroOrMoreInvocations instanceof List)) continue;
            @NonNull @NonNull List zeroOrMoreInvocations2 = (List)zeroOrMoreInvocations;
            allInvocations.addAll(zeroOrMoreInvocations2);
        }
        return allInvocations;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Invocation invoke(Object ... argValues) {
        Invocation theInvocation;
        if (this.isStrict) {
            int invocationHashCode = 0;
            Object[] objectArray = argValues;
            int n = argValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object argValue = objectArray[n2];
                invocationHashCode = 3 * invocationHashCode + this.idResolver.oclHashCode(argValue);
                ++n2;
            }
            Map<Integer, Object> map = this.hashCode2invocations;
            synchronized (map) {
                Object zeroOrMoreInvocations = this.hashCode2invocations.get(invocationHashCode);
                Invocation oneInvocation = null;
                ArrayList<Invocation> twoOrMoreInvocations = null;
                if (zeroOrMoreInvocations instanceof Invocation) {
                    oneInvocation = (Invocation)zeroOrMoreInvocations;
                    if (oneInvocation.isEqual((IdResolver)this.idResolver, argValues)) {
                        return oneInvocation;
                    }
                } else if (zeroOrMoreInvocations instanceof List) {
                    ArrayList<Invocation> zeroOrMoreInvocations2;
                    twoOrMoreInvocations = zeroOrMoreInvocations2 = (ArrayList<Invocation>)zeroOrMoreInvocations;
                    for (Invocation anInvocation : zeroOrMoreInvocations2) {
                        if (!anInvocation.isEqual((IdResolver)this.idResolver, argValues)) continue;
                        return anInvocation;
                    }
                }
                theInvocation = this.newInstance(invocationHashCode, argValues);
                if (zeroOrMoreInvocations == null) {
                    this.hashCode2invocations.put(invocationHashCode, theInvocation);
                } else if (twoOrMoreInvocations == null) {
                    twoOrMoreInvocations = new ArrayList<Invocation>(4);
                    assert (oneInvocation != null);
                    twoOrMoreInvocations.add(oneInvocation);
                    twoOrMoreInvocations.add(theInvocation);
                    this.hashCode2invocations.put(invocationHashCode, twoOrMoreInvocations);
                } else {
                    twoOrMoreInvocations.add(theInvocation);
                }
            }
        } else {
            theInvocation = this.newInstance(argValues);
        }
        this.interval.queue(theInvocation);
        return theInvocation;
    }

    protected void invoked(@NonNull Invocation invocation) {
        if (this.firstConsumer != null) {
            this.firstConsumer.invoked(invocation);
        }
    }

    @Override
    public boolean isStrict() {
        return this.isStrict;
    }

    protected abstract @NonNull Invocation newInstance(@NonNull Object @NonNull [] var1);

    protected @NonNull Invocation newInstance(int invocationHashCode, @NonNull Object @NonNull [] values) {
        return this.newInstance(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate() {
        AbstractInvocationConstructor abstractInvocationConstructor;
        @NonNull Object[] values2 = this.values;
        if (values2 == null) {
            abstractInvocationConstructor = this;
            synchronized (abstractInvocationConstructor) {
                values2 = this.values;
                if (values2 == null) {
                    this.values = new Object[this.valuesCount];
                    values2 = this.values;
                    if (this.firstAppender != null) {
                        this.firstAppender.propagate(values2);
                    }
                }
            }
        }
        abstractInvocationConstructor = this;
        synchronized (abstractInvocationConstructor) {
            if (this.propagating) {
                this.repropagate = true;
                return;
            }
            this.propagating = true;
        }
        do {
            this.repropagate = false;
            if (!this.firstConsumer.computeWork()) continue;
            this.firstConsumer.propagateHere(0, values2);
            this.firstConsumer.didWork();
        } while (this.repropagate);
        this.propagating = false;
    }

    public @NonNull String toString() {
        return this.getName();
    }

    private static class Appender
    extends Binder {
        private @Nullable Appender nextAppender = null;

        protected Appender(int valueIndex, @NonNull Connection connection) {
            super(valueIndex, connection);
        }

        public void appendAppender(int valueIndex, @NonNull Connection connection) {
            Appender nextAppender2 = this.nextAppender;
            if (nextAppender2 != null) {
                nextAppender2.appendAppender(valueIndex, connection);
            } else {
                this.nextAppender = new Appender(valueIndex, connection);
            }
        }

        public void propagate(@NonNull Object @NonNull [] values) {
            values[this.valueIndex] = this.connection;
            Appender nextAppender2 = this.nextAppender;
            if (nextAppender2 != null) {
                nextAppender2.propagate(values);
            }
        }

        public String toString() {
            return "?/" + this.valueIndex;
        }
    }

    private static abstract class Binder {
        protected final int valueIndex;
        protected final @NonNull Connection connection;

        protected Binder(int valueIndex, @NonNull Connection connection) {
            this.valueIndex = valueIndex;
            this.connection = connection;
        }
    }

    private static class Consumer
    extends Binder {
        protected final @NonNull AbstractInvocationConstructor invocationConstructor;
        protected final int consumerIndex;
        private int previouslyConsumedIndex = 0;
        private int targetConsumedIndex = 0;
        private int currentConsumedIndex = 0;
        private @Nullable Consumer nextConsumer = null;

        protected Consumer(@NonNull AbstractInvocationConstructor invocationConstructor, int valueIndex, int consumerIndex, @NonNull Connection connection) {
            super(valueIndex, connection);
            this.invocationConstructor = invocationConstructor;
            assert (consumerIndex >= 0);
            assert (consumerIndex <= valueIndex);
            this.consumerIndex = consumerIndex;
        }

        public void appendConsumer(int valueIndex, @NonNull Connection connection) {
            assert (this.targetConsumedIndex == 0);
            Consumer nextConsumer2 = this.nextConsumer;
            if (nextConsumer2 != null) {
                nextConsumer2.appendConsumer(valueIndex, connection);
            } else {
                this.nextConsumer = new Consumer(this.invocationConstructor, valueIndex, this.consumerIndex + 1, connection);
            }
        }

        public boolean computeWork() {
            this.targetConsumedIndex = this.connection.getCapacity();
            boolean hasWork = this.previouslyConsumedIndex < this.targetConsumedIndex;
            Consumer nextConsumer2 = this.nextConsumer;
            if (nextConsumer2 != null && nextConsumer2.computeWork()) {
                hasWork = true;
            }
            return hasWork;
        }

        public void didWork() {
            this.previouslyConsumedIndex = this.targetConsumedIndex;
            Consumer nextConsumer2 = this.nextConsumer;
            if (nextConsumer2 != null) {
                nextConsumer2.didWork();
            }
        }

        public void invoked(@NonNull Invocation invocation) {
            Consumer nextConsumer2;
            if (this.connection instanceof Connection.Incremental) {
                ((Connection.Incremental)this.connection).consume(this.currentConsumedIndex, invocation);
            }
            if ((nextConsumer2 = this.nextConsumer) != null) {
                nextConsumer2.invoked(invocation);
            }
        }

        public boolean propagateHere(int partialConsumerIndex, @NonNull Object @NonNull [] values) {
            boolean didInvoke = false;
            if (partialConsumerIndex < this.consumerIndex) {
                this.currentConsumedIndex = 0;
                while (this.currentConsumedIndex < this.targetConsumedIndex) {
                    didInvoke |= this.propagateNext(partialConsumerIndex, values).booleanValue();
                    ++this.currentConsumedIndex;
                }
            } else if (partialConsumerIndex == this.consumerIndex) {
                if (this.nextConsumer != null) {
                    this.currentConsumedIndex = 0;
                    while (this.currentConsumedIndex < this.previouslyConsumedIndex) {
                        Boolean didDownstreamInvoke = this.propagateNext(partialConsumerIndex + 1, values);
                        if (didDownstreamInvoke != null) {
                            if (!didDownstreamInvoke.booleanValue()) break;
                            didInvoke = true;
                        }
                        ++this.currentConsumedIndex;
                    }
                }
                this.currentConsumedIndex = this.previouslyConsumedIndex;
                while (this.currentConsumedIndex < this.targetConsumedIndex) {
                    didInvoke |= this.propagateNext(partialConsumerIndex, values).booleanValue();
                    ++this.currentConsumedIndex;
                }
            } else assert (false);
            return didInvoke;
        }

        private @Nullable Boolean propagateNext(int partialConsumerIndex, @NonNull Object @NonNull [] values) {
            Object value = this.connection.getValue(this.currentConsumedIndex);
            if (value == null) {
                return null;
            }
            values[this.valueIndex] = value;
            Consumer nextConsumer2 = this.nextConsumer;
            if (nextConsumer2 != null) {
                return nextConsumer2.propagateHere(partialConsumerIndex, values);
            }
            Invocation invocation = this.invocationConstructor.invoke(values);
            this.invocationConstructor.invoked(invocation);
            return true;
        }

        public String toString() {
            return String.valueOf(this.consumerIndex) + "/" + this.valueIndex + " " + this.previouslyConsumedIndex + "/" + this.currentConsumedIndex + "/" + this.targetConsumedIndex;
        }
    }

    public static abstract class Incremental
    extends AbstractInvocationConstructor
    implements InvocationConstructor.Incremental {
        protected int sequence = 0;
        private final @NonNull List<@NonNull Connection.Incremental> consumedConnections = new ArrayList<Connection.Incremental>();

        public Incremental(@NonNull InvocationManager invocationManager, @NonNull String name) {
            super(invocationManager, name, true);
        }

        @Override
        public synchronized void addConsumedConnection(@NonNull Connection.Incremental connection) {
            this.consumedConnections.add(connection);
            super.addConsumedConnection(connection);
        }

        @Override
        public @NonNull List<@NonNull Connection.Incremental> getConsumedConnections() {
            return this.consumedConnections;
        }

        @Override
        protected final @NonNull Invocation newInstance(@NonNull Object @NonNull [] values) {
            throw new IllegalStateException("Incremental invocations require an invocationHashCode.");
        }

        @Override
        public int nextSequence() {
            return this.sequence++;
        }
    }
}

