/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class RegionsAnalysis<@NonNull RA extends PartialRegionAnalysis<@NonNull RA>>
extends QVTbaseHelper
implements Nameable {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull Property oclContainerProperty;
    private final @NonNull Map<@NonNull ClassDatum, @NonNull TraceClassAnalysis<@NonNull RA>> classDatum2traceClassAnalysis = new HashMap<ClassDatum, TraceClassAnalysis<RA>>();
    private final @NonNull Map<@NonNull PropertyDatum, @NonNull TracePropertyAnalysis<@NonNull RA>> propertyDatum2tracePropertyAnalysis = new HashMap<PropertyDatum, TracePropertyAnalysis<RA>>();

    protected RegionsAnalysis(@NonNull ScheduleManager scheduleManager) {
        super(scheduleManager.getEnvironmentFactory());
        this.scheduleManager = scheduleManager;
        this.oclContainerProperty = scheduleManager.getStandardLibraryHelper().getOclContainerProperty();
    }

    public @NonNull TraceClassAnalysis<@NonNull RA> addConsumer(@NonNull ClassDatum classDatum, @NonNull RA consumer) {
        TraceClassAnalysis<@NonNull RA> traceClassAnalysis = this.lazyCreateTraceClassAnalysis(classDatum);
        traceClassAnalysis.addConsumer(consumer);
        return traceClassAnalysis;
    }

    public @NonNull TracePropertyAnalysis<@NonNull RA> addConsumer(@NonNull PropertyDatum tracePropertyDatum, @NonNull RA consumer) {
        TracePropertyAnalysis<@NonNull RA> tracePropertyAnalysis = this.lazyCreateTracePropertyAnalysis(tracePropertyDatum);
        tracePropertyAnalysis.addConsumer(consumer);
        return tracePropertyAnalysis;
    }

    public @NonNull TraceClassAnalysis<@NonNull RA> addProducer(@NonNull ClassDatum classDatum, @NonNull RA producer) {
        TraceClassAnalysis<@NonNull RA> traceClassAnalysis = this.lazyCreateTraceClassAnalysis(classDatum);
        traceClassAnalysis.addProducer(producer);
        return traceClassAnalysis;
    }

    public @NonNull TracePropertyAnalysis<@NonNull RA> addProducer(@NonNull PropertyDatum tracePropertyDatum, @NonNull RA producer) {
        TracePropertyAnalysis<@NonNull RA> tracePropertyAnalysis = this.lazyCreateTracePropertyAnalysis(tracePropertyDatum);
        tracePropertyAnalysis.addProducer(producer);
        return tracePropertyAnalysis;
    }

    protected @Nullable TraceClassAnalysis<@NonNull RA> basicGetTraceClassAnalysis(@NonNull ClassDatum classDatum) {
        return this.classDatum2traceClassAnalysis.get(classDatum);
    }

    public @Nullable TracePropertyAnalysis<@NonNull RA> basicGetTracePropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        assert (QVTscheduleUtil.getReferredProperty((PropertyDatum)propertyDatum) != this.oclContainerProperty);
        return this.propertyDatum2tracePropertyAnalysis.get(propertyDatum);
    }

    protected void computeTraceClassDiscrimination() throws CompilerChainException {
        for (TraceClassAnalysis<RA> traceClassAnalysis : this.classDatum2traceClassAnalysis.values()) {
            traceClassAnalysis.discriminate();
        }
    }

    protected void computeTraceClassInheritance() {
        TraceClassAnalysis<Object> superTraceClassRegionAnalysis;
        ClassDatum classDatum;
        HashSet<@NonNull ClassDatum> missingClassDatums = new HashSet<ClassDatum>();
        for (TraceClassAnalysis<RA> traceClassAnalysis : this.classDatum2traceClassAnalysis.values()) {
            classDatum = traceClassAnalysis.getClassDatum();
            for (ClassDatum superClassDatum : QVTscheduleUtil.getSuperClassDatums((ClassDatum)classDatum)) {
                if (superClassDatum == classDatum || (superTraceClassRegionAnalysis = this.classDatum2traceClassAnalysis.get(superClassDatum)) != null) continue;
                missingClassDatums.add(superClassDatum);
            }
        }
        for (ClassDatum classDatum2 : missingClassDatums) {
            this.lazyCreateTraceClassAnalysis(classDatum2);
        }
        for (TraceClassAnalysis<Object> traceClassAnalysis : this.classDatum2traceClassAnalysis.values()) {
            classDatum = traceClassAnalysis.getClassDatum();
            for (ClassDatum superClassDatum : QVTscheduleUtil.getSuperClassDatums((ClassDatum)classDatum)) {
                if (superClassDatum == classDatum) continue;
                superTraceClassRegionAnalysis = this.classDatum2traceClassAnalysis.get(superClassDatum);
                assert (superTraceClassRegionAnalysis != null);
                superTraceClassRegionAnalysis.addSubTraceClassAnalysis(traceClassAnalysis);
                traceClassAnalysis.addSuperTraceClassAnalysis(superTraceClassRegionAnalysis);
            }
        }
    }

    protected abstract @NonNull TraceClassAnalysis<@NonNull RA> createTraceClassAnalysis(@NonNull ClassDatum var1);

    protected abstract @NonNull TracePropertyAnalysis<@NonNull RA> createTracePropertyAnalysis(@NonNull TraceClassAnalysis<@NonNull RA> var1, @NonNull PropertyDatum var2);

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull TraceClassAnalysis<@NonNull RA> getTraceClassAnalysis(@NonNull ClassDatum classDatum) {
        return (TraceClassAnalysis)ClassUtil.nonNullState(this.classDatum2traceClassAnalysis.get(classDatum));
    }

    public @NonNull TracePropertyAnalysis<@NonNull RA> getTracePropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        assert (QVTscheduleUtil.getReferredProperty((PropertyDatum)propertyDatum) != this.oclContainerProperty);
        return (TracePropertyAnalysis)ClassUtil.nonNullState(this.propertyDatum2tracePropertyAnalysis.get(propertyDatum));
    }

    private @NonNull TraceClassAnalysis<@NonNull RA> lazyCreateTraceClassAnalysis(@NonNull ClassDatum classDatum) {
        TraceClassAnalysis<@NonNull RA> traceClassAnalysis = this.classDatum2traceClassAnalysis.get(classDatum);
        if (traceClassAnalysis == null) {
            traceClassAnalysis = this.createTraceClassAnalysis(classDatum);
            this.classDatum2traceClassAnalysis.put(classDatum, traceClassAnalysis);
        }
        return traceClassAnalysis;
    }

    private @NonNull TracePropertyAnalysis<@NonNull RA> lazyCreateTracePropertyAnalysis(@NonNull PropertyDatum tracePropertyDatum) {
        TracePropertyAnalysis<@NonNull RA> tracePropertyAnalysis = this.propertyDatum2tracePropertyAnalysis.get(tracePropertyDatum);
        if (tracePropertyAnalysis == null) {
            ClassDatum classDatum = QVTscheduleUtil.getOwningClassDatum((PropertyDatum)tracePropertyDatum);
            TraceClassAnalysis<@NonNull RA> traceClassAnalysis = this.lazyCreateTraceClassAnalysis(classDatum);
            tracePropertyAnalysis = this.createTracePropertyAnalysis(traceClassAnalysis, tracePropertyDatum);
            this.propertyDatum2tracePropertyAnalysis.put(tracePropertyDatum, tracePropertyAnalysis);
        }
        return tracePropertyAnalysis;
    }
}

