/*******************************************************************************
 * Copyright (c) 2018 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     Adolfo Sanchez-Barbudo Herrera - initial API and implementation
 *******************************************************************************/
/*
 * generated by Xtext 2.10.0
 */
package org.eclipse.qvtd.doc.services;

import java.util.List;

import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.services.TerminalsGrammarAccess;
import org.eclipse.xtext.service.AbstractElementFinder.AbstractGrammarElementFinder;
import org.eclipse.xtext.service.GrammarProvider;

import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class MiniOCLCSGrammarAccess extends AbstractGrammarElementFinder {
	
	public class RootCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.RootCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cImportsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cImportsImportCSParserRuleCall_0_0 = (RuleCall)cImportsAssignment_0.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cPackagesAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final RuleCall cPackagesPackageCSParserRuleCall_1_0_0 = (RuleCall)cPackagesAssignment_1_0.eContents().get(0);
		private final Assignment cConstraintsAssignment_1_1 = (Assignment)cAlternatives_1.eContents().get(1);
		private final RuleCall cConstraintsConstraintsDefCSParserRuleCall_1_1_0 = (RuleCall)cConstraintsAssignment_1_1.eContents().get(0);
		
		//RootCS:
		//	imports+=ImportCS* (packages+=PackageCS
		//	| constraints+=ConstraintsDefCS)*;
		@Override public ParserRule getRule() { return rule; }
		
		//imports+=ImportCS* (packages+=PackageCS | constraints+=ConstraintsDefCS)*
		public Group getGroup() { return cGroup; }
		
		//imports+=ImportCS*
		public Assignment getImportsAssignment_0() { return cImportsAssignment_0; }
		
		//ImportCS
		public RuleCall getImportsImportCSParserRuleCall_0_0() { return cImportsImportCSParserRuleCall_0_0; }
		
		//(packages+=PackageCS | constraints+=ConstraintsDefCS)*
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//packages+=PackageCS
		public Assignment getPackagesAssignment_1_0() { return cPackagesAssignment_1_0; }
		
		//PackageCS
		public RuleCall getPackagesPackageCSParserRuleCall_1_0_0() { return cPackagesPackageCSParserRuleCall_1_0_0; }
		
		//constraints+=ConstraintsDefCS
		public Assignment getConstraintsAssignment_1_1() { return cConstraintsAssignment_1_1; }
		
		//ConstraintsDefCS
		public RuleCall getConstraintsConstraintsDefCSParserRuleCall_1_1_0() { return cConstraintsConstraintsDefCSParserRuleCall_1_1_0; }
	}
	public class ImportCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.ImportCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Assignment cAliasAssignment_1_0 = (Assignment)cGroup_1.eContents().get(0);
		private final RuleCall cAliasIDTerminalRuleCall_1_0_0 = (RuleCall)cAliasAssignment_1_0.eContents().get(0);
		private final Keyword cColonKeyword_1_1 = (Keyword)cGroup_1.eContents().get(1);
		private final Assignment cUriAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cUriSTRINGTerminalRuleCall_2_0 = (RuleCall)cUriAssignment_2.eContents().get(0);
		private final Keyword cSemicolonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//ImportCS:
		//	'import' (alias=ID ':') uri=STRING ';';
		@Override public ParserRule getRule() { return rule; }
		
		//'import' (alias=ID ':') uri=STRING ';'
		public Group getGroup() { return cGroup; }
		
		//'import'
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }
		
		//(alias=ID ':')
		public Group getGroup_1() { return cGroup_1; }
		
		//alias=ID
		public Assignment getAliasAssignment_1_0() { return cAliasAssignment_1_0; }
		
		//ID
		public RuleCall getAliasIDTerminalRuleCall_1_0_0() { return cAliasIDTerminalRuleCall_1_0_0; }
		
		//':'
		public Keyword getColonKeyword_1_1() { return cColonKeyword_1_1; }
		
		//uri=STRING
		public Assignment getUriAssignment_2() { return cUriAssignment_2; }
		
		//STRING
		public RuleCall getUriSTRINGTerminalRuleCall_2_0() { return cUriSTRINGTerminalRuleCall_2_0; }
		
		//';'
		public Keyword getSemicolonKeyword_3() { return cSemicolonKeyword_3; }
	}
	public class PackageCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.PackageCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cPackageKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cPackagesAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cPackagesPackageCSParserRuleCall_3_0_0 = (RuleCall)cPackagesAssignment_3_0.eContents().get(0);
		private final Assignment cClassesAssignment_3_1 = (Assignment)cAlternatives_3.eContents().get(1);
		private final RuleCall cClassesClassCSParserRuleCall_3_1_0 = (RuleCall)cClassesAssignment_3_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//PackageCS:
		//	'package' name=ID '{' (packages+=PackageCS
		//	//|classifiers+=ClassifierCS
		//	| classes+=ClassCS)*
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//'package' name=ID '{' (packages+=PackageCS //|classifiers+=ClassifierCS
		//| classes+=ClassCS)* '}'
		public Group getGroup() { return cGroup; }
		
		//'package'
		public Keyword getPackageKeyword_0() { return cPackageKeyword_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }
		
		//(packages+=PackageCS //|classifiers+=ClassifierCS
		//| classes+=ClassCS)*
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//packages+=PackageCS
		public Assignment getPackagesAssignment_3_0() { return cPackagesAssignment_3_0; }
		
		//PackageCS
		public RuleCall getPackagesPackageCSParserRuleCall_3_0_0() { return cPackagesPackageCSParserRuleCall_3_0_0; }
		
		//classes+=ClassCS
		public Assignment getClassesAssignment_3_1() { return cClassesAssignment_3_1; }
		
		//ClassCS
		public RuleCall getClassesClassCSParserRuleCall_3_1_0() { return cClassesClassCSParserRuleCall_3_1_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_4() { return cRightCurlyBracketKeyword_4; }
	}
	public class ClassCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.ClassCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cClassKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cExtendsKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cExtendsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cExtendsPathNameCSParserRuleCall_2_1_0 = (RuleCall)cExtendsAssignment_2_1.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Alternatives cAlternatives_4 = (Alternatives)cGroup.eContents().get(4);
		private final Assignment cPropertiesAssignment_4_0 = (Assignment)cAlternatives_4.eContents().get(0);
		private final RuleCall cPropertiesPropertyCSParserRuleCall_4_0_0 = (RuleCall)cPropertiesAssignment_4_0.eContents().get(0);
		private final Assignment cOperationsAssignment_4_1 = (Assignment)cAlternatives_4.eContents().get(1);
		private final RuleCall cOperationsOperationCSParserRuleCall_4_1_0 = (RuleCall)cOperationsAssignment_4_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		////ClassifierCS:
		////   ClassCS | DatatypeCS
		////;
		//ClassCS:
		//	'class' name=ID ('extends' extends=PathNameCS)? '{' (properties+=PropertyCS
		//	| operations+=OperationCS)*
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//'class' name=ID ('extends' extends=PathNameCS)? '{' (properties+=PropertyCS | operations+=OperationCS)* '}'
		public Group getGroup() { return cGroup; }
		
		//'class'
		public Keyword getClassKeyword_0() { return cClassKeyword_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//('extends' extends=PathNameCS)?
		public Group getGroup_2() { return cGroup_2; }
		
		//'extends'
		public Keyword getExtendsKeyword_2_0() { return cExtendsKeyword_2_0; }
		
		//extends=PathNameCS
		public Assignment getExtendsAssignment_2_1() { return cExtendsAssignment_2_1; }
		
		//PathNameCS
		public RuleCall getExtendsPathNameCSParserRuleCall_2_1_0() { return cExtendsPathNameCSParserRuleCall_2_1_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3() { return cLeftCurlyBracketKeyword_3; }
		
		//(properties+=PropertyCS | operations+=OperationCS)*
		public Alternatives getAlternatives_4() { return cAlternatives_4; }
		
		//properties+=PropertyCS
		public Assignment getPropertiesAssignment_4_0() { return cPropertiesAssignment_4_0; }
		
		//PropertyCS
		public RuleCall getPropertiesPropertyCSParserRuleCall_4_0_0() { return cPropertiesPropertyCSParserRuleCall_4_0_0; }
		
		//operations+=OperationCS
		public Assignment getOperationsAssignment_4_1() { return cOperationsAssignment_4_1; }
		
		//OperationCS
		public RuleCall getOperationsOperationCSParserRuleCall_4_1_0() { return cOperationsOperationCSParserRuleCall_4_1_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_5() { return cRightCurlyBracketKeyword_5; }
	}
	public class PropertyCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.PropertyCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cPropKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cTypeRefAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cTypeRefPathNameCSParserRuleCall_3_0 = (RuleCall)cTypeRefAssignment_3.eContents().get(0);
		private final Assignment cMultiplicityAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cMultiplicityMultiplicityCSParserRuleCall_4_0 = (RuleCall)cMultiplicityAssignment_4.eContents().get(0);
		private final Keyword cSemicolonKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		////DatatypeCS:
		////  'datatype' name=ID ':' typeName=STRING ';'
		////;
		//PropertyCS: //('attribute' | 'containment' | 'cross_reference')
		//	'prop' name=ID ':' typeRef=PathNameCS multiplicity=MultiplicityCS? ';';
		@Override public ParserRule getRule() { return rule; }
		
		////('attribute' | 'containment' | 'cross_reference')
		//'prop' name=ID ':' typeRef=PathNameCS multiplicity=MultiplicityCS? ';'
		public Group getGroup() { return cGroup; }
		
		////('attribute' | 'containment' | 'cross_reference')
		//'prop'
		public Keyword getPropKeyword_0() { return cPropKeyword_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//typeRef=PathNameCS
		public Assignment getTypeRefAssignment_3() { return cTypeRefAssignment_3; }
		
		//PathNameCS
		public RuleCall getTypeRefPathNameCSParserRuleCall_3_0() { return cTypeRefPathNameCSParserRuleCall_3_0; }
		
		//multiplicity=MultiplicityCS?
		public Assignment getMultiplicityAssignment_4() { return cMultiplicityAssignment_4; }
		
		//MultiplicityCS
		public RuleCall getMultiplicityMultiplicityCSParserRuleCall_4_0() { return cMultiplicityMultiplicityCSParserRuleCall_4_0; }
		
		//';'
		public Keyword getSemicolonKeyword_5() { return cSemicolonKeyword_5; }
	}
	public class MultiplicityCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.MultiplicityCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftSquareBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cOptAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final Keyword cOptQuestionMarkKeyword_1_0_0 = (Keyword)cOptAssignment_1_0.eContents().get(0);
		private final Assignment cMultAssignment_1_1 = (Assignment)cAlternatives_1.eContents().get(1);
		private final Keyword cMultAsteriskKeyword_1_1_0 = (Keyword)cMultAssignment_1_1.eContents().get(0);
		private final Assignment cMandatoryAssignment_1_2 = (Assignment)cAlternatives_1.eContents().get(2);
		private final RuleCall cMandatoryINTTerminalRuleCall_1_2_0 = (RuleCall)cMandatoryAssignment_1_2.eContents().get(0);
		private final Group cGroup_1_3 = (Group)cAlternatives_1.eContents().get(3);
		private final Assignment cLowerIntAssignment_1_3_0 = (Assignment)cGroup_1_3.eContents().get(0);
		private final RuleCall cLowerIntINTTerminalRuleCall_1_3_0_0 = (RuleCall)cLowerIntAssignment_1_3_0.eContents().get(0);
		private final Keyword cFullStopFullStopKeyword_1_3_1 = (Keyword)cGroup_1_3.eContents().get(1);
		private final Alternatives cAlternatives_1_3_2 = (Alternatives)cGroup_1_3.eContents().get(2);
		private final Assignment cUpperIntAssignment_1_3_2_0 = (Assignment)cAlternatives_1_3_2.eContents().get(0);
		private final RuleCall cUpperIntINTTerminalRuleCall_1_3_2_0_0 = (RuleCall)cUpperIntAssignment_1_3_2_0.eContents().get(0);
		private final Assignment cUpperMultAssignment_1_3_2_1 = (Assignment)cAlternatives_1_3_2.eContents().get(1);
		private final Keyword cUpperMultAsteriskKeyword_1_3_2_1_0 = (Keyword)cUpperMultAssignment_1_3_2_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//MultiplicityCS:
		//	'[' (opt?='?' | mult?='*' | mandatory=INT | lowerInt=INT '..' (upperInt=INT | upperMult?='*'))
		//	']';
		@Override public ParserRule getRule() { return rule; }
		
		//'[' (opt?='?' | mult?='*' | mandatory=INT | lowerInt=INT '..' (upperInt=INT | upperMult?='*')) ']'
		public Group getGroup() { return cGroup; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_0() { return cLeftSquareBracketKeyword_0; }
		
		//(opt?='?' | mult?='*' | mandatory=INT | lowerInt=INT '..' (upperInt=INT | upperMult?='*'))
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//opt?='?'
		public Assignment getOptAssignment_1_0() { return cOptAssignment_1_0; }
		
		//'?'
		public Keyword getOptQuestionMarkKeyword_1_0_0() { return cOptQuestionMarkKeyword_1_0_0; }
		
		//mult?='*'
		public Assignment getMultAssignment_1_1() { return cMultAssignment_1_1; }
		
		//'*'
		public Keyword getMultAsteriskKeyword_1_1_0() { return cMultAsteriskKeyword_1_1_0; }
		
		//mandatory=INT
		public Assignment getMandatoryAssignment_1_2() { return cMandatoryAssignment_1_2; }
		
		//INT
		public RuleCall getMandatoryINTTerminalRuleCall_1_2_0() { return cMandatoryINTTerminalRuleCall_1_2_0; }
		
		//lowerInt=INT '..' (upperInt=INT | upperMult?='*')
		public Group getGroup_1_3() { return cGroup_1_3; }
		
		//lowerInt=INT
		public Assignment getLowerIntAssignment_1_3_0() { return cLowerIntAssignment_1_3_0; }
		
		//INT
		public RuleCall getLowerIntINTTerminalRuleCall_1_3_0_0() { return cLowerIntINTTerminalRuleCall_1_3_0_0; }
		
		//'..'
		public Keyword getFullStopFullStopKeyword_1_3_1() { return cFullStopFullStopKeyword_1_3_1; }
		
		//(upperInt=INT | upperMult?='*')
		public Alternatives getAlternatives_1_3_2() { return cAlternatives_1_3_2; }
		
		//upperInt=INT
		public Assignment getUpperIntAssignment_1_3_2_0() { return cUpperIntAssignment_1_3_2_0; }
		
		//INT
		public RuleCall getUpperIntINTTerminalRuleCall_1_3_2_0_0() { return cUpperIntINTTerminalRuleCall_1_3_2_0_0; }
		
		//upperMult?='*'
		public Assignment getUpperMultAssignment_1_3_2_1() { return cUpperMultAssignment_1_3_2_1; }
		
		//'*'
		public Keyword getUpperMultAsteriskKeyword_1_3_2_1_0() { return cUpperMultAsteriskKeyword_1_3_2_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_2() { return cRightSquareBracketKeyword_2; }
	}
	public class OperationCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.OperationCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cOpKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Assignment cParamsAssignment_3_0 = (Assignment)cGroup_3.eContents().get(0);
		private final RuleCall cParamsParameterCSParserRuleCall_3_0_0 = (RuleCall)cParamsAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cGroup_3.eContents().get(1);
		private final Keyword cCommaKeyword_3_1_0 = (Keyword)cGroup_3_1.eContents().get(0);
		private final Assignment cParamsAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cParamsParameterCSParserRuleCall_3_1_1_0 = (RuleCall)cParamsAssignment_3_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Keyword cColonKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cResultRefAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cResultRefPathNameCSParserRuleCall_6_0 = (RuleCall)cResultRefAssignment_6.eContents().get(0);
		private final Keyword cEqualsSignKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Assignment cBodyAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final RuleCall cBodyExpCSParserRuleCall_8_0 = (RuleCall)cBodyAssignment_8.eContents().get(0);
		private final Keyword cSemicolonKeyword_9 = (Keyword)cGroup.eContents().get(9);
		
		//OperationCS:
		//	'op' name=ID
		//	'(' (params+=ParameterCS (',' params+=ParameterCS)*)? ')'
		//	':' resultRef=PathNameCS
		//	'=' body=ExpCS
		//	';';
		@Override public ParserRule getRule() { return rule; }
		
		//'op' name=ID '(' (params+=ParameterCS (',' params+=ParameterCS)*)? ')' ':' resultRef=PathNameCS '=' body=ExpCS ';'
		public Group getGroup() { return cGroup; }
		
		//'op'
		public Keyword getOpKeyword_0() { return cOpKeyword_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_2() { return cLeftParenthesisKeyword_2; }
		
		//(params+=ParameterCS (',' params+=ParameterCS)*)?
		public Group getGroup_3() { return cGroup_3; }
		
		//params+=ParameterCS
		public Assignment getParamsAssignment_3_0() { return cParamsAssignment_3_0; }
		
		//ParameterCS
		public RuleCall getParamsParameterCSParserRuleCall_3_0_0() { return cParamsParameterCSParserRuleCall_3_0_0; }
		
		//(',' params+=ParameterCS)*
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//','
		public Keyword getCommaKeyword_3_1_0() { return cCommaKeyword_3_1_0; }
		
		//params+=ParameterCS
		public Assignment getParamsAssignment_3_1_1() { return cParamsAssignment_3_1_1; }
		
		//ParameterCS
		public RuleCall getParamsParameterCSParserRuleCall_3_1_1_0() { return cParamsParameterCSParserRuleCall_3_1_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_4() { return cRightParenthesisKeyword_4; }
		
		//':'
		public Keyword getColonKeyword_5() { return cColonKeyword_5; }
		
		//resultRef=PathNameCS
		public Assignment getResultRefAssignment_6() { return cResultRefAssignment_6; }
		
		//PathNameCS
		public RuleCall getResultRefPathNameCSParserRuleCall_6_0() { return cResultRefPathNameCSParserRuleCall_6_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_7() { return cEqualsSignKeyword_7; }
		
		//body=ExpCS
		public Assignment getBodyAssignment_8() { return cBodyAssignment_8; }
		
		//ExpCS
		public RuleCall getBodyExpCSParserRuleCall_8_0() { return cBodyExpCSParserRuleCall_8_0; }
		
		//';'
		public Keyword getSemicolonKeyword_9() { return cSemicolonKeyword_9; }
	}
	public class ParameterCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.ParameterCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameIDTerminalRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cTypeRefAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cTypeRefPathNameCSParserRuleCall_2_0 = (RuleCall)cTypeRefAssignment_2.eContents().get(0);
		
		//ParameterCS:
		//	name=ID ':' typeRef=PathNameCS;
		@Override public ParserRule getRule() { return rule; }
		
		//name=ID ':' typeRef=PathNameCS
		public Group getGroup() { return cGroup; }
		
		//name=ID
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_0_0() { return cNameIDTerminalRuleCall_0_0; }
		
		//':'
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }
		
		//typeRef=PathNameCS
		public Assignment getTypeRefAssignment_2() { return cTypeRefAssignment_2; }
		
		//PathNameCS
		public RuleCall getTypeRefPathNameCSParserRuleCall_2_0() { return cTypeRefPathNameCSParserRuleCall_2_0; }
	}
	public class ConstraintsDefCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.ConstraintsDefCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cContextKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cTypeRefAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cTypeRefPathNameCSParserRuleCall_1_0 = (RuleCall)cTypeRefAssignment_1.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cInvariantsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cInvariantsInvariantCSParserRuleCall_3_0 = (RuleCall)cInvariantsAssignment_3.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//ConstraintsDefCS:
		//	'context' typeRef=PathNameCS '{'
		//	invariants+=InvariantCS*
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//'context' typeRef=PathNameCS '{' invariants+=InvariantCS* '}'
		public Group getGroup() { return cGroup; }
		
		//'context'
		public Keyword getContextKeyword_0() { return cContextKeyword_0; }
		
		//typeRef=PathNameCS
		public Assignment getTypeRefAssignment_1() { return cTypeRefAssignment_1; }
		
		//PathNameCS
		public RuleCall getTypeRefPathNameCSParserRuleCall_1_0() { return cTypeRefPathNameCSParserRuleCall_1_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }
		
		//invariants+=InvariantCS*
		public Assignment getInvariantsAssignment_3() { return cInvariantsAssignment_3; }
		
		//InvariantCS
		public RuleCall getInvariantsInvariantCSParserRuleCall_3_0() { return cInvariantsInvariantCSParserRuleCall_3_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_4() { return cRightCurlyBracketKeyword_4; }
	}
	public class InvariantCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.InvariantCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cInvKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cExpAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cExpExpCSParserRuleCall_2_0 = (RuleCall)cExpAssignment_2.eContents().get(0);
		private final Keyword cSemicolonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//InvariantCS:
		//	'inv' ':' exp=ExpCS ';';
		@Override public ParserRule getRule() { return rule; }
		
		//'inv' ':' exp=ExpCS ';'
		public Group getGroup() { return cGroup; }
		
		//'inv'
		public Keyword getInvKeyword_0() { return cInvKeyword_0; }
		
		//':'
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }
		
		//exp=ExpCS
		public Assignment getExpAssignment_2() { return cExpAssignment_2; }
		
		//ExpCS
		public RuleCall getExpExpCSParserRuleCall_2_0() { return cExpExpCSParserRuleCall_2_0; }
		
		//';'
		public Keyword getSemicolonKeyword_3() { return cSemicolonKeyword_3; }
	}
	public class ExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.ExpCS");
		private final RuleCall cEqualityExpCSParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//// Expressions
		//ExpCS:
		//	EqualityExpCS;
		@Override public ParserRule getRule() { return rule; }
		
		//EqualityExpCS
		public RuleCall getEqualityExpCSParserRuleCall() { return cEqualityExpCSParserRuleCall; }
	}
	public class EqualityExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.EqualityExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cCallExpCSParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Action cEqualityExpCSLeftAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Assignment cOpNameAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final Alternatives cOpNameAlternatives_1_1_0 = (Alternatives)cOpNameAssignment_1_1.eContents().get(0);
		private final Keyword cOpNameEqualsSignKeyword_1_1_0_0 = (Keyword)cOpNameAlternatives_1_1_0.eContents().get(0);
		private final Keyword cOpNameLessThanSignGreaterThanSignKeyword_1_1_0_1 = (Keyword)cOpNameAlternatives_1_1_0.eContents().get(1);
		private final Assignment cRightAssignment_1_2 = (Assignment)cGroup_1.eContents().get(2);
		private final RuleCall cRightCallExpCSParserRuleCall_1_2_0 = (RuleCall)cRightAssignment_1_2.eContents().get(0);
		
		//EqualityExpCS:
		//	CallExpCS ({EqualityExpCS.left=current} opName=('=' | '<>') right=CallExpCS)*;
		@Override public ParserRule getRule() { return rule; }
		
		//CallExpCS ({EqualityExpCS.left=current} opName=('=' | '<>') right=CallExpCS)*
		public Group getGroup() { return cGroup; }
		
		//CallExpCS
		public RuleCall getCallExpCSParserRuleCall_0() { return cCallExpCSParserRuleCall_0; }
		
		//({EqualityExpCS.left=current} opName=('=' | '<>') right=CallExpCS)*
		public Group getGroup_1() { return cGroup_1; }
		
		//{EqualityExpCS.left=current}
		public Action getEqualityExpCSLeftAction_1_0() { return cEqualityExpCSLeftAction_1_0; }
		
		//opName=('=' | '<>')
		public Assignment getOpNameAssignment_1_1() { return cOpNameAssignment_1_1; }
		
		//('=' | '<>')
		public Alternatives getOpNameAlternatives_1_1_0() { return cOpNameAlternatives_1_1_0; }
		
		//'='
		public Keyword getOpNameEqualsSignKeyword_1_1_0_0() { return cOpNameEqualsSignKeyword_1_1_0_0; }
		
		//'<>'
		public Keyword getOpNameLessThanSignGreaterThanSignKeyword_1_1_0_1() { return cOpNameLessThanSignGreaterThanSignKeyword_1_1_0_1; }
		
		//right=CallExpCS
		public Assignment getRightAssignment_1_2() { return cRightAssignment_1_2; }
		
		//CallExpCS
		public RuleCall getRightCallExpCSParserRuleCall_1_2_0() { return cRightCallExpCSParserRuleCall_1_2_0; }
	}
	public class CallExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.CallExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cPrimaryExpCSParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Action cCallExpCSSourceAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Assignment cOpNameAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final Alternatives cOpNameAlternatives_1_1_0 = (Alternatives)cOpNameAssignment_1_1.eContents().get(0);
		private final Keyword cOpNameFullStopKeyword_1_1_0_0 = (Keyword)cOpNameAlternatives_1_1_0.eContents().get(0);
		private final Keyword cOpNameHyphenMinusGreaterThanSignKeyword_1_1_0_1 = (Keyword)cOpNameAlternatives_1_1_0.eContents().get(1);
		private final Assignment cNavExpAssignment_1_2 = (Assignment)cGroup_1.eContents().get(2);
		private final RuleCall cNavExpNavigationExpCSParserRuleCall_1_2_0 = (RuleCall)cNavExpAssignment_1_2.eContents().get(0);
		
		//CallExpCS:
		//	PrimaryExpCS ({CallExpCS.source=current} opName=('.' | '->') navExp=NavigationExpCS)*;
		@Override public ParserRule getRule() { return rule; }
		
		//PrimaryExpCS ({CallExpCS.source=current} opName=('.' | '->') navExp=NavigationExpCS)*
		public Group getGroup() { return cGroup; }
		
		//PrimaryExpCS
		public RuleCall getPrimaryExpCSParserRuleCall_0() { return cPrimaryExpCSParserRuleCall_0; }
		
		//({CallExpCS.source=current} opName=('.' | '->') navExp=NavigationExpCS)*
		public Group getGroup_1() { return cGroup_1; }
		
		//{CallExpCS.source=current}
		public Action getCallExpCSSourceAction_1_0() { return cCallExpCSSourceAction_1_0; }
		
		//opName=('.' | '->')
		public Assignment getOpNameAssignment_1_1() { return cOpNameAssignment_1_1; }
		
		//('.' | '->')
		public Alternatives getOpNameAlternatives_1_1_0() { return cOpNameAlternatives_1_1_0; }
		
		//'.'
		public Keyword getOpNameFullStopKeyword_1_1_0_0() { return cOpNameFullStopKeyword_1_1_0_0; }
		
		//'->'
		public Keyword getOpNameHyphenMinusGreaterThanSignKeyword_1_1_0_1() { return cOpNameHyphenMinusGreaterThanSignKeyword_1_1_0_1; }
		
		//navExp=NavigationExpCS
		public Assignment getNavExpAssignment_1_2() { return cNavExpAssignment_1_2; }
		
		//NavigationExpCS
		public RuleCall getNavExpNavigationExpCSParserRuleCall_1_2_0() { return cNavExpNavigationExpCSParserRuleCall_1_2_0; }
	}
	public class PrimaryExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.PrimaryExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cSelfExpCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cNameExpCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cLiteralExpCSParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cLetExpCSParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		
		//PrimaryExpCS:
		//	SelfExpCS | NameExpCS | LiteralExpCS | LetExpCS;
		@Override public ParserRule getRule() { return rule; }
		
		//SelfExpCS | NameExpCS | LiteralExpCS | LetExpCS
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//SelfExpCS
		public RuleCall getSelfExpCSParserRuleCall_0() { return cSelfExpCSParserRuleCall_0; }
		
		//NameExpCS
		public RuleCall getNameExpCSParserRuleCall_1() { return cNameExpCSParserRuleCall_1; }
		
		//LiteralExpCS
		public RuleCall getLiteralExpCSParserRuleCall_2() { return cLiteralExpCSParserRuleCall_2; }
		
		//LetExpCS
		public RuleCall getLetExpCSParserRuleCall_3() { return cLetExpCSParserRuleCall_3; }
	}
	public class SelfExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.SelfExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSelfExpCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cSelfKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//SelfExpCS:
		//	{SelfExpCS} 'self';
		@Override public ParserRule getRule() { return rule; }
		
		//{SelfExpCS} 'self'
		public Group getGroup() { return cGroup; }
		
		//{SelfExpCS}
		public Action getSelfExpCSAction_0() { return cSelfExpCSAction_0; }
		
		//'self'
		public Keyword getSelfKeyword_1() { return cSelfKeyword_1; }
	}
	public class NavigationExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.NavigationExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cLoopExpCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cNameExpCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//NavigationExpCS:
		//	LoopExpCS | NameExpCS;
		@Override public ParserRule getRule() { return rule; }
		
		//LoopExpCS | NameExpCS
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//LoopExpCS
		public RuleCall getLoopExpCSParserRuleCall_0() { return cLoopExpCSParserRuleCall_0; }
		
		//NameExpCS
		public RuleCall getNameExpCSParserRuleCall_1() { return cNameExpCSParserRuleCall_1; }
	}
	public class LoopExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.LoopExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cCollectExpCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cIterateExpCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//LoopExpCS:
		//	CollectExpCS | IterateExpCS;
		@Override public ParserRule getRule() { return rule; }
		
		//CollectExpCS | IterateExpCS
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//CollectExpCS
		public RuleCall getCollectExpCSParserRuleCall_0() { return cCollectExpCSParserRuleCall_0; }
		
		//IterateExpCS
		public RuleCall getIterateExpCSParserRuleCall_1() { return cIterateExpCSParserRuleCall_1; }
	}
	public class CollectExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.CollectExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cCollectKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Assignment cItVarAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final RuleCall cItVarIteratorVarCSParserRuleCall_2_0_0 = (RuleCall)cItVarAssignment_2_0.eContents().get(0);
		private final Keyword cVerticalLineKeyword_2_1 = (Keyword)cGroup_2.eContents().get(1);
		private final Assignment cExpAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cExpExpCSParserRuleCall_3_0 = (RuleCall)cExpAssignment_3.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//CollectExpCS:
		//	'collect' '(' (itVar=IteratorVarCS '|')? exp=ExpCS ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'collect' '(' (itVar=IteratorVarCS '|')? exp=ExpCS ')'
		public Group getGroup() { return cGroup; }
		
		//'collect'
		public Keyword getCollectKeyword_0() { return cCollectKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//(itVar=IteratorVarCS '|')?
		public Group getGroup_2() { return cGroup_2; }
		
		//itVar=IteratorVarCS
		public Assignment getItVarAssignment_2_0() { return cItVarAssignment_2_0; }
		
		//IteratorVarCS
		public RuleCall getItVarIteratorVarCSParserRuleCall_2_0_0() { return cItVarIteratorVarCSParserRuleCall_2_0_0; }
		
		//'|'
		public Keyword getVerticalLineKeyword_2_1() { return cVerticalLineKeyword_2_1; }
		
		//exp=ExpCS
		public Assignment getExpAssignment_3() { return cExpAssignment_3; }
		
		//ExpCS
		public RuleCall getExpExpCSParserRuleCall_3_0() { return cExpExpCSParserRuleCall_3_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_4() { return cRightParenthesisKeyword_4; }
	}
	public class IteratorVarCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.IteratorVarCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cItNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cItNameIDTerminalRuleCall_0_0 = (RuleCall)cItNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cItTypeAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cItTypePathNameCSParserRuleCall_1_1_0 = (RuleCall)cItTypeAssignment_1_1.eContents().get(0);
		
		//IteratorVarCS:
		//	itName=ID (':' itType=PathNameCS)?;
		@Override public ParserRule getRule() { return rule; }
		
		//itName=ID (':' itType=PathNameCS)?
		public Group getGroup() { return cGroup; }
		
		//itName=ID
		public Assignment getItNameAssignment_0() { return cItNameAssignment_0; }
		
		//ID
		public RuleCall getItNameIDTerminalRuleCall_0_0() { return cItNameIDTerminalRuleCall_0_0; }
		
		//(':' itType=PathNameCS)?
		public Group getGroup_1() { return cGroup_1; }
		
		//':'
		public Keyword getColonKeyword_1_0() { return cColonKeyword_1_0; }
		
		//itType=PathNameCS
		public Assignment getItTypeAssignment_1_1() { return cItTypeAssignment_1_1; }
		
		//PathNameCS
		public RuleCall getItTypePathNameCSParserRuleCall_1_1_0() { return cItTypePathNameCSParserRuleCall_1_1_0; }
	}
	public class IterateExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.IterateExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cIterateKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cItVarAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cItVarIteratorVarCSParserRuleCall_2_0 = (RuleCall)cItVarAssignment_2.eContents().get(0);
		private final Keyword cSemicolonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cAccVarAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cAccVarAccVarCSParserRuleCall_4_0 = (RuleCall)cAccVarAssignment_4.eContents().get(0);
		private final Keyword cVerticalLineKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cExpAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cExpExpCSParserRuleCall_6_0 = (RuleCall)cExpAssignment_6.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_7 = (Keyword)cGroup.eContents().get(7);
		
		//IterateExpCS:
		//	'iterate' '(' itVar=IteratorVarCS ';' accVar=AccVarCS '|' exp=ExpCS ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'iterate' '(' itVar=IteratorVarCS ';' accVar=AccVarCS '|' exp=ExpCS ')'
		public Group getGroup() { return cGroup; }
		
		//'iterate'
		public Keyword getIterateKeyword_0() { return cIterateKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//itVar=IteratorVarCS
		public Assignment getItVarAssignment_2() { return cItVarAssignment_2; }
		
		//IteratorVarCS
		public RuleCall getItVarIteratorVarCSParserRuleCall_2_0() { return cItVarIteratorVarCSParserRuleCall_2_0; }
		
		//';'
		public Keyword getSemicolonKeyword_3() { return cSemicolonKeyword_3; }
		
		//accVar=AccVarCS
		public Assignment getAccVarAssignment_4() { return cAccVarAssignment_4; }
		
		//AccVarCS
		public RuleCall getAccVarAccVarCSParserRuleCall_4_0() { return cAccVarAccVarCSParserRuleCall_4_0; }
		
		//'|'
		public Keyword getVerticalLineKeyword_5() { return cVerticalLineKeyword_5; }
		
		//exp=ExpCS
		public Assignment getExpAssignment_6() { return cExpAssignment_6; }
		
		//ExpCS
		public RuleCall getExpExpCSParserRuleCall_6_0() { return cExpExpCSParserRuleCall_6_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_7() { return cRightParenthesisKeyword_7; }
	}
	public class AccVarCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.AccVarCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cAccNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cAccNameIDTerminalRuleCall_0_0 = (RuleCall)cAccNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cAccTypeAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cAccTypePathNameCSParserRuleCall_1_1_0 = (RuleCall)cAccTypeAssignment_1_1.eContents().get(0);
		private final Keyword cEqualsSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cAccInitExpAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cAccInitExpExpCSParserRuleCall_3_0 = (RuleCall)cAccInitExpAssignment_3.eContents().get(0);
		
		//AccVarCS:
		//	accName=ID (':' accType=PathNameCS)? '=' accInitExp=ExpCS;
		@Override public ParserRule getRule() { return rule; }
		
		//accName=ID (':' accType=PathNameCS)? '=' accInitExp=ExpCS
		public Group getGroup() { return cGroup; }
		
		//accName=ID
		public Assignment getAccNameAssignment_0() { return cAccNameAssignment_0; }
		
		//ID
		public RuleCall getAccNameIDTerminalRuleCall_0_0() { return cAccNameIDTerminalRuleCall_0_0; }
		
		//(':' accType=PathNameCS)?
		public Group getGroup_1() { return cGroup_1; }
		
		//':'
		public Keyword getColonKeyword_1_0() { return cColonKeyword_1_0; }
		
		//accType=PathNameCS
		public Assignment getAccTypeAssignment_1_1() { return cAccTypeAssignment_1_1; }
		
		//PathNameCS
		public RuleCall getAccTypePathNameCSParserRuleCall_1_1_0() { return cAccTypePathNameCSParserRuleCall_1_1_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_2() { return cEqualsSignKeyword_2; }
		
		//accInitExp=ExpCS
		public Assignment getAccInitExpAssignment_3() { return cAccInitExpAssignment_3; }
		
		//ExpCS
		public RuleCall getAccInitExpExpCSParserRuleCall_3_0() { return cAccInitExpExpCSParserRuleCall_3_0; }
	}
	public class NameExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.NameExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cExpNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cExpNamePathNameCSParserRuleCall_0_0 = (RuleCall)cExpNameAssignment_0.eContents().get(0);
		private final Assignment cRoundedBracketsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cRoundedBracketsRoundedBracketClauseCSParserRuleCall_1_0 = (RuleCall)cRoundedBracketsAssignment_1.eContents().get(0);
		
		//NameExpCS:
		//	expName=PathNameCS
		//	roundedBrackets=RoundedBracketClauseCS?;
		@Override public ParserRule getRule() { return rule; }
		
		//expName=PathNameCS roundedBrackets=RoundedBracketClauseCS?
		public Group getGroup() { return cGroup; }
		
		//expName=PathNameCS
		public Assignment getExpNameAssignment_0() { return cExpNameAssignment_0; }
		
		//PathNameCS
		public RuleCall getExpNamePathNameCSParserRuleCall_0_0() { return cExpNamePathNameCSParserRuleCall_0_0; }
		
		//roundedBrackets=RoundedBracketClauseCS?
		public Assignment getRoundedBracketsAssignment_1() { return cRoundedBracketsAssignment_1; }
		
		//RoundedBracketClauseCS
		public RuleCall getRoundedBracketsRoundedBracketClauseCSParserRuleCall_1_0() { return cRoundedBracketsRoundedBracketClauseCSParserRuleCall_1_0; }
	}
	public class RoundedBracketClauseCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.RoundedBracketClauseCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cRoundedBracketClauseCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Assignment cArgsAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final RuleCall cArgsExpCSParserRuleCall_2_0_0 = (RuleCall)cArgsAssignment_2_0.eContents().get(0);
		private final Group cGroup_2_1 = (Group)cGroup_2.eContents().get(1);
		private final Keyword cCommaKeyword_2_1_0 = (Keyword)cGroup_2_1.eContents().get(0);
		private final Assignment cArgsAssignment_2_1_1 = (Assignment)cGroup_2_1.eContents().get(1);
		private final RuleCall cArgsExpCSParserRuleCall_2_1_1_0 = (RuleCall)cArgsAssignment_2_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//RoundedBracketClauseCS:
		//	{RoundedBracketClauseCS}
		//	'(' (args+=ExpCS (',' args+=ExpCS)*)?
		//	')';
		@Override public ParserRule getRule() { return rule; }
		
		//{RoundedBracketClauseCS} '(' (args+=ExpCS (',' args+=ExpCS)*)? ')'
		public Group getGroup() { return cGroup; }
		
		//{RoundedBracketClauseCS}
		public Action getRoundedBracketClauseCSAction_0() { return cRoundedBracketClauseCSAction_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//(args+=ExpCS (',' args+=ExpCS)*)?
		public Group getGroup_2() { return cGroup_2; }
		
		//args+=ExpCS
		public Assignment getArgsAssignment_2_0() { return cArgsAssignment_2_0; }
		
		//ExpCS
		public RuleCall getArgsExpCSParserRuleCall_2_0_0() { return cArgsExpCSParserRuleCall_2_0_0; }
		
		//(',' args+=ExpCS)*
		public Group getGroup_2_1() { return cGroup_2_1; }
		
		//','
		public Keyword getCommaKeyword_2_1_0() { return cCommaKeyword_2_1_0; }
		
		//args+=ExpCS
		public Assignment getArgsAssignment_2_1_1() { return cArgsAssignment_2_1_1; }
		
		//ExpCS
		public RuleCall getArgsExpCSParserRuleCall_2_1_1_0() { return cArgsExpCSParserRuleCall_2_1_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_3() { return cRightParenthesisKeyword_3; }
	}
	public class LiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.LiteralExpCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cIntLiteralExpCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cBooleanLiteralExpCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cNullLiteralExpCSParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cCollectionLiteralExpCSParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		
		//LiteralExpCS:
		//	IntLiteralExpCS | BooleanLiteralExpCS | NullLiteralExpCS | CollectionLiteralExpCS;
		@Override public ParserRule getRule() { return rule; }
		
		//IntLiteralExpCS | BooleanLiteralExpCS | NullLiteralExpCS | CollectionLiteralExpCS
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//IntLiteralExpCS
		public RuleCall getIntLiteralExpCSParserRuleCall_0() { return cIntLiteralExpCSParserRuleCall_0; }
		
		//BooleanLiteralExpCS
		public RuleCall getBooleanLiteralExpCSParserRuleCall_1() { return cBooleanLiteralExpCSParserRuleCall_1; }
		
		//NullLiteralExpCS
		public RuleCall getNullLiteralExpCSParserRuleCall_2() { return cNullLiteralExpCSParserRuleCall_2; }
		
		//CollectionLiteralExpCS
		public RuleCall getCollectionLiteralExpCSParserRuleCall_3() { return cCollectionLiteralExpCSParserRuleCall_3; }
	}
	public class IntLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.IntLiteralExpCS");
		private final Assignment cIntSymbolAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cIntSymbolINTTerminalRuleCall_0 = (RuleCall)cIntSymbolAssignment.eContents().get(0);
		
		//IntLiteralExpCS:
		//	intSymbol=INT;
		@Override public ParserRule getRule() { return rule; }
		
		//intSymbol=INT
		public Assignment getIntSymbolAssignment() { return cIntSymbolAssignment; }
		
		//INT
		public RuleCall getIntSymbolINTTerminalRuleCall_0() { return cIntSymbolINTTerminalRuleCall_0; }
	}
	public class BooleanLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.BooleanLiteralExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cBooleanExpCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cBoolSymbolAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final Keyword cBoolSymbolTrueKeyword_1_0_0 = (Keyword)cBoolSymbolAssignment_1_0.eContents().get(0);
		private final Keyword cFalseKeyword_1_1 = (Keyword)cAlternatives_1.eContents().get(1);
		
		//BooleanLiteralExpCS:
		//	{BooleanExpCS} (boolSymbol?='true'
		//	| 'false');
		@Override public ParserRule getRule() { return rule; }
		
		//{BooleanExpCS} (boolSymbol?='true' | 'false')
		public Group getGroup() { return cGroup; }
		
		//{BooleanExpCS}
		public Action getBooleanExpCSAction_0() { return cBooleanExpCSAction_0; }
		
		//(boolSymbol?='true' | 'false')
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//boolSymbol?='true'
		public Assignment getBoolSymbolAssignment_1_0() { return cBoolSymbolAssignment_1_0; }
		
		//'true'
		public Keyword getBoolSymbolTrueKeyword_1_0_0() { return cBoolSymbolTrueKeyword_1_0_0; }
		
		//'false'
		public Keyword getFalseKeyword_1_1() { return cFalseKeyword_1_1; }
	}
	public class NullLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.NullLiteralExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cNullLiteralExpCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cNullKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//NullLiteralExpCS:
		//	{NullLiteralExpCS}
		//	'null';
		@Override public ParserRule getRule() { return rule; }
		
		//{NullLiteralExpCS} 'null'
		public Group getGroup() { return cGroup; }
		
		//{NullLiteralExpCS}
		public Action getNullLiteralExpCSAction_0() { return cNullLiteralExpCSAction_0; }
		
		//'null'
		public Keyword getNullKeyword_1() { return cNullKeyword_1; }
	}
	public class CollectionLiteralExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.CollectionLiteralExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cKindAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cKindCollectionKindCSEnumRuleCall_0_0 = (RuleCall)cKindAssignment_0.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cPartsAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cPartsCollectionLiteralPartCSParserRuleCall_2_0 = (RuleCall)cPartsAssignment_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//CollectionLiteralExpCS:
		//	kind=CollectionKindCS '{'
		//	parts+=CollectionLiteralPartCS*
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//kind=CollectionKindCS '{' parts+=CollectionLiteralPartCS* '}'
		public Group getGroup() { return cGroup; }
		
		//kind=CollectionKindCS
		public Assignment getKindAssignment_0() { return cKindAssignment_0; }
		
		//CollectionKindCS
		public RuleCall getKindCollectionKindCSEnumRuleCall_0_0() { return cKindCollectionKindCSEnumRuleCall_0_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_1() { return cLeftCurlyBracketKeyword_1; }
		
		//parts+=CollectionLiteralPartCS*
		public Assignment getPartsAssignment_2() { return cPartsAssignment_2; }
		
		//CollectionLiteralPartCS
		public RuleCall getPartsCollectionLiteralPartCSParserRuleCall_2_0() { return cPartsCollectionLiteralPartCSParserRuleCall_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3() { return cRightCurlyBracketKeyword_3; }
	}
	public class CollectionLiteralPartCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.CollectionLiteralPartCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cFirstAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cFirstExpCSParserRuleCall_0_0 = (RuleCall)cFirstAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cFullStopFullStopKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cLastAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cLastExpCSParserRuleCall_1_1_0 = (RuleCall)cLastAssignment_1_1.eContents().get(0);
		
		//CollectionLiteralPartCS:
		//	first=ExpCS ('..' last=ExpCS)?;
		@Override public ParserRule getRule() { return rule; }
		
		//first=ExpCS ('..' last=ExpCS)?
		public Group getGroup() { return cGroup; }
		
		//first=ExpCS
		public Assignment getFirstAssignment_0() { return cFirstAssignment_0; }
		
		//ExpCS
		public RuleCall getFirstExpCSParserRuleCall_0_0() { return cFirstExpCSParserRuleCall_0_0; }
		
		//('..' last=ExpCS)?
		public Group getGroup_1() { return cGroup_1; }
		
		//'..'
		public Keyword getFullStopFullStopKeyword_1_0() { return cFullStopFullStopKeyword_1_0; }
		
		//last=ExpCS
		public Assignment getLastAssignment_1_1() { return cLastAssignment_1_1; }
		
		//ExpCS
		public RuleCall getLastExpCSParserRuleCall_1_1_0() { return cLastExpCSParserRuleCall_1_1_0; }
	}
	public class LetExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.LetExpCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLetKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cLetVarsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cLetVarsLetVarCSParserRuleCall_1_0 = (RuleCall)cLetVarsAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cLetVarsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cLetVarsLetVarCSParserRuleCall_2_1_0 = (RuleCall)cLetVarsAssignment_2_1.eContents().get(0);
		private final Keyword cInKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cInExpAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cInExpExpCSParserRuleCall_4_0 = (RuleCall)cInExpAssignment_4.eContents().get(0);
		
		//LetExpCS:
		//	'let' letVars+=LetVarCS (',' letVars+=LetVarCS)*
		//	'in' inExp=ExpCS;
		@Override public ParserRule getRule() { return rule; }
		
		//'let' letVars+=LetVarCS (',' letVars+=LetVarCS)* 'in' inExp=ExpCS
		public Group getGroup() { return cGroup; }
		
		//'let'
		public Keyword getLetKeyword_0() { return cLetKeyword_0; }
		
		//letVars+=LetVarCS
		public Assignment getLetVarsAssignment_1() { return cLetVarsAssignment_1; }
		
		//LetVarCS
		public RuleCall getLetVarsLetVarCSParserRuleCall_1_0() { return cLetVarsLetVarCSParserRuleCall_1_0; }
		
		//(',' letVars+=LetVarCS)*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//letVars+=LetVarCS
		public Assignment getLetVarsAssignment_2_1() { return cLetVarsAssignment_2_1; }
		
		//LetVarCS
		public RuleCall getLetVarsLetVarCSParserRuleCall_2_1_0() { return cLetVarsLetVarCSParserRuleCall_2_1_0; }
		
		//'in'
		public Keyword getInKeyword_3() { return cInKeyword_3; }
		
		//inExp=ExpCS
		public Assignment getInExpAssignment_4() { return cInExpAssignment_4; }
		
		//ExpCS
		public RuleCall getInExpExpCSParserRuleCall_4_0() { return cInExpExpCSParserRuleCall_4_0; }
	}
	public class LetVarCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.LetVarCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameIDTerminalRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cTypeRefAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cTypeRefPathNameCSParserRuleCall_1_1_0 = (RuleCall)cTypeRefAssignment_1_1.eContents().get(0);
		private final Keyword cEqualsSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cInitExpAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cInitExpExpCSParserRuleCall_3_0 = (RuleCall)cInitExpAssignment_3.eContents().get(0);
		
		//LetVarCS:
		//	name=ID (':' typeRef=PathNameCS)? '=' initExp=ExpCS;
		@Override public ParserRule getRule() { return rule; }
		
		//name=ID (':' typeRef=PathNameCS)? '=' initExp=ExpCS
		public Group getGroup() { return cGroup; }
		
		//name=ID
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_0_0() { return cNameIDTerminalRuleCall_0_0; }
		
		//(':' typeRef=PathNameCS)?
		public Group getGroup_1() { return cGroup_1; }
		
		//':'
		public Keyword getColonKeyword_1_0() { return cColonKeyword_1_0; }
		
		//typeRef=PathNameCS
		public Assignment getTypeRefAssignment_1_1() { return cTypeRefAssignment_1_1; }
		
		//PathNameCS
		public RuleCall getTypeRefPathNameCSParserRuleCall_1_1_0() { return cTypeRefPathNameCSParserRuleCall_1_1_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_2() { return cEqualsSignKeyword_2; }
		
		//initExp=ExpCS
		public Assignment getInitExpAssignment_3() { return cInitExpAssignment_3; }
		
		//ExpCS
		public RuleCall getInitExpExpCSParserRuleCall_3_0() { return cInitExpExpCSParserRuleCall_3_0; }
	}
	public class PathNameCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.PathNameCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPathElementsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cPathElementsPathElementCSParserRuleCall_0_0 = (RuleCall)cPathElementsAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cColonColonKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cPathElementsAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cPathElementsPathElementCSParserRuleCall_1_1_0 = (RuleCall)cPathElementsAssignment_1_1.eContents().get(0);
		
		//PathNameCS:
		//	pathElements+=PathElementCS ('::' pathElements+=PathElementCS)*;
		@Override public ParserRule getRule() { return rule; }
		
		//pathElements+=PathElementCS ('::' pathElements+=PathElementCS)*
		public Group getGroup() { return cGroup; }
		
		//pathElements+=PathElementCS
		public Assignment getPathElementsAssignment_0() { return cPathElementsAssignment_0; }
		
		//PathElementCS
		public RuleCall getPathElementsPathElementCSParserRuleCall_0_0() { return cPathElementsPathElementCSParserRuleCall_0_0; }
		
		//('::' pathElements+=PathElementCS)*
		public Group getGroup_1() { return cGroup_1; }
		
		//'::'
		public Keyword getColonColonKeyword_1_0() { return cColonColonKeyword_1_0; }
		
		//pathElements+=PathElementCS
		public Assignment getPathElementsAssignment_1_1() { return cPathElementsAssignment_1_1; }
		
		//PathElementCS
		public RuleCall getPathElementsPathElementCSParserRuleCall_1_1_0() { return cPathElementsPathElementCSParserRuleCall_1_1_0; }
	}
	public class PathElementCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.PathElementCS");
		private final Assignment cElementNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cElementNameIDTerminalRuleCall_0 = (RuleCall)cElementNameAssignment.eContents().get(0);
		
		//PathElementCS:
		//	elementName=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//elementName=ID
		public Assignment getElementNameAssignment() { return cElementNameAssignment; }
		
		//ID
		public RuleCall getElementNameIDTerminalRuleCall_0() { return cElementNameIDTerminalRuleCall_0; }
	}
	
	public class CollectionKindCSElements extends AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.qvtd.doc.MiniOCLCS.CollectionKindCS");
		private final EnumLiteralDeclaration cCollectionEnumLiteralDeclaration = (EnumLiteralDeclaration)rule.eContents().get(1);
		private final Keyword cCollectionCollectionKeyword_0 = (Keyword)cCollectionEnumLiteralDeclaration.eContents().get(0);
		
		//enum CollectionKindCS:
		//	Collection;
		public EnumRule getRule() { return rule; }
		
		//Collection
		public EnumLiteralDeclaration getCollectionEnumLiteralDeclaration() { return cCollectionEnumLiteralDeclaration; }
		
		//'Collection'
		public Keyword getCollectionCollectionKeyword_0() { return cCollectionCollectionKeyword_0; }
	}
	
	private final RootCSElements pRootCS;
	private final ImportCSElements pImportCS;
	private final PackageCSElements pPackageCS;
	private final ClassCSElements pClassCS;
	private final PropertyCSElements pPropertyCS;
	private final MultiplicityCSElements pMultiplicityCS;
	private final OperationCSElements pOperationCS;
	private final ParameterCSElements pParameterCS;
	private final ConstraintsDefCSElements pConstraintsDefCS;
	private final InvariantCSElements pInvariantCS;
	private final ExpCSElements pExpCS;
	private final EqualityExpCSElements pEqualityExpCS;
	private final CallExpCSElements pCallExpCS;
	private final PrimaryExpCSElements pPrimaryExpCS;
	private final SelfExpCSElements pSelfExpCS;
	private final NavigationExpCSElements pNavigationExpCS;
	private final LoopExpCSElements pLoopExpCS;
	private final CollectExpCSElements pCollectExpCS;
	private final IteratorVarCSElements pIteratorVarCS;
	private final IterateExpCSElements pIterateExpCS;
	private final AccVarCSElements pAccVarCS;
	private final NameExpCSElements pNameExpCS;
	private final RoundedBracketClauseCSElements pRoundedBracketClauseCS;
	private final LiteralExpCSElements pLiteralExpCS;
	private final IntLiteralExpCSElements pIntLiteralExpCS;
	private final BooleanLiteralExpCSElements pBooleanLiteralExpCS;
	private final NullLiteralExpCSElements pNullLiteralExpCS;
	private final CollectionKindCSElements eCollectionKindCS;
	private final CollectionLiteralExpCSElements pCollectionLiteralExpCS;
	private final CollectionLiteralPartCSElements pCollectionLiteralPartCS;
	private final LetExpCSElements pLetExpCS;
	private final LetVarCSElements pLetVarCS;
	private final PathNameCSElements pPathNameCS;
	private final PathElementCSElements pPathElementCS;
	
	private final Grammar grammar;
	
	private final TerminalsGrammarAccess gaTerminals;

	@Inject
	public MiniOCLCSGrammarAccess(GrammarProvider grammarProvider,
			TerminalsGrammarAccess gaTerminals) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaTerminals = gaTerminals;
		this.pRootCS = new RootCSElements();
		this.pImportCS = new ImportCSElements();
		this.pPackageCS = new PackageCSElements();
		this.pClassCS = new ClassCSElements();
		this.pPropertyCS = new PropertyCSElements();
		this.pMultiplicityCS = new MultiplicityCSElements();
		this.pOperationCS = new OperationCSElements();
		this.pParameterCS = new ParameterCSElements();
		this.pConstraintsDefCS = new ConstraintsDefCSElements();
		this.pInvariantCS = new InvariantCSElements();
		this.pExpCS = new ExpCSElements();
		this.pEqualityExpCS = new EqualityExpCSElements();
		this.pCallExpCS = new CallExpCSElements();
		this.pPrimaryExpCS = new PrimaryExpCSElements();
		this.pSelfExpCS = new SelfExpCSElements();
		this.pNavigationExpCS = new NavigationExpCSElements();
		this.pLoopExpCS = new LoopExpCSElements();
		this.pCollectExpCS = new CollectExpCSElements();
		this.pIteratorVarCS = new IteratorVarCSElements();
		this.pIterateExpCS = new IterateExpCSElements();
		this.pAccVarCS = new AccVarCSElements();
		this.pNameExpCS = new NameExpCSElements();
		this.pRoundedBracketClauseCS = new RoundedBracketClauseCSElements();
		this.pLiteralExpCS = new LiteralExpCSElements();
		this.pIntLiteralExpCS = new IntLiteralExpCSElements();
		this.pBooleanLiteralExpCS = new BooleanLiteralExpCSElements();
		this.pNullLiteralExpCS = new NullLiteralExpCSElements();
		this.eCollectionKindCS = new CollectionKindCSElements();
		this.pCollectionLiteralExpCS = new CollectionLiteralExpCSElements();
		this.pCollectionLiteralPartCS = new CollectionLiteralPartCSElements();
		this.pLetExpCS = new LetExpCSElements();
		this.pLetVarCS = new LetVarCSElements();
		this.pPathNameCS = new PathNameCSElements();
		this.pPathElementCS = new PathElementCSElements();
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.qvtd.doc.MiniOCLCS".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	
	
	public TerminalsGrammarAccess getTerminalsGrammarAccess() {
		return gaTerminals;
	}

	
	//RootCS:
	//	imports+=ImportCS* (packages+=PackageCS
	//	| constraints+=ConstraintsDefCS)*;
	public RootCSElements getRootCSAccess() {
		return pRootCS;
	}
	
	public ParserRule getRootCSRule() {
		return getRootCSAccess().getRule();
	}
	
	//ImportCS:
	//	'import' (alias=ID ':') uri=STRING ';';
	public ImportCSElements getImportCSAccess() {
		return pImportCS;
	}
	
	public ParserRule getImportCSRule() {
		return getImportCSAccess().getRule();
	}
	
	//PackageCS:
	//	'package' name=ID '{' (packages+=PackageCS
	//	//|classifiers+=ClassifierCS
	//	| classes+=ClassCS)*
	//	'}';
	public PackageCSElements getPackageCSAccess() {
		return pPackageCS;
	}
	
	public ParserRule getPackageCSRule() {
		return getPackageCSAccess().getRule();
	}
	
	////ClassifierCS:
	////   ClassCS | DatatypeCS
	////;
	//ClassCS:
	//	'class' name=ID ('extends' extends=PathNameCS)? '{' (properties+=PropertyCS
	//	| operations+=OperationCS)*
	//	'}';
	public ClassCSElements getClassCSAccess() {
		return pClassCS;
	}
	
	public ParserRule getClassCSRule() {
		return getClassCSAccess().getRule();
	}
	
	////DatatypeCS:
	////  'datatype' name=ID ':' typeName=STRING ';'
	////;
	//PropertyCS: //('attribute' | 'containment' | 'cross_reference')
	//	'prop' name=ID ':' typeRef=PathNameCS multiplicity=MultiplicityCS? ';';
	public PropertyCSElements getPropertyCSAccess() {
		return pPropertyCS;
	}
	
	public ParserRule getPropertyCSRule() {
		return getPropertyCSAccess().getRule();
	}
	
	//MultiplicityCS:
	//	'[' (opt?='?' | mult?='*' | mandatory=INT | lowerInt=INT '..' (upperInt=INT | upperMult?='*'))
	//	']';
	public MultiplicityCSElements getMultiplicityCSAccess() {
		return pMultiplicityCS;
	}
	
	public ParserRule getMultiplicityCSRule() {
		return getMultiplicityCSAccess().getRule();
	}
	
	//OperationCS:
	//	'op' name=ID
	//	'(' (params+=ParameterCS (',' params+=ParameterCS)*)? ')'
	//	':' resultRef=PathNameCS
	//	'=' body=ExpCS
	//	';';
	public OperationCSElements getOperationCSAccess() {
		return pOperationCS;
	}
	
	public ParserRule getOperationCSRule() {
		return getOperationCSAccess().getRule();
	}
	
	//ParameterCS:
	//	name=ID ':' typeRef=PathNameCS;
	public ParameterCSElements getParameterCSAccess() {
		return pParameterCS;
	}
	
	public ParserRule getParameterCSRule() {
		return getParameterCSAccess().getRule();
	}
	
	//ConstraintsDefCS:
	//	'context' typeRef=PathNameCS '{'
	//	invariants+=InvariantCS*
	//	'}';
	public ConstraintsDefCSElements getConstraintsDefCSAccess() {
		return pConstraintsDefCS;
	}
	
	public ParserRule getConstraintsDefCSRule() {
		return getConstraintsDefCSAccess().getRule();
	}
	
	//InvariantCS:
	//	'inv' ':' exp=ExpCS ';';
	public InvariantCSElements getInvariantCSAccess() {
		return pInvariantCS;
	}
	
	public ParserRule getInvariantCSRule() {
		return getInvariantCSAccess().getRule();
	}
	
	//// Expressions
	//ExpCS:
	//	EqualityExpCS;
	public ExpCSElements getExpCSAccess() {
		return pExpCS;
	}
	
	public ParserRule getExpCSRule() {
		return getExpCSAccess().getRule();
	}
	
	//EqualityExpCS:
	//	CallExpCS ({EqualityExpCS.left=current} opName=('=' | '<>') right=CallExpCS)*;
	public EqualityExpCSElements getEqualityExpCSAccess() {
		return pEqualityExpCS;
	}
	
	public ParserRule getEqualityExpCSRule() {
		return getEqualityExpCSAccess().getRule();
	}
	
	//CallExpCS:
	//	PrimaryExpCS ({CallExpCS.source=current} opName=('.' | '->') navExp=NavigationExpCS)*;
	public CallExpCSElements getCallExpCSAccess() {
		return pCallExpCS;
	}
	
	public ParserRule getCallExpCSRule() {
		return getCallExpCSAccess().getRule();
	}
	
	//PrimaryExpCS:
	//	SelfExpCS | NameExpCS | LiteralExpCS | LetExpCS;
	public PrimaryExpCSElements getPrimaryExpCSAccess() {
		return pPrimaryExpCS;
	}
	
	public ParserRule getPrimaryExpCSRule() {
		return getPrimaryExpCSAccess().getRule();
	}
	
	//SelfExpCS:
	//	{SelfExpCS} 'self';
	public SelfExpCSElements getSelfExpCSAccess() {
		return pSelfExpCS;
	}
	
	public ParserRule getSelfExpCSRule() {
		return getSelfExpCSAccess().getRule();
	}
	
	//NavigationExpCS:
	//	LoopExpCS | NameExpCS;
	public NavigationExpCSElements getNavigationExpCSAccess() {
		return pNavigationExpCS;
	}
	
	public ParserRule getNavigationExpCSRule() {
		return getNavigationExpCSAccess().getRule();
	}
	
	//LoopExpCS:
	//	CollectExpCS | IterateExpCS;
	public LoopExpCSElements getLoopExpCSAccess() {
		return pLoopExpCS;
	}
	
	public ParserRule getLoopExpCSRule() {
		return getLoopExpCSAccess().getRule();
	}
	
	//CollectExpCS:
	//	'collect' '(' (itVar=IteratorVarCS '|')? exp=ExpCS ')';
	public CollectExpCSElements getCollectExpCSAccess() {
		return pCollectExpCS;
	}
	
	public ParserRule getCollectExpCSRule() {
		return getCollectExpCSAccess().getRule();
	}
	
	//IteratorVarCS:
	//	itName=ID (':' itType=PathNameCS)?;
	public IteratorVarCSElements getIteratorVarCSAccess() {
		return pIteratorVarCS;
	}
	
	public ParserRule getIteratorVarCSRule() {
		return getIteratorVarCSAccess().getRule();
	}
	
	//IterateExpCS:
	//	'iterate' '(' itVar=IteratorVarCS ';' accVar=AccVarCS '|' exp=ExpCS ')';
	public IterateExpCSElements getIterateExpCSAccess() {
		return pIterateExpCS;
	}
	
	public ParserRule getIterateExpCSRule() {
		return getIterateExpCSAccess().getRule();
	}
	
	//AccVarCS:
	//	accName=ID (':' accType=PathNameCS)? '=' accInitExp=ExpCS;
	public AccVarCSElements getAccVarCSAccess() {
		return pAccVarCS;
	}
	
	public ParserRule getAccVarCSRule() {
		return getAccVarCSAccess().getRule();
	}
	
	//NameExpCS:
	//	expName=PathNameCS
	//	roundedBrackets=RoundedBracketClauseCS?;
	public NameExpCSElements getNameExpCSAccess() {
		return pNameExpCS;
	}
	
	public ParserRule getNameExpCSRule() {
		return getNameExpCSAccess().getRule();
	}
	
	//RoundedBracketClauseCS:
	//	{RoundedBracketClauseCS}
	//	'(' (args+=ExpCS (',' args+=ExpCS)*)?
	//	')';
	public RoundedBracketClauseCSElements getRoundedBracketClauseCSAccess() {
		return pRoundedBracketClauseCS;
	}
	
	public ParserRule getRoundedBracketClauseCSRule() {
		return getRoundedBracketClauseCSAccess().getRule();
	}
	
	//LiteralExpCS:
	//	IntLiteralExpCS | BooleanLiteralExpCS | NullLiteralExpCS | CollectionLiteralExpCS;
	public LiteralExpCSElements getLiteralExpCSAccess() {
		return pLiteralExpCS;
	}
	
	public ParserRule getLiteralExpCSRule() {
		return getLiteralExpCSAccess().getRule();
	}
	
	//IntLiteralExpCS:
	//	intSymbol=INT;
	public IntLiteralExpCSElements getIntLiteralExpCSAccess() {
		return pIntLiteralExpCS;
	}
	
	public ParserRule getIntLiteralExpCSRule() {
		return getIntLiteralExpCSAccess().getRule();
	}
	
	//BooleanLiteralExpCS:
	//	{BooleanExpCS} (boolSymbol?='true'
	//	| 'false');
	public BooleanLiteralExpCSElements getBooleanLiteralExpCSAccess() {
		return pBooleanLiteralExpCS;
	}
	
	public ParserRule getBooleanLiteralExpCSRule() {
		return getBooleanLiteralExpCSAccess().getRule();
	}
	
	//NullLiteralExpCS:
	//	{NullLiteralExpCS}
	//	'null';
	public NullLiteralExpCSElements getNullLiteralExpCSAccess() {
		return pNullLiteralExpCS;
	}
	
	public ParserRule getNullLiteralExpCSRule() {
		return getNullLiteralExpCSAccess().getRule();
	}
	
	//enum CollectionKindCS:
	//	Collection;
	public CollectionKindCSElements getCollectionKindCSAccess() {
		return eCollectionKindCS;
	}
	
	public EnumRule getCollectionKindCSRule() {
		return getCollectionKindCSAccess().getRule();
	}
	
	//CollectionLiteralExpCS:
	//	kind=CollectionKindCS '{'
	//	parts+=CollectionLiteralPartCS*
	//	'}';
	public CollectionLiteralExpCSElements getCollectionLiteralExpCSAccess() {
		return pCollectionLiteralExpCS;
	}
	
	public ParserRule getCollectionLiteralExpCSRule() {
		return getCollectionLiteralExpCSAccess().getRule();
	}
	
	//CollectionLiteralPartCS:
	//	first=ExpCS ('..' last=ExpCS)?;
	public CollectionLiteralPartCSElements getCollectionLiteralPartCSAccess() {
		return pCollectionLiteralPartCS;
	}
	
	public ParserRule getCollectionLiteralPartCSRule() {
		return getCollectionLiteralPartCSAccess().getRule();
	}
	
	//LetExpCS:
	//	'let' letVars+=LetVarCS (',' letVars+=LetVarCS)*
	//	'in' inExp=ExpCS;
	public LetExpCSElements getLetExpCSAccess() {
		return pLetExpCS;
	}
	
	public ParserRule getLetExpCSRule() {
		return getLetExpCSAccess().getRule();
	}
	
	//LetVarCS:
	//	name=ID (':' typeRef=PathNameCS)? '=' initExp=ExpCS;
	public LetVarCSElements getLetVarCSAccess() {
		return pLetVarCS;
	}
	
	public ParserRule getLetVarCSRule() {
		return getLetVarCSAccess().getRule();
	}
	
	//PathNameCS:
	//	pathElements+=PathElementCS ('::' pathElements+=PathElementCS)*;
	public PathNameCSElements getPathNameCSAccess() {
		return pPathNameCS;
	}
	
	public ParserRule getPathNameCSRule() {
		return getPathNameCSAccess().getRule();
	}
	
	//PathElementCS:
	//	elementName=ID;
	public PathElementCSElements getPathElementCSAccess() {
		return pPathElementCS;
	}
	
	public ParserRule getPathElementCSRule() {
		return getPathElementCSAccess().getRule();
	}
	
	//terminal ID:
	//	'^'? ('a'..'z' | 'A'..'Z' | '_') ('a'..'z' | 'A'..'Z' | '_' | '0'..'9')*;
	public TerminalRule getIDRule() {
		return gaTerminals.getIDRule();
	}
	
	//terminal INT returns ecore::EInt:
	//	'0'..'9'+;
	public TerminalRule getINTRule() {
		return gaTerminals.getINTRule();
	}
	
	//terminal STRING:
	//	'"' ('\\' . | !('\\' | '"'))* '"' |
	//	"'" ('\\' . | !('\\' | "'"))* "'";
	public TerminalRule getSTRINGRule() {
		return gaTerminals.getSTRINGRule();
	}
	
	//terminal ML_COMMENT:
	//	'/ *'->'* /';
	public TerminalRule getML_COMMENTRule() {
		return gaTerminals.getML_COMMENTRule();
	}
	
	//terminal SL_COMMENT:
	//	'//' !('\n' | '\r')* ('\r'? '\n')?;
	public TerminalRule getSL_COMMENTRule() {
		return gaTerminals.getSL_COMMENTRule();
	}
	
	//terminal WS:
	//	' ' | '\t' | '\r' | '\n'+;
	public TerminalRule getWSRule() {
		return gaTerminals.getWSRule();
	}
	
	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return gaTerminals.getANY_OTHERRule();
	}
}
