/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtcore.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.AbstractExtendingPivotVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;

public abstract class AbstractDomainUsageAnalysis
extends AbstractExtendingPivotVisitor<DomainUsage, EnvironmentFactory>
implements DomainUsageAnalysis.Internal {
    private DomainUsage selfUsage = null;
    protected final @NonNull Map<@NonNull Element, DomainUsage> element2usage = new HashMap<Element, DomainUsage>();

    protected AbstractDomainUsageAnalysis(@NonNull EnvironmentFactory environmentFactory) {
        super((Object)environmentFactory);
    }

    @Override
    public @Nullable DomainUsage basicGetUsage(@Nullable Element element) {
        return this.element2usage.get(element);
    }

    protected @NonNull DomainUsage doNavigationCallExp(@NonNull Property property, @NonNull NavigationCallExp object) {
        DomainUsage knownPropertyUsage;
        DomainUsage actualSourceUsage = this.visit((Element)object.getOwnedSource());
        DomainUsage usage = knownPropertyUsage = this.visit((Element)property);
        RootDomainUsageAnalysis rootAnalysis = this.getRootAnalysis();
        Property oppositeProperty = property.getOpposite();
        if (property.isIsComposite() || oppositeProperty != null && oppositeProperty.isIsComposite() || property == rootAnalysis.getOclContainerProperty() || property == rootAnalysis.getOclContentsProperty()) {
            usage = this.intersection(usage, actualSourceUsage);
        } else if (!(property.isIsImplicit() || rootAnalysis.isDirty(property) || !usage.isMiddle() && !usage.isOutput() || !actualSourceUsage.isInput() || actualSourceUsage.isMiddle() || actualSourceUsage.isOutput())) {
            usage = this.intersection(usage, actualSourceUsage);
        }
        return usage;
    }

    protected @NonNull DomainUsage getAllInstancesUsage(@NonNull OperationCallExp object, @NonNull DomainUsage sourceUsage) {
        return sourceUsage;
    }

    public @NonNull Map<@NonNull Element, DomainUsage> getElements2Usage() {
        return this.element2usage;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return (EnvironmentFactory)this.context;
    }

    protected abstract @NonNull RootDomainUsageAnalysis getRootAnalysis();

    @Override
    public @NonNull DomainUsage getUsage(@NonNull Element element) {
        DomainUsage usage = this.element2usage.get(element);
        if (usage == null) {
            usage = (DomainUsage)element.accept((Visitor)this);
            assert (usage != null) : "null usage for " + element.eClass().getName() + " " + element;
            this.setUsage(element, usage);
        }
        return usage;
    }

    public @NonNull DomainUsage intersection(@NonNull DomainUsage firstUsage, @NonNull DomainUsage secondUsage) {
        int secondMask;
        int firstMask = ((DomainUsage.Internal)firstUsage).getMask();
        if (firstMask == (secondMask = ((DomainUsage.Internal)secondUsage).getMask())) {
            if (firstUsage != secondUsage) {
                if (!firstUsage.isConstant()) {
                    this.replace((DomainUsage.Internal)firstUsage, secondUsage);
                    return secondUsage;
                }
                if (!secondUsage.isConstant()) {
                    this.replace((DomainUsage.Internal)secondUsage, firstUsage);
                    return firstUsage;
                }
            }
            return firstUsage;
        }
        int intersectionMask = firstMask & secondMask;
        RootDomainUsageAnalysis.DomainUsageConstant usage = this.getRootAnalysis().getValidUsage(intersectionMask);
        if (usage != null) {
            if (usage != firstUsage && !firstUsage.isConstant()) {
                this.replace((DomainUsage.Internal)firstUsage, (DomainUsage)usage);
            }
            if (usage != secondUsage && !secondUsage.isConstant()) {
                this.replace((DomainUsage.Internal)secondUsage, (DomainUsage)usage);
            }
            return usage;
        }
        usage = this.getRootAnalysis().createVariableUsage(intersectionMask);
        if (!firstUsage.isConstant()) {
            this.replace((DomainUsage.Internal)firstUsage, (DomainUsage)usage);
        }
        if (!secondUsage.isConstant()) {
            this.replace((DomainUsage.Internal)secondUsage, (DomainUsage)usage);
        }
        return usage;
    }

    protected void popSelfUsage(@Nullable DomainUsage savedUsage) {
        this.selfUsage = savedUsage;
    }

    protected DomainUsage pushSelfUsage(@NonNull DomainUsage usage) {
        DomainUsage oldUsage = this.selfUsage;
        int usageMask = ((DomainUsage.Internal)usage).getMask();
        RootDomainUsageAnalysis.DomainUsageConstant constantUsage = this.getRootAnalysis().getValidUsage(usageMask);
        if (constantUsage == null) {
            usage = this.getRootAnalysis().createVariableUsage(usageMask);
        }
        this.selfUsage = usage;
        return oldUsage;
    }

    protected void replace(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull DomainUsage.Internal oldUsage, @NonNull DomainUsage newUsage) {
        Iterable elements = oldUsage.getElements();
        if (elements != null) {
            for (Element element : elements) {
                this.setUsage(element, newUsage);
            }
        }
    }

    protected void setUsage(@NonNull Element element, @NonNull DomainUsage newUsage) {
        this.element2usage.put(element, newUsage);
        ((DomainUsage.Internal)newUsage).addUsedBy(element);
    }

    public String toString() {
        HashMap<@NonNull String, DomainUsage> map = new HashMap<String, DomainUsage>(this.element2usage.size());
        ArrayList<@NonNull String> keys = new ArrayList<String>(this.element2usage.size());
        for (Map.Entry<Element, DomainUsage> entry : this.element2usage.entrySet()) {
            Element element = entry.getKey();
            String key = String.valueOf(element.eClass().getName()) + " : " + element;
            map.put(key, entry.getValue());
            keys.add(key);
        }
        Collections.sort(keys);
        StringBuilder s = new StringBuilder();
        for (String key : keys) {
            DomainUsage usage = (DomainUsage)map.get(key);
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(key);
            s.append(" => ");
            s.append(usage);
        }
        return s.toString();
    }

    public @NonNull DomainUsage union(@NonNull DomainUsage firstUsage, @NonNull DomainUsage secondUsage) {
        int secondMask;
        int firstMask = ((DomainUsage.Internal)firstUsage).getMask();
        int unionMask = firstMask | (secondMask = ((DomainUsage.Internal)secondUsage).getMask());
        if (unionMask == firstMask && firstUsage.isConstant()) {
            return firstUsage;
        }
        if (unionMask == secondMask && secondUsage.isConstant()) {
            return secondUsage;
        }
        if (firstUsage.isConstant() && secondUsage.isConstant()) {
            return this.getRootAnalysis().getConstantUsage(unionMask);
        }
        return this.getRootAnalysis().createVariableUsage(unionMask);
    }

    @Override
    public @NonNull DomainUsage visit(@Nullable Element element) {
        if (element == null) {
            return this.getRootAnalysis().getAnyUsage();
        }
        DomainUsage usage = this.element2usage.get(element);
        if (usage == null) {
            usage = (DomainUsage)element.accept((Visitor)this);
            assert (usage != null) : "null usage for " + element.eClass().getName() + " " + element;
            this.setUsage(element, usage);
        }
        return usage;
    }

    public @NonNull DomainUsage visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
    }

    public @NonNull DomainUsage visitClass(@NonNull Class object) {
        DomainUsage usage = (DomainUsage)this.getRootAnalysis().class2usage.get(object);
        if (usage != null) {
            return usage;
        }
        return this.getRootAnalysis().getPrimitiveUsage();
    }

    public @NonNull DomainUsage visitCollectionItem(@NonNull CollectionItem object) {
        return this.visit((Element)object.getOwnedItem());
    }

    public @NonNull DomainUsage visitCollectionLiteralExp(@NonNull CollectionLiteralExp object) {
        DomainUsage usage = this.visit((Element)((CollectionType)object.getType()).getElementType());
        for (CollectionLiteralPart part : object.getOwnedParts()) {
            usage = this.intersection(usage, this.visit((Element)part));
        }
        return usage;
    }

    public @NonNull DomainUsage visitCollectionRange(@NonNull CollectionRange object) {
        DomainUsage firstUsage = this.visit((Element)object.getOwnedFirst());
        DomainUsage lastUsage = this.visit((Element)object.getOwnedLast());
        return this.intersection(firstUsage, lastUsage);
    }

    public @NonNull DomainUsage visitCollectionType(@NonNull CollectionType object) {
        return this.visit((Element)object.getElementType());
    }

    public @NonNull DomainUsage visitExpressionInOCL(@NonNull ExpressionInOCL object) {
        Variable ownedContext;
        OCLExpression ownedBody = object.getOwnedBody();
        if (ownedBody == null && object.getBody() != null) {
            try {
                ownedBody = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.context).parseSpecification((LanguageExpression)object).getOwnedBody();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        if ((ownedContext = object.getOwnedContext()) != null && this.selfUsage != null) {
            this.setUsage((Element)ownedContext, this.selfUsage);
        } else {
            this.visit((Element)ownedContext);
        }
        for (Variable parameter : object.getOwnedParameters()) {
            this.visit((Element)parameter);
        }
        this.visit((Element)object.getOwnedResult());
        return this.visit((Element)ownedBody);
    }

    public @NonNull DomainUsage visitIfExp(@NonNull IfExp object) {
        DomainUsage conditionUsage = this.visit((Element)object.getOwnedCondition());
        DomainUsage thenUsage = this.visit((Element)object.getOwnedThen());
        DomainUsage elseUsage = this.visit((Element)object.getOwnedElse());
        return this.intersection(thenUsage, elseUsage);
    }

    public @NonNull DomainUsage visitIterateExp(@NonNull IterateExp object) {
        Iteration iteration;
        DomainUsage sourceUsage = this.visit((Element)object.getOwnedSource());
        for (Variable iterator : object.getOwnedIterators()) {
            if (iterator == null) continue;
            this.setUsage((Element)iterator, sourceUsage);
        }
        this.visit((Element)object.getOwnedResult());
        DomainUsage bodyUsage = this.visit((Element)object.getOwnedBody());
        TemplateParameterSubstitutionVisitor visitor = new TemplateParameterSubstitutionVisitor((EnvironmentFactoryInternal)this.context, object.getOwnedSource().getType(), null);
        object.accept((Visitor)visitor);
        Iteration eObject = iteration = object.getReferredIteration();
        while (eObject != null) {
            TemplateSignature ownedSignature;
            if (eObject instanceof TemplateableElement && (ownedSignature = ((TemplateableElement)eObject).getOwnedSignature()) != null) {
                for (TemplateParameter templateParameter : ownedSignature.getOwnedParameters()) {
                    if (templateParameter == null) continue;
                    Type templateParameterType = visitor.get(templateParameter);
                    DomainUsage templateParameterUsage = this.visit((Element)templateParameterType);
                    this.setUsage((Element)templateParameter, templateParameterUsage);
                }
            }
            eObject = eObject.eContainer();
        }
        return this.visit((Element)iteration.getType());
    }

    public @NonNull DomainUsage visitIteratorExp(@NonNull IteratorExp object) {
        Iteration iteration;
        DomainUsage sourceUsage = this.visit((Element)object.getOwnedSource());
        for (Variable iterator : object.getOwnedIterators()) {
            if (iterator == null) continue;
            this.setUsage((Element)iterator, sourceUsage);
        }
        DomainUsage bodyUsage = this.visit((Element)object.getOwnedBody());
        TemplateParameterSubstitutionVisitor visitor = new TemplateParameterSubstitutionVisitor((EnvironmentFactoryInternal)this.context, object.getOwnedSource().getType(), null);
        object.accept((Visitor)visitor);
        Iteration eObject = iteration = object.getReferredIteration();
        while (eObject != null) {
            TemplateSignature ownedSignature;
            if (eObject instanceof TemplateableElement && (ownedSignature = ((TemplateableElement)eObject).getOwnedSignature()) != null) {
                for (TemplateParameter templateParameter : ownedSignature.getOwnedParameters()) {
                    if (templateParameter == null) continue;
                    Type templateParameterType = visitor.get(templateParameter);
                    DomainUsage templateParameterUsage = this.visit((Element)templateParameterType);
                    this.setUsage((Element)templateParameter, templateParameterUsage);
                }
            }
            eObject = eObject.eContainer();
        }
        return this.visit((Element)object.getType());
    }

    public @NonNull DomainUsage visitLetExp(@NonNull LetExp object) {
        this.visit((Element)object.getOwnedVariable());
        return this.visit((Element)object.getOwnedIn());
    }

    public @NonNull DomainUsage visitLiteralExp(@NonNull LiteralExp object) {
        return this.getRootAnalysis().getPrimitiveUsage();
    }

    public @NonNull DomainUsage visitMapLiteralExp(@NonNull MapLiteralExp object) {
        RootDomainUsageAnalysis.DomainUsageConstant usage = this.getRootAnalysis().getAnyUsage();
        for (MapLiteralPart part : object.getOwnedParts()) {
            usage = this.intersection((DomainUsage)usage, this.visit((Element)part));
        }
        return usage;
    }

    public @NonNull DomainUsage visitMapLiteralPart(@NonNull MapLiteralPart object) {
        DomainUsage keyUsage = this.visit((Element)object.getOwnedKey());
        DomainUsage valueUsage = this.visit((Element)object.getOwnedValue());
        return this.intersection(keyUsage, valueUsage);
    }

    public @NonNull DomainUsage visitNullLiteralExp(@NonNull NullLiteralExp object) {
        return this.getRootAnalysis().createVariableUsage(this.getRootAnalysis().getAnyMask());
    }

    public @NonNull DomainUsage visitOperation(@NonNull Operation object) {
        DomainUsage savedUsage = this.pushSelfUsage(this.visit((Element)object.getOwningClass()));
        try {
            for (Parameter parameter : object.getOwnedParameters()) {
                this.visit((Element)parameter);
            }
            LanguageExpression bodyExpression = object.getBodyExpression();
            if (bodyExpression == null) {
                DomainUsage domainUsage = this.visit((Element)object.getType());
                return domainUsage;
            }
            ExpressionInOCL parseSpecification = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.context).parseSpecification(bodyExpression);
            DomainUsage domainUsage = this.visit((Element)parseSpecification);
            return domainUsage;
        }
        finally {
            this.popSelfUsage(savedUsage);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull DomainUsage visitOperationCallExp(@NonNull OperationCallExp object) {
        DomainUsage sourceUsage = this.visit((Element)object.getOwnedSource());
        DomainUsage savedUsage = this.pushSelfUsage(sourceUsage);
        try {
            DomainUsage operationCallUsage;
            Operation operation = (Operation)ClassUtil.nonNullState((Object)object.getReferredOperation());
            RootDomainUsageAnalysis rootAnalysis = this.getRootAnalysis();
            OperationId operationId = operation.getOperationId();
            if (operationId == rootAnalysis.getOclContainerId() || operationId == rootAnalysis.getOclContentsId()) {
                DomainUsage domainUsage = sourceUsage;
                return domainUsage;
            }
            String operationName = object.getReferredOperation().getName();
            if ("allInstances".equals(operationName)) {
                DomainUsage domainUsage = this.getAllInstancesUsage(object, sourceUsage);
                return domainUsage;
            }
            if ("=".equals(operationName) || "<>".equals(operationName)) {
                DomainUsage rightUsage = this.visit((Element)object.getOwnedArguments().get(0));
                this.intersection(sourceUsage, rightUsage);
                RootDomainUsageAnalysis.DomainUsageConstant domainUsageConstant = this.getRootAnalysis().getPrimitiveUsage();
                return domainUsageConstant;
            }
            TemplateParameter templateParameter = operation.getType().isTemplateParameter();
            if (templateParameter != null) {
                List ownedParameters = operation.getOwnedParameters();
                int iMax = Math.min(ownedParameters.size(), object.getOwnedArguments().size());
                int i = 0;
                while (i < iMax) {
                    Parameter parameter = (Parameter)ownedParameters.get(i);
                    if (parameter.isIsTypeof() && parameter.getType() == templateParameter) {
                        DomainUsage argumentUsage;
                        OCLExpression argument = (OCLExpression)object.getOwnedArguments().get(i);
                        DomainUsage domainUsage = argumentUsage = this.visit((Element)argument);
                        return domainUsage;
                    }
                    ++i;
                }
            }
            DomainUsageAnalysis analysis = rootAnalysis.getAnalysis(operation);
            HashMap<DomainUsage, DomainUsage> referred2specialized = new HashMap<DomainUsage, DomainUsage>();
            @NonNull List ownedParameters = ClassUtil.nullFree((List)operation.getOwnedParameters());
            int iMax = Math.min(ownedParameters.size(), object.getOwnedArguments().size());
            int i = 0;
            while (i < iMax) {
                DomainUsage specializedParameterUsage;
                Parameter parameter = (Parameter)ownedParameters.get(i);
                OCLExpression argument = (OCLExpression)object.getOwnedArguments().get(i);
                DomainUsage referredParameterUsage = analysis.getUsage((Element)parameter);
                if (referredParameterUsage.isConstant()) {
                    specializedParameterUsage = referredParameterUsage;
                } else {
                    specializedParameterUsage = (DomainUsage)referred2specialized.get(referredParameterUsage);
                    if (specializedParameterUsage == null) {
                        specializedParameterUsage = ((DomainUsage.Internal)referredParameterUsage).cloneVariable();
                        referred2specialized.put(referredParameterUsage, specializedParameterUsage);
                    }
                }
                DomainUsage argumentUsage = this.visit((Element)argument);
                this.intersection(argumentUsage, specializedParameterUsage);
                ++i;
            }
            DomainUsage operationUsage = analysis.basicGetUsage((Element)operation);
            if (operationUsage != null && !operationUsage.isConstant()) {
                operationUsage = ((DomainUsage.Internal)operationUsage).cloneVariable();
            }
            DomainUsage domainUsage = operationCallUsage = this.visit((Element)object.getType());
            return domainUsage;
        }
        finally {
            this.popSelfUsage(savedUsage);
        }
    }

    public @NonNull DomainUsage visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp object) {
        Property property = (Property)ClassUtil.nonNullState((Object)object.getReferredProperty());
        Property oppositeProperty = (Property)ClassUtil.nonNullState((Object)property.getOpposite());
        return this.doNavigationCallExp(oppositeProperty, (NavigationCallExp)object);
    }

    public @NonNull DomainUsage visitParameter(@NonNull Parameter object) {
        DomainUsage usage = this.visit((Element)object.getType());
        return this.getRootAnalysis().getValidOrVariableUsage(usage);
    }

    public @NonNull DomainUsage visitPrimitiveType(@NonNull PrimitiveType object) {
        return this.getRootAnalysis().getPrimitiveUsage();
    }

    public @NonNull DomainUsage visitProperty(@NonNull Property property) {
        DomainUsage annotatedUsage = this.getRootAnalysis().getAnnotatedUsage(property);
        DomainUsage superUsage = (DomainUsage)super.visitProperty(property);
        if (annotatedUsage != null) {
            return this.intersection(annotatedUsage, superUsage);
        }
        return superUsage;
    }

    public @NonNull DomainUsage visitPropertyCallExp(@NonNull PropertyCallExp object) {
        Property property = (Property)ClassUtil.nonNullState((Object)object.getReferredProperty());
        return this.doNavigationCallExp(property, (NavigationCallExp)object);
    }

    public @NonNull DomainUsage visitSelfType(@NonNull SelfType object) {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.selfUsage);
    }

    public @NonNull DomainUsage visitShadowExp(@NonNull ShadowExp object) {
        DomainUsage usage = this.visit((Element)object.getType());
        for (ShadowPart part : object.getOwnedParts()) {
            this.visit((Element)part);
        }
        return usage;
    }

    public @NonNull DomainUsage visitShadowPart(@NonNull ShadowPart object) {
        this.visit((Element)object.getOwnedInit());
        return this.visit((Element)object.getType());
    }

    public @NonNull DomainUsage visitTemplateParameter(@NonNull TemplateParameter object) {
        int anyMask;
        RootDomainUsageAnalysis rootAnalysis = this.getRootAnalysis();
        RootDomainUsageAnalysis.DomainUsageConstant usage = rootAnalysis.getValidUsage(anyMask = rootAnalysis.getAnyMask());
        if (usage == null) {
            usage = rootAnalysis.createVariableUsage(anyMask);
        }
        return usage;
    }

    public @NonNull DomainUsage visitTupleLiteralExp(@NonNull TupleLiteralExp object) {
        RootDomainUsageAnalysis.DomainUsageConstant usage = this.getRootAnalysis().getAnyUsage();
        for (TupleLiteralPart part : object.getOwnedParts()) {
            usage = this.intersection((DomainUsage)usage, this.visit((Element)part));
        }
        return usage;
    }

    public @NonNull DomainUsage visitTupleLiteralPart(@NonNull TupleLiteralPart object) {
        return this.visit((Element)object.getType());
    }

    public @NonNull DomainUsage visitTupleType(@NonNull TupleType object) {
        RootDomainUsageAnalysis.DomainUsageConstant usage = this.getRootAnalysis().getAnyUsage();
        for (Property part : object.getOwnedProperties()) {
            usage = this.intersection((DomainUsage)usage, this.visit((Element)part.getType()));
        }
        return usage;
    }

    public @NonNull DomainUsage visitType(@NonNull Type object) {
        return this.getRootAnalysis().getPrimitiveUsage();
    }

    public @NonNull DomainUsage visitTypeExp(@NonNull TypeExp object) {
        DomainUsage usage = this.visit((Element)object.getReferredType());
        return this.getRootAnalysis().getValidOrVariableUsage(usage);
    }

    public @NonNull DomainUsage visitTypedElement(@NonNull TypedElement object) {
        return this.visit((Element)object.getType());
    }

    public @NonNull DomainUsage visitVariableDeclaration(@NonNull VariableDeclaration object) {
        return this.visit((Element)object.getType());
    }

    public @NonNull DomainUsage visitVariableExp(@NonNull VariableExp object) {
        VariableDeclaration referredVariable = object.getReferredVariable();
        DomainUsage usage = this.visit((Element)referredVariable);
        assert (usage != null) : referredVariable + " usage not defined";
        return usage;
    }
}

