/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvti.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.AddStatement;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.BufferStatement;
import org.eclipse.qvtd.pivot.qvtimperative.CheckStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.LoopParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.LoopVariable;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.VariableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;

public class QVTimperativeDomainUsageAnalysis
extends RootDomainUsageAnalysis
implements QVTimperativeVisitor<DomainUsage> {
    public QVTimperativeDomainUsageAnalysis(@NonNull EnvironmentFactory environmentFactory) {
        super(environmentFactory);
    }

    public @NonNull Map<Element, DomainUsage> analyzeTransformation(@NonNull Transformation transformation) {
        Variable ownedContext;
        int checkedMask = 0;
        int enforcedMask = 0;
        CompleteModel completeModel = ((EnvironmentFactory)this.context).getCompleteModel();
        for (TypedModel typedModel : ClassUtil.nullFree((EList)transformation.getModelParameter())) {
            boolean isEnforced = false;
            boolean isChecked = false;
            ImperativeTypedModel imperativeTypedModel = (ImperativeTypedModel)typedModel;
            if (imperativeTypedModel.isIsTrace()) {
                this.setTraceTypedModel(typedModel);
            } else if (imperativeTypedModel.isIsEnforced()) {
                isEnforced = true;
            } else if (imperativeTypedModel.isIsChecked()) {
                isChecked = true;
            } else if (imperativeTypedModel.isIsPrimitive()) continue;
            int nextBit = this.add(typedModel);
            int bitMask = 1 << nextBit;
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull RootDomainUsageAnalysis.DomainUsageConstant typedModelUsage = this.getConstantUsage(bitMask);
            this.addValidUsage(bitMask, typedModelUsage);
            if (isEnforced) {
                enforcedMask |= bitMask;
            }
            if (isChecked) {
                checkedMask |= bitMask;
            }
            this.setUsage((Element)typedModel, (DomainUsage)typedModelUsage);
            Variable ownedContext2 = typedModel.getOwnedContext();
            if (ownedContext2 != null) {
                this.setUsage((Element)ownedContext2, (DomainUsage)typedModelUsage);
            }
            HashSet<@NonNull CompleteClass> completeClasses = new HashSet<CompleteClass>();
            for (Package asPackage : QVTbaseUtil.getAllUsedPackages((TypedModel)typedModel)) {
                CompletePackage completePackage = completeModel.getCompletePackage(asPackage);
                for (CompleteClass completeClass : ClassUtil.nullFree((List)completePackage.getOwnedCompleteClasses())) {
                    for (CompleteClass superCompleteClass : completeClass.getSuperCompleteClasses()) {
                        completeClasses.add(superCompleteClass);
                    }
                }
            }
            for (CompleteClass completeClass : completeClasses) {
                for (Class asClass : ClassUtil.nullFree((List)completeClass.getPartialClasses())) {
                    RootDomainUsageAnalysis.DomainUsageConstant oldUsage = (RootDomainUsageAnalysis.DomainUsageConstant)this.class2usage.get(asClass);
                    RootDomainUsageAnalysis.DomainUsageConstant classUsage = typedModelUsage;
                    if (asClass instanceof DataType && !(asClass instanceof CollectionType)) {
                        classUsage = this.getPrimitiveUsage();
                    }
                    RootDomainUsageAnalysis.DomainUsageConstant newUsage = oldUsage != null ? classUsage.union(oldUsage) : classUsage;
                    this.class2usage.put(asClass, newUsage);
                }
            }
        }
        for (Class asClass : this.class2usage.keySet()) {
            DomainUsage newUsage = (DomainUsage)this.class2usage.get(asClass);
            assert (newUsage != null);
            for (Property property : ClassUtil.nullFree((List)asClass.getOwnedProperties())) {
                this.property2containingClassUsage.put(property, newUsage);
                DomainUsage referredTypeUsage = this.getAnnotatedUsage(property);
                if (referredTypeUsage != null) continue;
                referredTypeUsage = this.visit((Element)property.getType());
            }
        }
        this.class2usage.put(((StandardLibraryInternal)this.standardLibrary).getOclTypeType(), this.getAnyUsage());
        this.setInputUsage(checkedMask);
        this.setOutputUsage(enforcedMask);
        DomainUsage middleUsage = this.setMiddleUsage(~checkedMask & ~enforcedMask & ~PRIMITIVE_USAGE_BIT_MASK.intValue());
        TypedModel traceTypedModel = this.basicGetTraceTypedModel();
        if (traceTypedModel != null) {
            this.setUsage((Element)traceTypedModel, middleUsage);
        }
        if ((ownedContext = transformation.getOwnedContext()) != null) {
            this.setUsage((Element)ownedContext, (DomainUsage)this.getAnyUsage());
        }
        this.analyzePropertyAssignments(transformation);
        this.visit((Element)transformation);
        return this.element2usage;
    }

    public @NonNull DomainUsage visitAddStatement(@NonNull AddStatement object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitAppendParameter(@NonNull AppendParameter object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitAppendParameterBinding(@NonNull AppendParameterBinding object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitBufferStatement(@NonNull BufferStatement object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitCheckStatement(@NonNull CheckStatement object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitConnectionVariable(@NonNull ConnectionVariable object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitDeclareStatement(@NonNull DeclareStatement object) {
        return this.getUsage((Element)PivotUtil.getType((TypedElement)object));
    }

    public @NonNull DomainUsage visitGuardParameter(@NonNull GuardParameter object) {
        return this.getUsage((Element)QVTimperativeUtil.getReferredTypedModel((GuardParameter)object));
    }

    public @NonNull DomainUsage visitGuardParameterBinding(@NonNull GuardParameterBinding object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitImperativeModel(@NonNull ImperativeModel object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitImperativeTransformation(@NonNull ImperativeTransformation object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitImperativeTypedModel(@NonNull ImperativeTypedModel object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitLoopParameterBinding(@NonNull LoopParameterBinding object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitLoopVariable(@NonNull LoopVariable object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitMapping(@NonNull Mapping object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitMappingCall(@NonNull MappingCall object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitMappingLoop(@NonNull MappingLoop object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitMappingParameter(@NonNull MappingParameter object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitMappingParameterBinding(@NonNull MappingParameterBinding object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitMappingStatement(@NonNull MappingStatement object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitNewStatement(@NonNull NewStatement object) {
        return this.getUsage((Element)QVTimperativeUtil.getReferredTypedModel((NewStatement)object));
    }

    public @NonNull DomainUsage visitObservableStatement(@NonNull ObservableStatement object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitSetStatement(@NonNull SetStatement object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitSimpleParameter(@NonNull SimpleParameter object) {
        return this.getUsage((Element)QVTimperativeUtil.getReferredTypedModel((SimpleParameter)object));
    }

    public @NonNull DomainUsage visitSimpleParameterBinding(@NonNull SimpleParameterBinding object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitStatement(@NonNull Statement object) {
        return this.getNoneUsage();
    }

    public @NonNull DomainUsage visitVariableStatement(@NonNull VariableStatement object) {
        return this.getNoneUsage();
    }
}

