/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.qvtr2umlx;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationModel;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.util.AbstractExtendingQVTrelationVisitor;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;
import org.eclipse.qvtd.umlx.RelDiagram;
import org.eclipse.qvtd.umlx.RelDomainNode;
import org.eclipse.qvtd.umlx.RelInvocationEdge;
import org.eclipse.qvtd.umlx.RelInvocationNode;
import org.eclipse.qvtd.umlx.RelPatternEdge;
import org.eclipse.qvtd.umlx.RelPatternNode;
import org.eclipse.qvtd.umlx.TxDiagram;
import org.eclipse.qvtd.umlx.TxKeyNode;
import org.eclipse.qvtd.umlx.TxPackageNode;
import org.eclipse.qvtd.umlx.TxParameterNode;
import org.eclipse.qvtd.umlx.TxPartNode;
import org.eclipse.qvtd.umlx.TxQueryNode;
import org.eclipse.qvtd.umlx.TxTypedModelNode;
import org.eclipse.qvtd.umlx.UMLXElement;
import org.eclipse.qvtd.umlx.UMLXFactory;
import org.eclipse.qvtd.umlx.UMLXModel;
import org.eclipse.qvtd.umlx.UMLXTypedElement;
import org.eclipse.qvtd.umlx.compiler.UMLXCompilerChain;
import org.eclipse.qvtd.umlx.utilities.UMLXUtil;

public class QVTr2UMLX {
    public static final @NonNull TracingOption DEAD_VARIABLE = new TracingOption(UMLXCompilerChain.PLUGIN_ID, "qvtr2umlx/dead-variable");
    protected final @NonNull EnvironmentFactory environmentFactory;
    private final @NonNull Resource qvtrResource;
    private final @NonNull Resource umlxResource;
    private final @NonNull Map<@NonNull Element, @NonNull UMLXElement> qvtr2umlx = new HashMap<Element, UMLXElement>();
    private final @NonNull Set<@NonNull Element> references = new HashSet<Element>();

    public QVTr2UMLX(@NonNull EnvironmentFactory environmentFactory, @NonNull Resource qvtrResource, @NonNull Resource umlxResource) {
        this.environmentFactory = environmentFactory;
        this.qvtrResource = qvtrResource;
        this.umlxResource = umlxResource;
    }

    public void addReference(@NonNull Element qvtrElement) {
        this.references.add(qvtrElement);
    }

    protected <T extends UMLXElement> @Nullable T basicGetUMLXElement(@NonNull java.lang.Class<T> umlxClass, @NonNull Element qvtrElement) {
        UMLXElement umlxElement = this.qvtr2umlx.get(qvtrElement);
        if (umlxElement == null) {
            return null;
        }
        if (!umlxClass.isAssignableFrom(umlxElement.getClass())) {
            throw new ClassCastException("UMLX element " + umlxElement + " cannot be cast to " + umlxClass);
        }
        UMLXElement castElement = umlxElement;
        return (T)castElement;
    }

    protected @NonNull RelDomainNode getContainingRelDomainNode(@NonNull OCLExpression qvtrExpression) {
        EObject eContainer;
        OCLExpression eObject = qvtrExpression;
        while ((eContainer = eObject.eContainer()) != null) {
            if (eContainer instanceof RelationCallExp) {
                EObject eContainer2;
                RelationCallExp qvtrRelationCallExp = (RelationCallExp)eContainer;
                int argumentIndex = qvtrRelationCallExp.getArgument().indexOf((Object)eObject);
                assert (argumentIndex >= 0);
                RelationDomain referredDomain = QVTrelationUtil.getRelationCallExpArgumentDomain((RelationCallExp)qvtrRelationCallExp, (int)argumentIndex);
                RelationCallExp eObject2 = qvtrRelationCallExp;
                while ((eContainer2 = eObject2.eContainer()) != null) {
                    if (eContainer2 instanceof Relation) {
                        Relation qvtrRelation = (Relation)eContainer2;
                        RelationDomain rRelationDomain = QVTrelationUtil.getRelationDomain((Relation)qvtrRelation, (TypedModel)QVTrelationUtil.getTypedModel((Domain)referredDomain));
                        return this.getUMLXElement(RelDomainNode.class, (Element)rRelationDomain);
                    }
                    eObject2 = eContainer2;
                }
            }
            if (eContainer instanceof RelationDomain) {
                return this.getUMLXElement(RelDomainNode.class, (Element)((RelationDomain)eContainer));
            }
            eObject = eContainer;
        }
        Relation qvtrRelation = QVTrelationUtil.getContainingRelation((EObject)qvtrExpression);
        RelDiagram relDiagram = this.getUMLXElement(RelDiagram.class, (Element)qvtrRelation);
        return this.getPrimitiveRelDomainNode(relDiagram);
    }

    public @Nullable EStructuralFeature getEcoreOf(@NonNull Property qvtrProperty) {
        EStructuralFeature ecoreOfPivot = (EStructuralFeature)this.environmentFactory.getMetamodelManager().getEcoreOfPivot(EStructuralFeature.class, (Element)qvtrProperty);
        return ecoreOfPivot;
    }

    public @Nullable EClassifier getEcoreOf(@NonNull Type qvtrType) {
        EClassifier ecoreOfPivot = (EClassifier)qvtrType.getESObject();
        if (ecoreOfPivot == null && qvtrType instanceof PrimitiveType) {
            StandardLibrary standardLibrary = this.environmentFactory.getStandardLibrary();
            if (qvtrType == standardLibrary.getStringType()) {
                return EcorePackage.Literals.ESTRING;
            }
            if (qvtrType == standardLibrary.getBooleanType()) {
                return EcorePackage.Literals.EBOOLEAN_OBJECT;
            }
            if (qvtrType == standardLibrary.getIntegerType()) {
                return EcorePackage.Literals.EBIG_INTEGER;
            }
            if (qvtrType == standardLibrary.getRealType()) {
                return EcorePackage.Literals.EBIG_DECIMAL;
            }
        }
        return ecoreOfPivot;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    protected @NonNull String getPackagePath(@NonNull StringBuilder s, @NonNull Namespace qvtrNamespace) {
        EObject eContainer = qvtrNamespace.eContainer();
        if (eContainer instanceof Namespace && !(eContainer instanceof Model)) {
            this.getPackagePath(s, (Namespace)eContainer);
            s.append("::");
        }
        s.append(PivotUtil.getName((NamedElement)qvtrNamespace));
        return s.toString();
    }

    protected @NonNull RelDomainNode getPrimitiveRelDomainNode(@NonNull RelDiagram relDiagram) {
        RelDomainNode relDomainNode2;
        for (RelDomainNode relDomainNode2 : UMLXUtil.getOwnedRelDomainNodes(relDiagram)) {
            if (relDomainNode2.getReferredTxTypedModelNode() != null) continue;
            return relDomainNode2;
        }
        relDomainNode2 = UMLXFactory.eINSTANCE.createRelDomainNode();
        relDiagram.getOwnedRelDomainNodes().add((Object)relDomainNode2);
        return relDomainNode2;
    }

    public @NonNull String getProjectName(@NonNull URI traceURI) {
        URI trimFileExtension = traceURI.trimFileExtension();
        if (trimFileExtension.isPlatform()) {
            return trimFileExtension.segment(1);
        }
        return trimFileExtension.segment(0);
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    protected <T extends UMLXElement> @NonNull T getUMLXElement(@NonNull java.lang.Class<T> umlxClass, @NonNull Element qvtrElement) {
        UMLXElement umlxElement = this.qvtr2umlx.get(qvtrElement);
        if (umlxElement == null) {
            throw new IllegalArgumentException("Missing UMLX element for " + qvtrElement);
        }
        if (!umlxClass.isAssignableFrom(umlxElement.getClass())) {
            throw new ClassCastException("UMLX element " + umlxElement + " cannot be cast to " + umlxClass);
        }
        UMLXElement castElement = umlxElement;
        return (T)castElement;
    }

    protected void install(@NonNull Element qvtrElement, @NonNull UMLXElement umlxElement) {
        UMLXElement oldUmlxElement = this.qvtr2umlx.put(qvtrElement, umlxElement);
        for (Comment comment : QVTbaseUtil.getOwnedComments((Element)qvtrElement)) {
            umlxElement.getComments().add((Object)comment.getBody());
        }
        assert (oldUmlxElement == null);
    }

    public void transform() throws CompilerChainException {
        for (EObject eObject : this.qvtrResource.getContents()) {
            if (!(eObject instanceof RelationModel)) continue;
            UMLXModel umlxModel = UMLXFactory.eINSTANCE.createUMLXModel();
            ((Element)eObject).accept((Visitor)new CreateTransformationVisitor(this, umlxModel));
            this.umlxResource.getContents().add((Object)umlxModel);
        }
        if (!this.references.isEmpty()) {
            ReferenceVisitor referenceVisitor = new ReferenceVisitor(this);
            for (Element element : this.references) {
                element.accept((Visitor)referenceVisitor);
            }
        }
    }

    protected static abstract class AbstractVisitor
    extends AbstractExtendingQVTrelationVisitor<UMLXElement, QVTr2UMLX> {
        public AbstractVisitor(@NonNull QVTr2UMLX context) {
            super((Object)context);
        }

        protected <T1 extends Element, T2 extends UMLXElement> @Nullable T2 create(@Nullable T1 source) {
            if (source == null) {
                return null;
            }
            @Nullable UMLXElement target = (UMLXElement)source.accept((Visitor)this);
            return (T2)target;
        }

        protected <T1 extends Element, T2 extends UMLXElement> void createAll(Iterable<T1> sources, List<? super T2> targets) {
            for (Element source : sources) {
                UMLXElement target = (UMLXElement)source.accept((Visitor)this);
                if (target == null || targets == null) continue;
                targets.add(target);
            }
        }

        protected void setReferredEType(@NonNull UMLXTypedElement umlxTypedElement, @NonNull TypedElement qvtrTypedElement) {
            umlxTypedElement.setIsRequired(qvtrTypedElement.isIsRequired());
            Type qvtrType = PivotUtil.getType((TypedElement)qvtrTypedElement);
            if (qvtrType instanceof CollectionType) {
                CollectionType qvtrCollectionType = (CollectionType)qvtrType;
                umlxTypedElement.setIsMany(true);
                umlxTypedElement.setIsNullFree(qvtrCollectionType.isIsNullFree());
                umlxTypedElement.setIsOrdered(qvtrCollectionType.isOrdered());
                umlxTypedElement.setIsUnique(qvtrCollectionType.isUnique());
                qvtrType = PivotUtil.getElementalType((Type)qvtrCollectionType);
            }
            umlxTypedElement.setReferredEClassifier(((QVTr2UMLX)this.context).getEcoreOf(qvtrType));
        }

        protected <T extends UMLXElement> @NonNull T visit(@NonNull java.lang.Class<T> umlxClass, @NonNull Element qvtrElement) {
            UMLXElement umlxElement = (UMLXElement)qvtrElement.accept((Visitor)this);
            if (umlxElement == null) {
                throw new IllegalArgumentException("Missing UMLX element for " + qvtrElement);
            }
            if (!umlxClass.isAssignableFrom(umlxElement.getClass())) {
                throw new ClassCastException("UMLX element " + umlxElement + " cannot be cast to " + umlxClass);
            }
            UMLXElement castElement = umlxElement;
            return (T)castElement;
        }

        public @Nullable UMLXElement visitOCLExpression(@NonNull OCLExpression qvtrExpression) {
            RelDomainNode relDomainNode = ((QVTr2UMLX)this.context).getContainingRelDomainNode(qvtrExpression);
            RelPatternNode relPatternExpressionNode = UMLXFactory.eINSTANCE.createRelPatternNode();
            ((QVTr2UMLX)this.context).install((Element)qvtrExpression, relPatternExpressionNode);
            String[] stringArray = PrettyPrinter.print((Element)qvtrExpression).split("\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                relPatternExpressionNode.getInitExpressionLines().add((Object)line);
                ++n2;
            }
            relDomainNode.getOwnedRelPatternNodes().add((Object)relPatternExpressionNode);
            return relPatternExpressionNode;
        }

        public @Nullable RelPatternNode visitVariableExp(@NonNull VariableExp qvtrVariableExp) {
            RelPatternNode relPatternNode = ((QVTr2UMLX)this.context).getUMLXElement(RelPatternNode.class, (Element)PivotUtil.getReferredVariable((VariableExp)qvtrVariableExp));
            return relPatternNode;
        }

        public @Nullable UMLXElement visiting(@NonNull Visitable visitable) {
            throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    protected static class CreateRelationVisitor
    extends AbstractVisitor {
        protected final @NonNull Relation qvtrRelation;
        private final @NonNull Map<@NonNull VariableDeclaration, @NonNull List<@NonNull RelationDomain>> variable2domains = new HashMap<VariableDeclaration, List<RelationDomain>>();
        private @Nullable List<@NonNull RelPatternNode> ownedPrimitiveNodes = null;
        private final @NonNull RelDiagram relDiagram;

        public CreateRelationVisitor(@NonNull QVTr2UMLX context, @NonNull Relation qvtrRelation) {
            super(context);
            Pattern rWhere;
            this.qvtrRelation = qvtrRelation;
            for (RelationDomain rDomain : QVTrelationUtil.getOwnedDomains((Relation)qvtrRelation)) {
                this.analyzeTree((Element)rDomain, rDomain);
            }
            Pattern rWhen = qvtrRelation.getWhen();
            if (rWhen != null) {
                this.analyzeTree((Element)rWhen, null);
            }
            if ((rWhere = qvtrRelation.getWhere()) != null) {
                this.analyzeTree((Element)rWhere, null);
            }
            for (Variable rVariable : QVTrelationUtil.getOwnedVariables((Relation)qvtrRelation)) {
                OCLExpression rExpression = rVariable.getOwnedInit();
                if (rExpression == null) continue;
                List<@NonNull RelationDomain> referencedDomains = this.analyzeTree((Element)rExpression, null);
                for (RelationDomain rDomain : referencedDomains) {
                    this.add((VariableDeclaration)rVariable, rDomain);
                }
            }
            this.relDiagram = UMLXFactory.eINSTANCE.createRelDiagram();
        }

        private @NonNull List<@NonNull RelationDomain> add(@NonNull VariableDeclaration variable, @Nullable RelationDomain rDomain) {
            List<@NonNull RelationDomain> domains = this.variable2domains.get(variable);
            if (domains == null) {
                domains = new ArrayList<RelationDomain>();
                this.variable2domains.put(variable, domains);
            }
            if (rDomain != null && !domains.contains(rDomain)) {
                domains.add(rDomain);
            }
            return domains;
        }

        private @NonNull List<@NonNull RelationDomain> analyzeTree(@NonNull Element rElement, @Nullable RelationDomain rDomain) {
            ArrayList<@NonNull RelationDomain> referencedDomains = new ArrayList<RelationDomain>();
            for (EObject eObject : new TreeIterable((EObject)rElement, true)) {
                VariableDeclaration variable = null;
                if (eObject instanceof VariableExp) {
                    variable = PivotUtil.getReferredVariable((VariableExp)((VariableExp)eObject));
                } else if (eObject instanceof TemplateExp) {
                    variable = QVTrelationUtil.getBindsTo((TemplateExp)((TemplateExp)eObject));
                }
                if (variable == null) continue;
                for (RelationDomain domain : this.add(variable, rDomain)) {
                    if (referencedDomains.contains(domain)) continue;
                    referencedDomains.add(domain);
                }
            }
            return referencedDomains;
        }

        protected @NonNull RelPatternNode createRelPatternClassNode(@NonNull TypedElement qvtrTypedElement) {
            boolean isImplicit;
            RelPatternNode relPatternClassNode = UMLXFactory.eINSTANCE.createRelPatternNode();
            ((QVTr2UMLX)this.context).install((Element)qvtrTypedElement, relPatternClassNode);
            boolean bl = isImplicit = qvtrTypedElement instanceof Variable && ((Variable)qvtrTypedElement).isIsImplicit();
            if (isImplicit) {
                relPatternClassNode.setIsAnon(true);
                relPatternClassNode.setName("");
            } else {
                relPatternClassNode.setIsAnon(false);
                relPatternClassNode.setName(qvtrTypedElement.getName());
            }
            this.setReferredEType(relPatternClassNode, qvtrTypedElement);
            return relPatternClassNode;
        }

        private @NonNull List<@NonNull RelPatternNode> getPrimitiveNodes() {
            List<@NonNull RelPatternNode> ownedPrimitiveNodes2 = this.ownedPrimitiveNodes;
            if (ownedPrimitiveNodes2 == null) {
                RelDomainNode relDomainNode = ((QVTr2UMLX)this.context).getPrimitiveRelDomainNode(this.relDiagram);
                this.ownedPrimitiveNodes = ownedPrimitiveNodes2 = UMLXUtil.Internal.getOwnedRelPatternNodesList(relDomainNode);
            }
            return ownedPrimitiveNodes2;
        }

        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.qvtrRelation.getName());
            ArrayList<@NonNull VariableDeclaration> variables = new ArrayList<VariableDeclaration>(this.variable2domains.keySet());
            Collections.sort(variables, NameUtil.NAMEABLE_COMPARATOR);
            for (VariableDeclaration variable : variables) {
                List<@NonNull RelationDomain> domains = this.variable2domains.get(variable);
                assert (domains != null);
                s.append("\n\t'");
                s.append(variable.getName());
                s.append("' =>");
                for (RelationDomain domain : domains) {
                    s.append(" '");
                    s.append(domain.getName());
                    s.append("'");
                }
            }
            return s.toString();
        }

        public @Nullable UMLXElement visitRelation(@NonNull Relation qvtrRelation) {
            Pattern qvtrWhere;
            ((QVTr2UMLX)this.context).install((Element)qvtrRelation, this.relDiagram);
            this.relDiagram.setIsAbstract(qvtrRelation.isIsAbstract());
            this.relDiagram.setIsTop(qvtrRelation.isIsTopLevel());
            this.relDiagram.setName(qvtrRelation.getName());
            this.createAll(QVTrelationUtil.getOwnedDomains((Relation)qvtrRelation), this.relDiagram.getOwnedRelDomainNodes());
            for (Variable qvtrVariable : QVTrelationUtil.getOwnedVariables((Relation)qvtrRelation)) {
                Object relPatternClassNode = ((QVTr2UMLX)this.context).basicGetUMLXElement(RelPatternNode.class, (Element)qvtrVariable);
                if (relPatternClassNode != null) continue;
                relPatternClassNode = this.createRelPatternClassNode((TypedElement)qvtrVariable);
                OCLExpression ownedInit = qvtrVariable.getOwnedInit();
                if (ownedInit != null) {
                    String[] stringArray = PrettyPrinter.print((Element)ownedInit).split("\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        relPatternClassNode.getInitExpressionLines().add((Object)line);
                        ++n2;
                    }
                }
                List<RelPatternNode> ownedNodes = null;
                List<@NonNull RelationDomain> qvtrDomains = this.variable2domains.get(qvtrVariable);
                if (qvtrDomains == null) {
                    DEAD_VARIABLE.println("Dead variable " + qvtrRelation.getName() + "." + qvtrVariable.getName());
                } else if (qvtrDomains.size() == 1) {
                    RelationDomain qvtrDomain = qvtrDomains.get(0);
                    RelDomainNode relDomainNode = ((QVTr2UMLX)this.context).basicGetUMLXElement(RelDomainNode.class, (Element)qvtrDomain);
                    assert (relDomainNode != null);
                    ownedNodes = UMLXUtil.Internal.getOwnedRelPatternNodesList(relDomainNode);
                }
                if (ownedNodes == null) {
                    ownedNodes = this.getPrimitiveNodes();
                }
                ownedNodes.add((RelPatternNode)relPatternClassNode);
            }
            Pattern qvtrWhen = qvtrRelation.getWhen();
            if (qvtrWhen != null) {
                for (Predicate qvtrPredicate : QVTrelationUtil.getOwnedPredicates((Pattern)qvtrWhen)) {
                    QVTrelationUtil.getOwnedConditionExpression((Predicate)qvtrPredicate).accept((Visitor)this);
                }
            }
            if ((qvtrWhere = qvtrRelation.getWhere()) != null) {
                for (Predicate qvtrPredicate : QVTrelationUtil.getOwnedPredicates((Pattern)qvtrWhere)) {
                    QVTrelationUtil.getOwnedConditionExpression((Predicate)qvtrPredicate).accept((Visitor)this);
                }
            }
            return this.relDiagram;
        }

        public @Nullable UMLXElement visitRelationCallExp(@NonNull RelationCallExp qvtrRelationCallExp) {
            Predicate qvtrPredicate = QVTrelationUtil.getContainingPredicate((EObject)qvtrRelationCallExp);
            Relation qvtrRelation = QVTrelationUtil.getContainingRelation((EObject)qvtrRelationCallExp);
            Boolean isWhen = null;
            Pattern qvtrWhen = qvtrRelation.getWhen();
            Pattern qvtrWhere = qvtrRelation.getWhere();
            if (qvtrWhen != null && Iterables.contains((Iterable)QVTrelationUtil.getOwnedPredicates((Pattern)qvtrWhen), (Object)qvtrPredicate)) {
                isWhen = true;
            } else if (qvtrWhere != null && Iterables.contains((Iterable)QVTrelationUtil.getOwnedPredicates((Pattern)qvtrWhere), (Object)qvtrPredicate)) {
                isWhen = false;
            }
            RelDiagram relDiagram = ((QVTr2UMLX)this.context).getUMLXElement(RelDiagram.class, (Element)qvtrRelation);
            RelInvocationNode relInvocationNode = UMLXFactory.eINSTANCE.createRelInvocationNode();
            ((QVTr2UMLX)this.context).install((Element)qvtrRelationCallExp, relInvocationNode);
            relInvocationNode.setIsThen(isWhen == Boolean.FALSE);
            relDiagram.getOwnedRelInvocationNodes().add((Object)relInvocationNode);
            ((QVTr2UMLX)this.context).addReference((Element)qvtrRelationCallExp);
            return relInvocationNode;
        }

        public @Nullable UMLXElement visitRelationDomain(@NonNull RelationDomain qvtrRelationDomain) {
            RelDomainNode relDomainNode = UMLXFactory.eINSTANCE.createRelDomainNode();
            ((QVTr2UMLX)this.context).install((Element)qvtrRelationDomain, relDomainNode);
            TxTypedModelNode tyTypedModelNode = ((QVTr2UMLX)this.context).getUMLXElement(TxTypedModelNode.class, (Element)QVTrelationUtil.getTypedModel((Domain)qvtrRelationDomain));
            relDomainNode.setReferredTxTypedModelNode(tyTypedModelNode);
            if (qvtrRelationDomain.isIsCheckable()) {
                tyTypedModelNode.setCheck(true);
            }
            if (qvtrRelationDomain.isIsEnforceable()) {
                tyTypedModelNode.setEnforce(true);
                relDomainNode.setIsEnforced(true);
            }
            for (EObject eObject : new TreeIterable((EObject)qvtrRelationDomain, false)) {
                CollectionTemplateExp qvtrCollectionTemplateExp;
                Variable qvtrRestVariable;
                if (!(eObject instanceof TemplateExp)) continue;
                TemplateExp qvtrTemplateExp = (TemplateExp)eObject;
                RelPatternNode relPatternClassNode = this.createRelPatternClassNode((TypedElement)QVTrelationUtil.getBindsTo((TemplateExp)qvtrTemplateExp));
                ((QVTr2UMLX)this.context).install((Element)qvtrTemplateExp, relPatternClassNode);
                Variable qvtrVariable = qvtrTemplateExp.getBindsTo();
                List<RelPatternNode> ownedNodes = null;
                List<@NonNull RelationDomain> qvtrDomains = this.variable2domains.get(qvtrVariable);
                if (qvtrDomains == null) {
                    DEAD_VARIABLE.println("Dead variable " + this.qvtrRelation.getName() + "." + qvtrVariable.getName());
                } else if (qvtrDomains.size() == 1) {
                    ownedNodes = UMLXUtil.Internal.getOwnedRelPatternNodesList(relDomainNode);
                }
                if (ownedNodes == null) {
                    ownedNodes = this.getPrimitiveNodes();
                }
                ownedNodes.add(relPatternClassNode);
                if (!(eObject instanceof CollectionTemplateExp) || (qvtrRestVariable = (qvtrCollectionTemplateExp = (CollectionTemplateExp)eObject).getRest()) == null) continue;
                RelPatternNode relPatternRestNode = this.createRelPatternClassNode((TypedElement)qvtrRestVariable);
                ownedNodes.add(relPatternRestNode);
            }
            ((QVTr2UMLX)this.context).addReference((Element)qvtrRelationDomain);
            return relDomainNode;
        }
    }

    protected static class CreateTransformationVisitor
    extends AbstractVisitor {
        protected final @NonNull UMLXModel umlxModel;
        private final @NonNull Map<@NonNull Package, @NonNull TxPackageNode> asPackage2txPackageNode = new HashMap<Package, TxPackageNode>();

        public CreateTransformationVisitor(@NonNull QVTr2UMLX context, @NonNull UMLXModel umlxModel) {
            super(context);
            this.umlxModel = umlxModel;
        }

        public @Nullable UMLXElement visitFunction(@NonNull Function asFunction) {
            TxQueryNode txQueryNode = UMLXFactory.eINSTANCE.createTxQueryNode();
            ((QVTr2UMLX)this.context).install((Element)asFunction, txQueryNode);
            txQueryNode.setName(asFunction.getName());
            this.setReferredEType(txQueryNode, (TypedElement)asFunction);
            OCLExpression bodyExpression = asFunction.getQueryExpression();
            if (bodyExpression != null) {
                String[] stringArray = PrettyPrinter.print((Element)bodyExpression).split("\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    txQueryNode.getInitExpressionLines().add((Object)line);
                    ++n2;
                }
            }
            this.createAll(QVTrelationUtil.getOwnedParameters((Operation)asFunction), txQueryNode.getOwnedTxParameterNodes());
            return txQueryNode;
        }

        public @Nullable UMLXElement visitFunctionParameter(@NonNull FunctionParameter asFunctionParameter) {
            TxParameterNode txParameterNode = UMLXFactory.eINSTANCE.createTxParameterNode();
            ((QVTr2UMLX)this.context).install((Element)asFunctionParameter, txParameterNode);
            txParameterNode.setName(asFunctionParameter.getName());
            this.setReferredEType(txParameterNode, (TypedElement)asFunctionParameter);
            return txParameterNode;
        }

        public @Nullable UMLXElement visitKey(@NonNull Key qvtrKey) {
            TxPartNode txPartNode;
            TxKeyNode txKeyNode = UMLXFactory.eINSTANCE.createTxKeyNode();
            ((QVTr2UMLX)this.context).install((Element)qvtrKey, txKeyNode);
            txKeyNode.setReferredEClass((EClass)((QVTr2UMLX)this.context).getEcoreOf((Type)QVTrelationUtil.getIdentifies((Key)qvtrKey)));
            for (Property qvtrPart : QVTrelationUtil.getOwnedParts((Key)qvtrKey)) {
                txPartNode = UMLXFactory.eINSTANCE.createTxPartNode();
                txPartNode.setReferredEStructuralFeature(((QVTr2UMLX)this.context).getEcoreOf(qvtrPart));
                txKeyNode.getOwnedTxPartNodes().add((Object)txPartNode);
            }
            for (Property qvtrPart : QVTrelationUtil.getOwnedOppositeParts((Key)qvtrKey)) {
                txPartNode = UMLXFactory.eINSTANCE.createTxPartNode();
                txPartNode.setReferredEStructuralFeature(((QVTr2UMLX)this.context).getEcoreOf(qvtrPart));
                txPartNode.setIsOpposite(true);
                txKeyNode.getOwnedTxPartNodes().add((Object)txPartNode);
            }
            return txKeyNode;
        }

        public @Nullable UMLXElement visitPackage(@NonNull Package qvtrPackage) {
            if ("http://www.eclipse.org/ocl/2015/Orphanage".equals(qvtrPackage.getURI())) {
                return null;
            }
            this.createAll(PivotUtil.getOwnedClasses((Package)qvtrPackage), null);
            this.createAll(PivotUtil.getOwnedPackages((Package)qvtrPackage), null);
            return null;
        }

        public @Nullable UMLXElement visitRelation(@NonNull Relation qvtrRelation) {
            CreateRelationVisitor createRelationVisitor = new CreateRelationVisitor((QVTr2UMLX)this.context, qvtrRelation);
            return (UMLXElement)qvtrRelation.accept((Visitor)createRelationVisitor);
        }

        public @Nullable UMLXElement visitRelationModel(@NonNull RelationModel qvtrModel) {
            String externalURI = qvtrModel.getExternalURI();
            if (externalURI.endsWith(".qvtras")) {
                externalURI = externalURI.replace(".qvtras", ".umlx");
            } else if (externalURI.endsWith(".qvtr")) {
                externalURI = externalURI.replace(".qvtr", ".umlx");
            }
            ((QVTr2UMLX)this.context).install((Element)qvtrModel, this.umlxModel);
            this.createAll(PivotUtil.getOwnedPackages((Model)qvtrModel), null);
            for (Import qvtrImport : QVTrelationUtil.getOwnedImports((Model)qvtrModel)) {
                String name;
                EList<String> importAliases;
                Namespace asNamespace = qvtrImport.getImportedNamespace();
                TxPackageNode txPackageNode = this.asPackage2txPackageNode.get(asNamespace);
                if (txPackageNode == null || (importAliases = txPackageNode.getImportAliases()).contains(name = qvtrImport.getName())) continue;
                importAliases.add(name);
            }
            return null;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable UMLXElement visitRelationalTransformation(@NonNull RelationalTransformation qvtrTransformation) {
            StringBuilder s = new StringBuilder();
            String packagePath = ((QVTr2UMLX)this.context).getPackagePath(s, (Namespace)QVTbaseUtil.getOwningPackage((Class)qvtrTransformation));
            TxDiagram txDiagram = UMLXFactory.eINSTANCE.createTxDiagram();
            txDiagram.setName(qvtrTransformation.getName());
            txDiagram.setPackage(packagePath);
            ((QVTr2UMLX)this.context).install((Element)qvtrTransformation, txDiagram);
            @NonNull Iterable modelParameters = QVTrelationUtil.getModelParameters((Transformation)qvtrTransformation);
            for (TypedModel qvtrTypedModel : modelParameters) {
                if (qvtrTypedModel.isIsTrace()) continue;
                for (Package asPackage : QVTrelationUtil.getUsedPackages((TypedModel)qvtrTypedModel)) {
                    TxPackageNode txPackageNode = this.asPackage2txPackageNode.get(asPackage);
                    if (txPackageNode != null) continue;
                    txPackageNode = UMLXFactory.eINSTANCE.createTxPackageNode();
                    txPackageNode.setReferredEPackage(asPackage.getEPackage());
                    txDiagram.getOwnedTxPackageNodes().add((Object)txPackageNode);
                    this.asPackage2txPackageNode.put(asPackage, txPackageNode);
                }
            }
            this.createAll(modelParameters, txDiagram.getOwnedTxTypedModelNodes());
            this.createAll(QVTrelationUtil.getOwnedKey((RelationalTransformation)qvtrTransformation), txDiagram.getOwnedTxKeyNodes());
            this.createAll(QVTrelationUtil.getRule((Transformation)qvtrTransformation), txDiagram.getOwnedRelDiagrams());
            this.createAll(QVTrelationUtil.getOwnedOperations((Transformation)qvtrTransformation), txDiagram.getOwnedTxQueryNodes());
            this.umlxModel.getOwnedTxDiagrams().add((Object)txDiagram);
            return null;
        }

        public @Nullable UMLXElement visitTypedModel(@NonNull TypedModel qvtrTypedModel) {
            if (qvtrTypedModel.isIsPrimitive()) {
                return null;
            }
            TxTypedModelNode txTypedModelNode = UMLXFactory.eINSTANCE.createTxTypedModelNode();
            ((QVTr2UMLX)this.context).install((Element)qvtrTypedModel, txTypedModelNode);
            String name = qvtrTypedModel.getName();
            txTypedModelNode.setName(name);
            for (Package usedPackage : QVTrelationUtil.getUsedPackages((TypedModel)qvtrTypedModel)) {
                TxPackageNode txPackageNode = this.asPackage2txPackageNode.get(usedPackage);
                txTypedModelNode.getUsedTxPackageNodes().add((Object)txPackageNode);
            }
            if (qvtrTypedModel.getDependsOn().size() > 0) {
                ((QVTr2UMLX)this.context).addReference((Element)qvtrTypedModel);
            }
            return txTypedModelNode;
        }
    }

    protected static class ReferenceVisitor
    extends AbstractVisitor {
        public ReferenceVisitor(@NonNull QVTr2UMLX context) {
            super(context);
        }

        public @Nullable UMLXElement visitCollectionTemplateExp(@NonNull CollectionTemplateExp qvtrCollectionTemplateExp) {
            OCLExpression qvtrWhere;
            RelPatternNode relPatternNode = ((QVTr2UMLX)this.context).getUMLXElement(RelPatternNode.class, (Element)qvtrCollectionTemplateExp);
            assert (relPatternNode.isIsMany());
            int sourceIndex = 1;
            for (OCLExpression qvtrMember : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)qvtrCollectionTemplateExp)) {
                RelPatternNode relMemberPatternNode = this.visit(RelPatternNode.class, (Element)qvtrMember);
                RelPatternEdge relPatternEdge = UMLXFactory.eINSTANCE.createRelPatternEdge();
                relPatternEdge.setSourceIndex(sourceIndex);
                relPatternEdge.setSource(relPatternNode);
                relPatternEdge.setTarget(relMemberPatternNode);
                relMemberPatternNode.getOwningRelDomainNode().getOwnedRelPatternEdges().add((Object)relPatternEdge);
                ++sourceIndex;
            }
            Variable qvtrRest = qvtrCollectionTemplateExp.getRest();
            if (qvtrRest != null) {
                RelPatternNode relRestPatternNode = this.visit(RelPatternNode.class, (Element)qvtrRest);
                RelPatternEdge relPatternEdge = UMLXFactory.eINSTANCE.createRelPatternEdge();
                relPatternEdge.setSourceIndex(-1);
                relPatternEdge.setSource(relPatternNode);
                relPatternEdge.setTarget(relRestPatternNode);
                relRestPatternNode.getOwningRelDomainNode().getOwnedRelPatternEdges().add((Object)relPatternEdge);
            }
            if ((qvtrWhere = qvtrCollectionTemplateExp.getWhere()) != null) {
                RelPatternNode relWherePatternNode = (RelPatternNode)qvtrWhere.accept((Visitor)this);
                relPatternNode.getOwningRelDomainNode().getOwnedRelPatternNodes().add((Object)relWherePatternNode);
            }
            return relPatternNode;
        }

        public @Nullable UMLXElement visitObjectTemplateExp(@NonNull ObjectTemplateExp qvtrObjectTemplateExp) {
            RelPatternNode relPatternNode = ((QVTr2UMLX)this.context).getUMLXElement(RelPatternNode.class, (Element)qvtrObjectTemplateExp);
            for (PropertyTemplateItem qvtrPropertyTemplateItem : QVTrelationUtil.getOwnedParts((ObjectTemplateExp)qvtrObjectTemplateExp)) {
                Property partProperty = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)qvtrPropertyTemplateItem);
                OCLExpression partValue = QVTrelationUtil.getOwnedValue((PropertyTemplateItem)qvtrPropertyTemplateItem);
                RelPatternNode relPartPatternNode = this.visit(RelPatternNode.class, (Element)partValue);
                RelPatternEdge relPatternEdge = UMLXFactory.eINSTANCE.createRelPatternEdge();
                Property oppositeProperty = partProperty.getOpposite();
                if (partProperty.isIsComposite()) {
                    relPatternEdge.setReferredEStructuralFeature(((QVTr2UMLX)this.context).getEcoreOf(partProperty));
                    relPatternEdge.setSource(relPatternNode);
                    relPatternEdge.setTarget(relPartPatternNode);
                } else if (oppositeProperty != null && !relPartPatternNode.isExpression().booleanValue() && oppositeProperty.isIsComposite()) {
                    relPatternEdge.setReferredEStructuralFeature(((QVTr2UMLX)this.context).getEcoreOf(oppositeProperty));
                    relPatternEdge.setSource(relPartPatternNode);
                    relPatternEdge.setTarget(relPatternNode);
                } else if (oppositeProperty != null && !relPartPatternNode.isExpression().booleanValue() && partProperty.isIsImplicit()) {
                    relPatternEdge.setReferredEStructuralFeature(((QVTr2UMLX)this.context).getEcoreOf(oppositeProperty));
                    relPatternEdge.setSource(relPartPatternNode);
                    relPatternEdge.setTarget(relPatternNode);
                } else {
                    relPatternEdge.setReferredEStructuralFeature(((QVTr2UMLX)this.context).getEcoreOf(partProperty));
                    relPatternEdge.setSource(relPatternNode);
                    relPatternEdge.setTarget(relPartPatternNode);
                }
                relPartPatternNode.getOwningRelDomainNode().getOwnedRelPatternEdges().add((Object)relPatternEdge);
            }
            OCLExpression qvtrWhere = qvtrObjectTemplateExp.getWhere();
            if (qvtrWhere != null) {
                RelPatternNode relWherePatternNode = (RelPatternNode)qvtrWhere.accept((Visitor)this);
                relPatternNode.getOwningRelDomainNode().getOwnedRelPatternNodes().add((Object)relWherePatternNode);
            }
            return relPatternNode;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable UMLXElement visitRelationCallExp(@NonNull RelationCallExp qvtrRelationCallExp) {
            RelInvocationNode relInvocationNode = ((QVTr2UMLX)this.context).getUMLXElement(RelInvocationNode.class, (Element)qvtrRelationCallExp);
            Relation qvtrReferredRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)qvtrRelationCallExp);
            RelDiagram relReferredDiagram = ((QVTr2UMLX)this.context).getUMLXElement(RelDiagram.class, (Element)qvtrReferredRelation);
            relInvocationNode.setReferredRelDiagram(relReferredDiagram);
            @NonNull List qvtrRootVariables = QVTrelationUtil.getRootVariables((Relation)qvtrReferredRelation);
            @NonNull Iterable qvtrArguments = QVTrelationUtil.getOwnedArguments((RelationCallExp)qvtrRelationCallExp);
            Iterator<@NonNull T> itRootVariables = qvtrRootVariables.iterator();
            Iterator<@NonNull T> itArguments = qvtrArguments.iterator();
            while (itRootVariables.hasNext() && itArguments.hasNext()) {
                Variable qvtrRootVariable = (Variable)itRootVariables.next();
                OCLExpression qvtrArgument = (OCLExpression)itArguments.next();
                RelPatternNode umlxRootVariable = ((QVTr2UMLX)this.context).getUMLXElement(RelPatternNode.class, (Element)qvtrRootVariable);
                RelPatternNode relArgumentNode = (RelPatternNode)this.create(qvtrArgument);
                RelInvocationEdge relInvocationEdge = UMLXFactory.eINSTANCE.createRelInvocationEdge();
                relInvocationEdge.setOwningRelInvocationNode(relInvocationNode);
                relInvocationEdge.setInvokingRelPatternNode(relArgumentNode);
                relInvocationEdge.setReferredRelPatternNode(umlxRootVariable);
            }
            return null;
        }

        public @Nullable UMLXElement visitRelationDomain(@NonNull RelationDomain qvtrRelationDomain) {
            RelDomainNode relDomainNode = ((QVTr2UMLX)this.context).getUMLXElement(RelDomainNode.class, (Element)qvtrRelationDomain);
            for (DomainPattern qvtrPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)qvtrRelationDomain)) {
                TemplateExp qvtrTemplateExpression = QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)qvtrPattern);
                RelPatternNode relPatternNode = ((QVTr2UMLX)this.context).getUMLXElement(RelPatternNode.class, (Element)qvtrTemplateExpression);
                relPatternNode.setIsRoot(true);
                qvtrTemplateExpression.accept((Visitor)this);
            }
            return relDomainNode;
        }

        public @Nullable UMLXElement visitSharedVariable(@NonNull SharedVariable qvtrSharedVariable) {
            RelPatternNode relPatternNode = ((QVTr2UMLX)this.context).getUMLXElement(RelPatternNode.class, (Element)qvtrSharedVariable);
            return relPatternNode;
        }

        public @Nullable UMLXElement visitTypedModel(@NonNull TypedModel qvtrTypedModel) {
            TxTypedModelNode txTypedModelNode = ((QVTr2UMLX)this.context).getUMLXElement(TxTypedModelNode.class, (Element)qvtrTypedModel);
            for (TypedModel qvtrDependsOn : QVTrelationUtil.getDependsOns((TypedModel)qvtrTypedModel)) {
                TxTypedModelNode txDependsOn = ((QVTr2UMLX)this.context).getUMLXElement(TxTypedModelNode.class, (Element)qvtrDependsOn);
                txTypedModelNode.getDependsOns().add((Object)txDependsOn);
            }
            return txTypedModelNode;
        }
    }
}

