/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.ParameterVariable;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.BottomVariable;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardVariable;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.QVTcoreFactory;
import org.eclipse.qvtd.pivot.qvtcore.QVTcorePackage;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.util.AbstractExtendingQVTcoreVisitor;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public abstract class AbstractQVTc2QVTc
extends QVTcoreHelper {
    protected final @NonNull AbstractCreateVisitor<@NonNull ?> createVisitor;
    protected final @NonNull AbstractUpdateVisitor<@NonNull ?> updateVisitor;
    private TypedModel middleTypedModelTarget = null;
    private final @NonNull Map<@Nullable NamedElement, @NonNull Map<@NonNull Element, @NonNull List<@NonNull Element>>> scope2source2targets = new HashMap<NamedElement, Map<Element, List<Element>>>();
    private final @NonNull Stack<@NonNull NamedElement> scopeStack = new Stack();
    private final @NonNull Map<@NonNull Element, @NonNull Element> target2source = new HashMap<Element, Element>();
    private final @NonNull Map<@NonNull Element, @NonNull Element> debugCopy2source = new HashMap<Element, Element>();
    private @Nullable Resource debugSource = null;
    private @Nullable Resource debugTarget = null;

    protected AbstractQVTc2QVTc(@NonNull EnvironmentFactory environmentFactory) {
        super(environmentFactory);
        this.createVisitor = this.createCreateVisitor();
        this.updateVisitor = this.createUpdateVisitor();
    }

    public void addDebugCopies(@NonNull Map<EObject, EObject> copier) {
        for (EObject eSource : copier.keySet()) {
            EObject eTarget = copier.get(eSource);
            assert (eSource != null && eTarget != null);
            this.debugCopy2source.put((Element)eTarget, (Element)eSource);
        }
    }

    public void addTrace(@NonNull Element source, @NonNull Element target) {
        List<Element> targets;
        this.target2source.put(target, source);
        NamedElement scope = this.scopeStack.peek();
        Map<@NonNull Element, @NonNull List<@NonNull Element>> source2targets = this.scope2source2targets.get(scope);
        if (source2targets == null) {
            source2targets = new HashMap<Element, List<Element>>();
            this.scope2source2targets.put(scope, source2targets);
        }
        if ((targets = source2targets.get(source)) == null) {
            targets = new ArrayList<Element>();
            source2targets.put(source, targets);
        }
        assert (!targets.contains(target));
        targets.add(target);
    }

    protected @Nullable Element basicEquivalentSource(@Nullable Element target) {
        if (target == null) {
            return null;
        }
        assert (target.eResource() != this.debugSource) : "source element used for basicEquivalentSource " + target;
        return this.target2source.get(target);
    }

    protected abstract @NonNull AbstractCreateVisitor<@NonNull ?> createCreateVisitor();

    protected @NonNull Import createImport(@NonNull Import iIn) {
        Import iOut = this.createImport(iIn.getName(), (Namespace)ClassUtil.nonNull((Object)iIn.getImportedNamespace()));
        this.addTrace((Element)iIn, (Element)iOut);
        return iOut;
    }

    protected @NonNull Package createPackage(@NonNull Package pIn) {
        Package pOut = this.createPackage((String)ClassUtil.nonNull((Object)pIn.getName()), pIn.getNsPrefix(), pIn.getURI());
        this.addTrace((Element)pIn, (Element)pOut);
        return pOut;
    }

    protected abstract @NonNull AbstractUpdateVisitor<@NonNull ?> createUpdateVisitor();

    protected <T extends Element> @NonNull T equivalentSource(@NonNull T target) {
        assert (target.eResource() != this.debugSource) : "source element used for equivalentSource " + target;
        Element source = this.target2source.get(target);
        assert (source != null);
        return (T)source;
    }

    protected <T extends Element> @NonNull T equivalentTarget(T source) {
        assert (source != null);
        assert (source.eResource() != this.debugTarget) : "target element used for equivalentTarget " + source;
        List<@NonNull Element> targets = null;
        int i = this.scopeStack.size();
        while (targets == null && --i >= 0) {
            NamedElement scope = (NamedElement)this.scopeStack.get(i);
            Map<@NonNull Element, @NonNull List<@NonNull Element>> source2targets = this.scope2source2targets.get(scope);
            if (source2targets == null) continue;
            targets = source2targets.get(source);
        }
        if (targets != null) {
            Element target = (Element)targets.get(0);
            assert (target != null);
            return (T)target;
        }
        return source;
    }

    protected @NonNull TypedModel getMiddleTypedModelTarget() {
        assert (this.middleTypedModelTarget != null);
        return this.middleTypedModelTarget;
    }

    public void popScope() {
        this.scopeStack.pop();
    }

    public void pushScope(@NonNull NamedElement scope) {
        assert (!this.scopeStack.contains(scope));
        this.scopeStack.push(scope);
    }

    protected void setDebugSource(@NonNull Resource debugSource) {
        this.debugSource = debugSource;
    }

    protected void setMiddleTypedModelTarget(@NonNull TypedModel middleTypedModelTarget) {
        this.middleTypedModelTarget = middleTypedModelTarget;
    }

    public void transform(@NonNull Resource source, @NonNull Resource target) throws IOException {
        this.debugSource = source;
        this.debugTarget = target;
        for (EObject eContent : source.getContents()) {
            if (!(eContent instanceof CoreModel)) continue;
            CoreModel mIn = (CoreModel)eContent;
            this.transform(mIn, (List<EObject>)target.getContents());
        }
        TreeIterator tit = target.getAllContents();
        while (tit.hasNext()) {
            EObject eTarget = (EObject)tit.next();
            EObject eSource = (EObject)this.target2source.get(eTarget);
            EObject eCopied = (EObject)this.debugCopy2source.get(eTarget);
            if (eSource != null || eCopied != null) continue;
            QVTruntimeUtil.errPrintln((String)("No source for " + eTarget.eClass().getName() + "@" + Integer.toString(System.identityHashCode(eTarget)) + ":" + eTarget + " / " + eTarget.eContainer().eClass().getName() + "@" + Integer.toString(System.identityHashCode(eTarget.eContainer()))));
        }
        List missingOperationCallSources = QVTbaseUtil.rewriteMissingOperationCallSources((EnvironmentFactory)this.environmentFactory, (Resource)target);
        if (missingOperationCallSources != null) {
            QVTruntimeUtil.errPrintln((String)("Missing OperationCallExp sources were fixed up for '" + target.getURI() + "'"));
        }
    }

    protected void transform(@NonNull CoreModel mIn, @NonNull List<@NonNull EObject> mOuts) throws IOException {
        try {
            CoreModel mOut = (CoreModel)mIn.accept(this.createVisitor);
            assert (mOut != null);
            mOuts.add((EObject)mOut);
            mOut.accept(this.updateVisitor);
        }
        catch (WrappedException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw e;
        }
    }

    protected static abstract class AbstractCreateVisitor<@NonNull C extends AbstractQVTc2QVTc>
    extends AbstractExtendingQVTcoreVisitor<Element, C> {
        public AbstractCreateVisitor(@NonNull C context) {
            super(context);
        }

        public <T extends Element> @Nullable T create(@Nullable T source) {
            if (source == null) {
                return null;
            }
            @Nullable Element target = (Element)source.accept((Visitor)this);
            return (T)target;
        }

        public <T extends Element> void createAll(Iterable<T> sources, List<? super T> targets) {
            for (Element source : sources) {
                Element target = (Element)source.accept((Visitor)this);
                if (target == null) continue;
                targets.add(target);
            }
        }

        protected void doAssignments(@NonNull BottomPattern bIn, @NonNull BottomPattern bOut) {
            this.createAll((Iterable)bIn.getAssignment(), (List)bOut.getAssignment());
        }

        protected void doLocalMappings(@NonNull Mapping mIn, @NonNull Mapping mOut) {
            this.createAll((Iterable)mIn.getLocal(), (List)mOut.getLocal());
        }

        protected void doMapping(@NonNull Mapping mIn, @NonNull Mapping mOut) {
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)mIn, (Element)mOut);
            mOut.setName(mIn.getName());
            mOut.setIsAbstract(mIn.isIsAbstract());
            mOut.setGuardPattern(this.create(mIn.getGuardPattern()));
            mOut.setBottomPattern(this.create(mIn.getBottomPattern()));
            this.createAll((Iterable)mIn.getDomain(), (List)mOut.getDomain());
            this.doLocalMappings(mIn, mOut);
            this.createAll(mIn.getOwnedComments(), mOut.getOwnedComments());
        }

        protected void doRealizedVariables(@NonNull BottomPattern bIn, @NonNull BottomPattern bOut) {
            this.createAll((Iterable)bIn.getRealizedVariable(), (List)bOut.getRealizedVariable());
        }

        protected void doRules(@NonNull Transformation tIn, @NonNull Transformation tOut) {
            this.createAll((Iterable)tIn.getRule(), (List)tOut.getRule());
        }

        public @Nullable Element visiting(@NonNull Visitable visitable) {
            throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + ((Object)((Object)this)).getClass().getSimpleName());
        }

        public @NonNull BottomPattern visitBottomPattern(@NonNull BottomPattern bIn) {
            BottomPattern bOut = QVTcoreFactory.eINSTANCE.createBottomPattern();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)bIn, (Element)bOut);
            this.doAssignments(bIn, bOut);
            this.createAll((Iterable)bIn.getPredicate(), (List)bOut.getPredicate());
            this.doRealizedVariables(bIn, bOut);
            this.createAll((Iterable)bIn.getOwnedVariables(), (List)bOut.getOwnedVariables());
            this.createAll(bIn.getOwnedComments(), bOut.getOwnedComments());
            return bOut;
        }

        public @NonNull BottomVariable visitBottomVariable(@NonNull BottomVariable vIn) {
            BottomVariable vOut = QVTcoreFactory.eINSTANCE.createBottomVariable();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)vIn, (Element)vOut);
            vOut.setName(vIn.getName());
            this.createAll(vIn.getOwnedComments(), vOut.getOwnedComments());
            return vOut;
        }

        public @Nullable Element visitComment(@NonNull Comment cIn) {
            Comment cOut = PivotFactory.eINSTANCE.createComment();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)cIn, (Element)cOut);
            cOut.setBody(cIn.getBody());
            this.createAll(cIn.getOwnedComments(), cOut.getOwnedComments());
            return cOut;
        }

        public @NonNull CoreDomain visitCoreDomain(@NonNull CoreDomain dIn) {
            CoreDomain dOut = QVTcoreFactory.eINSTANCE.createCoreDomain();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)dIn, (Element)dOut);
            dOut.setIsCheckable(dIn.isIsCheckable());
            dOut.setIsEnforceable(dIn.isIsEnforceable());
            dOut.setGuardPattern(this.create(dIn.getGuardPattern()));
            dOut.setBottomPattern(this.create(dIn.getBottomPattern()));
            this.createAll(dIn.getOwnedComments(), dOut.getOwnedComments());
            return dOut;
        }

        public @NonNull CoreModel visitCoreModel(@NonNull CoreModel mIn) {
            CoreModel mOut = QVTcoreFactory.eINSTANCE.createCoreModel();
            ((AbstractQVTc2QVTc)((Object)this.context)).pushScope((NamedElement)mOut);
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)mIn, (Element)mOut);
            this.createAll(mIn.getOwnedImports(), mOut.getOwnedImports());
            this.createAll(mIn.getOwnedPackages(), mOut.getOwnedPackages());
            this.createAll(mIn.getOwnedComments(), mOut.getOwnedComments());
            ((AbstractQVTc2QVTc)((Object)this.context)).popScope();
            return mOut;
        }

        public @NonNull Function visitFunction(@NonNull Function fIn) {
            Function fOut = QVTbaseFactory.eINSTANCE.createFunction();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)fIn, (Element)fOut);
            ((AbstractQVTc2QVTc)((Object)this.context)).pushScope((NamedElement)fOut);
            fOut.setName(fIn.getName());
            fOut.setIsRequired(fIn.isIsRequired());
            fOut.setIsStatic(fIn.isIsStatic());
            fOut.setIsTransient(fIn.isIsTransient());
            fOut.setIsTypeof(fIn.isIsTypeof());
            fOut.setImplementationClass(fIn.getImplementationClass());
            this.createAll(fIn.getOwnedParameters(), fOut.getOwnedParameters());
            this.createAll(fIn.getOwnedComments(), fOut.getOwnedComments());
            ((AbstractQVTc2QVTc)((Object)this.context)).popScope();
            return fOut;
        }

        public @NonNull FunctionParameter visitFunctionParameter(@NonNull FunctionParameter fpIn) {
            FunctionParameter fpOut = QVTbaseFactory.eINSTANCE.createFunctionParameter();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)fpIn, (Element)fpOut);
            fpOut.setName(fpIn.getName());
            fpOut.setIsRequired(fpIn.isIsRequired());
            fpOut.setIsTypeof(fpIn.isIsTypeof());
            this.createAll(fpIn.getOwnedComments(), fpOut.getOwnedComments());
            return fpOut;
        }

        public @NonNull GuardPattern visitGuardPattern(@NonNull GuardPattern gIn) {
            GuardPattern gOut = QVTcoreFactory.eINSTANCE.createGuardPattern();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)gIn, (Element)gOut);
            this.createAll((Iterable)gIn.getPredicate(), (List)gOut.getPredicate());
            this.createAll((Iterable)gIn.getOwnedVariables(), (List)gOut.getOwnedVariables());
            this.createAll(gIn.getOwnedComments(), gOut.getOwnedComments());
            return gOut;
        }

        public @NonNull GuardVariable visitGuardVariable(@NonNull GuardVariable vIn) {
            GuardVariable vOut = QVTcoreFactory.eINSTANCE.createGuardVariable();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)vIn, (Element)vOut);
            vOut.setName(vIn.getName());
            this.createAll(vIn.getOwnedComments(), vOut.getOwnedComments());
            return vOut;
        }

        public @Nullable Element visitImport(@NonNull Import iIn) {
            Import iOut = ((AbstractQVTc2QVTc)((Object)this.context)).createImport(iIn);
            this.createAll(iIn.getOwnedComments(), iOut.getOwnedComments());
            return iOut;
        }

        public @Nullable Element visitMapping(@NonNull Mapping mIn) {
            Mapping mOut = QVTcoreFactory.eINSTANCE.createMapping();
            ((AbstractQVTc2QVTc)((Object)this.context)).pushScope((NamedElement)mOut);
            this.doMapping(mIn, mOut);
            ((AbstractQVTc2QVTc)((Object)this.context)).popScope();
            return mOut;
        }

        public final @Nullable Element visitNavigationAssignment(@NonNull NavigationAssignment object) {
            return this.visiting((Visitable)object);
        }

        public @Nullable Element visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment paIn) {
            OppositePropertyAssignment paOut = QVTcoreFactory.eINSTANCE.createOppositePropertyAssignment();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)paIn, (Element)paOut);
            if (paIn.eIsSet((EStructuralFeature)QVTcorePackage.Literals.ASSIGNMENT__IS_DEFAULT)) {
                paOut.setIsDefault(paIn.isIsDefault());
            }
            if (paIn.eIsSet((EStructuralFeature)QVTcorePackage.Literals.ASSIGNMENT__IS_PARTIAL)) {
                paOut.setIsPartial(paIn.isIsPartial());
            }
            paOut.setTargetProperty(paIn.getTargetProperty());
            this.createAll(paIn.getOwnedComments(), paOut.getOwnedComments());
            return paOut;
        }

        public @Nullable Element visitPackage(@NonNull Package pIn) {
            if ("http://www.eclipse.org/ocl/2015/Orphanage".equals(pIn.getURI())) {
                return null;
            }
            Package pOut = ((AbstractQVTc2QVTc)((Object)this.context)).createPackage(pIn);
            this.createAll(pIn.getOwnedClasses(), pOut.getOwnedClasses());
            this.createAll(pIn.getOwnedPackages(), pOut.getOwnedPackages());
            this.createAll(pIn.getOwnedComments(), pOut.getOwnedComments());
            return pOut;
        }

        public @NonNull Parameter visitParameter(@NonNull Parameter vIn) {
            Parameter vOut = PivotFactory.eINSTANCE.createParameter();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)vIn, (Element)vOut);
            vOut.setName(vIn.getName());
            this.createAll(vIn.getOwnedComments(), vOut.getOwnedComments());
            return vOut;
        }

        public @NonNull ParameterVariable visitParameterVariable(@NonNull ParameterVariable vIn) {
            ParameterVariable vOut = PivotFactory.eINSTANCE.createParameterVariable();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)vIn, (Element)vOut);
            vOut.setName(vIn.getName());
            this.createAll(vIn.getOwnedComments(), vOut.getOwnedComments());
            return vOut;
        }

        public @Nullable Element visitPredicate(@NonNull Predicate pIn) {
            Predicate pOut = QVTbaseFactory.eINSTANCE.createPredicate();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)pIn, (Element)pOut);
            this.createAll(pIn.getOwnedComments(), pOut.getOwnedComments());
            return pOut;
        }

        public @Nullable Element visitPropertyAssignment(@NonNull PropertyAssignment paIn) {
            PropertyAssignment paOut = QVTcoreFactory.eINSTANCE.createPropertyAssignment();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)paIn, (Element)paOut);
            if (paIn.eIsSet((EStructuralFeature)QVTcorePackage.Literals.ASSIGNMENT__IS_DEFAULT)) {
                paOut.setIsDefault(paIn.isIsDefault());
            }
            if (paIn.eIsSet((EStructuralFeature)QVTcorePackage.Literals.ASSIGNMENT__IS_PARTIAL)) {
                paOut.setIsPartial(paIn.isIsPartial());
            }
            paOut.setTargetProperty(paIn.getTargetProperty());
            this.createAll(paIn.getOwnedComments(), paOut.getOwnedComments());
            return paOut;
        }

        public @NonNull Variable visitRealizedVariable(@NonNull RealizedVariable rvIn) {
            RealizedVariable rvOut = QVTcoreFactory.eINSTANCE.createRealizedVariable();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)rvIn, (Element)rvOut);
            rvOut.setName(rvIn.getName());
            rvOut.setIsImplicit(rvIn.isIsImplicit());
            rvOut.setType(rvIn.getType());
            this.createAll(rvIn.getOwnedComments(), rvOut.getOwnedComments());
            return rvOut;
        }

        public @NonNull Transformation visitTransformation(@NonNull Transformation tIn) {
            Transformation tOut = QVTbaseFactory.eINSTANCE.createTransformation();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)tIn, (Element)tOut);
            tOut.setName(tIn.getName());
            tOut.setOwnedContext(this.create(tIn.getOwnedContext()));
            this.createAll(tIn.getOwnedOperations(), tOut.getOwnedOperations());
            this.createAll((Iterable)tIn.getModelParameter(), (List)tOut.getModelParameter());
            if (QVTbaseUtil.basicGetPrimitiveTypedModel((Transformation)tIn) == null) {
                tOut.getModelParameter().add(0, (Object)new QVTcoreHelper(((AbstractQVTc2QVTc)((Object)this.context)).getEnvironmentFactory()).createPrimitiveTypedModel());
            }
            this.doRules(tIn, tOut);
            this.createAll(tIn.getOwnedComments(), tOut.getOwnedComments());
            return tOut;
        }

        public @NonNull TypedModel visitTypedModel(@NonNull TypedModel tmIn) {
            TypedModel tmOut = QVTbaseFactory.eINSTANCE.createTypedModel();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)tmIn, (Element)tmOut);
            String name = tmIn.getName();
            if (name == null) {
                ((AbstractQVTc2QVTc)((Object)this.context)).setMiddleTypedModelTarget(tmOut);
            }
            tmOut.setName(name);
            tmOut.getUsedPackage().addAll((Collection)tmIn.getUsedPackage());
            tmOut.setIsPrimitive(tmIn.isIsPrimitive());
            tmOut.setIsThis(tmIn.isIsThis());
            tmOut.setIsTrace(tmIn.isIsTrace() || name == null);
            this.createAll(tmIn.getOwnedComments(), tmOut.getOwnedComments());
            return tmOut;
        }

        public @Nullable Element visitVariableAssignment(@NonNull VariableAssignment vaIn) {
            VariableAssignment vaOut = QVTcoreFactory.eINSTANCE.createVariableAssignment();
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)vaIn, (Element)vaOut);
            vaOut.setIsDefault(vaIn.isIsDefault());
            this.createAll(vaIn.getOwnedComments(), vaOut.getOwnedComments());
            return vaOut;
        }
    }

    protected static abstract class AbstractUpdateVisitor<@NonNull C extends AbstractQVTc2QVTc>
    extends AbstractExtendingQVTcoreVisitor<Object, C> {
        private Operation equalsOperation = null;
        protected final @NonNull QVTcoreHelper helper;

        public AbstractUpdateVisitor(@NonNull C context) {
            super(context);
            this.helper = context;
        }

        protected void checkOut(@NonNull Element pOut) {
            Resource eResource = pOut.eResource();
            assert (eResource != null);
            TreeIterator tit = pOut.eAllContents();
            while (tit.hasNext()) {
                VariableDeclaration variable;
                Resource vResource;
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof VariableExp) || (vResource = (variable = ((VariableExp)eObject).getReferredVariable()).eResource()) == eResource) continue;
                QVTruntimeUtil.errPrintln((String)(variable + " : " + NameUtil.debugFullName((Object)variable) + " not in output resource."));
                vResource = variable.eResource();
            }
        }

        protected Object convertToPredicate(@NonNull NavigationAssignment paIn, @NonNull Predicate pOut) {
            OCLExpression slotExpression = this.copy(paIn.getSlotExpression());
            Property targetProperty = QVTcoreUtil.getTargetProperty((NavigationAssignment)paIn);
            assert (slotExpression != null && targetProperty != null);
            OCLExpression valueExpression = this.copy(paIn.getValue());
            assert (valueExpression != null);
            NavigationCallExp propertyCallExp = this.helper.createNavigationCallExp(slotExpression, targetProperty);
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)paIn, (Element)propertyCallExp);
            propertyCallExp.eUnset((EStructuralFeature)PivotPackage.Literals.TYPED_ELEMENT__IS_REQUIRED);
            Operation equalsOperation = this.getEqualsOperation();
            OperationCallExp operationCallExp = this.helper.createOperationCallExp((OCLExpression)propertyCallExp, equalsOperation, Collections.singletonList(valueExpression));
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)paIn, (Element)operationCallExp);
            operationCallExp.setName(equalsOperation.getName());
            pOut.setConditionExpression((OCLExpression)operationCallExp);
            this.checkOut((Element)pOut);
            return null;
        }

        protected @Nullable Object convertToVariableAssignment(@NonNull NavigationAssignment paIn, @NonNull VariableAssignment vaOut) {
            OCLExpression veIn = paIn.getValue();
            assert (veIn instanceof VariableExp);
            VariableDeclaration vIn = ((VariableExp)veIn).getReferredVariable();
            assert (vIn instanceof Variable);
            Variable vOut = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentTarget((Variable)vIn);
            vaOut.setTargetVariable((VariableDeclaration)vOut);
            OCLExpression slotExpression = this.copy(paIn.getSlotExpression());
            Property targetProperty = QVTcoreUtil.getTargetProperty((NavigationAssignment)paIn);
            assert (slotExpression != null && targetProperty != null);
            NavigationCallExp propertyCallExp = this.helper.createNavigationCallExp(slotExpression, targetProperty);
            ((AbstractQVTc2QVTc)((Object)this.context)).addTrace((Element)paIn, (Element)propertyCallExp);
            propertyCallExp.eUnset((EStructuralFeature)PivotPackage.Literals.TYPED_ELEMENT__IS_REQUIRED);
            vaOut.setValue((OCLExpression)propertyCallExp);
            this.checkOut((Element)vaOut);
            return null;
        }

        protected <T extends Element> @Nullable T copy(@Nullable T eIn) {
            if (eIn == null) {
                return null;
            }
            assert (this.context != null);
            ExpressionCopier copier = new ExpressionCopier((AbstractQVTc2QVTc)((Object)this.context));
            Element eOut = (Element)copier.copy((EObject)eIn);
            copier.copyReferences();
            ((AbstractQVTc2QVTc)((Object)this.context)).addDebugCopies((Map<EObject, EObject>)((Object)copier));
            return (T)eOut;
        }

        public @Nullable OCLExpression createCastCopy(@Nullable OCLExpression eIn, @Nullable Type toType) {
            StandardLibrary standardLibrary;
            if (eIn == null || toType == null) {
                return null;
            }
            OCLExpression eOut = this.copy(eIn);
            if (eOut == null) {
                return null;
            }
            Type eType = eOut.getType();
            if (eType.conformsTo(standardLibrary = ((AbstractQVTc2QVTc)((Object)this.context)).getEnvironmentFactory().getStandardLibrary(), toType)) {
                return eOut;
            }
            assert (toType.conformsTo(standardLibrary, eType));
            return this.helper.createOperationCallExp(eOut, "oclAsType", new OCLExpression[]{this.helper.createTypeExp(toType)});
        }

        protected @NonNull Mapping doMapping(@NonNull Mapping mOut) {
            Mapping mIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(mOut);
            this.updateChild((Element)mOut.getGuardPattern());
            this.updateChild((Element)mOut.getBottomPattern());
            this.updateAllChildren((List)mOut.getDomain());
            this.updateAllChildren((List)mOut.getLocal());
            this.updateAllReferences((List)mIn.getSpecification(), (List)mOut.getSpecification());
            return mIn;
        }

        public @NonNull Operation getEqualsOperation() {
            if (this.equalsOperation != null) {
                return this.equalsOperation;
            }
            for (Operation op : ((AbstractQVTc2QVTc)((Object)this.context)).environmentFactory.getStandardLibrary().getOclAnyType().getOwnedOperations()) {
                if (!op.getName().equals("=")) continue;
                this.equalsOperation = op;
                return op;
            }
            throw new IllegalStateException();
        }

        protected <T extends Element> void updateAllChildren(List<T> targets) {
            for (Element target : targets) {
                target.accept((Visitor)this);
            }
        }

        protected <T extends Element> void updateAllReferences(List<T> sources, List<T> targets) {
            for (Element source : sources) {
                targets.add(((AbstractQVTc2QVTc)((Object)this.context)).equivalentTarget(source));
            }
        }

        protected void updateChild(@Nullable Element target) {
            if (target != null) {
                target.accept((Visitor)this);
            }
        }

        public @Nullable Object visiting(@NonNull Visitable visitable) {
            throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + ((Object)((Object)this)).getClass().getSimpleName());
        }

        public @Nullable Object visitBottomPattern(@NonNull BottomPattern bOut) {
            this.updateAllChildren((List)bOut.getAssignment());
            this.updateAllChildren((List)bOut.getPredicate());
            this.updateAllChildren((List)bOut.getRealizedVariable());
            this.updateAllChildren((List)bOut.getOwnedVariables());
            return null;
        }

        public @Nullable Object visitCoreDomain(@NonNull CoreDomain dOut) {
            Element dIn = ((AbstractQVTc2QVTc)((Object)this.context)).basicEquivalentSource((Element)dOut);
            TypedModel tmOut = dIn instanceof CoreDomain ? ((AbstractQVTc2QVTc)((Object)this.context)).equivalentTarget(QVTcoreUtil.getTypedModel((Domain)((CoreDomain)dIn))) : ((AbstractQVTc2QVTc)((Object)this.context)).getMiddleTypedModelTarget();
            dOut.setTypedModel(tmOut);
            dOut.setName(tmOut.getName());
            this.updateChild((Element)dOut.getGuardPattern());
            this.updateChild((Element)dOut.getBottomPattern());
            return null;
        }

        public @Nullable Object visitCoreModel(@NonNull CoreModel mOut) {
            CoreModel mIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(mOut);
            ((AbstractQVTc2QVTc)((Object)this.context)).pushScope((NamedElement)mOut);
            this.updateAllChildren(mOut.getOwnedPackages());
            ((AbstractQVTc2QVTc)((Object)this.context)).popScope();
            return null;
        }

        public @Nullable Element visitFunction(@NonNull Function fOut) {
            ((AbstractQVTc2QVTc)((Object)this.context)).pushScope((NamedElement)fOut);
            Function fIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(fOut);
            fOut.setBodyExpression(this.copy(fIn.getBodyExpression()));
            fOut.setType(fIn.getType());
            this.updateAllChildren(fOut.getOwnedParameters());
            ((AbstractQVTc2QVTc)((Object)this.context)).popScope();
            return null;
        }

        public @Nullable Object visitFunctionParameter(@NonNull FunctionParameter fpOut) {
            FunctionParameter fpIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(fpOut);
            fpOut.setType(fpIn.getType());
            fpOut.setTypeValue(fpIn.getTypeValue());
            return null;
        }

        public @Nullable Object visitGuardPattern(@NonNull GuardPattern gOut) {
            this.updateAllChildren((List)gOut.getPredicate());
            this.updateAllChildren((List)gOut.getOwnedVariables());
            for (VariableDeclaration vOut : gOut.getOwnedVariables()) {
                assert (!(vOut instanceof RealizedVariable));
            }
            return null;
        }

        public @NonNull Mapping visitMapping(@NonNull Mapping mOut) {
            ((AbstractQVTc2QVTc)((Object)this.context)).pushScope((NamedElement)mOut);
            Mapping mIn = this.doMapping(mOut);
            ((AbstractQVTc2QVTc)((Object)this.context)).popScope();
            return mIn;
        }

        public final Object visitNavigationAssignment(@NonNull NavigationAssignment object) {
            return this.visiting((Visitable)object);
        }

        public @Nullable Element visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment paOut) {
            OppositePropertyAssignment paIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(paOut);
            paOut.setSlotExpression(this.copy(paIn.getSlotExpression()));
            paOut.setValue(this.copy(paIn.getValue()));
            this.checkOut((Element)paOut);
            return paIn;
        }

        public @Nullable Object visitPackage(@NonNull Package pOut) {
            this.updateAllChildren(pOut.getOwnedClasses());
            this.updateAllChildren(pOut.getOwnedPackages());
            return null;
        }

        public @Nullable Object visitParameter(@NonNull Parameter pOut) {
            Parameter pIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(pOut);
            pOut.setName(pIn.getName());
            pOut.setIsRequired(pIn.isIsRequired());
            Type tIn = pIn.getType();
            Type tVar = tIn != null ? ((AbstractQVTc2QVTc)((Object)this.context)).equivalentTarget(tIn) : null;
            pOut.setType(tVar);
            Type tvIn = pIn.getTypeValue();
            pOut.setTypeValue(tvIn != null ? ((AbstractQVTc2QVTc)((Object)this.context)).equivalentTarget(tvIn) : null);
            return pIn;
        }

        public @Nullable Object visitPredicate(@NonNull Predicate pOut) {
            Predicate pIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(pOut);
            if (pIn instanceof NavigationAssignment) {
                return this.convertToPredicate((NavigationAssignment)pIn, pOut);
            }
            if (pIn instanceof Predicate) {
                pOut.setConditionExpression(this.copy(pIn.getConditionExpression()));
                this.checkOut((Element)pOut);
                return null;
            }
            return this.visiting((Visitable)pOut);
        }

        public @Nullable Element visitPropertyAssignment(@NonNull PropertyAssignment paOut) {
            PropertyAssignment paIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(paOut);
            paOut.setSlotExpression(this.copy(paIn.getSlotExpression()));
            paOut.setValue(this.copy(paIn.getValue()));
            this.checkOut((Element)paOut);
            return paIn;
        }

        public @Nullable Object visitRealizedVariable(@NonNull RealizedVariable rvOut) {
            RealizedVariable rvIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(rvOut);
            rvOut.setOwnedInit(this.copy(rvIn.getOwnedInit()));
            return rvIn;
        }

        public @Nullable Transformation visitTransformation(@NonNull Transformation tOut) {
            Transformation tIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(tOut);
            this.updateChild((Element)tOut.getOwnedContext());
            this.updateAllChildren(tOut.getOwnedOperations());
            this.updateAllChildren((List)tOut.getModelParameter());
            this.updateAllChildren((List)tOut.getRule());
            this.updateAllReferences(tIn.getSuperClasses(), tOut.getSuperClasses());
            return null;
        }

        public @Nullable Object visitTypedModel(@NonNull TypedModel tmOut) {
            TypedModel tmIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(tmOut);
            this.updateAllReferences((List)tmIn.getDependsOn(), (List)tmOut.getDependsOn());
            this.updateAllReferences((List)tmIn.getIterates(), (List)tmOut.getIterates());
            return null;
        }

        public @Nullable Object visitVariable(@NonNull Variable vOut) {
            Variable vIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(vOut);
            vOut.setName(vIn.getName());
            vOut.setIsImplicit(vIn.isIsImplicit());
            vOut.setIsRequired(vIn.isIsRequired());
            Type tIn = vIn.getType();
            Object tVar = vOut.eContainer() instanceof Transformation ? tIn : (tIn != null ? ((AbstractQVTc2QVTc)((Object)this.context)).equivalentTarget(tIn) : null);
            vOut.setType(tVar);
            Type tvIn = vIn.getTypeValue();
            vOut.setTypeValue(tvIn != null ? ((AbstractQVTc2QVTc)((Object)this.context)).equivalentTarget(tvIn) : null);
            vOut.setOwnedInit(this.createCastCopy(vIn.getOwnedInit(), (Type)tVar));
            return vIn;
        }

        public @Nullable Object visitVariableAssignment(@NonNull VariableAssignment vaOut) {
            VariableAssignment vaIn = ((AbstractQVTc2QVTc)((Object)this.context)).equivalentSource(vaOut);
            vaOut.setTargetVariable(((AbstractQVTc2QVTc)((Object)this.context)).equivalentTarget(vaIn.getTargetVariable()));
            vaOut.setValue(this.copy(vaIn.getValue()));
            return vaIn;
        }
    }

    protected static class ExpressionCopier
    extends EcoreUtil.Copier {
        private final @NonNull AbstractQVTc2QVTc context;

        public ExpressionCopier(@NonNull AbstractQVTc2QVTc context) {
            this.context = context;
        }

        public EObject get(Object oIn) {
            if (oIn instanceof Transformation) {
                ((Object)((Object)this)).getClass();
                return (EObject)oIn;
            }
            EObject eOut = (EObject)super.get(oIn);
            if (eOut == null) {
                eOut = this.context.equivalentTarget((Element)oIn);
            }
            return eOut;
        }
    }
}

