/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxRegistry;
import org.eclipse.m2m.internal.qvt.oml.blackbox.CompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContextImpl;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;

public class BlackboxUnitResolver
implements UnitResolver {
    public static final BlackboxUnitResolver DEFAULT = new BlackboxUnitResolver(URI.createURI((String)"/"));
    private ResolutionContext fContext;

    public BlackboxUnitResolver(URI context) {
        this.fContext = new ResolutionContextImpl(context);
    }

    public static boolean isBlackboxUnitURI(URI uri) {
        return "qvto".equals(uri.scheme()) && "blackbox".equals(uri.authority());
    }

    public static UnitProxy getUnit(URI uri) {
        if (BlackboxUnitResolver.isBlackboxUnitURI(uri) && uri.segmentCount() > 0) {
            String id = uri.lastSegment();
            return DEFAULT.resolveUnit(id);
        }
        return null;
    }

    public UnitProxy resolveUnit(String qualifiedName) {
        AbstractCompilationUnitDescriptor descriptor = BlackboxRegistry.INSTANCE.getCompilationUnitDescriptor(qualifiedName, this.fContext);
        if (descriptor != null) {
            String name;
            String namespace;
            int namePos = qualifiedName.lastIndexOf(46);
            if (namePos > 0) {
                namespace = qualifiedName.substring(0, namePos);
                if (namePos + 1 < qualifiedName.length()) {
                    ++namePos;
                }
                name = qualifiedName.substring(namePos);
            } else {
                name = qualifiedName;
                namespace = null;
            }
            return new BBoxUnit(namespace, name, descriptor);
        }
        return null;
    }

    class BBoxUnit
    extends UnitProxy {
        private AbstractCompilationUnitDescriptor fDescriptor;

        BBoxUnit(String namespace, String name, AbstractCompilationUnitDescriptor descriptor) {
            super(namespace, name, descriptor.getURI());
            this.fDescriptor = descriptor;
        }

        public int getContentType() {
            return 1;
        }

        public UnitContents getContents() throws IOException {
            return new BBoxUnitContents(this.fDescriptor);
        }

        public UnitResolver getResolver() {
            return BlackboxUnitResolver.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BBoxUnitContents
    implements UnitContents.ModelContents {
        private AbstractCompilationUnitDescriptor fDescriptor;
        private Diagnostic fProblems;

        BBoxUnitContents(AbstractCompilationUnitDescriptor descriptor) {
            assert (descriptor != null);
            this.fDescriptor = descriptor;
        }

        @Override
        public Diagnostic getProblems() {
            return this.fProblems;
        }

        @Override
        public List<EObject> loadElements(EPackage.Registry packageRegistry) {
            LoadContext loadContext = new LoadContext(packageRegistry);
            CompilationUnit cunit = null;
            try {
                cunit = BlackboxRegistry.INSTANCE.loadCompilationUnit(this.fDescriptor, loadContext);
            }
            catch (BlackboxException e) {
                Diagnostic diagnostic = e.getDiagnostic();
                if (diagnostic != null) {
                    QvtPlugin.logDiagnostic(diagnostic);
                } else {
                    QvtPlugin.error(NLS.bind(ValidationMessages.FailedToLoadUnit, new Object[]{this.fDescriptor.getQualifiedName()}), e);
                }
                String errMessage = NLS.bind(ValidationMessages.FailedToLoadUnit, this.fDescriptor.getQualifiedName());
                this.fProblems = new BasicDiagnostic(diagnostic.getSource(), diagnostic.getCode(), QvtOperationalParserUtil.wrappInSeeErrorLogMessage(errMessage), null);
            }
            if (cunit == null) {
                return Collections.emptyList();
            }
            List<QvtOperationalModuleEnv> elementEnvs = cunit.getElements();
            ArrayList<EObject> unitElements = new ArrayList<EObject>(elementEnvs.size());
            for (QvtOperationalModuleEnv nextEnv : elementEnvs) {
                Module module = nextEnv.getModuleContextType();
                if (module == null) continue;
                unitElements.add((EObject)module);
                ASTBindingHelper.setEnvironment((EObject)module, nextEnv);
            }
            return unitElements;
        }
    }
}

