/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml;

import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.InternalTransformationExecutor;
import org.eclipse.m2m.internal.qvt.oml.TransformationExecutorBlackboxRegistry;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTEvaluationOptions;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.util.Trace;

public final class TransformationExecutor {
    private InternalTransformationExecutor.TracesAwareExecutor fExector;

    public TransformationExecutor(URI uri) {
        this.fExector = new InternalTransformationExecutor.TracesAwareExecutor(uri);
    }

    public TransformationExecutor(URI uri, EPackage.Registry registry) {
        this.fExector = new InternalTransformationExecutor.TracesAwareExecutor(uri, registry);
    }

    public Diagnostic loadTransformation() {
        return this.loadTransformation((IProgressMonitor)new NullProgressMonitor());
    }

    public Diagnostic loadTransformation(IProgressMonitor monitor) {
        return this.fExector.loadTransformation(monitor);
    }

    public ExecutionDiagnostic execute(ExecutionContext executionContext, ModelExtent ... modelParameters) {
        ExecutionDiagnostic executionDiagnostic = this.fExector.execute(executionContext, modelParameters);
        Trace trace = executionContext.getSessionData().getValue(QVTEvaluationOptions.INCREMENTAL_UPDATE_TRACE);
        if (trace != null) {
            trace.setTraceContent(Collections.singletonList(this.fExector.getTraces()));
        }
        return executionDiagnostic;
    }

    public void cleanup() {
        this.fExector.cleanup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BlackboxRegistry {
        public static final BlackboxRegistry INSTANCE = new TransformationExecutorBlackboxRegistry();

        public Diagnostic registerModules(Class<?> ... var1);

        public Diagnostic registerModule(Class<?> var1);

        public Diagnostic registerModule(Class<?> var1, String var2, String var3);

        public Diagnostic registerModule(Class<?> var1, String var2, String var3, String[] var4);
    }
}

