/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.BrowserNode;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.MetamodelNode;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetamodelContainerNode
extends BrowserNode {
    static final int GLOBAL_REGISTRY_TYPE = 0;
    static final int WORKSPACE_MODELS_TYPE = 1;
    final int type;
    final String label;
    final Image image;

    MetamodelContainerNode(int type, String label, Image image, BrowserNode parent) {
        super(null, parent);
        this.label = label;
        this.image = image;
        this.type = type;
        assert (type >= 0 && type <= 1);
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    public BrowserNode resolve(EModelElement element) {
        List<MetamodelContainerNode> childContainers = this.childContainers();
        Collections.sort(childContainers, new Comparator<MetamodelContainerNode>(){

            @Override
            public int compare(MetamodelContainerNode o1, MetamodelContainerNode o2) {
                return o1.type - o2.type;
            }
        });
        BrowserNode result = null;
        List<BrowserNode> allChildNodes = this.getChildren(false);
        int i = 0;
        while (i < allChildNodes.size()) {
            MetamodelNode mmNode;
            BrowserNode node = allChildNodes.get(i);
            if (node instanceof MetamodelNode && (mmNode = (MetamodelNode)node).mayContain(element) && (result = mmNode.resolveModelElement(element)) != null) break;
            ++i;
        }
        if (result == null) {
            for (MetamodelContainerNode metamodelContainerNode : childContainers) {
                result = metamodelContainerNode.resolve(element);
                if (result != null) break;
            }
        }
        return result;
    }

    public List<MetamodelContainerNode> childContainers() {
        ArrayList<MetamodelContainerNode> childContainers = new ArrayList<MetamodelContainerNode>();
        List<BrowserNode> childNodes = this.getChildren(false);
        int i = 0;
        while (i < childNodes.size()) {
            BrowserNode node = childNodes.get(i);
            if (node instanceof MetamodelContainerNode) {
                childContainers.add((MetamodelContainerNode)node);
            }
            ++i;
        }
        return childContainers;
    }
}

