/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImportKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalFileEnv
extends QvtOperationalModuleEnv {
    private final URI myFile;

    protected QvtOperationalFileEnv(URI uri, EPackage.Registry registry) {
        super((EPackage.Registry)new EPackageRegistryImpl(registry), null);
        if (uri == null) {
            throw new IllegalArgumentException("Non-null uri required");
        }
        this.myFile = uri;
        QvtOperationalStdLibrary.INSTANCE.importTo(this);
    }

    public URI getFile() {
        return this.myFile;
    }

    @Override
    public String toString() {
        return "QVTOEnv:" + this.myFile.toString();
    }

    public void parserError(int errorCode, int leftToken, int rightToken, String tokenText) {
        if (tokenText.equals("\"qvtErrorToken\"") && errorCode == 5) {
            errorCode = 11;
        }
        super.parserError(errorCode, leftToken, rightToken, tokenText);
    }

    public List<EStructuralFeature> getAdditionalAttributes(EClassifier classifier) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        result.addAll(super.getAdditionalAttributes((Object)classifier));
        if (classifier instanceof Module) {
            Module module = (Module)classifier;
            for (ModuleImport imp : module.getModuleImport()) {
                if (imp.getKind() != ImportKind.EXTENSION && !(imp.getImportedModule() instanceof Library)) continue;
                Module extendedModule = imp.getImportedModule();
                List attributes = this.getUMLReflection().getAttributes((Object)extendedModule);
                List<EStructuralFeature> additionalAttributes = this.getAdditionalAttributes((EClassifier)extendedModule);
                result.addAll(attributes);
                result.addAll(additionalAttributes);
            }
        }
        return result;
    }
}

