/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.qvt.oml.debug.core.BreakpointError;
import org.eclipse.m2m.qvt.oml.debug.core.IQVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOBreakpoint;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugElement;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugUtil;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOThread;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOVirtualProcess;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTOVirtualMachineShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.QVTOVirtualMachine;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMEventListener;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.NewBreakpointData;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMBreakpointRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMBreakpointResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMDisconnectEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResumeEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResumeRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStartEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStartRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMSuspendEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMSuspendRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMTerminateEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMTerminateRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTODebugTarget
extends QVTODebugElement
implements IQVTODebugTarget,
IDebugEventSetListener,
IBreakpointManagerListener {
    private final Map<Long, QVTOBreakpoint> fID2Breakpoint = new HashMap<Long, QVTOBreakpoint>();
    private final ILaunch fLaunch;
    private final IProcess fProcess;
    private QVTOThread fMainThread;
    private String fMainModuleName;
    private boolean fIsStarting;
    private boolean fIsSuspended = false;
    private final IQVTOVirtualMachineShell fVM;
    private final List<VMEventListener> fEventListener = new LinkedList<VMEventListener>();
    private final Object fVMStartMonitor = new Object();

    public QVTODebugTarget(IProcess process, IQVTOVirtualMachineShell vm) {
        super(null);
        this.fLaunch = process.getLaunch();
        this.fProcess = process;
        this.fVM = vm;
        this.fIsStarting = true;
        this.fEventListener.add(this.createVMEventListener());
        EventDispatchJob dispatcher = new EventDispatchJob();
        Thread eventDispatherThread = new Thread((Runnable)dispatcher, "QVTO VM Event Dispatch");
        eventDispatherThread.setDaemon(true);
        eventDispatherThread.start();
        try {
            this.sendRequest(new VMStartRequest());
        }
        catch (DebugException e) {
            QVTODebugCore.log(e.getStatus());
            return;
        }
        this.joinStartOrTerminate();
        this.installVMBreakpoints();
        DebugEvent createEvent = new DebugEvent((Object)this, 4);
        createEvent.setData(new HashMap<Long, QVTOBreakpoint>(this.fID2Breakpoint));
        this.fMainThread = new QVTOThread(this);
        this.fLaunch.addDebugTarget((IDebugTarget)this);
        System.setProperty("org.eclipse.m2m.qvt.oml.debug.debuggerActive", Boolean.TRUE.toString());
        try {
            this.fVM.sendRequest(new VMResumeRequest(0));
        }
        catch (IOException e) {
            QVTODebugCore.log(e);
        }
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fireEvent(createEvent);
    }

    protected URI computeBreakpointURI(URI sourceURI) {
        return sourceURI;
    }

    private void installVMBreakpoints() {
        HashMap<Long, QVTOBreakpoint> installedBreakpoints = new HashMap<Long, QVTOBreakpoint>();
        ArrayList<NewBreakpointData> allBpData = new ArrayList<NewBreakpointData>();
        for (QVTOBreakpoint qvtBp : QVTODebugCore.getQVTOBreakpoints(QVTOBreakpoint.class)) {
            boolean enabled = false;
            try {
                enabled = qvtBp.isEnabled();
            }
            catch (CoreException e) {
                QVTODebugCore.log(e.getStatus());
            }
            if (!enabled) continue;
            installedBreakpoints.put(new Long(qvtBp.getID()), qvtBp);
            try {
                NewBreakpointData data = qvtBp.createNewBreakpointData();
                data.targetURI = this.computeBreakpointURI(URI.createURI((String)data.targetURI, (boolean)true)).toString();
                allBpData.add(data);
            }
            catch (CoreException e) {
                QVTODebugCore.log(e.getStatus());
            }
        }
        if (!allBpData.isEmpty()) {
            VMBreakpointRequest breakpointRequest = VMBreakpointRequest.createAdd(allBpData.toArray(new NewBreakpointData[allBpData.size()]));
            try {
                VMResponse response = this.fVM.sendRequest(breakpointRequest);
                this.fID2Breakpoint.clear();
                if (response instanceof VMBreakpointResponse) {
                    VMBreakpointResponse bpResponse = (VMBreakpointResponse)response;
                    long[] lArray = bpResponse.getAddedBreakpointsIDs();
                    int n = lArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long addedID = lArray[n2];
                        Long key = new Long(addedID);
                        QVTOBreakpoint bp = (QVTOBreakpoint)((Object)installedBreakpoints.get(key));
                        if (bp != null) {
                            this.fID2Breakpoint.put(key, bp);
                        }
                        ++n2;
                    }
                }
            }
            catch (IOException e) {
                QVTODebugCore.log(e);
            }
        }
    }

    public Collection<? extends IBreakpoint> getInstalledBreakpoints() {
        return Collections.unmodifiableCollection(this.fID2Breakpoint.values());
    }

    @Override
    public VMResponse sendRequest(VMRequest request) throws DebugException {
        try {
            return this.fVM.sendRequest(request);
        }
        catch (IOException e) {
            throw new DebugException(QVTODebugUtil.createDebugError("Send debug request failed", e));
        }
    }

    public synchronized boolean isSuspended() {
        return !this.isTerminated() && this.fIsSuspended;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IQVTOVirtualMachineShell getVM() {
        return this.fVM;
    }

    public IProcess getProcess() {
        IProcess[] processes = this.getLaunch().getProcesses();
        if (processes != null && processes.length > 0) {
            return processes[0];
        }
        return null;
    }

    public boolean hasThreads() throws DebugException {
        return !this.isTerminated();
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] iThreadArray;
        if (this.fMainThread != null) {
            IThread[] iThreadArray2 = new IThread[1];
            iThreadArray = iThreadArray2;
            iThreadArray2[0] = this.fMainThread;
        } else {
            iThreadArray = new IThread[]{};
        }
        return iThreadArray;
    }

    public String getName() throws DebugException {
        return "QVTO Debug target";
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals(this.getModelIdentifier());
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fVM.isTerminated();
    }

    public void terminate() throws DebugException {
        this.sendRequest(new VMTerminateRequest());
    }

    protected void started(String mainModuleName) {
        this.setMainModuleName(mainModuleName);
        this.setStarting(false);
    }

    protected synchronized void setMainModuleName(String mainModuleName) {
        this.fMainModuleName = mainModuleName;
    }

    public synchronized String getMainModuleName() {
        return this.fMainModuleName;
    }

    protected void terminated() {
        QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/target", "Debug target terminated");
        System.setProperty("org.eclipse.m2m.qvt.oml.debug.debuggerActive", Boolean.FALSE.toString());
        this.setStarting(false);
        this.fMainThread = null;
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            IBreakpointManager breakpointManager = debugPlugin.getBreakpointManager();
            breakpointManager.removeBreakpointListener((IBreakpointListener)this);
            breakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
            debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        }
        this.fID2Breakpoint.clear();
        this.fireTerminateEvent();
        if (this.fProcess instanceof QVTOVirtualProcess) {
            QVTOVirtualProcess vp = (QVTOVirtualProcess)this.fProcess;
            vp.terminated();
        }
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public void resume() throws DebugException {
        this.sendRequest(new VMResumeRequest(0));
    }

    public void suspend() throws DebugException {
        this.sendRequest(new VMSuspendRequest(0));
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!(breakpoint instanceof QVTOBreakpoint) || !DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return;
        }
        QVTOBreakpoint qvtBreakpoint = (QVTOBreakpoint)breakpoint;
        try {
            VMBreakpointResponse bpResponse;
            long[] addedIDs;
            NewBreakpointData bpData = qvtBreakpoint.createNewBreakpointData();
            VMBreakpointRequest addBreakpointRequest = VMBreakpointRequest.createAdd(bpData);
            VMResponse response = this.sendRequest(addBreakpointRequest);
            if (response instanceof VMBreakpointResponse && (addedIDs = (bpResponse = (VMBreakpointResponse)response).getAddedBreakpointsIDs()).length > 0) {
                this.fID2Breakpoint.put(new Long(addedIDs[0]), qvtBreakpoint);
            }
        }
        catch (CoreException e) {
            QVTODebugCore.log(e.getStatus());
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!(breakpoint instanceof QVTOBreakpoint) || !DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return;
        }
        boolean nowEnabled = false;
        try {
            nowEnabled = breakpoint.isEnabled();
        }
        catch (CoreException coreException) {}
        boolean beforeEnabled = delta.getAttribute("org.eclipse.debug.core.enabled", false);
        VMBreakpointRequest changeRequest = null;
        try {
            QVTOBreakpoint qvtBreakpoint = (QVTOBreakpoint)breakpoint;
            changeRequest = nowEnabled && !beforeEnabled ? VMBreakpointRequest.createAdd(new NewBreakpointData[]{qvtBreakpoint.createNewBreakpointData()}) : (!nowEnabled && beforeEnabled ? VMBreakpointRequest.createRemove(qvtBreakpoint.getID()) : VMBreakpointRequest.createChange(qvtBreakpoint.getID(), qvtBreakpoint.createBreakpointData()));
        }
        catch (CoreException e) {
            QVTODebugCore.log(e);
        }
        if (changeRequest != null) {
            try {
                this.fVM.sendRequest(changeRequest);
            }
            catch (IOException e) {
                QVTODebugCore.log(e);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof QVTOBreakpoint) {
            IMarker marker;
            if (delta == null && (marker = breakpoint.getMarker()).exists()) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            QVTOBreakpoint qvtBreakpoint = (QVTOBreakpoint)breakpoint;
            this.fID2Breakpoint.remove(new Long(((QVTOBreakpoint)breakpoint).getID()));
            VMBreakpointRequest removeRequest = VMBreakpointRequest.createRemove(qvtBreakpoint.getID());
            try {
                this.fVM.sendRequest(removeRequest);
            }
            catch (IOException e) {
                QVTODebugCore.log(e);
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 8 && (this.fMainThread != null && event.getSource() == this.fMainThread || event.getSource() == this.fProcess) && !this.isTerminated()) {
                this.terminated();
            }
            ++i;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        for (IBreakpoint breakpoint : QVTODebugCore.getQVTOBreakpoints(IBreakpoint.class)) {
            if (enabled) {
                this.breakpointAdded(breakpoint);
                continue;
            }
            this.breakpointRemoved(breakpoint, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void joinStartOrTerminate() {
        Object object = this.fVMStartMonitor;
        synchronized (object) {
            while (true) {
                if (!this.fIsStarting) {
                    return;
                }
                try {
                    this.fVMStartMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStarting(boolean isStarting) {
        Object object = this.fVMStartMonitor;
        synchronized (object) {
            this.fIsStarting = isStarting;
            this.fVMStartMonitor.notify();
        }
    }

    private void handleBreakpointConditionError(VMSuspendEvent suspend) {
        BreakpointError breakpointStatus = new BreakpointError(suspend.getBreakpointID(), suspend.getReason(), suspend.getReasonDetail());
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)breakpointStatus);
        if (handler != null) {
            try {
                handler.handleStatus((IStatus)breakpointStatus, (Object)this);
            }
            catch (CoreException e) {
                QVTODebugCore.log(e.getStatus());
            }
        } else {
            QVTODebugCore.log((IStatus)breakpointStatus);
        }
    }

    private VMEventListener createVMEventListener() {
        return new VMEventListener(){

            public void handleEvent(VMEvent event) {
                if (event instanceof VMResumeEvent) {
                    QVTODebugTarget.this.fIsSuspended = false;
                    QVTODebugTarget.this.fireResumeEvent(0);
                } else if (event instanceof VMSuspendEvent) {
                    QVTODebugTarget.this.fIsSuspended = true;
                    VMSuspendEvent suspend = (VMSuspendEvent)event;
                    QVTODebugTarget.this.fireSuspendEvent(suspend.detail);
                    if (suspend.detail == 42) {
                        QVTODebugTarget.this.handleBreakpointConditionError(suspend);
                    }
                } else if (event instanceof VMTerminateEvent) {
                    QVTODebugTarget.this.fIsSuspended = false;
                    QVTODebugTarget.this.terminated();
                } else if (event instanceof VMDisconnectEvent) {
                    QVTODebugTarget.this.fIsSuspended = false;
                    QVTODebugTarget.this.terminated();
                } else if (event instanceof VMStartEvent) {
                    QVTODebugTarget.this.started(((VMStartEvent)event).mainModuleName);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVMEventListener(VMEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        List<VMEventListener> list = this.fEventListener;
        synchronized (list) {
            this.fEventListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeVMEventListener(VMEventListener listener) {
        List<VMEventListener> list = this.fEventListener;
        synchronized (list) {
            return this.fEventListener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleVMEvent(VMEvent event) {
        ArrayList<VMEventListener> listeners;
        List<VMEventListener> list = this.fEventListener;
        synchronized (list) {
            listeners = new ArrayList<VMEventListener>(this.fEventListener);
        }
        for (VMEventListener vmEventListener : listeners) {
            try {
                vmEventListener.handleEvent(event);
            }
            catch (Exception e) {
                QVTODebugCore.log(e);
            }
        }
    }

    public IValue evaluate(String expressionText, long frameID) throws CoreException {
        if (this.getVM() instanceof QVTOVirtualMachine) {
            return ((QVTOVirtualMachine)this.getVM()).evaluate(expressionText, this, frameID);
        }
        return null;
    }

    private class EventDispatchJob
    implements Runnable {
        EventDispatchJob() {
        }

        public void run() {
            while (!QVTODebugTarget.this.isTerminated()) {
                VMEvent event;
                try {
                    event = QVTODebugTarget.this.fVM.readVMEvent();
                }
                catch (IOException iOException) {
                    break;
                }
                if (event == null) continue;
                QVTODebugTarget.this.handleVMEvent(event);
            }
            QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/target", "Debug target VMEvent dispatcher shutdown");
        }
    }
}

