/**
* Essential OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2010 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 184048, 225493, 243976, 259818, 282882, 287993, 288040, 292112, 295166
*   Borland - Bug 242880
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
* </copyright>
*
* $Id: LightweightParserprs.java,v 1.14 2010/05/14 09:16:04 sboyko Exp $
*/
/**
* <copyright>
*
* Copyright (c) 2006, 2007 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (297966)
*
* </copyright>
*
*/
/**
* <copyright>
*
* Copyright (c) 2006, 2007 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (297966)
*
* </copyright>
*
*/

package org.eclipse.m2m.internal.qvt.oml.cst.completion.parser;

public class LightweightParserprs implements lpg.runtime.ParseTable, LightweightParsersym {
    public final static int ERROR_SYMBOL = 2;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 96;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 97;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 30;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 506;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 163;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 9973;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 2;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 687;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 287;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 450;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 1926;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 3;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 119;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 119;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 9285;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 9286;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = true;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return LightweightParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,1,0,1,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,1,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,1,
            0,0,0,0,0,0,0,0,0,0,
            0,1,0,0,0,0,1,0,1,0,
            0,0,0,0,1,1,0,0,0,1,
            1,0,0,0,1,0,0,1,0,0,
            0,1,0,1,0,0,0,1,0,0,
            0,0,0,1,0,0,1,0,1,0,
            1,0,0,0,0,0,0,0,1,0,
            1,1,1,0,0,0,0,0,0,0,
            0,0,0,0,0,0,1,0,0,1,
            1,0,0,1,1,0,1,0,0,1,
            1,0,0,1,1,1,1,0,0,0,
            1,1,1,1,1,0,0,0,0,0,
            1,1,1,0,0,0,1,0,0,1,
            0,0,0,0,1,1,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static char prosthesesIndex[] = {0,
            12,13,9,10,15,17,18,40,38,42,
            32,39,41,43,44,273,274,276,277,11,
            29,30,31,33,46,47,48,49,50,51,
            52,53,54,59,60,61,86,88,89,90,
            91,94,96,113,123,141,152,265,267,101,
            83,84,85,80,81,82,77,78,79,74,
            75,76,71,72,73,68,69,70,65,66,
            67,133,24,55,62,63,64,102,107,110,
            132,136,16,93,95,112,56,58,211,155,
            21,57,227,286,287,22,25,27,189,108,
            23,175,87,165,190,195,196,197,248,262,
            285,6,8,14,26,36,37,104,105,111,
            114,169,170,171,172,173,174,183,209,210,
            228,229,230,231,232,235,236,237,238,239,
            240,242,243,244,246,284,34,35,98,99,
            106,109,119,124,126,129,130,148,149,154,
            157,158,163,179,187,198,199,200,202,208,
            216,217,219,233,234,266,269,270,271,280,
            282,2,3,4,19,20,45,92,97,100,
            103,115,116,117,118,120,121,122,125,127,
            128,131,134,135,137,138,139,140,142,143,
            144,145,146,147,150,151,153,156,159,160,
            161,162,164,166,167,168,176,177,178,180,
            181,182,184,185,186,188,191,192,193,194,
            201,203,204,205,206,207,212,213,214,215,
            218,220,221,222,223,224,225,226,241,245,
            247,249,250,251,252,253,254,255,256,257,
            258,259,260,261,263,264,268,272,275,278,
            279,281,283,1,5,7,28
        };
    };
    public final static char prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,1,1,0,0,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,0,1,1,0,0,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            0,1,1,1,1,1,1,1,1,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,0,
            1,1,1,1,1,0,0,0,0,0,
            0,1,1,1,1,1,1,1,0,0,
            0,0,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,0,0,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck0 {
        public final static short baseCheck0[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,2,1,1,1,
            3,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,4,4,
            0,1,1,3,1,3,3,5,1,1,
            1,1,1,1,1,1,1,1,1,1,
            4,0,1,1,3,1,1,3,1,1,
            1,1,1,1,1,4,1,3,1,1,
            1,2,1,1,1,1,1,1,1,1,
            1,1,1,1,8,10,10,8,10,1,
            1,1,5,6,8,8,7,7,5,6,
            9,1,4,6,4,0,0,1,1,3,
            1,1,1,1,1,1,1,1,1,3,
            1,3,1,1,1,3,1,3,1,1,
            1,3,1,3,1,1,1,3,1,3,
            1,1,1,3,3,1,3,3,1,1,
            1,3,3,3,3,1,3,3,3,3,
            1,1,1,3,3,1,3,3,1,1,
            1,3,3,1,3,3,1,1,1,2,
            2,1,2,2,1,1,1,1,1,1,
            3,4,1,3,1,4,4,1,6,4,
            1,1,1,3,1,0,1,3,2,1,
            2,1,0,1,2,4,4,1,2,4,
            4,2,3,3,5,5,3,3,3,3,
            1,1,1,1,3,3,3,3,1,7,
            7,5,3,5,1,3,1,1,1,3,
            0,2,2,6,2,1,1,1,1,1,
            1,7,5,6,4,2,1,2,1,1,
            3,7,2,4,4,2,1,2,5,5,
            0,1,2,2,1,1,2,1,0,5,
            1,1,1,0,2,1,0,6,5,1,
            3,1,1,1,1,1,1,1,1,4,
            4,2,1,3,5,5,1,3,0,1,
            2,0,1,6,3,1,5,1,1,1,
            1,1,3,5,5,3,1,0,0,1,
            2,1,1,3,2,3,2,2,2,1,
            6,4,2,4,4,1,1,3,1,2,
            1,2,0,1,1,1,1,1,1,1,
            1,1,2,1,1,1,2,5,1,1,
            2,5,5,0,1,1,1,1,2,4,
            1,2,0,1,1,1,2,0,1,1,
            1,3,3,0,1,1,1,1,3,2,
            2,2,0,1,1,1,1,1,1,2,
            1,7,1,2,0,1,2,1,3,2,
            1,4,1,0,1,1,1,8,0,2,
            1,3,2,0,2,1,3,2,9,1,
            0,2,0,3,1,3,2,0,2,2,
            1,1,1,1,1,0,3,1,1,3,
            3,3,3,1,0,0,4,1,0,6,
            6,7,5,6,8,1,1,1,3,2,
            2,1,1,2,2,4,3,1,1,4,
            2,2,3,1,1,2,2,2,3,4,
            0,2,1,1,2,5,3,2,6,5,
            3,2,0,1,2,1,1,1,1,0,
            5,2,3,0,1,2,2,0,1,1,
            2,2,0,1,2,2,0,1,1,1,
            1,1,3,3,3,5,5,7,7,5,
            5,0,2,2,0,2,0,1,3,1,
            1,1,1,0,1,5,5,3,2,1,
            1,1,1,7,5,7,5,4,3,1,
            1,3,3,1,3,3,1,1,1,1,
            1,3,4,4,3,3,3,4,3,1,
            7,0,2,1,1,1,0,2,2,0,
            1,3,0,1,3,3,1,1,4,2,
            0,1,1,1,1,1,3,1,1,1,
            3,3,1,1,1,3,3,1,3,2,
            1,3,3,2,1,1,1,-132,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -123,1,2,-2,-122,1,2,-5,-6,5,
            -15,1,2,-181,-7,5,16,17,18,19,
            16,17,18,19,-46,1,2,-305,-176,-105,
            -221,1,2,-65,-8,118,119,8,9,10,
            11,12,13,14,15,-292,-11,1,2,-118,
            -16,5,-145,8,9,10,11,12,13,14,
            15,-106,1,2,3,4,-222,1,2,-171,
            1,2,3,4,-18,-149,-96,-477,161,162,
            3,4,-282,6,7,-236,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,218,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,86,156,
            93,94,95,112,113,114,176,-20,149,150,
            176,112,113,114,-12,1,2,183,184,5,
            -13,-45,192,193,149,150,-233,121,-359,1,
            2,152,120,118,119,177,178,179,175,209,
            210,211,212,180,201,202,164,-21,189,190,
            -51,194,-299,1,2,3,4,217,8,205,
            206,155,-400,1,2,-380,160,5,-127,164,
            50,3,4,8,6,7,161,162,-304,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,93,94,95,112,113,114,105,-496,91,
            -156,1,2,266,96,97,98,9,10,-141,
            159,-217,3,4,269,6,7,272,-428,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,101,93,94,95,87,-286,1,2,91,
            -426,1,2,-14,96,259,98,-102,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,-309,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -336,91,-97,97,-371,-502,96,101,98,-342,
            -109,-397,1,2,9,10,5,-361,1,2,
            -295,115,-22,-446,1,2,215,216,5,-331,
            -332,8,-503,116,117,-421,-315,-449,-23,-453,
            -24,9,10,-25,-26,8,-52,-30,-476,1,
            2,-31,50,5,-333,257,-147,-401,-252,3,
            4,-32,6,7,147,148,-104,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,105,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,93,
            94,95,129,105,-92,-501,-17,-93,156,-497,
            106,107,108,106,107,108,129,-33,-143,159,
            203,204,152,-34,-35,175,8,-36,167,-37,
            180,-38,116,117,-39,-40,177,178,179,154,
            -41,278,279,170,-42,166,166,168,168,195,
            -47,-48,200,-49,50,-258,50,50,3,4,
            -53,6,7,147,148,-188,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,93,94,
            95,86,263,264,265,247,270,261,-493,273,
            154,3,4,267,6,7,-451,-131,-307,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,153,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,93,94,95,-153,1,2,90,-303,91,
            242,196,253,258,96,99,98,-352,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -146,97,-44,86,-216,1,2,3,4,5,
            6,7,-50,1,2,3,4,5,6,7,
            -103,1,2,3,4,5,6,7,-129,121,
            -128,213,-152,-244,-200,-214,-62,-343,-399,-500,
            -225,-226,-245,-394,-246,-60,-61,-442,-270,-271,
            50,-278,50,-495,50,-64,-348,241,-384,-66,
            -385,-68,-390,155,-69,-70,-79,-81,160,-82,
            153,-83,-84,-85,-288,1,2,-86,50,-87,
            50,-88,50,-378,50,50,50,83,84,85,
            50,50,50,50,50,83,84,85,50,50,
            -89,50,100,83,84,85,50,199,50,109,
            50,111,50,-90,197,-1,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,91,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-125,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,245,-91,-393,-94,87,88,244,260,246,
            207,208,-95,254,-99,-107,268,182,251,271,
            262,-108,-119,-124,-126,252,-135,-136,-139,-151,
            -159,-160,-161,-162,277,282,-163,-164,-165,-166,
            -167,-172,-178,-179,-180,-183,-184,-185,-186,-187,
            -59,1,2,50,219,220,-173,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,89,
            -140,1,2,87,88,-174,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-27,89,
            -189,-190,87,88,-177,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-142,1,2,
            92,87,88,-202,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,89,-232,1,2,
            87,88,-279,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-191,89,-192,86,-71,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,-193,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,-194,157,
            -293,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-487,1,2,-195,87,88,-356,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,89,-505,1,2,87,88,-358,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-133,89,-137,-55,87,88,-360,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            86,90,-196,90,87,88,-362,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-313,
            -314,-197,-275,87,88,-410,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,86,90,
            90,86,-115,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,-198,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,-334,-339,
            -199,-203,157,-455,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-201,-346,90,90,
            87,88,-456,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-218,-471,90,92,87,
            88,-457,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-494,-506,90,92,87,88,
            -19,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-290,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,-403,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-204,173,173,-205,
            -206,-207,-208,-209,-210,-211,-212,-213,-219,-223,
            -224,-227,-228,50,-230,-117,-231,-235,-259,-434,
            1,2,-386,-433,1,2,-220,-387,198,116,
            117,-322,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,-408,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,91,100,97,99,92,96,
            101,98,100,-238,-240,-241,-247,100,-250,-251,
            -253,50,-254,-262,115,-263,-264,-424,1,2,
            -265,-266,-267,-357,-370,-377,-268,-269,-272,118,
            119,-427,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,97,92,92,92,87,-43,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,-274,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-98,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,-450,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-280,-285,-294,-297,-298,
            -300,-301,-302,-308,-311,-317,-320,-321,-324,-325,
            -328,-335,50,-344,-347,-349,-350,-351,-353,-355,
            191,-363,-364,-365,-366,-367,-368,-369,-372,-373,
            -374,-375,-376,121,-120,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-121,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -155,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-182,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-215,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-310,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-354,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-405,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-432,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-9,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,-381,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-138,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,-388,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-154,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,-391,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -158,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            -395,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-229,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,-396,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-234,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,-402,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-248,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,-404,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-276,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,-413,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-281,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,-414,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-283,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,-415,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-284,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,-416,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-289,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,-417,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-291,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,-418,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -296,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            -419,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-312,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,-420,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-340,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,-430,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-345,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,-431,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-379,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,-438,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-389,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,-439,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-406,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,-441,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-407,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,-447,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-409,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,-454,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-422,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,-458,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -423,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            -459,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-425,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,-460,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-435,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,-461,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-440,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,-462,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-481,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,-463,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-482,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,-464,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-483,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,-466,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-484,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,-468,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-485,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,-469,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-504,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,-470,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -116,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            -437,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,-72,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,72,51,52,53,54,55,56,57,
            58,59,60,61,62,-112,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,-475,51,52,53,54,
            55,56,57,58,59,-113,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,-478,51,52,53,54,
            55,56,57,58,59,-114,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,-479,51,52,53,54,
            55,56,57,58,59,-73,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,-480,51,52,53,54,
            55,56,-74,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,-486,51,52,53,54,55,56,-75,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,-489,
            51,52,53,54,55,56,-76,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,-490,51,52,53,
            54,55,56,-110,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17
        };
    };

    public interface BaseCheck1 {
        public final static short baseCheck1[] = {
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,-491,51,52,53,-111,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,-498,51,52,53,
            -28,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            -29,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            -452,-473,-488,103,-499,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            50,50,50,103,-77,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,-78,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,-3,0,0,103,-10,1,
            2,3,4,5,6,7,0,0,0,0,
            -329,1,2,3,4,5,6,7,0,0,
            -243,-257,-157,1,2,3,4,5,6,7,
            -239,1,2,3,4,5,6,7,0,-474,
            0,0,-319,0,50,0,0,103,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-472,1,2,0,0,0,0,0,0,
            50,50,0,0,0,0,0,0,0,0,
            0,83,84,85,0,-168,1,2,3,4,
            5,6,7,83,84,85,102,-383,1,2,
            3,4,5,6,7,83,84,85,110,-134,
            90,50,-465,83,84,85,122,123,124,125,
            126,127,128,102,130,131,132,133,134,135,
            136,137,138,139,140,141,142,143,144,145,
            110,102,100,122,123,124,125,126,127,128,
            89,130,131,132,133,134,135,136,137,138,
            139,140,141,142,143,144,145,-261,83,84,
            85,-169,1,2,3,4,5,6,7,0,
            83,84,85,-148,1,2,0,0,0,0,
            169,0,-448,151,0,110,-170,1,2,3,
            4,5,6,7,92,0,0,110,99,0,
            171,172,0,0,0,221,222,50,224,225,
            226,227,228,229,230,231,232,-255,1,2,
            -249,1,2,3,4,5,6,7,-273,1,
            2,3,4,5,6,7,-277,1,2,3,
            4,5,6,7,83,84,85,0,0,249,
            -287,1,2,3,4,5,6,7,-56,102,
            -467,0,89,275,276,281,0,50,86,83,
            84,85,0,174,0,0,0,104,0,122,
            123,124,125,126,127,128,0,130,131,132,
            133,134,135,136,137,138,139,140,141,142,
            143,144,145,83,84,85,89,256,50,0,
            -338,83,84,85,0,-306,1,2,0,83,
            84,85,0,-101,1,2,169,-4,1,2,
            0,0,0,83,84,85,-326,1,2,3,
            4,5,6,7,86,0,86,0,-256,274,
            -327,1,2,3,4,5,6,7,-341,1,
            2,3,4,5,6,7,-429,1,2,3,
            4,5,6,7,-445,1,2,3,4,5,
            6,7,-492,1,2,3,4,5,6,7,
            -57,-392,0,3,4,-175,6,7,3,4,
            -411,6,7,-67,1,2,91,-330,1,2,
            -130,96,5,98,91,8,106,107,108,83,
            84,85,0,0,97,-100,1,2,101,-63,
            1,2,-323,83,84,85,-436,1,2,-412,
            50,83,84,85,-318,50,-150,1,2,83,
            84,85,-144,50,106,107,108,83,84,85,
            50,-260,-54,0,-242,83,84,85,0,-398,
            1,2,0,158,5,165,-443,1,2,50,
            -337,-58,50,93,94,95,86,-80,93,94,
            95,0,89,102,50,0,0,-237,-316,-382,
            0,0,50,0,0,0,0,104,185,186,
            0,50,50,165,50,188,0,0,89,109,
            120,111,97,0,0,86,101,91,0,214,
            50,50,96,104,98,89,129,50,-444,0,
            115,109,0,111,234,235,236,50,50,50,
            104,99,0,109,0,111,146,0,0,120,
            99,99,171,172,100,89,163,86,0,0,
            0,0,0,86,105,0,0,170,146,99,
            0,0,0,86,86,86,238,0,50,0,
            146,181,0,0,158,0,0,0,0,0,
            0,0,0,0,0,0,0,280,0,163,
            0,0,187,181,0,151,0,0,0,0,
            0,0,0,0,0,0,223,0,90,0,
            0,0,0,0,0,0,167,0,0,248,
            0,250,0,0,0,0,0,0,0,0,
            243,0,0,0,174,0,0,0,0,0,
            0,0,0,0,0,0,0,0,239,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,237,
            0,0,240,283,233,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,255,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0
        };
    };

    public final static short baseCheck[] = new short[BaseCheck0.baseCheck0.length + BaseCheck1.baseCheck1.length];
    {
        int index = 0;
        System.arraycopy(BaseCheck0.baseCheck0, 0, baseCheck, index, BaseCheck0.baseCheck0.length);
        index += BaseCheck0.baseCheck0.length;
        System.arraycopy(BaseCheck1.baseCheck1, 0, baseCheck, index, BaseCheck1.baseCheck1.length);
    };
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction0 {
        public final static char baseAction0[] = {
            182,183,183,183,183,183,183,183,183,183,
            183,183,183,183,183,183,184,285,285,285,
            285,285,285,285,285,285,285,285,112,286,
            113,113,113,20,1,1,2,2,114,114,
            5,5,4,4,4,4,4,4,4,4,
            3,3,3,3,3,83,83,83,83,6,
            7,185,185,186,186,96,91,101,97,115,
            115,98,98,287,287,287,287,21,21,21,
            21,22,147,147,148,148,116,116,117,11,
            11,11,11,11,11,11,23,187,187,9,
            12,8,8,13,13,10,14,15,24,24,
            24,25,25,27,27,28,28,28,29,29,
            26,26,26,31,31,31,31,31,31,31,
            31,31,33,32,32,34,92,88,88,87,
            87,73,73,36,35,74,74,77,77,75,
            75,76,76,70,70,69,69,71,71,67,
            67,66,66,68,68,64,64,63,63,65,
            65,61,61,60,60,60,62,62,62,58,
            58,57,57,57,57,57,59,59,59,59,
            59,55,55,54,54,54,56,56,56,52,
            52,51,51,51,53,53,53,103,103,37,
            37,37,38,38,38,30,30,39,39,39,
            39,39,40,188,188,83,84,42,83,85,
            43,149,21,21,150,189,189,190,190,190,
            73,78,191,191,118,119,119,119,73,79,
            79,79,79,151,151,100,100,100,100,100,
            100,152,152,152,73,80,80,80,80,120,
            44,44,44,28,28,87,87,193,193,194,
            194,195,195,195,192,192,39,153,153,196,
            197,198,41,41,41,41,41,39,45,199,
            199,199,29,45,154,154,154,200,200,156,
            156,201,201,202,202,73,81,203,204,204,
            72,81,205,206,206,207,208,208,82,46,
            39,29,210,210,210,210,211,211,212,212,
            209,209,209,213,213,213,214,158,158,159,
            159,215,216,216,29,29,39,47,217,39,
            39,155,155,121,121,121,160,90,90,218,
            218,161,118,162,162,162,86,86,157,157,
            50,156,156,156,202,202,219,221,222,223,
            222,163,220,220,221,221,221,221,221,221,
            221,221,221,221,221,224,224,227,228,225,
            225,230,231,229,234,234,235,235,233,236,
            232,239,232,237,237,240,165,165,238,238,
            106,106,107,108,166,166,168,168,167,167,
            167,105,164,164,169,169,169,169,169,169,
            169,169,226,245,226,244,244,246,243,243,
            243,170,170,170,242,242,129,122,130,247,
            247,249,249,249,248,248,250,250,250,171,
            171,254,254,172,172,255,255,255,251,251,
            251,256,256,256,256,256,173,173,257,257,
            257,257,257,257,252,252,253,253,258,258,
            123,123,123,123,123,123,124,124,124,134,
            134,135,175,175,131,131,132,133,125,125,
            138,136,136,137,126,126,141,141,139,140,
            102,259,259,127,127,142,143,143,144,145,
            145,145,262,262,263,264,265,265,265,261,
            261,267,267,260,268,268,271,271,269,269,
            272,272,272,270,270,273,273,274,274,275,
            276,276,276,275,48,48,176,176,176,176,
            49,49,277,277,277,177,177,178,178,179,
            278,278,278,278,16,16,17,17,17,17,
            279,279,279,279,18,18,18,18,18,18,
            19,19,31,31,39,31,31,39,39,1,
            1,280,280,40,40,60,62,217,222,229,
            221,281,128,128,180,180,180,282,282,174,
            241,241,99,283,283,181,181,181,181,146,
            146,109,109,111,111,111,110,110,94,94,
            94,93,93,93,95,95,95,95,266,266,
            266,104,104,104,104,89,182,182,300,2319,
            1354,1333,108,1355,109,110,948,89,93,79,
            90,92,94,95,1224,620,621,624,143,219,
            77,78,80,217,111,112,113,114,962,120,
            121,122,132,1512,218,201,204,1358,212,220,
            232,233,286,297,330,356,628,627,377,1478,
            805,196,1362,1372,186,1488,785,176,1484,1485,
            169,1495,779,163,1490,1492,157,1505,778,151,
            316,372,141,1496,146,1501,240,248,264,315,
            321,2884,3711,1354,62,2630,3727,1354,5,2341,
            3709,225,40,1354,2908,2344,2103,1224,620,621,
            622,1224,620,621,623,2242,322,1354,3520,233,
            2649,225,4112,1354,2784,2644,373,244,948,89,
            93,231,90,92,94,95,3053,225,40,1354,
            3098,198,1924,63,948,89,93,231,90,92,
            94,95,90,38,1354,30,31,225,4113,1354,
            90,38,1354,30,31,2243,63,85,3016,370,
            8562,1884,668,3507,670,669,2171,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,962,120,121,122,
            132,1512,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,3826,1478,805,196,
            1362,1372,186,1488,785,176,1484,1485,169,1495,
            779,163,1490,1492,157,1505,778,151,316,372,
            141,1496,146,1501,240,248,264,315,321,269,
            308,678,2117,2118,32,39,3347,625,70,3261,
            237,626,32,39,41,225,40,1354,16,3436,
            2093,2173,3174,273,1851,3261,238,1140,361,225,
            5855,1354,4477,272,373,244,8780,1860,598,521,
            331,3713,3712,1852,643,1862,312,8563,2223,3243,
            1845,214,1315,90,38,1354,30,31,2095,1009,
            323,2114,2134,225,40,1354,214,362,1627,2941,
            8709,609,1884,668,6353,670,669,570,8562,727,
            3845,1354,1333,108,1355,109,110,948,89,93,
            79,90,92,94,95,1224,620,621,624,143,
            219,77,78,80,217,111,112,113,114,962,
            120,121,122,132,1512,218,201,204,1358,212,
            220,232,233,286,297,330,356,628,627,274,
            1478,805,196,1362,1372,186,1488,785,176,1484,
            1485,169,1495,779,163,1490,1492,157,1505,778,
            151,316,4134,4138,1496,146,1501,240,248,264,
            315,321,967,2117,2118,32,39,3844,419,2577,
            4137,225,3837,1354,8384,71,4135,4136,8386,499,
            3016,2113,3460,1884,668,1347,670,669,569,1931,
            8654,1354,1333,108,1355,109,110,948,89,93,
            79,90,92,94,95,1224,620,621,624,143,
            219,77,78,80,217,111,112,113,114,962,
            120,121,122,132,1512,218,201,204,1358,212,
            220,232,233,286,297,330,356,628,627,275,
            1478,805,196,1362,1372,186,1488,785,176,1484,
            1485,169,1495,779,163,1490,1492,157,1505,778,
            151,316,139,141,1496,146,1501,240,248,264,
            315,321,632,3830,2117,2118,7266,225,1876,1354,
            72,225,4140,1354,69,71,540,7183,2366,2319,
            1354,1333,108,1355,109,110,948,89,93,79,
            90,92,94,95,1224,620,621,624,143,219,
            77,78,80,217,111,112,113,114,962,120,
            121,122,132,1512,218,201,204,1358,212,220,
            232,233,286,297,330,356,628,627,3513,1478,
            805,196,1362,1372,186,1488,785,176,1484,1485,
            169,1495,779,163,1490,1492,157,1505,778,151,
            316,2659,141,1496,146,1501,240,248,264,315,
            321,3002,72,2641,70,3006,2577,71,69,7017,
            3375,2985,225,40,1354,501,503,1627,225,6021,
            1354,3234,98,2364,2942,40,1354,353,5971,5274,
            3283,3283,5191,2577,84,86,3575,3526,214,2906,
            3183,3017,500,502,194,351,5191,2780,2584,225,
            40,1354,3050,306,1627,3294,8278,3016,3349,2708,
            1884,668,3277,670,669,2640,2747,2366,2319,1354,
            1333,108,1355,109,110,948,89,93,79,90,
            92,94,95,1224,620,621,624,143,219,77,
            78,80,217,111,112,113,114,962,120,121,
            122,132,1512,218,201,204,1358,212,220,232,
            233,286,297,330,356,628,627,438,1478,805,
            196,1362,1372,186,1488,785,176,1484,1485,169,
            1495,779,163,1490,1492,157,1505,778,151,316,
            2659,141,1496,146,1501,240,248,264,315,321,
            3719,2117,2118,463,439,3177,3094,2651,3309,307,
            2233,427,430,431,427,430,431,7816,2689,2686,
            2113,318,320,4643,3125,3201,521,3833,2572,4073,
            2640,643,3042,84,86,2347,2667,8780,3664,5440,
            302,2742,1468,1465,459,2246,1322,9021,435,435,
            6187,3403,2660,784,2695,619,3016,303,608,1884,
            668,2835,670,669,3102,2747,545,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,962,120,121,122,
            132,1512,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,289,1478,805,196,
            1362,1372,186,1488,785,176,1484,1485,169,1495,
            779,163,1490,1492,157,1505,778,151,316,287,
            141,1496,146,1501,240,248,264,315,321,9032,
            2117,2118,288,552,554,848,4121,563,548,3016,
            574,298,1884,668,559,670,669,3394,2808,2426,
            3846,1354,1333,108,1355,109,110,948,89,93,
            79,90,92,94,95,1224,620,621,624,143,
            219,77,78,80,217,111,112,113,114,962,
            120,121,122,132,1512,218,201,204,1358,212,
            220,232,233,286,297,330,356,628,627,4107,
            1478,805,196,1362,1372,186,1488,785,176,1484,
            1485,169,1495,779,163,1490,1492,157,1505,778,
            151,316,343,141,1496,146,1501,240,248,264,
            315,321,679,2117,2118,225,3836,1354,539,3519,
            72,3831,295,1850,2834,71,651,4143,787,2319,
            1354,1333,108,1355,109,110,948,89,93,79,
            90,92,94,95,1224,620,621,624,143,219,
            77,78,80,217,111,112,113,114,962,120,
            121,122,132,1512,218,201,204,1358,212,220,
            232,233,286,297,330,356,628,627,290,1478,
            805,196,1362,1372,186,1488,785,176,1484,1485,
            169,1495,779,163,1490,1492,157,1505,778,151,
            316,287,141,1496,146,1501,240,248,264,315,
            321,2783,224,117,288,190,40,1354,1884,55,
            1892,57,58,2756,40,1354,1884,55,1892,57,
            58,2756,40,1354,1884,55,1892,57,58,1,
            361,3321,4142,3219,3485,2685,2968,3052,3535,549,
            3647,3357,3195,3087,3196,3352,129,2580,596,3257,
            3360,551,3322,252,3643,260,3253,2053,441,3260,
            3276,3280,2611,2479,299,3248,52,2627,2940,362,
            3409,5523,3415,3418,3422,225,2586,1354,3383,547,
            3392,562,2700,684,3569,239,251,453,1331,225,
            228,285,342,672,460,677,2115,225,228,617,
            607,2421,305,249,3013,225,228,382,4132,247,
            1516,251,662,511,3291,294,2051,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,962,120,121,122,
            132,1512,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,64,1478,805,196,
            1362,1372,186,1488,785,176,1484,1485,169,1495,
            779,163,1490,1492,157,1505,778,151,316,686,
            141,1496,146,1501,240,248,264,315,321,240,
            2319,1354,1333,108,1355,109,110,948,89,93,
            79,90,92,94,95,1224,620,621,624,143,
            219,77,78,80,217,111,112,113,114,962,
            120,121,122,132,1512,218,201,204,1358,212,
            220,232,233,286,297,330,356,628,627,275,
            1478,805,196,1362,1372,186,1488,785,176,1484,
            1485,169,1495,779,163,1490,1492,157,1505,778,
            151,316,139,141,1496,146,1501,240,248,264,
            315,321,454,3302,2869,3426,3717,3715,6602,3718,
            456,326,328,3254,479,2115,3436,856,774,8603,
            565,1350,2792,234,3442,2855,1470,3389,3399,3288,
            2974,2924,3407,3156,3213,599,649,3167,3306,3325,
            3332,3338,3447,3448,2739,3023,3456,2872,3411,3413,
            3420,225,685,1354,473,687,8536,365,2319,1354,
            1333,108,1355,109,110,948,89,93,79,90,
            92,94,95,1224,620,621,624,143,219,77,
            78,80,217,111,112,113,114,962,120,121,
            122,132,1512,218,201,204,1358,212,220,232,
            233,286,297,330,356,628,627,275,1478,805,
            196,1362,1372,186,1488,785,176,1484,1485,169,
            1495,779,163,1490,1492,157,1505,778,151,316,
            139,141,1496,146,1501,240,248,264,315,321,
            2119,225,685,1354,3717,3847,425,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,962,120,121,122,
            132,1512,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,275,1478,805,196,
            1362,1372,186,1488,785,176,1484,1485,169,1495,
            779,163,1490,1492,157,1505,778,151,316,139,
            141,1496,146,1501,240,248,264,315,321,226,
            3829,3266,2934,3717,3848,485,2319,1354,1333,108,
            1355,109,110,948,89,93,79,90,92,94,
            95,1224,620,621,624,143,219,77,78,80,
            217,111,112,113,114,962,120,121,122,132,
            1512,218,201,204,1358,212,220,232,233,286,
            297,330,356,628,627,275,1478,805,196,1362,
            1372,186,1488,785,176,1484,1485,169,1495,779,
            163,1490,1492,157,1505,778,151,316,139,141,
            1496,146,1501,240,248,264,315,321,225,685,
            1354,2106,3717,3990,607,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620,621,624,143,219,77,78,80,217,
            111,112,113,114,962,120,121,122,132,1512,
            218,201,204,1358,212,220,232,233,286,297,
            330,356,628,627,275,1478,805,196,1362,1372,
            186,1488,785,176,1484,1485,169,1495,779,163,
            1490,1492,157,1505,778,151,316,139,141,1496,
            146,1501,240,248,264,315,321,1369,225,685,
            1354,3717,4108,130,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,962,120,121,122,132,1512,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,314,1478,805,196,1362,1372,186,
            1488,785,176,1484,1485,169,1495,779,163,1490,
            1492,157,1505,778,151,316,4125,141,1496,146,
            1501,240,248,264,315,321,3424,4115,476,3348,
            2528,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1321,120,121,122,132,2121,218,201,204,1358,
            212,220,232,233,286,297,330,356,628,627,
            3429,1478,805,196,1362,1372,186,1488,785,176,
            1484,1485,169,1495,779,163,159,2122,158,1335,
            313,667,2319,1354,1333,108,1355,109,110,948,
            89,93,79,90,92,94,95,1224,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,962,120,121,122,132,1512,218,201,204,
            1358,212,220,232,233,286,297,330,356,628,
            627,275,1478,805,196,1362,1372,186,1488,785,
            176,1484,1485,169,1495,779,163,1490,1492,157,
            1505,778,151,316,139,141,1496,146,1501,240,
            248,264,315,321,225,685,1354,658,3717,4129,
            849,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            962,120,121,122,132,1512,218,201,204,1358,
            212,220,232,233,286,297,330,356,628,627,
            275,1478,805,196,1362,1372,186,1488,785,176,
            1484,1485,169,1495,779,163,1490,1492,157,1505,
            778,151,316,139,141,1496,146,1501,240,248,
            264,315,321,486,225,685,1354,3717,5606,909,
            2319,1354,1333,108,1355,109,110,948,89,93,
            79,90,92,94,95,1224,620,621,624,143,
            219,77,78,80,217,111,112,113,114,962,
            120,121,122,132,1512,218,201,204,1358,212,
            220,232,233,286,297,330,356,628,627,275,
            1478,805,196,1362,1372,186,1488,785,176,1484,
            1485,169,1495,779,163,1490,1492,157,1505,778,
            151,316,139,141,1496,146,1501,240,248,264,
            315,321,2808,3526,2808,3244,3717,5772,969,2319,
            1354,1333,108,1355,109,110,948,89,93,79,
            90,92,94,95,1224,620,621,624,143,219,
            77,78,80,217,111,112,113,114,962,120,
            121,122,132,1512,218,201,204,1358,212,220,
            232,233,286,297,330,356,628,627,275,1478,
            805,196,1362,1372,186,1488,785,176,1484,1485,
            169,1495,779,163,1490,1492,157,1505,778,151,
            316,139,141,1496,146,1501,240,248,264,315,
            321,1628,533,3169,527,3717,5938,1029,2319,1354,
            1333,108,1355,109,110,948,89,93,79,90,
            92,94,95,1224,620,621,624,143,219,77,
            78,80,217,111,112,113,114,962,120,121,
            122,132,1512,218,201,204,1358,212,220,232,
            233,286,297,330,356,628,627,275,1478,805,
            196,1362,1372,186,1488,785,176,1484,1485,169,
            1495,779,163,1490,1492,157,1505,778,151,316,
            139,141,1496,146,1501,240,248,264,315,321,
            2808,2808,3434,3507,3717,6104,1089,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,962,120,121,122,
            132,1512,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,310,1478,805,196,
            1362,1372,186,1488,785,176,1484,1485,169,1495,
            779,163,1490,1492,157,1505,778,151,316,4125,
            141,1496,146,1501,240,248,264,315,321,329,
            4942,546,3348,2528,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1321,120,121,122,132,3705,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,3440,1478,805,196,1362,1372,186,
            1488,785,176,1484,1485,169,165,3706,164,2808,
            2808,838,2865,309,1151,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620,621,624,143,219,77,78,80,217,
            111,112,113,114,962,120,121,122,132,1512,
            218,201,204,1358,212,220,232,233,286,297,
            330,356,628,627,275,1478,805,196,1362,1372,
            186,1488,785,176,1484,1485,169,1495,779,163,
            1490,1492,157,1505,778,151,316,139,141,1496,
            146,1501,240,248,264,315,321,3343,2808,412,
            408,3717,7876,1211,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,962,120,121,122,132,1512,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,275,1478,805,196,1362,1372,186,
            1488,785,176,1484,1485,169,1495,779,163,1490,
            1492,157,1505,778,151,316,139,141,1496,146,
            1501,240,248,264,315,321,99,2808,379,133,
            3717,7936,1271,2319,1354,1333,108,1355,109,110,
            948,89,93,79,90,92,94,95,1224,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,962,120,121,122,132,1512,218,201,
            204,1358,212,220,232,233,286,297,330,356,
            628,627,275,1478,805,196,1362,1372,186,1488,
            785,176,1484,1485,169,1495,779,163,1490,1492,
            157,1505,778,151,316,139,141,1496,146,1501,
            240,248,264,315,321,2600,2600,468,4110,3717,
            7996,1331,2319,1354,1333,108,1355,109,110,948,
            89,93,79,90,92,94,95,1224,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,962,120,121,122,132,1512,218,201,204,
            1358,212,220,232,233,286,297,330,356,628,
            627,291,1478,805,196,1362,1372,186,1488,785,
            176,1484,1485,169,1495,779,163,1490,1492,157,
            1505,778,151,316,2105,141,1496,146,1501,240,
            248,264,315,321,2426,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620,621,624,143,219,77,78,80,217,
            111,112,113,114,962,120,121,122,132,1512,
            218,201,204,1358,212,220,232,233,286,297,
            330,356,628,627,3195,1478,805,196,1362,1372,
            186,1488,785,176,1484,1485,169,1495,779,163,
            1490,1492,157,1505,778,151,316,2659,141,1496,
            146,1501,240,248,264,315,321,3180,1864,507,
            3328,2682,2715,2971,2989,3040,3449,2907,2258,3466,
            3469,3472,3474,3477,616,3479,3438,960,3465,3444,
            225,1876,1354,3438,225,4140,1354,3468,3438,296,
            85,86,2282,2319,1354,1333,108,1355,109,110,
            948,89,93,79,90,92,94,95,1224,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,962,120,121,122,132,1512,218,201,
            204,1358,212,220,232,233,286,297,330,356,
            628,627,3379,1478,805,196,1362,1372,186,1488,
            785,176,1484,1485,169,1495,779,163,1490,1492,
            157,1505,778,151,316,372,141,1496,146,1501,
            240,248,264,315,321,72,1846,70,530,4111,
            71,69,348,254,3480,1262,3481,3486,253,3488,
            3489,91,385,3482,3490,7432,3492,3494,225,3836,
            1354,3495,1395,3496,3550,2658,2860,3497,3499,3502,
            374,244,1871,2319,1354,1333,108,1355,109,110,
            948,89,93,79,90,92,94,95,1224,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,962,120,121,122,132,1512,218,201,
            204,1358,212,220,232,233,286,297,330,356,
            628,627,275,1478,805,196,1362,1372,186,1488,
            785,176,1484,1485,169,1495,779,163,1490,1492,
            157,1505,778,151,316,139,141,1496,146,1501,
            240,248,264,315,321,6851,5689,2106,2106,7100,
            2111,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            962,120,121,122,132,1512,218,201,204,1358,
            212,220,232,233,286,297,330,356,628,627,
            3505,1478,805,196,1362,1372,186,1488,785,176,
            1484,1485,169,1495,779,163,1490,1492,157,1505,
            778,151,316,242,141,1496,146,1501,240,248,
            264,315,321,2477,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,962,120,121,122,132,1512,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,3121,1478,805,196,1362,1372,186,
            1488,785,176,1484,1485,169,1495,779,163,1490,
            1492,157,1505,778,151,316,2137,141,1496,146,
            1501,240,248,2140,315,321,3508,2607,3510,3511,
            3515,3517,3368,3370,3521,3524,3527,1502,1515,3528,
            3532,3534,3536,440,3318,3538,3539,3540,3542,3549,
            3547,241,3554,3235,3559,3560,3143,1622,1635,3562,
            3561,3361,3567,3564,2138,1391,2319,1354,1333,108,
            1355,109,110,948,89,93,79,90,92,94,
            95,1224,620,621,624,143,219,77,78,80,
            217,111,112,113,114,962,120,121,122,132,
            1512,218,201,204,1358,212,220,232,233,286,
            297,330,356,628,627,268,1478,805,196,1362,
            1372,186,1488,785,176,1484,1485,169,1495,779,
            163,1490,1492,157,1505,778,151,316,267,141,
            1496,146,1501,240,248,264,315,321,1451,2319,
            1354,1333,108,1355,109,110,948,89,93,79,
            90,92,94,95,1224,620,621,624,143,219,
            77,78,80,217,111,112,113,114,962,120,
            121,122,132,1512,218,201,204,1358,212,220,
            232,233,286,297,330,356,628,627,266,1478,
            805,196,1362,1372,186,1488,785,176,1484,1485,
            169,1495,779,163,1490,1492,157,1505,778,151,
            316,265,141,1496,146,1501,240,248,264,315,
            321,1511,2319,1354,1333,108,1355,109,110,948,
            89,93,79,90,92,94,95,1224,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,962,120,121,122,132,1512,218,201,204,
            1358,212,220,232,233,286,297,330,356,628,
            627,634,1478,805,196,1362,1372,186,1488,785,
            176,1484,1485,169,1495,779,163,1490,1492,157,
            1505,778,151,316,633,141,1496,146,1501,240,
            248,264,315,321,1571,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620,621,624,143,219,77,78,80,217,
            111,112,113,114,962,120,121,122,132,1512,
            218,201,204,1358,212,220,232,233,286,297,
            330,356,628,627,383,1478,805,196,1362,1372,
            186,1488,785,176,1484,1485,169,1495,779,163,
            1490,1492,157,1505,778,151,316,4106,141,1496,
            146,1501,240,248,264,315,321,1631,2319,1354,
            1333,108,1355,109,110,948,89,93,79,90,
            92,94,95,1224,620,621,624,143,219,77,
            78,80,217,111,112,113,114,962,120,121,
            122,132,1512,218,201,204,1358,212,220,232,
            233,286,297,330,356,628,627,258,1478,805,
            196,1362,1372,186,1488,785,176,1484,1485,169,
            1495,779,163,1490,1492,157,1505,778,151,316,
            257,141,1496,146,1501,240,248,264,315,321,
            1691,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            962,120,121,122,132,1512,218,201,204,1358,
            212,220,232,233,286,297,330,356,628,627,
            276,1478,805,196,1362,1372,186,1488,785,176,
            1484,1485,169,1495,779,163,1490,1492,157,1505,
            778,151,316,140,141,1496,146,1501,240,248,
            264,315,321,1751,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,962,120,121,122,132,1512,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,256,1478,805,196,1362,1372,186,
            1488,785,176,1484,1485,169,1495,779,163,1490,
            1492,157,1505,778,151,316,255,141,1496,146,
            1501,240,248,264,315,321,1811,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,962,120,121,122,
            132,1512,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,594,1478,805,196,
            1362,1372,186,1488,785,176,1484,1485,169,1495,
            779,163,1490,1492,157,1505,778,151,316,593,
            141,1496,146,1501,240,248,264,315,321,1991,
            2319,1354,1333,108,1355,109,110,948,89,93,
            79,90,92,94,95,1224,620,621,624,143,
            219,77,78,80,217,111,112,113,114,962,
            120,121,122,132,1512,218,201,204,1358,212,
            220,232,233,286,297,330,356,628,627,283,
            1478,805,196,1362,1372,186,1488,785,176,1484,
            1485,169,1495,779,163,1490,1492,157,1505,778,
            151,316,282,141,1496,146,1501,240,248,264,
            315,321,2426,2319,1354,1333,108,1355,109,110,
            948,89,93,79,90,92,94,95,1224,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,962,120,121,122,132,1512,218,201,
            204,1358,212,220,232,233,286,297,330,356,
            628,627,3570,1478,805,196,1362,1372,186,1488,
            785,176,1484,1485,169,1495,779,163,1490,1492,
            157,1505,778,151,316,1877,141,1496,146,1501,
            240,248,264,315,321,2426,2319,1354,1333,108,
            1355,109,110,948,89,93,79,90,92,94,
            95,1224,620,621,624,143,219,77,78,80,
            217,111,112,113,114,962,120,121,122,132,
            1512,218,201,204,1358,212,220,232,233,286,
            297,330,356,628,627,1742,1478,805,196,1362,
            1372,186,1488,785,176,1484,1485,169,1495,779,
            163,1490,1492,157,1505,778,151,316,3827,141,
            1496,146,1501,240,248,264,315,321,2426,2319,
            1354,1333,108,1355,109,110,948,89,93,79,
            90,92,94,95,1224,620,621,624,143,219,
            77,78,80,217,111,112,113,114,962,120,
            121,122,132,1512,218,201,204,1358,212,220,
            232,233,286,297,330,356,628,627,3363,1478,
            805,196,1362,1372,186,1488,785,176,1484,1485,
            169,1495,779,163,1490,1492,157,1505,778,151,
            316,222,141,1496,146,1501,240,248,264,315,
            321,2426,2319,1354,1333,108,1355,109,110,948,
            89,93,79,90,92,94,95,1224,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,962,120,121,122,132,1512,218,201,204,
            1358,212,220,232,233,286,297,330,356,628,
            627,3572,1478,805,196,1362,1372,186,1488,785,
            176,1484,1485,169,1495,779,163,1490,1492,157,
            1505,778,151,316,67,141,1496,146,1501,240,
            248,264,315,321,2426,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620,621,624,143,219,77,78,80,217,
            111,112,113,114,962,120,121,122,132,1512,
            218,201,204,1358,212,220,232,233,286,297,
            330,356,628,627,3387,1478,805,196,1362,1372,
            186,1488,785,176,1484,1485,169,1495,779,163,
            1490,1492,157,1505,778,151,316,4114,141,1496,
            146,1501,240,248,264,315,321,2426,2319,1354,
            1333,108,1355,109,110,948,89,93,79,90,
            92,94,95,1224,620,621,624,143,219,77,
            78,80,217,111,112,113,114,962,120,121,
            122,132,1512,218,201,204,1358,212,220,232,
            233,286,297,330,356,628,627,3573,1478,805,
            196,1362,1372,186,1488,785,176,1484,1485,169,
            1495,779,163,1490,1492,157,1505,778,151,316,
            3100,141,1496,146,1501,240,248,264,315,321,
            2426,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            962,120,121,122,132,1512,218,201,204,1358,
            212,220,232,233,286,297,330,356,628,627,
            3576,1478,805,196,1362,1372,186,1488,785,176,
            1484,1485,169,1495,779,163,1490,1492,157,1505,
            778,151,316,4119,141,1496,146,1501,240,248,
            264,315,321,2426,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,962,120,121,122,132,1512,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,3574,1478,805,196,1362,1372,186,
            1488,785,176,1484,1485,169,1495,779,163,1490,
            1492,157,1505,778,151,316,366,141,1496,146,
            1501,240,248,264,315,321,2426,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,962,120,121,122,
            132,1512,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,3581,1478,805,196,
            1362,1372,186,1488,785,176,1484,1485,169,1495,
            779,163,1490,1492,157,1505,778,151,316,4126,
            141,1496,146,1501,240,248,264,315,321,2426,
            2319,1354,1333,108,1355,109,110,948,89,93,
            79,90,92,94,95,1224,620,621,624,143,
            219,77,78,80,217,111,112,113,114,962,
            120,121,122,132,1512,218,201,204,1358,212,
            220,232,233,286,297,330,356,628,627,3582,
            1478,805,196,1362,1372,186,1488,785,176,1484,
            1485,169,1495,779,163,1490,1492,157,1505,778,
            151,316,4127,141,1496,146,1501,240,248,264,
            315,321,2426,2319,1354,1333,108,1355,109,110,
            948,89,93,79,90,92,94,95,1224,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,962,120,121,122,132,1512,218,201,
            204,1358,212,220,232,233,286,297,330,356,
            628,627,3584,1478,805,196,1362,1372,186,1488,
            785,176,1484,1485,169,1495,779,163,1490,1492,
            157,1505,778,151,316,4128,141,1496,146,1501,
            240,248,264,315,321,2426,2319,1354,1333,108,
            1355,109,110,948,89,93,79,90,92,94,
            95,1224,620,621,624,143,219,77,78,80,
            217,111,112,113,114,962,120,121,122,132,
            1512,218,201,204,1358,212,220,232,233,286,
            297,330,356,628,627,3591,1478,805,196,1362,
            1372,186,1488,785,176,1484,1485,169,1495,779,
            163,1490,1492,157,1505,778,151,316,88,141,
            1496,146,1501,240,248,264,315,321,2426,2319,
            1354,1333,108,1355,109,110,948,89,93,79,
            90,92,94,95,1224,620,621,624,143,219,
            77,78,80,217,111,112,113,114,962,120,
            121,122,132,1512,218,201,204,1358,212,220,
            232,233,286,297,330,356,628,627,3593,1478,
            805,196,1362,1372,186,1488,785,176,1484,1485,
            169,1495,779,163,1490,1492,157,1505,778,151,
            316,234,141,1496,146,1501,240,248,264,315,
            321,2426,2319,1354,1333,108,1355,109,110,948,
            89,93,79,90,92,94,95,1224,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,962,120,121,122,132,1512,218,201,204,
            1358,212,220,232,233,286,297,330,356,628,
            627,3598,1478,805,196,1362,1372,186,1488,785,
            176,1484,1485,169,1495,779,163,1490,1492,157,
            1505,778,151,316,4130,141,1496,146,1501,240,
            248,264,315,321,2426,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620,621,624,143,219,77,78,80,217,
            111,112,113,114,962,120,121,122,132,1512,
            218,201,204,1358,212,220,232,233,286,297,
            330,356,628,627,3600,1478,805,196,1362,1372,
            186,1488,785,176,1484,1485,169,1495,779,163,
            1490,1492,157,1505,778,151,316,542,141,1496,
            146,1501,240,248,264,315,321,2426,2319,1354,
            1333,108,1355,109,110,948,89,93,79,90,
            92,94,95,1224,620,621,624,143,219,77,
            78,80,217,111,112,113,114,962,120,121,
            122,132,1512,218,201,204,1358,212,220,232,
            233,286,297,330,356,628,627,3601,1478,805,
            196,1362,1372,186,1488,785,176,1484,1485,169,
            1495,779,163,1490,1492,157,1505,778,151,316,
            68,141,1496,146,1501,240,248,264,315,321,
            2426,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            962,120,121,122,132,1512,218,201,204,1358,
            212,220,232,233,286,297,330,356,628,627,
            3603,1478,805,196,1362,1372,186,1488,785,176,
            1484,1485,169,1495,779,163,1490,1492,157,1505,
            778,151,316,3782,141,1496,146,1501,240,248,
            264,315,321,2426,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,962,120,121,122,132,1512,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,3366,1478,805,196,1362,1372,186,
            1488,785,176,1484,1485,169,1495,779,163,1490,
            1492,157,1505,778,151,316,317,141,1496,146,
            1501,240,248,264,315,321,2426,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,962,120,121,122,
            132,1512,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,3608,1478,805,196,
            1362,1372,186,1488,785,176,1484,1485,169,1495,
            779,163,1490,1492,157,1505,778,151,316,6436,
            141,1496,146,1501,240,248,264,315,321,2426,
            2319,1354,1333,108,1355,109,110,948,89,93,
            79,90,92,94,95,1224,620,621,624,143,
            219,77,78,80,217,111,112,113,114,962,
            120,121,122,132,1512,218,201,204,1358,212,
            220,232,233,286,297,330,356,628,627,3609,
            1478,805,196,1362,1372,186,1488,785,176,1484,
            1485,169,1495,779,163,1490,1492,157,1505,778,
            151,316,365,141,1496,146,1501,240,248,264,
            315,321,2426,2319,1354,1333,108,1355,109,110,
            948,89,93,79,90,92,94,95,1224,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,962,120,121,122,132,1512,218,201,
            204,1358,212,220,232,233,286,297,330,356,
            628,627,3610,1478,805,196,1362,1372,186,1488,
            785,176,1484,1485,169,1495,779,163,1490,1492,
            157,1505,778,151,316,364,141,1496,146,1501,
            240,248,264,315,321,2426,2319,1354,1333,108,
            1355,109,110,948,89,93,79,90,92,94,
            95,1224,620,621,624,143,219,77,78,80,
            217,111,112,113,114,962,120,121,122,132,
            1512,218,201,204,1358,212,220,232,233,286,
            297,330,356,628,627,3611,1478,805,196,1362,
            1372,186,1488,785,176,1484,1485,169,1495,779,
            163,1490,1492,157,1505,778,151,316,6685,141,
            1496,146,1501,240,248,264,315,321,2426,2319,
            1354,1333,108,1355,109,110,948,89,93,79,
            90,92,94,95,1224,620,621,624,143,219,
            77,78,80,217,111,112,113,114,962,120,
            121,122,132,1512,218,201,204,1358,212,220,
            232,233,286,297,330,356,628,627,3613,1478,
            805,196,1362,1372,186,1488,785,176,1484,1485,
            169,1495,779,163,1490,1492,157,1505,778,151,
            316,301,141,1496,146,1501,240,248,264,315,
            321,2426,2319,1354,1333,108,1355,109,110,948,
            89,93,79,90,92,94,95,1224,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,962,120,121,122,132,1512,218,201,204,
            1358,212,220,232,233,286,297,330,356,628,
            627,3612,1478,805,196,1362,1372,186,1488,785,
            176,1484,1485,169,1495,779,163,1490,1492,157,
            1505,778,151,316,6768,141,1496,146,1501,240,
            248,264,315,321,2426,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620,621,624,143,219,77,78,80,217,
            111,112,113,114,962,120,121,122,132,1512,
            218,201,204,1358,212,220,232,233,286,297,
            330,356,628,627,3618,1478,805,196,1362,1372,
            186,1488,785,176,1484,1485,169,1495,779,163,
            1490,1492,157,1505,778,151,316,6934,141,1496,
            146,1501,240,248,264,315,321,2426,2319,1354,
            1333,108,1355,109,110,948,89,93,79,90,
            92,94,95,1224,620,621,624,143,219,77,
            78,80,217,111,112,113,114,962,120,121,
            122,132,1512,218,201,204,1358,212,220,232,
            233,286,297,330,356,628,627,3619,1478,805,
            196,1362,1372,186,1488,785,176,1484,1485,169,
            1495,779,163,1490,1492,157,1505,778,151,316,
            344,141,1496,146,1501,240,248,264,315,321,
            2426,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            962,120,121,122,132,1512,218,201,204,1358,
            212,220,232,233,286,297,330,356,628,627,
            3398,1478,805,196,1362,1372,186,1488,785,176,
            1484,1485,169,1495,779,163,1490,1492,157,1505,
            778,151,316,7598,141,1496,146,1501,240,248,
            264,315,321,2426,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,962,120,121,122,132,1512,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,3621,1478,805,196,1362,1372,186,
            1488,785,176,1484,1485,169,1495,779,163,1490,
            1492,157,1505,778,151,316,8110,141,1496,146,
            1501,240,248,264,315,321,2426,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,962,120,121,122,
            132,1512,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,3401,1478,805,196,
            1362,1372,186,1488,785,176,1484,1485,169,1495,
            779,163,1490,1492,157,1505,778,151,316,8167,
            141,1496,146,1501,240,248,264,315,321,2426,
            2319,1354,1333,108,1355,109,110,948,89,93,
            79,90,92,94,95,1224,620,621,624,143,
            219,77,78,80,217,111,112,113,114,962,
            120,121,122,132,1512,218,201,204,1358,212,
            220,232,233,286,297,330,356,628,627,3620,
            1478,805,196,1362,1372,186,1488,785,176,1484,
            1485,169,1495,779,163,1490,1492,157,1505,778,
            151,316,8224,141,1496,146,1501,240,248,264,
            315,321,2426,2319,1354,1333,108,1355,109,110,
            948,89,93,79,90,92,94,95,1224,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,962,120,121,122,132,1512,218,201,
            204,1358,212,220,232,233,286,297,330,356,
            628,627,3623,1478,805,196,1362,1372,186,1488,
            785,176,1484,1485,169,1495,779,163,1490,1492,
            157,1505,778,151,316,346,141,1496,146,1501,
            240,248,264,315,321,2426,2319,1354,1333,108,
            1355,109,110,948,89,93,79,90,92,94,
            95,1224,620,621,624,143,219,77,78,80,
            217,111,112,113,114,962,120,121,122,132,
            1512,218,201,204,1358,212,220,232,233,286,
            297,330,356,628,627,3372,1478,805,196,1362,
            1372,186,1488,785,176,1484,1485,169,1495,779,
            163,1490,1492,157,1505,778,151,316,345,141,
            1496,146,1501,240,248,264,315,321,2426,2319,
            1354,1333,108,1355,109,110,948,89,93,79,
            90,92,94,95,1224,620,621,624,143,219,
            77,78,80,217,111,112,113,114,962,120,
            121,122,132,1512,218,201,204,1358,212,220,
            232,233,286,297,330,356,628,627,3625,1478,
            805,196,1362,1372,186,1488,785,176,1484,1485,
            169,1495,779,163,1490,1492,157,1505,778,151,
            316,482,141,1496,146,1501,240,248,264,315,
            321,2528,2319,1354,1333,108,1355,109,110,948,
            89,93,79,90,92,94,95,1224,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1321,120,121,122,132,3707,218,201,204,
            1358,212,220,232,233,286,297,330,356,628,
            627,3607,1478,805,196,1362,1372,186,1488,785,
            176,1484,1485,169,1495,779,163,1490,1492,157,
            153,3708,152,2528,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1321,120,121,122,132,2123,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,325,1478,805,196,1362,1372,186,
            1488,785,176,171,2124,170,2528,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1321,120,121,122,
            132,3701,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,3626,1478,805,196,
            1362,1372,186,179,3702,636,2528,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1321,120,121,122,
            132,3701,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,3628,1478,805,196,
            1362,1372,186,179,3703,178,2528,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1321,120,121,122,
            132,3701,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,3629,1478,805,196,
            1362,1372,186,179,3704,177,2528,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1321,120,121,122,
            132,2127,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,3635,1478,805,196,
            191,2128,190,2528,2319,1354,1333,108,1355,109,
            110,948,89,93,79,90,92,94,95,1224,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1321,120,121,122,132,2127,218,
            201,204,1358,212,220,232,233,286,297,330,
            356,628,627,3637,1478,805,196,191,2129,189,
            2528,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1321,120,121,122,132,2127,218,201,204,1358,
            212,220,232,233,286,297,330,356,628,627,
            3638,1478,805,196,191,2130,188,2528,2319,1354,
            1333,108,1355,109,110,948,89,93,79,90,
            92,94,95,1224,620,621,624,143,219,77,
            78,80,217,111,112,113,114,1321,120,121,
            122,132,2127,218,201,204,1358,212,220,232,
            233,286,297,330,356,628,627,3640,1478,805,
            196,191,2131,187,2528,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620
        };
    };

    public interface BaseAction1 {
        public final static char baseAction1[] = {
            621,624,143,219,77,78,80,217,111,112,
            113,114,1321,120,121,122,132,3262,218,201,
            204,1358,212,220,232,233,286,297,330,356,
            628,627,3641,199,3697,198,2528,2319,1354,1333,
            108,1355,109,110,948,89,93,79,90,92,
            94,95,1224,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1321,120,121,122,
            132,3262,218,201,204,1358,212,220,232,233,
            286,297,330,356,628,627,3646,199,3700,197,
            2528,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1321,120,121,122,132,2112,218,207,214,1358,
            212,220,232,233,286,297,330,356,628,627,
            2528,2319,1354,1333,108,1355,109,110,948,89,
            93,79,90,92,94,95,1224,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1321,120,121,122,132,2112,218,207,213,1358,
            212,220,232,233,286,297,330,356,628,627,
            3190,3271,3068,211,3346,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            440,487,680,210,2528,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1321,120,121,122,132,2112,
            218,207,206,1358,212,220,232,233,286,297,
            330,356,628,627,2528,2319,1354,1333,108,1355,
            109,110,948,89,93,79,90,92,94,95,
            1224,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1321,120,121,122,132,2112,
            218,207,205,1358,212,220,232,233,286,297,
            330,356,628,627,2809,9286,9286,203,61,40,
            1354,1884,55,1892,57,58,9286,9286,9286,9286,
            2756,40,1354,1884,55,1892,57,58,9286,9286,
            3191,3041,2756,40,1354,1884,55,1892,57,58,
            2831,40,1354,1884,55,1892,57,58,9286,3243,
            9286,9286,3438,9286,404,9286,9286,202,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,3069,685,1354,9286,9286,9286,9286,9286,9286,
            375,451,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,1911,225,228,9286,2807,40,1354,1884,55,
            1892,57,58,471,225,228,1514,2756,40,1354,
            1884,55,1892,57,58,3841,225,228,579,3444,
            371,490,3103,1911,225,228,397,398,399,400,
            401,402,804,4122,467,516,517,518,9033,8942,
            528,529,8810,534,535,2925,543,544,1521,1357,
            660,480,1871,444,445,446,447,448,449,1311,
            8053,467,516,517,518,9033,8942,528,529,8810,
            534,535,2925,543,544,1521,1357,3058,1911,225,
            228,2756,40,1354,1884,55,1892,57,58,9286,
            1911,225,228,225,685,1354,9286,9286,9286,9286,
            442,9286,3507,1869,9286,578,2756,40,1354,1884,
            55,1892,57,58,2106,9286,9286,659,1844,9286,
            477,1858,9286,9286,9286,392,387,451,394,395,
            396,405,406,1870,409,410,1866,217,685,1354,
            2756,40,1354,1884,55,1892,57,58,2756,40,
            1354,1884,55,1892,57,58,2756,40,1354,1884,
            55,1892,57,58,3842,225,228,9286,9286,2094,
            2756,40,1354,1884,55,1892,57,58,3207,4122,
            3507,9286,681,9039,1878,640,9286,683,457,3843,
            225,228,9286,519,9286,9286,9286,9013,9286,444,
            445,446,447,448,449,1311,9286,467,516,517,
            518,9033,8942,528,529,8810,534,535,2925,543,
            544,1521,1357,4120,225,228,682,489,532,9286,
            2939,1848,225,228,9286,225,4140,1354,9286,4124,
            225,228,9286,2274,2586,1354,442,225,1876,1354,
            9286,9286,9286,66,225,228,2756,40,1354,1884,
            55,1892,57,58,2922,9286,284,9286,2815,583,
            2756,40,1354,1884,55,1892,57,58,2756,40,
            1354,1884,55,1892,57,58,2756,40,1354,1884,
            55,1892,57,58,2756,40,1354,1884,55,1892,
            57,58,2756,40,1354,1884,55,1892,57,58,
            2340,2816,9286,1884,668,2340,670,669,1884,668,
            3507,670,669,2234,685,1354,72,2942,40,1354,
            2250,71,5274,347,63,5191,426,430,431,1873,
            225,228,9286,9286,223,225,1876,1354,631,217,
            685,1354,2603,5108,225,228,225,4140,1354,3507,
            520,5357,225,228,2576,618,225,685,1354,7349,
            225,228,3138,389,426,430,431,472,225,228,
            658,3157,2337,9286,360,3525,225,228,9286,225,
            40,1354,9286,4141,1627,1368,225,685,1354,421,
            2337,2632,658,8651,2117,2118,269,3287,1859,2117,
            2118,9286,681,480,656,9286,9286,3287,3287,3287,
            9286,9286,684,9286,9286,9286,9286,1843,2322,2588,
            9286,684,537,1365,252,1872,9286,9286,681,8572,
            270,662,70,9286,9286,269,69,72,9286,4139,
            550,525,71,9004,347,681,463,585,3265,9286,
            97,8572,9286,662,413,415,417,567,572,576,
            1843,425,9286,8572,9286,662,657,9286,9286,271,
            418,536,476,1858,4118,485,2120,2924,9286,9286,
            9286,9286,9286,584,438,9286,9286,458,657,1844,
            9286,9286,9286,566,571,575,420,9286,478,9286,
            655,3825,9286,9286,7515,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,1875,9286,3834,
            9286,9286,2321,5025,9286,4117,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,390,9286,475,9286,
            9286,9286,9286,9286,9286,9286,8382,9286,9286,6519,
            9286,9090,9286,9286,9286,9286,9286,9286,9286,9286,
            1854,9286,9286,9286,1849,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,422,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,8900,
            9286,9286,424,3824,8862,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,8383,9286,0
        };
    };

    public final static char baseAction[] = new char[BaseAction0.baseAction0.length + BaseAction1.baseAction1.length];
    {
        int index = 0;
        System.arraycopy(BaseAction0.baseAction0, 0, baseAction, index, BaseAction0.baseAction0.length);
        index += BaseAction0.baseAction0.length;
        System.arraycopy(BaseAction1.baseAction1, 0, baseAction, index, BaseAction1.baseAction1.length);
    };
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static char termCheck[] = {0,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,0,0,3,64,5,6,7,0,0,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,3,88,0,
            0,87,3,24,5,6,7,37,0,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,62,63,115,0,1,2,3,
            52,53,54,55,56,57,58,59,0,0,
            1,2,3,133,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            119,52,53,54,55,56,57,58,59,0,
            61,2,3,0,5,6,7,0,1,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,25,26,0,24,2,3,
            92,5,6,7,0,0,1,3,138,5,
            6,7,0,0,2,3,4,24,109,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            65,52,53,54,55,56,57,58,59,0,
            1,2,3,70,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            0,52,53,54,55,56,57,58,59,0,
            1,2,3,64,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,65,52,53,54,55,
            56,57,58,59,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,0,52,53,54,55,
            56,57,58,59,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,60,52,53,54,55,
            56,57,58,59,0,1,2,3,0,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,0,52,53,54,55,
            56,57,58,59,0,61,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,0,52,53,
            54,55,56,57,58,59,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,60,52,53,
            54,55,56,57,58,59,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,0,52,53,
            54,55,56,57,58,59,0,1,2,3,
            0,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,0,52,53,
            54,55,56,57,58,59,0,61,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,62,
            52,53,54,55,56,57,58,59,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,0,
            52,53,54,55,56,57,58,59,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,60,
            52,53,54,55,56,57,58,59,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,0,
            52,53,54,55,56,57,58,59,0,1,
            2,3,0,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,0,
            52,53,54,55,56,57,58,59,0,61,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,62,52,53,54,55,56,57,58,59,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,60,52,53,54,55,56,57,58,59,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,107,52,53,54,55,56,57,58,59,
            0,1,2,3,60,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,60,52,53,54,55,56,57,58,59,
            0,1,2,3,60,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,60,52,53,54,55,56,57,58,59,
            0,1,2,3,60,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,60,52,53,54,55,56,57,58,59,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,0,3,2,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,1,0,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,109,52,53,54,55,56,57,58,59,
            0,1,0,3,2,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,0,1,52,53,54,55,56,57,
            58,59,0,0,64,2,3,123,5,6,
            7,0,0,1,3,0,5,6,7,0,
            0,2,3,4,5,6,7,0,88,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,25,26,3,0,5,6,
            7,0,1,61,3,115,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,87,0,85,102,0,1,2,0,
            0,2,3,0,87,64,0,98,99,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,1,0,1,135,3,88,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,73,74,75,76,
            0,81,83,0,61,0,1,81,3,64,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,1,0,3,
            2,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,0,1,51,
            3,111,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,0,45,46,47,0,0,2,3,0,
            5,6,7,0,8,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            25,26,0,27,2,3,0,5,6,7,
            0,0,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,0,25,26,0,
            4,0,3,2,5,6,7,8,9,0,
            0,1,2,0,73,74,75,76,0,66,
            0,8,2,70,71,72,8,0,1,0,
            85,78,33,34,35,36,0,8,9,70,
            60,92,24,98,99,27,28,29,30,31,
            32,0,51,100,0,0,2,85,0,8,
            9,62,61,62,0,85,8,68,69,0,
            98,99,73,74,75,76,77,0,51,24,
            81,61,69,84,0,136,87,60,112,113,
            63,62,65,84,67,66,97,68,69,70,
            71,72,73,74,75,76,77,78,0,80,
            81,0,4,84,60,51,87,66,64,68,
            69,70,71,72,114,0,97,69,3,100,
            5,6,7,97,65,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            25,26,0,0,2,3,79,73,74,75,
            76,0,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,0,0,0,3,
            2,5,6,7,0,0,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,25,26,3,0,5,6,7,97,0,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,66,51,0,
            1,70,71,72,0,83,0,85,0,86,
            2,0,89,90,91,4,93,94,95,64,
            98,99,103,0,101,51,3,0,5,6,
            7,83,0,79,86,61,82,89,90,91,
            92,93,94,95,96,0,0,0,1,101,
            102,96,104,105,8,9,33,34,35,60,
            66,38,63,0,65,110,67,119,60,61,
            66,8,9,0,70,71,72,4,0,0,
            0,0,134,3,3,137,5,6,7,141,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,24,61,0,62,2,
            0,4,66,0,68,69,70,71,72,73,
            74,75,76,77,0,62,80,81,0,66,
            84,68,69,70,71,72,73,74,75,76,
            77,0,63,80,81,0,0,124,125,126,
            127,128,129,130,131,0,0,79,3,112,
            82,114,0,83,51,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            0,0,2,73,74,75,76,8,9,0,
            66,0,0,2,3,71,72,0,9,2,
            8,73,74,75,76,60,0,0,0,2,
            2,3,67,5,6,7,24,61,140,27,
            28,29,30,31,32,63,0,86,2,3,
            89,90,91,0,93,94,95,0,83,0,
            78,62,0,1,64,66,0,68,69,70,
            71,72,73,74,75,76,77,68,51,80,
            0,64,2,83,0,84,86,60,61,89,
            90,91,92,93,94,95,96,0,1,2,
            83,0,0,86,104,105,89,90,91,92,
            93,94,95,96,86,0,0,1,2,62,
            63,104,105,8,9,63,0,65,0,67,
            103,51,4,0,8,78,0,1,2,0,
            60,61,0,116,117,118,62,8,51,0,
            0,2,2,51,0,0,2,2,61,79,
            0,77,82,66,80,108,0,51,2,67,
            142,143,0,145,146,122,79,61,0,82,
            2,66,66,68,69,70,71,72,73,74,
            75,76,66,0,0,69,70,71,72,66,
            51,51,0,0,71,72,51,0,69,60,
            61,78,0,0,64,60,0,51,2,0,
            4,2,62,4,0,0,2,61,79,51,
            0,82,2,100,62,0,0,77,88,0,
            80,2,0,4,66,9,0,0,2,77,
            0,1,80,0,51,62,62,63,116,117,
            118,0,1,51,61,0,64,60,0,1,
            2,78,78,61,9,51,60,0,65,60,
            0,0,2,2,0,60,51,0,64,64,
            60,0,85,9,139,8,61,0,96,60,
            9,108,0,1,68,0,9,61,0,62,
            63,0,110,2,3,65,0,1,2,0,
            0,2,0,4,111,0,65,0,1,0,
            1,0,79,68,0,82,2,3,0,62,
            2,61,0,101,102,64,0,1,0,24,
            120,0,68,0,1,78,69,0,0,68,
            0,4,0,1,4,68,0,65,0,1,
            0,51,0,51,0,1,51,0,1,0,
            60,0,1,0,62,0,1,79,0,51,
            82,60,65,0,65,0,1,0,67,0,
            3,0,1,0,1,63,0,0,0,3,
            3,65,107,65,63,0,1,60,65,0,
            60,51,3,65,0,0,121,0,0,1,
            51,0,1,0,1,63,0,1,0,0,
            0,0,4,4,0,0,63,0,0,0,
            84,0,64,0,0,0,0,64,0,4,
            4,0,4,64,0,24,0,0,4,0,
            0,4,0,4,0,1,0,1,0,0,
            0,3,3,0,4,0,0,0,64,81,
            65,0,65,0,0,0,51,0,0,0,
            51,0,4,4,64,4,0,63,0,0,
            63,63,4,0,63,62,62,4,0,0,
            0,0,4,0,63,4,0,61,0,0,
            4,0,0,0,0,0,4,67,51,4,
            0,0,1,0,4,62,51,4,51,63,
            0,1,0,62,61,24,4,0,1,0,
            0,67,0,4,4,3,0,0,0,0,
            0,0,0,88,65,103,4,0,0,0,
            0,4,0,63,0,0,67,0,0,4,
            67,4,4,64,0,61,0,0,4,0,
            0,4,0,4,4,0,0,0,0,0,
            44,0,106,0,0,0,0,0,51,0,
            51,51,0,0,0,0,0,0,0,0,
            0,0,64,0,0,51,0,0,67,0,
            0,62,0,0,0,67,113,67,0,67,
            0,0,0,0,0,0,0,0,0,63,
            132,0,0,0,0,0,0,0,62,0,
            63,0,0,0,0,67,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,106,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,144,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0
        };
    };
    public final static char termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            9286,564,9666,564,9286,564,564,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,9286,564,564,564,564,564,564,564,564,
            9286,9286,443,1890,564,9322,1888,9915,9286,91,
            9337,9339,9340,9338,9336,1883,9328,9329,9330,9331,
            9332,9333,9334,9335,9286,1880,1882,2135,564,9286,
            9286,2590,9320,9388,9322,9916,9915,9867,136,9337,
            9339,9340,9338,9336,9314,9328,9329,9330,9331,9332,
            9333,9334,9335,5141,8564,564,9286,3716,9666,820,
            9886,9888,9896,9898,9887,9889,9897,9899,9286,9286,
            4892,9666,9320,9049,9322,9916,9915,9391,8332,9337,
            9339,9340,9338,9336,988,9328,9329,9330,9331,9332,
            9333,9334,9335,9387,1351,1349,9385,9386,9390,9389,
            9393,9392,955,817,961,8282,9319,1467,3531,8879,
            9645,845,9646,1511,821,781,8540,3940,1813,795,
            9285,604,604,604,604,604,604,604,604,9286,
            688,9666,9320,35,9322,9916,9915,9286,847,9337,
            9339,9340,9338,9336,1883,9328,9329,9330,9331,9332,
            9333,9334,9335,9286,1880,1882,9286,9323,9666,9320,
            2231,9322,9916,9915,9286,144,136,9320,8959,9322,
            9916,9915,595,9286,597,13621,597,9387,6220,9286,
            4892,9666,9320,137,9322,9916,9915,9391,8332,9337,
            9339,9340,9338,9336,988,9328,9329,9330,9331,9332,
            9333,9334,9335,9387,1351,1349,9385,9386,9390,9389,
            9393,9392,955,817,961,8282,9319,1467,3531,8879,
            9645,845,9646,1511,821,781,8540,3940,1813,795,
            40,604,604,604,604,604,604,604,604,9286,
            4892,9666,9320,1122,9322,9916,9915,9391,8332,9337,
            9339,9340,9338,9336,988,9328,9329,9330,9331,9332,
            9333,9334,9335,9387,1351,1349,9385,9386,9390,9389,
            9393,9392,955,817,961,8282,9319,1467,3531,8879,
            9645,845,9646,1511,821,781,8540,3940,9016,795,
            9286,604,604,604,604,604,604,604,604,9286,
            8584,9666,820,369,9286,4892,9666,9320,137,9322,
            9916,9915,9391,8332,9337,9339,9340,9338,9336,988,
            9328,9329,9330,9331,9332,9333,9334,9335,9387,1351,
            1349,9385,9386,9390,9389,9393,9392,955,817,961,
            8282,9319,1467,3531,8879,9645,845,9646,1511,821,
            781,8540,3940,1813,795,832,604,604,604,604,
            604,604,604,604,9286,4892,9666,9320,137,9322,
            9916,9915,9391,8332,9337,9339,9340,9338,9336,988,
            9328,9329,9330,9331,9332,9333,9334,9335,9387,1351,
            1349,9385,9386,9390,9389,9393,9392,955,817,961,
            8282,9319,1467,3531,8879,9645,845,9646,1511,821,
            781,8540,3940,1813,795,62,604,604,604,604,
            604,604,604,604,9286,4892,9666,9320,137,9322,
            9916,9915,9391,8332,9337,9339,9340,9338,9336,988,
            9328,9329,9330,9331,9332,9333,9334,9335,9387,1351,
            1349,9385,9386,9390,9389,9393,9392,955,817,961,
            8282,9319,1467,3531,8879,9645,845,9646,1511,821,
            781,8540,3940,1813,795,1885,604,604,604,604,
            604,604,604,604,9286,4892,9666,9320,553,9322,
            9916,9915,9391,8332,9337,9339,9340,9338,9336,988,
            9328,9329,9330,9331,9332,9333,9334,9335,9387,1351,
            1349,9385,9386,9390,9389,9393,9392,955,817,961,
            8282,9319,1467,3531,8879,9645,845,9646,1511,821,
            781,8540,3940,1813,795,488,604,604,604,604,
            604,604,604,604,9286,688,9286,4892,9666,9320,
            137,9322,9916,9915,9391,8332,9337,9339,9340,9338,
            9336,988,9328,9329,9330,9331,9332,9333,9334,9335,
            9387,1351,1349,9385,9386,9390,9389,9393,9392,955,
            817,961,8282,9319,1467,3531,8879,9645,845,9646,
            1511,821,781,8540,3940,1813,795,83,604,604,
            604,604,604,604,604,604,9286,4892,9666,9320,
            137,9322,9916,9915,9391,8332,9337,9339,9340,9338,
            9336,988,9328,9329,9330,9331,9332,9333,9334,9335,
            9387,1351,1349,9385,9386,9390,9389,9393,9392,955,
            817,961,8282,9319,1467,3531,8879,9645,845,9646,
            1511,821,781,8540,3940,1813,795,3614,604,604,
            604,604,604,604,604,604,9286,4892,9666,9320,
            9409,9322,9916,9915,9391,8332,9337,9339,9340,9338,
            9336,988,9328,9329,9330,9331,9332,9333,9334,9335,
            9387,1351,1349,9385,9386,9390,9389,9393,9392,955,
            817,961,8282,9319,1467,3531,8879,9645,845,9646,
            1511,821,781,8540,3940,1813,795,9286,604,604,
            604,604,604,604,604,604,9286,4892,9666,9320,
            9286,9322,9916,9915,9391,8332,9337,9339,9340,9338,
            9336,988,9328,9329,9330,9331,9332,9333,9334,9335,
            9387,1351,1349,9385,9386,9390,9389,9393,9392,955,
            817,961,8282,9319,1467,3531,8879,9645,845,9646,
            1511,821,781,8540,3940,1813,795,9286,604,604,
            604,604,604,604,604,604,9286,688,9286,4892,
            9666,9320,137,9322,9916,9915,9391,8332,9337,9339,
            9340,9338,9336,988,9328,9329,9330,9331,9332,9333,
            9334,9335,9387,1351,1349,9385,9386,9390,9389,9393,
            9392,955,817,961,8282,9319,1467,3531,8879,9645,
            845,9646,1511,821,781,8540,3940,1813,795,5888,
            604,604,604,604,604,604,604,604,9286,4892,
            9666,9320,137,9322,9916,9915,9391,8332,9337,9339,
            9340,9338,9336,988,9328,9329,9330,9331,9332,9333,
            9334,9335,9387,1351,1349,9385,9386,9390,9389,9393,
            9392,955,817,961,8282,9319,1467,3531,8879,9645,
            845,9646,1511,821,781,8540,3940,1813,795,138,
            604,604,604,604,604,604,604,604,9286,4892,
            9666,9320,137,9322,9916,9915,9391,8332,9337,9339,
            9340,9338,9336,988,9328,9329,9330,9331,9332,9333,
            9334,9335,9387,1351,1349,9385,9386,9390,9389,9393,
            9392,955,817,961,8282,9319,1467,3531,8879,9645,
            845,9646,1511,821,781,8540,3940,1813,795,4560,
            604,604,604,604,604,604,604,604,9286,4892,
            9666,9320,137,9322,9916,9915,9391,8332,9337,9339,
            9340,9338,9336,988,9328,9329,9330,9331,9332,9333,
            9334,9335,9387,1351,1349,9385,9386,9390,9389,9393,
            9392,955,817,961,8282,9319,1467,3531,8879,9645,
            845,9646,1511,821,781,8540,3940,1813,795,9286,
            604,604,604,604,604,604,604,604,9286,4892,
            9666,9320,9286,9322,9916,9915,9391,8332,9337,9339,
            9340,9338,9336,988,9328,9329,9330,9331,9332,9333,
            9334,9335,9387,1351,1349,9385,9386,9390,9389,9393,
            9392,955,817,961,8282,9319,1467,3531,8879,9645,
            845,9646,1511,821,781,8540,3940,1813,795,541,
            604,604,604,604,604,604,604,604,9286,688,
            9286,4892,9666,9320,137,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,6054,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,137,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,654,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,137,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,8996,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,87,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,9286,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,9286,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,5805,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,8910,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,245,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,249,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,3723,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,3728,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,72,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,141,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,1221,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,3852,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,648,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,9286,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,8996,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,9286,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,9286,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,9286,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,9286,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,9286,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,9286,604,604,604,604,604,604,604,604,
            9286,4892,9666,9320,9286,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,9286,604,604,604,604,604,604,604,604,
            393,4892,9286,9320,9666,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,9286,604,604,604,604,604,604,604,604,
            243,4892,9286,9320,9286,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,1813,
            795,6635,604,604,604,604,604,604,604,604,
            604,4892,9286,9320,9666,9322,9916,9915,9391,8332,
            9337,9339,9340,9338,9336,988,9328,9329,9330,9331,
            9332,9333,9334,9335,9387,1351,1349,9385,9386,9390,
            9389,9393,9392,955,817,961,8282,9319,1467,3531,
            8879,9645,845,9646,1511,821,781,8540,3940,9016,
            795,9286,9286,8875,605,605,605,605,605,605,
            605,605,506,9286,568,9666,9320,1526,9322,9916,
            9915,324,9286,4023,9320,149,9322,9916,9915,9286,
            9286,9666,661,653,661,661,661,150,568,661,
            661,661,661,661,661,661,661,661,661,661,
            661,661,661,61,661,661,9320,9286,9322,9916,
            9915,604,4892,8977,9320,9050,9322,9916,9915,9391,
            8332,9337,9339,9340,9338,9336,988,9328,9329,9330,
            9331,9332,9333,9334,9335,9387,1351,1349,9385,9386,
            9390,9389,9393,9392,955,817,961,8282,9319,1467,
            3531,8879,9645,845,9646,1511,821,781,8540,3940,
            9016,795,153,9286,9949,8998,9286,8962,9666,9286,
            9286,9666,9960,9286,2590,367,161,9950,9951,9337,
            9339,9340,9338,9336,1883,9328,9329,9330,9331,9332,
            9333,9334,9335,9286,1831,604,4892,1466,9320,367,
            9322,9916,9915,9391,8332,9337,9339,9340,9338,9336,
            988,9328,9329,9330,9331,9332,9333,9334,9335,9387,
            1351,1349,9385,9386,9390,9389,9393,9392,955,817,
            961,8282,9319,1467,3531,8879,9645,845,9646,1511,
            821,781,8540,3940,1813,795,8117,8060,8003,7946,
            666,7703,9961,9286,1228,604,4892,165,9320,82,
            9322,9916,9915,9391,8332,9337,9339,9340,9338,9336,
            988,9328,9329,9330,9331,9332,9333,9334,9335,9387,
            1351,1349,9385,9386,9390,9389,9393,9392,955,817,
            961,8282,9319,1467,3531,8879,9645,845,9646,1511,
            821,781,8540,3940,1813,795,604,4892,9286,2139,
            9666,9322,9916,9915,9391,8332,9337,9339,9340,9338,
            9336,988,9328,9329,9330,9331,9332,9333,9334,9335,
            9387,1351,1349,9385,9386,9390,9389,9393,9392,955,
            817,961,8282,9319,1467,3531,8879,9645,845,9646,
            1511,821,781,8540,3940,1813,795,604,4892,9796,
            9320,2132,9322,9916,9915,9391,8332,9337,9339,9340,
            9338,9336,988,9328,9329,9330,9331,9332,9333,9334,
            9335,9387,1351,1349,9385,9386,9390,9389,9393,9392,
            955,817,961,8282,9319,1467,3531,8879,9645,845,
            9646,173,821,781,8540,9286,9286,9666,661,9286,
            661,661,661,209,9391,661,661,661,661,661,
            661,661,661,661,661,661,661,661,661,496,
            661,661,9286,9385,9666,661,9286,661,661,661,
            9286,9286,661,661,661,661,661,661,661,661,
            661,661,661,661,661,661,9286,661,661,604,
            9507,9286,9320,9666,9322,9916,9915,9300,9299,155,
            9286,4394,9666,9286,179,179,179,179,236,215,
            9286,8486,9666,215,215,215,9391,144,136,142,
            9949,215,837,801,961,9289,145,200,192,1109,
            1715,1120,9387,9950,9951,9385,9386,9390,9389,9393,
            9392,180,9810,215,9286,464,9666,9949,193,200,
            192,9296,688,4975,9286,5058,199,9298,9301,56,
            9950,9951,9295,9292,9294,9293,9297,469,65,9387,
            9287,1313,8436,9290,635,2408,9291,1129,1728,9579,
            8918,172,40,159,65,216,9288,192,200,216,
            216,216,180,180,180,180,172,216,9286,172,
            166,9286,3103,160,816,9689,154,216,235,192,
            200,216,216,216,2136,9286,148,199,9320,216,
            9322,9916,9915,147,840,9337,9339,9340,9338,9336,
            1883,9328,9329,9330,9331,9332,9333,9334,9335,560,
            1880,1882,9286,9286,9666,661,8552,8117,8060,8003,
            7946,208,661,661,661,661,661,661,661,661,
            661,661,661,661,661,661,577,368,9286,9320,
            9666,9322,9916,9915,428,483,9337,9339,9340,9338,
            9336,1883,9328,9329,9330,9331,9332,9333,9334,9335,
            9286,1880,1882,4116,9286,9322,9916,9915,7631,9286,
            9337,9339,9340,9338,9336,1883,9328,9329,9330,9331,
            9332,9333,9334,9335,9286,1880,1882,216,9653,144,
            136,216,216,216,200,661,9286,9949,9286,9932,
            9666,9286,1811,9809,9808,853,9930,9931,1367,474,
            9950,9951,1841,604,8725,9831,9320,9286,9322,9916,
            9915,9014,9286,1340,642,1839,1341,642,642,642,
            2141,642,642,642,991,9286,154,311,4394,642,
            8981,991,1856,1857,200,192,837,801,961,8988,
            2498,3710,8802,160,40,9028,65,386,8926,470,
            216,200,192,9286,216,216,216,9346,414,9286,
            9286,9286,8955,9960,9320,1847,9322,9916,9915,1823,
            9337,9339,9340,9338,9336,1883,9328,9329,9330,9331,
            9332,9333,9334,9335,9388,9387,1377,9286,172,9666,
            175,9536,216,9286,192,200,216,216,216,180,
            180,180,180,172,349,172,172,166,174,216,
            160,192,200,216,216,216,180,180,180,180,
            172,9286,8627,172,166,281,9286,9618,9619,9620,
            9621,9622,9623,9563,9564,9286,9286,1340,9960,2503,
            1341,2136,9286,9961,9674,9337,9339,9340,9338,9336,
            1883,9328,9329,9330,9331,9332,9333,9334,9335,166,
            9286,9286,9666,8117,8060,8003,7946,200,192,181,
            775,9286,9286,9666,1479,771,9636,9286,191,9666,
            9391,8117,8060,8003,7946,6270,9286,9286,9286,9666,
            9666,9320,4809,9322,9916,9915,9387,800,1003,9385,
            9386,9390,9389,9393,9392,8788,9286,9932,9666,9957,
            1811,9809,9808,509,9930,9931,1367,9286,9961,9286,
            5473,172,144,136,3259,216,9286,192,200,216,
            216,216,180,180,180,180,172,191,555,172,
            9286,3260,9666,9014,167,3193,642,1619,555,642,
            642,642,2141,642,642,642,991,9286,8962,9666,
            9014,9286,9286,642,1856,1857,642,642,642,2141,
            642,642,642,991,9781,172,9286,8962,9666,9547,
            1815,1856,1857,200,192,8802,192,40,9286,65,
            555,433,9345,349,200,9548,9286,8947,9666,195,
            1359,433,549,555,555,555,171,8486,423,9286,
            9286,9666,9666,3838,9286,9286,9666,9666,423,433,
            9286,171,433,8769,171,9549,9286,639,9666,6884,
            9777,9780,168,9779,9778,9794,423,639,9286,423,
            9666,216,8769,192,200,216,216,216,180,180,
            180,180,216,259,300,200,216,216,216,775,
            432,3732,483,9286,771,9636,455,9286,8436,1359,
            432,4228,9286,358,368,1334,9286,9817,9666,9286,
            9901,9666,7886,9532,9286,9286,9666,688,432,391,
            9286,432,9666,4145,7886,9286,9286,7826,368,9286,
            7766,9666,434,9536,8769,8174,9286,9286,9666,7826,
            9286,2147,7766,429,9824,9547,6718,8788,9844,9843,
            9842,9286,2236,9697,688,185,367,1111,9286,799,
            9666,9548,5473,823,8174,8581,1320,363,840,3723,
            9286,9286,9666,9666,184,1217,9693,194,368,9382,
            2744,183,4311,8174,8734,8486,846,182,991,3728,
            8174,9549,136,2661,8228,498,8174,688,416,5390,
            8772,9286,9028,9666,9962,840,9286,798,9666,9286,
            9286,9666,9286,9892,2133,9286,840,9286,2928,9286,
            3017,9286,1340,8228,595,1341,597,13621,9286,6552,
            9666,5307,630,9722,9723,9590,461,1348,9286,9388,
            9770,34,8228,650,8962,6469,8436,9286,673,8228,
            9286,9411,9286,2009,9412,8228,156,41,9286,8713,
            9286,3720,34,9800,9286,8738,9927,9286,8875,264,
            3724,9286,1831,9286,7050,9286,2325,1340,9286,9670,
            1341,3724,969,9286,1328,9286,2414,9286,7465,9286,
            820,9286,5224,9286,8962,580,9286,9286,162,9953,
            9923,840,1316,1853,582,9286,5556,4560,840,352,
            4560,5639,13622,1855,9286,9286,1343,136,9286,1719,
            5722,355,1019,339,8867,8788,338,1629,9286,9286,
            9286,465,1278,9938,647,9286,8802,9286,9286,9286,
            3193,9286,9367,9286,9286,9286,9286,9513,9286,9512,
            9877,9286,9876,9516,9286,9388,9286,9286,9643,9286,
            9286,1867,319,9415,9286,2750,135,2839,9286,9286,
            9286,4133,9565,9286,1894,573,34,9286,3101,7703,
            993,9286,40,9286,592,9286,9812,9286,9286,9286,
            9924,9286,3106,8952,9662,8991,9286,8984,9286,136,
            8888,8902,9416,9286,8564,5141,6137,1346,9286,9286,
            65,9286,9410,9286,9882,9627,9286,688,327,9286,
            9626,466,9286,9286,9286,598,9515,9637,9799,9900,
            9286,134,3264,9286,9413,1006,9736,9414,9664,8639,
            9286,3353,9286,6386,8943,9388,9873,9286,3442,9286,
            9286,4726,9286,9872,8812,9566,9286,9286,9286,9286,
            9286,9286,9286,9051,41,6303,9404,9286,9286,66,
            9286,9401,9286,8802,9286,9286,6801,9286,9286,9748,
            6967,9417,9875,9847,9286,1313,9286,9286,9874,9286,
            9286,9405,505,9403,9402,9286,481,595,352,9286,
            1511,9286,9640,9286,9286,9286,9286,9286,9798,9286,
            9738,9667,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,3437,9286,9286,9801,9286,9286,7133,9286,
            9286,6137,9286,9286,9286,7216,9578,7299,9286,7382,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,8934,
            7681,9286,9286,9286,9286,9286,9286,9286,7548,9286,
            3849,9286,9286,9286,9286,4109,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9783,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9286,9286,9286,9286,
            9286,9286,9286,9286,9286,9286,9790
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            500,85,319,571,118,120,113,128,519,554,
            571,571,50,417,571,729,859,729,518,151,
            188,188,658,658,235,453,250,523,523,252,
            260,288,258,266,300,262,270,304,269,272,
            306,271,774,360,181,122,729,252,286,555,
            207,656,657,728,657,858,342,857,571,441,
            440,717,714,657,330,657,919,446,446,133,
            523,523,523,523,523,523,523,523,633,859,
            772,729,729,729,729,449,449,455,850,640,
            640,728,728,729,639,574,727,519,643,571,
            629,787,555,787,835,557,729,254,183,523,
            523,523,523,523,523,523,574,131,743,518,
            518,87,60,729,576,186,191,859,364,932,
            317,1,317,729,453,645,317,519,133,571,
            343,571,297,958,136,339,343,571,136,571,
            286,962,571,519,518,571,555,519,254,270,
            254,266,254,260,260,260,260,697,555,555,
            557,574,576,576,342,612,576,574,633,771,
            725,518,729,633,286,748,864,661,437,633,
            772,497,149,720,437,633,149,149,434,436,
            250,576,254,258,258,254,262,262,262,254,
            269,254,271,222,518,698,519,729,453,250,
            571,571,729,251,728,718,728,728,519,633,
            497,571,734,519,149,366,859,633,555,497,
            149,360,283,426,717,717,286,519,555,772,
            772,314,298,297,714,312,136,343,729,960,
            136,286,772,434,434,498,633,633,633,875,
            222,772,555,633,658,519,555,148,660,633,
            519,658,519,519,845,571,555,571,519,519,
            519,836,576,633,466,519,482,729,557,251,
            640,640,574,576,574,571,519,633,209,518,
            434,519,736,317,232,859,848,933,574,282,
            282,786,933,286,434,555,555,658,555,926,
            225,225,312,318,286,331,728,899,318,519,
            555,698,221,862,519,724,286,443,633,633,
            633,661,633,518,897,576,250,576,571,576,
            571,576,633,769,633,482,869,480,497,745,
            496,633,867,883,633,482,746,484,519,207,
            149,859,555,875,875,574,574,650,519,285,
            433,905,635,881,872,879,571,571,653,571,
            312,633,718,222,518,519,519,285,519,661,
            658,658,846,633,251,633,729,633,729,633,
            658,519,519,571,519,571,518,518,555,633,
            574,518,571,571,519,571,889,886,286,519,
            149,908,571,284,555,926,286,658,207,310,
            308,310,653,286,576,576,576,633,482,633,
            482,497,482,497,746,479,658,482,481,286,
            317,908,891,905,633,571,343,633,633,633,
            519,519,519,519,519,772,571,651,633,633,
            633,555,343,731,732,842,733,897,895,734,
            291,842,842,519,571,739
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static char asr[] = {0,
            64,40,9,36,1,41,43,47,33,34,
            35,46,45,38,42,39,14,10,13,11,
            12,15,31,32,8,30,29,24,28,27,
            16,17,18,19,20,21,22,23,26,25,
            37,3,7,6,5,48,49,50,44,52,
            53,54,55,56,57,58,59,2,0,52,
            53,54,55,56,57,58,59,33,34,35,
            124,125,126,127,128,129,130,131,5,3,
            7,6,38,0,119,0,52,53,54,55,
            56,57,58,59,33,34,35,5,3,7,
            6,81,97,36,84,87,62,77,68,9,
            8,69,73,74,75,76,0,87,0,81,
            0,1,5,3,7,6,0,8,69,0,
            78,108,62,63,0,86,89,90,91,104,
            105,92,93,94,83,95,96,2,64,0,
            68,9,8,69,73,74,62,75,76,77,
            4,64,106,67,60,51,107,80,81,97,
            84,87,123,112,113,85,88,2,119,24,
            78,100,70,72,71,66,0,1,61,0,
            14,10,13,11,12,15,16,17,18,19,
            20,21,22,23,3,83,24,0,64,106,
            60,51,107,123,112,113,85,88,119,103,
            67,2,4,0,5,6,7,3,101,102,
            0,64,88,0,61,63,108,120,111,103,
            135,139,82,79,116,117,118,144,24,65,
            1,78,100,70,71,66,72,8,69,68,
            9,73,74,75,76,62,77,80,81,84,
            87,97,4,106,67,107,123,112,113,85,
            119,60,88,64,2,51,0,68,9,0,
            5,6,7,3,122,0,24,138,0,62,
            77,80,0,84,0,97,0,1,65,2,
            60,51,82,61,79,0,64,51,119,134,
            102,137,105,104,92,83,96,2,141,101,
            93,94,86,91,90,95,89,0,85,98,
            99,2,14,10,13,11,12,15,16,17,
            18,19,20,21,22,23,3,83,0,2,
            3,1,0,2,133,64,88,115,49,44,
            50,48,9,36,5,3,7,6,37,25,
            26,16,17,18,19,20,21,22,23,15,
            27,28,24,30,29,8,32,31,14,10,
            13,11,12,39,42,38,45,46,35,33,
            34,47,1,41,43,40,54,58,55,59,
            52,56,53,57,0,61,103,116,117,118,
            2,63,51,62,0,2,64,60,0,136,
            92,0,2,109,0,85,60,0,61,111,
            2,63,65,0,61,70,66,111,103,135,
            116,117,118,144,65,4,64,106,107,123,
            112,113,85,88,2,119,78,108,62,51,
            60,67,0,64,106,51,107,123,112,113,
            85,88,2,119,132,67,4,60,0,86,
            101,134,102,89,90,91,104,105,92,137,
            93,94,83,141,95,96,119,2,44,50,
            49,48,52,53,54,55,56,57,58,59,
            40,9,36,27,28,24,30,29,8,32,
            31,39,42,38,45,46,35,33,34,47,
            1,41,43,37,26,25,15,16,17,18,
            19,20,21,22,23,14,10,13,11,12,
            5,7,6,3,0,52,53,54,55,56,
            57,58,59,40,9,36,1,41,43,47,
            33,34,35,46,45,38,42,39,31,32,
            8,30,29,24,28,27,37,48,49,50,
            44,2,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,25,26,5,3,
            7,6,4,0,61,2,60,0,111,65,
            1,0,123,0,1,4,64,63,65,62,
            2,60,116,117,118,103,51,61,0,109,
            52,53,54,55,56,57,58,59,44,50,
            49,48,9,36,37,27,28,24,30,29,
            8,32,31,39,42,38,45,46,35,33,
            34,47,1,41,43,40,61,16,17,18,
            19,20,21,22,23,14,10,13,11,12,
            15,26,25,5,7,6,3,2,0,64,
            60,107,0,51,64,112,114,2,1,0,
            70,144,135,2,62,64,51,0,62,64,
            51,2,70,0,51,67,60,68,9,8,
            69,73,74,75,76,77,1,70,71,65,
            66,100,72,80,81,97,84,87,4,62,
            78,63,0,4,106,67,60,51,107,123,
            112,113,85,2,119,88,52,53,54,55,
            56,57,58,59,44,50,49,48,9,36,
            5,3,7,6,37,25,26,16,17,18,
            19,20,21,22,23,15,14,10,13,11,
            12,39,42,38,45,46,35,33,34,47,
            1,41,43,40,64,28,24,30,29,32,
            31,27,8,0,112,113,0,65,63,4,
            60,103,116,117,118,111,62,51,2,61,
            0,62,78,4,51,0,60,63,67,51,
            0,51,139,24,2,60,4,0,65,1,
            2,139,51,60,0,24,51,0,44,0,
            2,120,60,0,121,107,106,0,61,51,
            140,79,82,0,64,110,96,5,86,6,
            7,142,143,145,146,2,3,0,2,3,
            7,6,5,102,0,24,3,7,6,5,
            0,4,5,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,25,26,6,
            7,3,2,85,98,99,0,82,79,61,
            1,51,2,66,0
        };
    };
    public final static char asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static char nasb[] = {0,
            145,235,225,268,235,235,235,235,49,236,
            9,9,158,62,9,235,93,235,174,235,
            235,235,235,235,235,235,151,219,219,235,
            235,235,235,235,235,235,235,235,235,235,
            235,235,49,117,42,9,235,235,235,184,
            52,85,235,304,260,259,274,259,9,235,
            235,125,291,235,28,235,282,235,235,235,
            160,195,207,207,207,207,219,219,235,259,
            235,235,235,235,235,235,235,235,235,235,
            235,158,158,235,235,38,67,180,235,288,
            265,49,184,49,25,9,235,235,42,213,
            213,201,201,201,166,187,309,34,235,48,
            48,11,1,235,49,235,275,158,120,285,
            241,48,241,305,235,235,241,49,235,9,
            275,9,52,298,36,295,275,9,36,9,
            235,158,106,49,48,54,184,49,235,235,
            235,235,235,235,235,235,235,184,184,184,
            9,235,49,49,274,22,49,235,235,235,
            17,48,235,235,235,235,235,98,235,235,
            235,235,235,235,235,235,235,235,235,158,
            151,49,235,235,235,235,235,235,235,235,
            235,235,235,158,48,156,57,151,235,151,
            9,9,235,235,158,158,235,235,49,235,
            235,9,44,49,235,49,259,235,184,235,
            235,307,240,123,158,158,235,49,184,235,
            235,89,235,235,157,272,243,275,305,301,
            243,235,235,235,235,235,235,235,235,158,
            158,235,184,235,260,49,184,158,153,235,
            49,40,49,49,235,59,184,140,49,49,
            49,31,49,235,34,49,235,235,9,235,
            235,235,109,46,20,262,49,235,65,48,
            235,49,241,241,80,259,235,294,308,235,
            235,49,285,235,235,184,184,235,184,51,
            78,78,87,241,235,28,304,272,241,49,
            184,75,127,235,49,241,235,158,235,235,
            235,111,235,48,235,49,151,49,9,49,
            9,49,235,235,235,235,235,235,235,151,
            70,235,235,235,235,235,151,143,49,52,
            235,259,184,158,158,309,309,235,49,158,
            235,279,158,133,235,235,9,9,129,9,
            87,235,158,235,48,49,49,158,49,153,
            40,40,235,235,235,235,235,235,235,235,
            94,49,49,106,49,9,49,49,184,235,
            235,48,9,59,49,9,193,235,235,49,
            235,136,9,240,184,51,235,260,52,158,
            104,158,82,235,49,49,49,235,235,235,
            235,235,235,235,151,235,260,235,235,235,
            241,255,158,252,235,9,275,235,235,235,
            49,49,49,49,49,235,9,158,235,235,
            235,184,275,172,138,73,96,235,235,131,
            91,72,72,49,9,172
        };
    };
    public final static char nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            16,210,211,193,192,209,19,176,2,0,
            16,2,184,19,176,0,201,156,0,194,
            0,177,178,0,190,8,0,175,180,0,
            8,150,0,152,0,164,0,155,0,120,
            0,159,0,259,0,91,97,50,16,3,
            2,8,0,2,101,0,216,0,2,115,
            0,278,279,0,204,0,200,50,0,195,
            0,10,9,0,179,177,0,166,0,270,
            0,265,263,0,261,0,106,0,247,0,
            258,0,50,154,0,253,0,2,3,8,
            16,196,0,241,0,2,97,0,199,0,
            2,3,8,16,197,0,100,50,0,268,
            50,0,282,0,245,0,277,0,262,0,
            254,0,244,50,0,251,0,252,0,2,
            91,0,208,0,2,3,8,16,220,0,
            92,0,8,16,86,3,2,50,0,16,
            3,8,2,68,0,3,8,16,2,65,
            0,173,0,16,3,8,2,198,0,80,
            16,8,121,2,3,0,3,8,16,2,
            71,0,72,0,16,3,8,2,62,0,
            3,8,16,2,59,0,16,3,8,2,
            56,0,3,8,16,2,53,0,2,3,
            8,16,38,0,229,128,232,134,135,138,
            141,145,102,221,0,2,3,276,0,50,
            90,0,134,135,128,138,141,145,102,169,
            0,172,171,0,2,256,50,0,50,86,
            0,2,214,0,186,2,0,280,2,188,
            0,165,0,50,3,95,94,0,250,172,
            0,2,223,0,181,109,0,2,187,0,
            2,239,0,146,109,50,0,237,50,0,
            233,50,0,50,99,0,50,151,100,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            11,162,163,12,37,134,136,3,2,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,40,73,74,38,39,54,55,
            56,57,115,116,117,45,58,76,48,52,
            75,88,89,90,93,94,99,84,87,91,
            22,118,119,120,121,122,123,124,125,19,
            13,7,20,14,21,23,18,1,4,15,
            17,27,5,6,8,9,10,25,131,34,
            43,130,135,46,53,96,47,97,104,105,
            106,111,132,133,142,158,44,98,107,26,
            100,102,108,109,110,16,24,28,29,30,
            35,50,51,77,114,138,139,140,164,31,
            32,33,49,78,79,80,81,82,83,85,
            86,92,95,101,112,113,126,127,128,129,
            137,141,145,153,156,157,41,42,103,143,
            144,146,147,148,149,150,151,152,154,155,
            159,160,161
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            167,168,166,0,170,0,0,182,181,183,
            0,0,0,0,0,0,0,0,296,0,
            0,0,0,0,0,0,0,0,0,185,
            0,0,0,0,188,0,0,213,214,0,
            0,0,0,0,0,0,0,0,0,219,
            209,210,211,206,207,208,203,204,205,200,
            201,202,197,198,199,194,195,196,191,192,
            193,241,175,186,189,0,190,0,0,224,
            0,0,171,0,0,226,187,0,270,0,
            173,0,277,301,302,0,176,178,260,222,
            174,255,212,254,261,263,0,0,0,289,
            0,0,0,169,177,180,0,220,0,225,
            227,0,0,0,0,0,0,0,269,0,
            0,0,0,278,279,0,0,282,0,0,
            283,0,0,284,285,300,0,179,216,217,
            221,223,231,235,237,239,240,248,0,0,
            0,250,252,0,259,0,264,0,265,268,
            273,0,0,280,281,292,0,0,293,298,
            299,0,0,165,0,172,184,215,0,218,
            0,228,229,230,0,232,233,234,236,238,
            0,0,0,0,0,0,0,0,242,243,
            244,245,246,247,0,0,249,0,0,0,
            251,0,253,0,0,0,0,0,256,0,
            0,257,258,0,0,0,0,0,262,0,
            0,0,266,0,267,0,0,0,271,272,
            0,0,0,0,274,275,276,0,0,0,
            0,0,286,0,287,288,0,0,0,0,
            0,0,0,0,290,291,0,294,295,297,
            0,0,0,0,0,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            429,465,475,363,397,405,451,485,439,15,
            24,48,55,197,383,390,84,107,282,372,
            423,163,226,241,413,459,33,33,38,43,
            62,67,102,178,378,137,178,214,178,72,
            72,122,126,159,159,270,270,274,274,278,
            296,300,493,497,501,505,115,130,145,152,
            152,219,288,232,247,97,78,6,6,78,
            172,304,172,78,172,172,95,1,251,251,
            251,251,265,307,307,315,315,323,323,323,
            323,1,1,343,348,353,358
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            31,31,31,31,31,31,31,31,447,22,
            31,31,31,191,31,31,76,113,31,31,
            31,169,223,223,419,447,22,31,31,31,
            31,31,31,191,31,142,183,134,204,22,
            76,31,31,22,100,22,31,22,31,100,
            100,31,100,100,31,31,119,134,149,81,
            156,223,292,236,236,100,31,9,12,81,
            175,12,193,90,186,208,76,3,253,256,
            259,262,267,309,312,317,320,325,328,331,
            334,337,340,345,350,355,360
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            29,28,28,31,31,31,29,28,29,18,
            18,176,176,41,31,31,156,29,85,31,
            31,29,44,44,31,29,17,17,49,49,
            176,176,47,41,31,82,41,192,41,202,
            202,209,209,154,154,79,79,119,119,43,
            42,84,23,22,7,6,214,46,72,156,
            156,44,85,44,44,86,39,40,40,156,
            41,40,41,156,41,41,157,62,80,80,
            80,80,151,53,53,56,56,59,59,59,
            59,62,62,65,68,71,76
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static char scopeLa[] = {
            4,4,4,4,4,4,4,4,67,2,
            4,4,4,113,4,4,51,106,4,4,
            4,4,4,4,60,67,2,4,4,4,
            4,4,4,113,4,4,112,4,112,2,
            51,4,4,2,64,2,4,2,4,64,
            64,4,64,64,4,4,67,4,4,4,
            4,4,60,51,51,64,4,85,85,4,
            123,85,123,4,123,123,51,80,100,100,
            78,78,60,69,8,9,68,76,75,74,
            73,77,62,81,84,87,97
        };
    };
    public final static char scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static char scopeStateSet[] = {
            156,156,156,156,156,156,156,156,156,247,
            247,337,337,156,156,156,6,156,30,156,
            156,156,156,156,156,156,247,247,156,156,
            337,337,156,156,156,173,156,338,156,7,
            7,338,338,27,27,173,173,243,243,156,
            156,30,156,156,127,127,1,156,52,6,
            6,156,30,156,156,9,156,156,156,6,
            156,156,156,6,156,156,124,169,173,173,
            173,173,3,160,160,162,162,166,166,166,
            166,169,169,170,171,172,173
        };
    };
    public final static char scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            224,0,80,222,0,443,40,0,85,213,
            0,85,236,0,341,60,256,1,442,179,
            0,213,0,342,60,256,1,442,179,0,
            4,0,341,1,441,179,0,251,1,168,
            34,0,251,1,168,33,0,251,1,164,
            65,164,34,0,251,1,164,65,164,33,
            0,251,1,164,34,0,251,1,164,33,
            0,236,109,112,0,51,0,236,1,0,
            4,213,0,236,109,4,236,1,0,4,
            109,236,51,0,236,0,381,61,0,64,
            0,251,1,380,46,0,236,379,70,322,
            193,0,106,0,278,51,321,0,67,236,
            0,377,1,374,0,376,1,373,0,318,
            1,45,0,4,249,0,236,1,369,50,
            0,4,371,0,251,1,44,0,4,367,
            0,236,1,114,0,4,320,0,364,363,
            61,0,362,1,38,71,193,0,4,317,
            0,236,39,0,123,359,0,316,123,236,
            39,0,112,360,0,123,316,112,360,0,
            113,0,123,316,113,0,316,112,316,123,
            236,39,0,112,316,113,0,123,316,112,
            316,113,0,358,357,1,356,0,236,1,
            42,0,4,283,0,236,51,243,1,42,
            0,243,1,42,0,51,236,4,283,0,
            236,51,284,1,42,0,284,1,42,0,
            193,0,100,213,0,100,236,0,78,213,
            0,78,236,0,263,0,60,263,0,263,
            1,49,0,314,1,49,0,352,61,25,
            0,246,60,246,1,25,0,246,1,25,
            0,60,246,4,0,310,61,26,0,246,
            1,26,0,351,40,0,215,0,69,201,
            0,8,201,0,218,0,9,216,0,68,
            216,0,221,0,76,219,0,75,219,0,
            74,219,0,73,219,0,77,222,0,62,
            222,0,227,0,81,225,0,230,0,84,
            228,0,233,0,87,231,0,240,0,97,
            234,0,251,1,255,277,65,168,66,193,
            0,251,1,277,65,168,0,251,1,255,
            164,0,251,1,255,164,66,193,0,251,
            1,255,347,66,193,0,250,60,164,1,
            164,71,193,0,250,60,237,1,164,71,
            193,0,237,1,164,71,193,0,60,250,
            4,0,236,1,164,71,193,0,236,67,
            260,51,261,1,164,71,193,0,260,51,
            261,1,164,71,193,0,67,236,4,0,
            236,67,260,1,164,71,193,0,260,1,
            164,71,193,0,236,67,261,60,254,1,
            164,71,193,0,236,67,261,60,164,1,
            164,71,193,0,236,67,261,1,164,71,
            193,0,350,61,15,0,310,61,166,0,
            348,1,15,0,246,1,166,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            8867,0,8584,9016,0,1313,784,0,8812,8734,
            8991,8952,3106,9051,1728,9050,853,2503,3103,9049,
            1526,9039,9033,8810,2925,0,1346,1467,0,8934,
            8926,8918,8639,8910,8552,8902,8888,8802,8788,8780,
            8772,8572,1815,8738,8713,8627,8564,1831,1823,8540,
            0,7548,7465,7382,7299,7216,7133,3442,3353,3264,
            7050,7681,6967,4809,1129,3852,6884,6801,6718,6635,
            6552,6469,4726,6386,6303,3017,2928,2839,2750,4643,
            1728,6220,6137,3732,6054,4560,1629,1019,5971,2661,
            5888,3614,5805,5722,5639,5556,5473,5390,856,5307,
            5224,4477,2414,1526,4394,2325,2236,2147,5141,4311,
            5058,4975,688,2009,4228,4145,1377,1228,4023,3940,
            3531,4892,1926,3106,2503,0,1619,8934,848,8926,
            8918,8639,8910,8552,8902,8888,8802,8788,8780,1516,
            8772,8572,1815,8947,8738,8713,8627,8564,1367,1120,
            1009,1831,8942,1823,8540,8486,8436,8332,8282,8228,
            8174,8117,8060,8003,7946,7886,7826,7766,7703,3193,
            2590,7631,7548,7465,7382,7299,7216,7133,3442,3353,
            3264,7050,6967,4809,1129,3852,6884,6801,6718,3106,
            6635,6552,6469,4726,6386,6303,3017,2928,2839,2750,
            4643,1728,6220,6137,6054,4560,1629,1019,5971,2661,
            5888,3614,5805,5722,5639,5556,2503,5473,5390,5307,
            5224,4477,2414,1526,4394,2325,2236,2147,5141,4311,
            5058,4975,2009,4228,4145,1377,1228,4023,3940,3531,
            4892,1926,3732,856,688,0,7548,7465,7382,7299,
            7216,7133,3442,3353,3264,7050,6967,4809,1129,3852,
            6884,6801,6718,3106,6635,6552,6469,4726,6386,6303,
            3017,2928,2839,2750,4643,1728,6220,6137,3732,6054,
            4560,1629,1019,5971,2661,5888,3614,5805,5722,5639,
            5556,2503,5473,5390,856,5307,5224,4477,2414,1526,
            4394,2325,2236,2147,5141,4311,5058,4975,688,2009,
            4228,4145,7631,3193,7886,7826,7766,8228,8174,1377,
            1228,4023,8486,8436,8117,8060,8003,7946,7703,2590,
            3940,8332,8282,3531,4892,1926,775,771,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,345,383,40,233,227,221,215,1,47,
            34,33,35,179,46,45,38,42,39,171,
            15,166,26,25,165,168,164,36,9,202,
            217,218,214,223,224,220,229,230,226,238,
            240,232,48,49,193,50,44,198,265,141,
            96,308,307,83,304,301,298,297,92,104,
            105,137,102,395,291,392,134,351,443,164,
            87,81,76,75,74,73,69,8,236,438,
            439,25,26,15,166,6,3,168,246,168,
            168,442,441,380,168,1,61,1,236,61,
            1,61,1,61,61,65,255,198,193,9,
            68,80,77,62,84,97,1,3,322,100,
            78,66,71,369,1,246,171,103,61,1,
            249,61,249,256,257,258,249,62,252,92,
            92,136,3,267,61,89,95,101,61,102,
            326,267,60,85,85,60,63,62,198,230,
            198,224,198,218,218,218,218,63,1,1,
            65,111,1,1,1,1,1,111,318,3,
            363,1,114,236,284,3,243,123,350,348,
            164,349,310,236,311,246,310,352,312,353,
            277,1,198,215,215,198,221,221,221,198,
            227,198,233,263,315,63,70,347,168,164,
            34,33,38,164,356,375,374,373,1,251,
            250,66,256,61,423,431,133,446,272,344,
            381,49,325,262,65,65,236,62,63,252,
            256,252,405,171,66,400,327,272,256,267,
            327,326,164,164,246,246,246,251,251,256,
            341,3,340,251,4,78,63,364,112,236,
            1,4,51,51,316,60,63,60,107,60,
            62,60,1,251,246,379,3,255,65,255,
            164,164,1,1,1,1,1,236,4,60,
            252,62,236,64,432,115,3,60,1,314,
            263,51,63,236,246,63,63,410,79,138,
            79,82,328,64,265,291,256,396,64,62,
            60,60,246,246,109,249,236,4,236,236,
            236,112,251,315,236,1,277,1,65,1,
            65,1,362,3,236,260,261,254,237,164,
            357,377,164,321,376,261,164,4,103,62,
            253,88,63,314,263,60,60,344,62,246,
            246,61,412,406,171,168,329,329,337,140,
            328,246,341,342,67,78,62,236,109,4,
            4,4,316,251,255,251,164,251,164,251,
            4,62,67,51,67,60,60,60,63,358,
            60,67,60,51,67,60,132,171,236,62,
            411,335,110,413,60,60,407,139,1,330,
            168,330,425,236,1,1,1,236,260,236,
            261,250,261,250,164,246,4,278,321,236,
            64,414,418,51,292,60,428,251,251,251,
            67,67,67,67,67,252,60,429,236,236,
            236,63,60,246,336,70,415,420,172,416,
            135,107,121,62,421,252
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "", //$NON-NLS-1$
            "+", //$NON-NLS-1$
            "-", //$NON-NLS-1$
            "*", //$NON-NLS-1$
            "/", //$NON-NLS-1$
            ">", //$NON-NLS-1$
            "<", //$NON-NLS-1$
            "=", //$NON-NLS-1$
            ">=", //$NON-NLS-1$
            "<=", //$NON-NLS-1$
            "<>", //$NON-NLS-1$
            "(", //$NON-NLS-1$
            ")", //$NON-NLS-1$
            "{", //$NON-NLS-1$
            "}", //$NON-NLS-1$
            "[", //$NON-NLS-1$
            "]", //$NON-NLS-1$
            "->", //$NON-NLS-1$
            "|", //$NON-NLS-1$
            ",", //$NON-NLS-1$
            ":", //$NON-NLS-1$
            "::", //$NON-NLS-1$
            ";", //$NON-NLS-1$
            ".", //$NON-NLS-1$
            "..", //$NON-NLS-1$
            ":=", //$NON-NLS-1$
            "+=", //$NON-NLS-1$
            "!", //$NON-NLS-1$
            "::=", //$NON-NLS-1$
            "?", //$NON-NLS-1$
            "<<", //$NON-NLS-1$
            ">>", //$NON-NLS-1$
            "...", //$NON-NLS-1$
            "~", //$NON-NLS-1$
            "!=", //$NON-NLS-1$
            "@", //$NON-NLS-1$
            "$empty", //$NON-NLS-1$
            "QUOTED_IDENTIFIER", //$NON-NLS-1$
            "INTEGER_LITERAL", //$NON-NLS-1$
            "REAL_LITERAL", //$NON-NLS-1$
            "STRING_LITERAL", //$NON-NLS-1$
            "SINGLE_LINE_COMMENT", //$NON-NLS-1$
            "MULTI_LINE_COMMENT", //$NON-NLS-1$
            "and", //$NON-NLS-1$
            "implies", //$NON-NLS-1$
            "not", //$NON-NLS-1$
            "or", //$NON-NLS-1$
            "xor", //$NON-NLS-1$
            "if", //$NON-NLS-1$
            "then", //$NON-NLS-1$
            "else", //$NON-NLS-1$
            "endif", //$NON-NLS-1$
            "let", //$NON-NLS-1$
            "in", //$NON-NLS-1$
            "false", //$NON-NLS-1$
            "true", //$NON-NLS-1$
            "null", //$NON-NLS-1$
            "invalid", //$NON-NLS-1$
            "self", //$NON-NLS-1$
            "Bag", //$NON-NLS-1$
            "Collection", //$NON-NLS-1$
            "OrderedSet", //$NON-NLS-1$
            "Sequence", //$NON-NLS-1$
            "Set", //$NON-NLS-1$
            "Tuple", //$NON-NLS-1$
            "Boolean", //$NON-NLS-1$
            "Integer", //$NON-NLS-1$
            "Real", //$NON-NLS-1$
            "String", //$NON-NLS-1$
            "UnlimitedNatural", //$NON-NLS-1$
            "OclAny", //$NON-NLS-1$
            "OclInvalid", //$NON-NLS-1$
            "OclVoid", //$NON-NLS-1$
            "Dict", //$NON-NLS-1$
            "List", //$NON-NLS-1$
            "break", //$NON-NLS-1$
            "switch", //$NON-NLS-1$
            "case", //$NON-NLS-1$
            "xselect", //$NON-NLS-1$
            "xcollect", //$NON-NLS-1$
            "selectOne", //$NON-NLS-1$
            "collectOne", //$NON-NLS-1$
            "collectselect", //$NON-NLS-1$
            "collectselectOne", //$NON-NLS-1$
            "return", //$NON-NLS-1$
            "forEach", //$NON-NLS-1$
            "forOne", //$NON-NLS-1$
            "var", //$NON-NLS-1$
            "while", //$NON-NLS-1$
            "continue", //$NON-NLS-1$
            "log", //$NON-NLS-1$
            "assert", //$NON-NLS-1$
            "with", //$NON-NLS-1$
            "compute", //$NON-NLS-1$
            "new", //$NON-NLS-1$
            "init", //$NON-NLS-1$
            "static", //$NON-NLS-1$
            "end", //$NON-NLS-1$
            "out", //$NON-NLS-1$
            "object", //$NON-NLS-1$
            "transformation", //$NON-NLS-1$
            "import", //$NON-NLS-1$
            "library", //$NON-NLS-1$
            "metamodel", //$NON-NLS-1$
            "mapping", //$NON-NLS-1$
            "query", //$NON-NLS-1$
            "helper", //$NON-NLS-1$
            "inout", //$NON-NLS-1$
            "when", //$NON-NLS-1$
            "configuration", //$NON-NLS-1$
            "intermediate", //$NON-NLS-1$
            "property", //$NON-NLS-1$
            "opposites", //$NON-NLS-1$
            "class", //$NON-NLS-1$
            "population", //$NON-NLS-1$
            "map", //$NON-NLS-1$
            "xmap", //$NON-NLS-1$
            "late", //$NON-NLS-1$
            "resolve", //$NON-NLS-1$
            "resolveone", //$NON-NLS-1$
            "resolveIn", //$NON-NLS-1$
            "resolveoneIn", //$NON-NLS-1$
            "invresolve", //$NON-NLS-1$
            "invresolveone", //$NON-NLS-1$
            "invresolveIn", //$NON-NLS-1$
            "invresolveoneIn", //$NON-NLS-1$
            "modeltype", //$NON-NLS-1$
            "uses", //$NON-NLS-1$
            "where", //$NON-NLS-1$
            "refines", //$NON-NLS-1$
            "access", //$NON-NLS-1$
            "extends", //$NON-NLS-1$
            "blackbox", //$NON-NLS-1$
            "abstract", //$NON-NLS-1$
            "result", //$NON-NLS-1$
            "main", //$NON-NLS-1$
            "this", //$NON-NLS-1$
            "rename", //$NON-NLS-1$
            "disjuncts", //$NON-NLS-1$
            "merges", //$NON-NLS-1$
            "inherits", //$NON-NLS-1$
            "composes", //$NON-NLS-1$
            "constructor", //$NON-NLS-1$
            "datatype", //$NON-NLS-1$
            "default", //$NON-NLS-1$
            "derived", //$NON-NLS-1$
            "do", //$NON-NLS-1$
            "elif", //$NON-NLS-1$
            "enum", //$NON-NLS-1$
            "except", //$NON-NLS-1$
            "exception", //$NON-NLS-1$
            "from", //$NON-NLS-1$
            "literal", //$NON-NLS-1$
            "ordered", //$NON-NLS-1$
            "primitive", //$NON-NLS-1$
            "raise", //$NON-NLS-1$
            "readonly", //$NON-NLS-1$
            "references", //$NON-NLS-1$
            "tag", //$NON-NLS-1$
            "try", //$NON-NLS-1$
            "typedef", //$NON-NLS-1$
            "unlimited", //$NON-NLS-1$
            "ERROR_TOKEN", //$NON-NLS-1$
            "IDENTIFIER", //$NON-NLS-1$
            "EOF_TOKEN", //$NON-NLS-1$
            "conceptualOperationNameCS", //$NON-NLS-1$
            "CollectionTypeIdentifierCS", //$NON-NLS-1$
            "simpleNameCS", //$NON-NLS-1$
            "QuotedSimpleNameCS", //$NON-NLS-1$
            "unreservedSimpleNameCS", //$NON-NLS-1$
            "pathNameCS", //$NON-NLS-1$
            "typeCS", //$NON-NLS-1$
            "tupleTypePartsCS", //$NON-NLS-1$
            "typedUninitializedVariableCS", //$NON-NLS-1$
            "untypedInitializedVariableCS", //$NON-NLS-1$
            "OclExpressionCS", //$NON-NLS-1$
            "typedInitializedVariableCS", //$NON-NLS-1$
            "initializedVariableCS", //$NON-NLS-1$
            "uninitializedVariableCS", //$NON-NLS-1$
            "CollectionLiteralPartsCS", //$NON-NLS-1$
            "CollectionLiteralPartCS", //$NON-NLS-1$
            "IntegerLiteralExpCS", //$NON-NLS-1$
            "StringLiteralExpCS", //$NON-NLS-1$
            "UnlimitedNaturalLiteralExpCS", //$NON-NLS-1$
            "TupleLiteralPartsCS", //$NON-NLS-1$
            "primaryExpCS", //$NON-NLS-1$
            "notNameExpressionCS", //$NON-NLS-1$
            "argumentsCS", //$NON-NLS-1$
            "SimpleNameExpCS", //$NON-NLS-1$
            "impliesNotNameNotLetCS", //$NON-NLS-1$
            "impliesNotLetCS", //$NON-NLS-1$
            "xorNotNameNotLetCS", //$NON-NLS-1$
            "xorNotLetCS", //$NON-NLS-1$
            "xorWithLetCS", //$NON-NLS-1$
            "orNotNameNotLetCS", //$NON-NLS-1$
            "orNotLetCS", //$NON-NLS-1$
            "orWithLetCS", //$NON-NLS-1$
            "andNotNameNotLetCS", //$NON-NLS-1$
            "andNotLetCS", //$NON-NLS-1$
            "andWithLetCS", //$NON-NLS-1$
            "equalityNotNameNotLetCS", //$NON-NLS-1$
            "equalityNotLetCS", //$NON-NLS-1$
            "equalityWithLetCS", //$NON-NLS-1$
            "relationalNotNameNotLetCS", //$NON-NLS-1$
            "relationalNotLetCS", //$NON-NLS-1$
            "relationalWithLetCS", //$NON-NLS-1$
            "additiveNotNameNotLetCS", //$NON-NLS-1$
            "additiveNotLetCS", //$NON-NLS-1$
            "additiveWithLetCS", //$NON-NLS-1$
            "multiplicativeNotNameNotLetCS", //$NON-NLS-1$
            "multiplicativeNotLetCS", //$NON-NLS-1$
            "multiplicativeWithLetCS", //$NON-NLS-1$
            "unaryNotLetCS", //$NON-NLS-1$
            "unaryWithLetCS", //$NON-NLS-1$
            "primaryNotNameCS", //$NON-NLS-1$
            "letVariablesCS", //$NON-NLS-1$
            "literalSimpleCS", //$NON-NLS-1$
            "dictLiteralPartCS", //$NON-NLS-1$
            "dictLiteralPartListCS", //$NON-NLS-1$
            "qvtErrorToken", //$NON-NLS-1$
            "expression_semi_list_element", //$NON-NLS-1$
            "var_init_declarator_list", //$NON-NLS-1$
            "var_init_declarator", //$NON-NLS-1$
            "var_init_op", //$NON-NLS-1$
            "assignStatementCS", //$NON-NLS-1$
            "whileBodyCS", //$NON-NLS-1$
            "expression_block", //$NON-NLS-1$
            "declarator1", //$NON-NLS-1$
            "forExpCS", //$NON-NLS-1$
            "forOpCode", //$NON-NLS-1$
            "forExpDeclaratorList", //$NON-NLS-1$
            "ifExpBodyCS", //$NON-NLS-1$
            "ifThenPart", //$NON-NLS-1$
            "ifElsePart", //$NON-NLS-1$
            "ifExpression", //$NON-NLS-1$
            "switchBodyExpCS", //$NON-NLS-1$
            "switchDeclaratorCS", //$NON-NLS-1$
            "declarator", //$NON-NLS-1$
            "switchAltExpCSList", //$NON-NLS-1$
            "switchAltExpCS", //$NON-NLS-1$
            "expression_statement", //$NON-NLS-1$
            "logExpCS", //$NON-NLS-1$
            "imperativeIterateExpCS", //$NON-NLS-1$
            "imperativeIteratorExpCSToken12", //$NON-NLS-1$
            "imperativeIteratorExpCSToken3", //$NON-NLS-1$
            "imperativeIteratorExpCSToken", //$NON-NLS-1$
            "imperativeIterContents12", //$NON-NLS-1$
            "imperativeIterContents3", //$NON-NLS-1$
            "variableDeclarationListCS", //$NON-NLS-1$
            "newTypespecCS", //$NON-NLS-1$
            "expression_semi_list", //$NON-NLS-1$
            "unit_element", //$NON-NLS-1$
            "unit", //$NON-NLS-1$
            "importDeclaration", //$NON-NLS-1$
            "qualifiedNameCS", //$NON-NLS-1$
            "_tag", //$NON-NLS-1$
            "transformation_h", //$NON-NLS-1$
            "library_h", //$NON-NLS-1$
            "transformation_signature", //$NON-NLS-1$
            "module_usageList", //$NON-NLS-1$
            "simple_signature", //$NON-NLS-1$
            "moduleref", //$NON-NLS-1$
            "libraryDeclaration", //$NON-NLS-1$
            "module_usage", //$NON-NLS-1$
            "moduleref_list", //$NON-NLS-1$
            "module_element", //$NON-NLS-1$
            "packageref_list", //$NON-NLS-1$
            "modeltypeDeclaration", //$NON-NLS-1$
            "packageref", //$NON-NLS-1$
            "uri", //$NON-NLS-1$
            "qvtIdentifierCS", //$NON-NLS-1$
            "type_list", //$NON-NLS-1$
            "classifierFeatureList", //$NON-NLS-1$
            "classifierFeatureCS", //$NON-NLS-1$
            "identifier_list", //$NON-NLS-1$
            "feature_key", //$NON-NLS-1$
            "multiplicity_range", //$NON-NLS-1$
            "scoped_identifier", //$NON-NLS-1$
            "helper_header", //$NON-NLS-1$
            "helper_info", //$NON-NLS-1$
            "complete_signature", //$NON-NLS-1$
            "helper_kind", //$NON-NLS-1$
            "constructor_header", //$NON-NLS-1$
            "entry_header", //$NON-NLS-1$
            "mapping_full_header", //$NON-NLS-1$
            "mapping_header", //$NON-NLS-1$
            "mapping_extra", //$NON-NLS-1$
            "mapping_extension_key", //$NON-NLS-1$
            "scoped_identifier_list", //$NON-NLS-1$
            "typespec", //$NON-NLS-1$
            "objectDeclCS", //$NON-NLS-1$
            "objectIdentifierCS", //$NON-NLS-1$
            "featureMappingCallExpCS", //$NON-NLS-1$
            "resolveOpArgsExpCS", //$NON-NLS-1$
            "resolveOp", //$NON-NLS-1$
            "resolveInOp", //$NON-NLS-1$
            "resolveResolveInExpCS", //$NON-NLS-1$
            "letExpSubCS3", //$NON-NLS-1$
            "qualifier", //$NON-NLS-1$
            "param_list", //$NON-NLS-1$
            "param", //$NON-NLS-1$
            "typeCS2", //$NON-NLS-1$
            "scoped_identifier2" //$NON-NLS-1$
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
