/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class QvtCodeReader {
    public static final int EOF = -1;
    private boolean mySkipComments = false;
    private boolean mySkipStrings = false;
    private boolean myForward = false;
    private IDocument myDocument;
    private int myOffset;
    private int myEnd = -1;
    private int myCachedLineNumber = -1;
    private int myCachedLineOffset = -1;

    public int getOffset() {
        return this.myForward ? this.myOffset - 1 : this.myOffset;
    }

    public void configureForwardReader(IDocument document, int offset, int length, boolean skipComments, boolean skipStrings) {
        this.myDocument = document;
        this.myOffset = offset;
        this.mySkipComments = skipComments;
        this.mySkipStrings = skipStrings;
        this.myForward = true;
        this.myEnd = Math.min(this.myDocument.getLength(), this.myOffset + length);
    }

    public void configureBackwardReader(IDocument document, int offset, boolean skipComments, boolean skipStrings) throws IOException {
        this.myDocument = document;
        this.myOffset = offset;
        this.mySkipComments = skipComments;
        this.mySkipStrings = skipStrings;
        this.myForward = false;
        try {
            this.myCachedLineNumber = this.myDocument.getLineOfOffset(this.myOffset);
        }
        catch (BadLocationException x) {
            throw new IOException(x.getMessage());
        }
    }

    public void close() {
        this.myDocument = null;
    }

    public int read() throws IOException {
        try {
            return this.myForward ? this.readForwards() : this.readBackwards();
        }
        catch (BadLocationException x) {
            throw new IOException(x.getMessage());
        }
    }

    private void gotoCommentEnd() throws BadLocationException {
        while (this.myOffset < this.myEnd) {
            char current;
            if ((current = this.myDocument.getChar(this.myOffset++)) != '*' || this.myOffset >= this.myEnd || this.myDocument.getChar(this.myOffset) != '/') continue;
            ++this.myOffset;
            return;
        }
    }

    private void gotoStringEnd(char delimiter) throws BadLocationException {
        while (this.myOffset < this.myEnd) {
            char current;
            if ((current = this.myDocument.getChar(this.myOffset++)) == '\\') {
                ++this.myOffset;
                continue;
            }
            if (current != delimiter) continue;
            return;
        }
    }

    private void gotoLineEnd() throws BadLocationException {
        int line = this.myDocument.getLineOfOffset(this.myOffset);
        this.myOffset = this.myDocument.getLineOffset(line + 1);
    }

    private int readForwards() throws BadLocationException {
        while (this.myOffset < this.myEnd) {
            char current = this.myDocument.getChar(this.myOffset++);
            switch (current) {
                case '/': {
                    char next;
                    if (this.mySkipComments && this.myOffset < this.myEnd && (next = this.myDocument.getChar(this.myOffset)) == '*') {
                        ++this.myOffset;
                        this.gotoCommentEnd();
                        break;
                    }
                    return current;
                }
                case '-': {
                    char next;
                    if (this.mySkipComments && this.myOffset < this.myEnd && (next = this.myDocument.getChar(this.myOffset)) == '-') {
                        this.gotoLineEnd();
                        break;
                    }
                    return current;
                }
                case '\"': 
                case '\'': {
                    if (this.mySkipStrings) {
                        this.gotoStringEnd(current);
                        break;
                    }
                    return current;
                }
                default: {
                    return current;
                }
            }
        }
        return -1;
    }

    private void handleSingleLineComment() throws BadLocationException {
        int line = this.myDocument.getLineOfOffset(this.myOffset);
        if (line < this.myCachedLineNumber) {
            this.myCachedLineNumber = line;
            this.myCachedLineOffset = this.myDocument.getLineOffset(line);
            int offset = this.myOffset;
            while (this.myCachedLineOffset < offset) {
                char current;
                if ((current = this.myDocument.getChar(offset--)) != '-' || this.myCachedLineOffset > offset || this.myDocument.getChar(offset) != '-') continue;
                this.myOffset = offset;
                return;
            }
        }
    }

    private void gotoCommentStart() throws BadLocationException {
        while (this.myOffset > 0) {
            char current;
            if ((current = this.myDocument.getChar(this.myOffset--)) != '*' || this.myOffset < 0 || this.myDocument.getChar(this.myOffset) != '/') continue;
            return;
        }
    }

    private void gotoStringStart(char delimiter) throws BadLocationException {
        while (this.myOffset > 0) {
            char current = this.myDocument.getChar(this.myOffset);
            if (current == delimiter && (this.myOffset < 0 || this.myDocument.getChar(this.myOffset - 1) != '\\')) {
                return;
            }
            --this.myOffset;
        }
    }

    private int readBackwards() throws BadLocationException {
        while (this.myOffset > 0) {
            --this.myOffset;
            this.handleSingleLineComment();
            char current = this.myDocument.getChar(this.myOffset);
            switch (current) {
                case '/': {
                    char next;
                    if (this.mySkipComments && this.myOffset > 1 && (next = this.myDocument.getChar(this.myOffset - 1)) == '*') {
                        this.myOffset -= 2;
                        this.gotoCommentStart();
                        break;
                    }
                    return current;
                }
                case '\'': {
                    if (this.mySkipStrings) {
                        --this.myOffset;
                        this.gotoStringStart(current);
                        break;
                    }
                    return current;
                }
                default: {
                    return current;
                }
            }
        }
        return -1;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        int i = off;
        while (i < end) {
            int ch = this.read();
            if (ch == -1) {
                if (i == off) {
                    return -1;
                }
                return i - off;
            }
            cbuf[i] = (char)ch;
            ++i;
        }
        return len;
    }

    public boolean ready() {
        return true;
    }

    public String getString() throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer();
        while ((ch = this.read()) != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

