/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.merge.service;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.merge.api.IMergerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MergerProviderDescriptor
implements Comparable<MergerProviderDescriptor> {
    protected final IConfigurationElement element;
    protected final String fileExtension;
    protected final String mergerProviderClassName;
    protected final String priority;
    private IMergerProvider mergerProvider;

    public MergerProviderDescriptor(IConfigurationElement configuration) {
        this.element = configuration;
        this.fileExtension = this.getAttribute("fileExtension", "*");
        this.priority = this.getAttribute("priority", "low");
        this.mergerProviderClassName = this.getAttribute("mergerProviderClass", null);
    }

    @Override
    public int compareTo(MergerProviderDescriptor other) {
        int nombre1 = other.getPriorityValue(other.getPriority());
        int nombre2 = this.getPriorityValue(this.getPriority());
        return nombre2 - nombre1;
    }

    public boolean equals(Object obj) {
        boolean isEqual = true;
        if (this == obj) {
            isEqual = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            isEqual = false;
        } else if (obj instanceof MergerProviderDescriptor) {
            MergerProviderDescriptor other = (MergerProviderDescriptor)obj;
            if (this.mergerProviderClassName == null && other.mergerProviderClassName != null) {
                isEqual = false;
            } else if (!this.mergerProviderClassName.equals(other.mergerProviderClassName)) {
                isEqual = false;
            } else if (this.fileExtension == null && other.fileExtension != null) {
                isEqual = false;
            } else if (!this.fileExtension.equals(other.fileExtension)) {
                isEqual = false;
            } else if (this.priority == null && other.priority != null) {
                isEqual = false;
            } else if (!this.priority.equals(other.priority)) {
                isEqual = false;
            }
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public IMergerProvider getMergerProviderInstance() {
        if (this.mergerProvider == null) {
            try {
                this.mergerProvider = (IMergerProvider)this.element.createExecutableExtension("mergerProviderClass");
            }
            catch (CoreException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
            }
        }
        return this.mergerProvider;
    }

    public String getPriority() {
        return this.priority.toLowerCase();
    }

    public int hashCode() {
        int classNameHash = 0;
        if (this.mergerProviderClassName != null) {
            classNameHash = this.mergerProviderClassName.hashCode();
        }
        int extensionHash = 0;
        if (this.fileExtension != null) {
            extensionHash = this.fileExtension.hashCode();
        }
        int priorityHash = 0;
        if (this.priority != null) {
            priorityHash = this.priority.hashCode();
        }
        return ((31 + classNameHash) * 31 + extensionHash) * 31 + priorityHash;
    }

    int getPriorityValue(String priorityString) {
        if (priorityString == null) {
            throw new IllegalArgumentException(EMFCompareDiffMessages.getString("Descriptor.IllegalPriority"));
        }
        int priorityValue = 3;
        if (priorityString.equals("lowest")) {
            priorityValue = 1;
        } else if (priorityString.equals("low")) {
            priorityValue = 2;
        } else if (priorityString.equals("high")) {
            priorityValue = 4;
        } else if (priorityString.equals("highest")) {
            priorityValue = 5;
        }
        return priorityValue;
    }

    private String getAttribute(String name, String defaultValue) {
        String value = this.element.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(EMFCompareDiffMessages.getString("Descriptor.MissingAttribute", name));
    }
}

