/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.service;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.api.IDiffEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EngineDescriptor
implements Comparable<EngineDescriptor> {
    protected final IConfigurationElement element;
    protected final String engineClassName;
    protected final String fileExtension;
    protected final String priority;
    private IDiffEngine engine;

    public EngineDescriptor(IConfigurationElement configuration) {
        this.element = configuration;
        this.fileExtension = this.getAttribute("fileExtension", "*");
        this.priority = this.getAttribute("priority", "low");
        this.engineClassName = this.getAttribute("engineClass", null);
    }

    @Override
    public int compareTo(EngineDescriptor other) {
        int nombre1 = this.getPriorityValue(other.getPriority());
        int nombre2 = this.getPriorityValue(this.getPriority());
        return nombre2 - nombre1;
    }

    public boolean equals(Object obj) {
        boolean isEqual = true;
        if (this == obj) {
            isEqual = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            isEqual = false;
        } else {
            EngineDescriptor other = (EngineDescriptor)obj;
            if (this.engineClassName == null && other.engineClassName != null) {
                isEqual = false;
            } else if (!this.engineClassName.equals(other.engineClassName)) {
                isEqual = false;
            } else if (this.fileExtension == null && other.fileExtension != null) {
                isEqual = false;
            } else if (!this.fileExtension.equals(other.fileExtension)) {
                isEqual = false;
            } else if (this.priority == null && other.priority != null) {
                isEqual = false;
            } else if (!this.priority.equals(other.priority)) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public IDiffEngine getEngineInstance() {
        if (this.engine == null) {
            try {
                this.engine = (IDiffEngine)this.element.createExecutableExtension("engineClass");
            }
            catch (CoreException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
            }
        }
        this.engine.reset();
        return this.engine;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getPriority() {
        return this.priority.toLowerCase();
    }

    public int hashCode() {
        int classNameHash = 0;
        if (this.engineClassName != null) {
            classNameHash = this.engineClassName.hashCode();
        }
        int extensionHash = 0;
        if (this.fileExtension != null) {
            extensionHash = this.fileExtension.hashCode();
        }
        int priorityHash = 0;
        if (this.priority != null) {
            priorityHash = this.priority.hashCode();
        }
        return ((31 + classNameHash) * 31 + extensionHash) * 31 + priorityHash;
    }

    private String getAttribute(String name, String defaultValue) {
        String value = this.element.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(EMFCompareDiffMessages.getString("Descriptor.MissingAttribute", name));
    }

    private int getPriorityValue(String priorityString) {
        if (priorityString == null) {
            throw new IllegalArgumentException(EMFCompareDiffMessages.getString("Descriptor.IllegalPriority"));
        }
        int priorityValue = 3;
        if (priorityString.equals("lowest")) {
            priorityValue = 1;
        } else if (priorityString.equals("low")) {
            priorityValue = 2;
        } else if (priorityString.equals("high")) {
            priorityValue = 4;
        } else if (priorityString.equals("highest")) {
            priorityValue = 5;
        }
        return priorityValue;
    }
}

