/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.EMFCompareException;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.osgi.framework.BundleContext;

public class EMFComparePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.compare";
    private static EMFComparePlugin plugin;

    public EMFComparePlugin() {
        plugin = this;
    }

    public static EMFComparePlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e, boolean blocker) {
        if (e == null) {
            throw new NullPointerException(EMFCompareMessages.getString("EMFComparePlugin.LogNullException"));
        }
        if (plugin == null) {
            e.printStackTrace();
        } else if (e instanceof CoreException) {
            EMFComparePlugin.log(((CoreException)e).getStatus());
        } else if (e instanceof NullPointerException) {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            EMFComparePlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, EMFCompareMessages.getString("EMFComparePlugin.ElementNotFound"), (Throwable)e));
        } else {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            EMFComparePlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, EMFCompareMessages.getString("EMFComparePlugin.JavaException"), (Throwable)e));
        }
    }

    public static void log(IStatus status) {
        if (status == null) {
            throw new NullPointerException(EMFCompareMessages.getString("EMFComparePlugin.LogNullStatus"));
        }
        if (EMFComparePlugin.getDefault() == null) {
            throw new EMFCompareException(status.getException());
        }
        EMFComparePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, boolean blocker) {
        if (plugin == null) {
            System.err.println(message);
        } else {
            String errorMessage;
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            if ((errorMessage = message) == null || errorMessage.equals("")) {
                errorMessage = EMFCompareMessages.getString("EMFComparePlugin.UnexpectedException");
            }
            EMFComparePlugin.log((IStatus)new Status(severity, PLUGIN_ID, errorMessage));
        }
    }

    public boolean getBoolean(String preferenceKey) {
        return plugin.getPluginPreferences().getBoolean(preferenceKey);
    }

    public int getInt(String preferenceKey) {
        return plugin.getPluginPreferences().getInt(preferenceKey);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

