/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.util;

import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.match.metamodel.Match3Element;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.compare.util.ClassUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.swt.graphics.Image;

public final class EMFCompareEObjectUtils {
    private static AdapterFactoryLabelProvider labelProvider;

    private EMFCompareEObjectUtils() {
    }

    public static Image computeObjectImage(EObject eObject) {
        return EMFCompareEObjectUtils.getLabelProvider().getImage((Object)eObject);
    }

    public static String computeObjectName(EObject eObject) {
        String objectName = EMFCompareEObjectUtils.getLabelProvider().getText((Object)eObject);
        if (objectName == null || objectName.equals("")) {
            objectName = EMFCompareUIMessages.getString("EMFCompareEObjectUtils.undefinedName");
        }
        return objectName;
    }

    public static EObject getAncestorElement(EObject object) {
        EObject ancestorElement = null;
        if (object instanceof ConflictingDiffElement) {
            ancestorElement = ((ConflictingDiffElement)object).getOriginElement();
        } else if (object instanceof Match3Element) {
            ancestorElement = ((Match3Element)object).getOriginElement();
        }
        return ancestorElement;
    }

    public static EObject getLeftElement(EObject object) {
        EObject leftElement = null;
        leftElement = (EObject)ClassUtils.invokeMethod((Object)object, (String)"getLeftElement", (Object[])new Object[0]);
        if (leftElement == null) {
            leftElement = (EObject)ClassUtils.invokeMethod((Object)object, (String)"getLeftParent", (Object[])new Object[0]);
        }
        return leftElement;
    }

    public static EObject getRightElement(EObject object) {
        EObject rightElement = null;
        rightElement = (EObject)ClassUtils.invokeMethod((Object)object, (String)"getRightElement", (Object[])new Object[0]);
        if (rightElement == null) {
            rightElement = (EObject)ClassUtils.invokeMethod((Object)object, (String)"getRightParent", (Object[])new Object[0]);
        }
        return rightElement;
    }

    private static AdapterFactoryLabelProvider getLabelProvider() {
        if (labelProvider == null) {
            labelProvider = new AdapterFactoryLabelProvider(AdapterUtils.getAdapterFactory());
        }
        return labelProvider;
    }
}

