/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.content.part.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.UnMatchElement;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.util.EMFCompareEObjectUtils;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.content.part.IModelContentMergeViewerTab;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabFolder;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabItem;
import org.eclipse.emf.compare.ui.viewer.content.part.property.PropertyContentProvider;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelContentMergePropertyTab
extends TableViewer
implements IModelContentMergeViewerTab {
    protected final int partSide;
    private final Map<String, ModelContentMergeTabItem> dataToItem = new EMFCompareMap();
    private final List<DiffElement> differences = new ArrayList<DiffElement>();
    private final ModelContentMergeTabFolder parent;

    public ModelContentMergePropertyTab(Composite parentComposite, int side, ModelContentMergeTabFolder parentFolder) {
        super(parentComposite, 0);
        this.partSide = side;
        this.parent = parentFolder;
        this.setContentProvider((IContentProvider)new PropertyContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider(AdapterUtils.getAdapterFactory()));
        this.getTable().addPaintListener((PaintListener)new PropertyPaintListener());
        this.setUseHashlookup(true);
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        GC gc = new GC((Drawable)this.getTable());
        gc.setFont(this.getTable().getFont());
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        TableColumn nameColumn = new TableColumn(this.getTable(), 16384);
        nameColumn.setText(EMFCompareUIMessages.getString("ModelContentMergePropertyPart.column1.name"));
        nameColumn.setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)metrics, (int)(nameColumn.getText().length() * 3)));
        TableColumn weightsColumn = new TableColumn(this.getTable(), 131072);
        weightsColumn.setText(EMFCompareUIMessages.getString("ModelContentMergePropertyPart.column2.name"));
        weightsColumn.setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)metrics, (int)(weightsColumn.getText().length() * 3)));
        this.mapDifferences();
    }

    @Override
    public void dispose() {
        this.dataToItem.clear();
        this.differences.clear();
        this.getTable().dispose();
    }

    public TableItem find(DiffElement diff) {
        ReferenceChange theDiff;
        EObject inputEObject = ((PropertyContentProvider)this.getContentProvider()).getInputEObject();
        TableItem item = null;
        if (diff instanceof AttributeChange) {
            AttributeChange theDiff2 = (AttributeChange)diff;
            if (theDiff2.getLeftElement() == inputEObject || theDiff2.getRightElement() == inputEObject) {
                item = (TableItem)this.findItem(theDiff2.getAttribute());
            }
        } else if (diff instanceof ReferenceChange && ((theDiff = (ReferenceChange)diff).getLeftElement() == inputEObject || theDiff.getRightElement() == inputEObject)) {
            item = (TableItem)this.findItem(theDiff.getReference());
        }
        return item;
    }

    @Override
    public List<? extends Item> getSelectedElements() {
        ArrayList<TableItem> result = new ArrayList<TableItem>();
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            List list = this.getSelectionFromWidget();
            for (Object o : list) {
                Widget w = this.findItem(o);
                if (!(w instanceof TableItem)) continue;
                result.add((TableItem)w);
            }
        }
        return result;
    }

    public int getSide() {
        return this.partSide;
    }

    public int getTotalColumnsWidth() {
        int width = 0;
        TableColumn[] tableColumnArray = this.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            width += col.getWidth();
            ++n2;
        }
        return width;
    }

    @Override
    public ModelContentMergeTabItem getUIItem(EObject data) {
        ModelContentMergeTabItem item;
        EObject element = this.getInput() instanceof UnMatchElement ? ((UnMatchElement)this.getInput()).getElement() : (this.partSide == 1 ? ((Match2Elements)this.getInput()).getLeftElement() : ((Match2Elements)this.getInput()).getRightElement());
        String key = EcoreUtil.getURI((EObject)element).fragment();
        String[] fragments = EcoreUtil.getURI((EObject)data).fragment().split("/");
        if (fragments.length > 0) {
            key = String.valueOf(key) + '/' + fragments[fragments.length - 1];
        }
        if ((item = this.dataToItem.get(key)) != null) {
            if (this.getSelectedElements().contains(item.getActualItem())) {
                item.setCurveSize(2);
            } else {
                item.setCurveSize(1);
            }
            item.setCurveY(((TableItem)item.getActualItem()).getBounds().y + ((TableItem)item.getActualItem()).getBounds().height / 2);
        }
        return item;
    }

    @Override
    public List<ModelContentMergeTabItem> getVisibleElements() {
        if (this.dataToItem.size() > 0 && this.dataToItem.values().iterator().next().getActualItem().isDisposed()) {
            this.mapTableItems();
        }
        ArrayList<ModelContentMergeTabItem> result = new ArrayList<ModelContentMergeTabItem>();
        for (String data : this.dataToItem.keySet()) {
            EObject element;
            if (!data.startsWith(EcoreUtil.getURI((EObject)(element = this.getInput() instanceof UnMatchElement ? ((UnMatchElement)this.getInput()).getElement() : (this.partSide == 1 ? ((Match2Elements)this.getInput()).getLeftElement() : ((Match2Elements)this.getInput()).getRightElement()))).fragment())) continue;
            ModelContentMergeTabItem next = this.dataToItem.get(data);
            TableItem nextTableItem = (TableItem)next.getActualItem();
            if (nextTableItem.getBounds().y < this.getTable().getClientArea().y || nextTableItem.getBounds().y > this.getTable().getClientArea().y + this.getTable().getClientArea().height) continue;
            if (this.getSelectedElements().contains(nextTableItem)) {
                next.setCurveSize(2);
            } else {
                next.setCurveSize(1);
            }
            next.setCurveY(nextTableItem.getBounds().y + nextTableItem.getBounds().height / 2);
            next.setHeaderHeight(this.getTable().getHeaderHeight());
            result.add(next);
        }
        return result;
    }

    @Override
    public void redraw() {
        this.getTable().redraw();
    }

    public void refresh(Object element, boolean updateLabels) {
        super.refresh(element, updateLabels);
        this.mapDifferences();
        this.mapTableItems();
    }

    @Override
    public void setReflectiveInput(Object input) {
        this.setInput(input);
        this.mapDifferences();
        this.mapTableItems();
    }

    public void showItem(DiffElement diff) {
        TableItem elementItem = this.find(diff);
        if (elementItem != null) {
            this.getTable().setSelection(elementItem);
        }
    }

    @Override
    public void showItems(List<DiffElement> items) {
        if (items.size() > 0) {
            this.showItem(items.get(0));
        }
    }

    protected void associate(Object element, Item item) {
        if (element instanceof Object[]) {
            Object data = item.getData();
            if (data != ((Object[])element)[0]) {
                if (data != null) {
                    this.disassociate(item);
                }
                item.setData(((Object[])element)[0]);
            }
            this.mapElement(((Object[])element)[0], (Widget)item);
        } else if (element instanceof List) {
            Object data = item.getData();
            if (data != ((List)element).get(0)) {
                if (data != null) {
                    this.disassociate(item);
                }
                item.setData(((List)element).get(0));
            }
            this.mapElement(((List)element).get(0), (Widget)item);
        } else {
            super.associate(element, item);
        }
    }

    private void mapDifferences() {
        this.differences.clear();
        for (DiffElement diff : this.parent.getDiffAsList()) {
            if (!(diff instanceof ReferenceChange) && !(diff instanceof AttributeChange)) continue;
            this.differences.add(diff);
        }
    }

    private void mapTableItems() {
        this.dataToItem.clear();
        int i = 0;
        while (i < this.differences.size()) {
            DiffElement diff = this.differences.get(i);
            Object data = diff instanceof ReferenceChange ? ((ReferenceChange)diff).getReference() : ((AttributeChange)diff).getAttribute();
            TableItem item = (TableItem)this.findItem(data);
            if (item != null) {
                ModelContentMergeTabItem wrappedItem = new ModelContentMergeTabItem((Item)item, "changed.color");
                String key = "";
                if (this.partSide == 1) {
                    key = EcoreUtil.getURI((EObject)EMFCompareEObjectUtils.getLeftElement((EObject)diff)).fragment();
                } else if (this.partSide == 2) {
                    key = EcoreUtil.getURI((EObject)EMFCompareEObjectUtils.getRightElement((EObject)diff)).fragment();
                }
                String[] fragments = EcoreUtil.getURI((EObject)data).fragment().split("/");
                key = String.valueOf(key) + '/' + fragments[fragments.length - 1];
                this.dataToItem.put(key, wrappedItem);
            }
            ++i;
        }
    }

    private class PropertyLabelProvider
    extends AdapterFactoryLabelProvider {
        public PropertyLabelProvider(AdapterFactory theAdapterFactory) {
            super(theAdapterFactory);
        }

        public Image getColumnImage(Object object, int columnIndex) {
            Image image = super.getColumnImage(object, columnIndex);
            if (object instanceof List) {
                image = super.getColumnImage(((List)object).get(columnIndex), columnIndex);
            }
            return image;
        }

        public String getColumnText(Object object, int columnIndex) {
            String text = super.getColumnText(object, columnIndex);
            if (object instanceof List) {
                text = super.getColumnText(((List)object).get(columnIndex), columnIndex);
            }
            return text;
        }
    }

    class PropertyPaintListener
    implements PaintListener {
        PropertyPaintListener() {
        }

        public void paintControl(PaintEvent event) {
            if (ModelContentMergeViewer.shouldDrawDiffMarkers()) {
                for (ModelContentMergeTabItem item : ModelContentMergePropertyTab.this.getVisibleElements()) {
                    this.drawLine(event, item);
                }
            }
        }

        private void drawLine(PaintEvent event, ModelContentMergeTabItem item) {
            Rectangle tableBounds = ModelContentMergePropertyTab.this.getTable().getBounds();
            ((TableItem)item.getActualItem()).setBackground(new Color((Device)ModelContentMergePropertyTab.this.getControl().getDisplay(), ModelContentMergeViewer.getColor("highlight.color")));
            event.gc.setLineWidth(2);
            event.gc.setForeground(new Color((Device)item.getActualItem().getDisplay(), ModelContentMergeViewer.getColor(item.getCurveColor())));
            if (ModelContentMergePropertyTab.this.partSide == 1) {
                event.gc.drawLine(ModelContentMergePropertyTab.this.getTotalColumnsWidth(), item.getCurveY(), tableBounds.width, item.getCurveY());
            }
        }
    }
}

