/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.match.EMFCompareMatchMessages;
import org.eclipse.emf.compare.match.engine.AbstractSimilarityChecker;
import org.eclipse.emf.compare.match.engine.IMatchEngine;
import org.eclipse.emf.compare.match.engine.IMatchScope;
import org.eclipse.emf.compare.match.engine.IMatchScopeProvider;
import org.eclipse.emf.compare.match.engine.MatchScopeProviderUtil;
import org.eclipse.emf.compare.match.engine.MatchSettings;
import org.eclipse.emf.compare.match.engine.internal.DistinctEcoreSimilarityChecker;
import org.eclipse.emf.compare.match.engine.internal.EcoreIDSimilarityChecker;
import org.eclipse.emf.compare.match.engine.internal.GenericMatchEngineToCheckerBridge;
import org.eclipse.emf.compare.match.engine.internal.StatisticBasedSimilarityChecker;
import org.eclipse.emf.compare.match.engine.internal.XMIIDSimilarityChecker;
import org.eclipse.emf.compare.match.internal.statistic.NameSimilarity;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.compare.match.statistic.MetamodelFilter;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMatchEngine
implements IMatchEngine {
    private static final String MATCH_ELEMENT_NAME = "matchedElements";
    private static final String SUBMATCH_ELEMENT_NAME = "subMatchElements";
    private static final String UNMATCH_ELEMENT_NAME = "unmatchedElements";
    protected MetamodelFilter filter = new MetamodelFilter();
    @Deprecated
    protected Map<String, Object> options = new EMFCompareMap();
    private MatchSettings structuredOptions;
    private final Set<EObject> remainingUnmatchedElements = new HashSet<EObject>();
    private final List<EObject> stillToFindFromModel1 = new ArrayList<EObject>();
    private final List<EObject> stillToFindFromModel2 = new ArrayList<EObject>();
    private AbstractSimilarityChecker checker;
    private List<Match2Elements> externalRefMappings = new ArrayList<Match2Elements>();

    public GenericMatchEngine() {
        this.structuredOptions = new MatchSettings();
    }

    @Override
    public MatchModel contentMatch(EObject leftObject, EObject rightObject, EObject ancestor, Map<String, Object> optionMap) {
        this.updateSettings(this.structuredOptions, optionMap);
        this.checker = this.prepareChecker();
        IMatchScopeProvider scopeProvider = MatchScopeProviderUtil.getScopeProvider(optionMap, leftObject, rightObject, ancestor);
        IMatchScope leftScope = scopeProvider.getLeftScope();
        IMatchScope rightScope = scopeProvider.getRightScope();
        IMatchScope ancestorScope = scopeProvider.getAncestorScope();
        MatchModel result = null;
        if (leftScope.isInScope(leftObject) && rightScope.isInScope(rightObject) && ancestorScope.isInScope(ancestor)) {
            result = this.doContentMatch(leftObject, leftScope, rightObject, rightScope, ancestor, ancestorScope);
        }
        return result;
    }

    private MatchModel doContentMatch(EObject leftObject, IMatchScope leftScope, EObject rightObject, IMatchScope rightScope, EObject ancestor, IMatchScope ancestorScope) {
        MatchModel root = null;
        if (leftScope.isInScope(leftObject) && rightScope.isInScope(rightObject) && ancestorScope.isInScope(ancestor)) {
            root = MatchFactory.eINSTANCE.createMatchModel();
            this.setModelRoots(root, leftObject, rightObject, ancestor);
            Monitor monitor = this.createProgressMonitor();
            MatchModel leftObjectAncestorMatch = this.doContentMatch(leftObject, leftScope, ancestor, ancestorScope);
            leftObjectAncestorMatch.getMatchedElements().removeAll(this.externalRefMappings);
            ArrayList<Match2Elements> leftExternal2WayMappings = new ArrayList<Match2Elements>(this.externalRefMappings);
            MatchModel rightObjectAncestorMatch = this.doContentMatch(rightObject, rightScope, ancestor, ancestorScope);
            rightObjectAncestorMatch.getMatchedElements().removeAll(this.externalRefMappings);
            ArrayList<Match2Elements> rightExternal2WayMappings = new ArrayList<Match2Elements>(this.externalRefMappings);
            ArrayList<MatchElement> leftObjectMatchedElements = new ArrayList<MatchElement>((Collection<MatchElement>)leftObjectAncestorMatch.getMatchedElements());
            ArrayList<MatchElement> rightObjectMatchedElements = new ArrayList<MatchElement>((Collection<MatchElement>)rightObjectAncestorMatch.getMatchedElements());
            for (Object unmatch : leftObjectAncestorMatch.getUnmatchedElements()) {
                this.remainingUnmatchedElements.add(((UnmatchElement)unmatch).getElement());
            }
            for (Object unmatch : rightObjectAncestorMatch.getUnmatchedElements()) {
                this.remainingUnmatchedElements.add(((UnmatchElement)unmatch).getElement());
            }
            try {
                Match3Elements subMatchRoot = null;
                if (leftObjectMatchedElements.size() > 0 && rightObjectMatchedElements.size() > 0) {
                    Match2Elements leftObjectMatchRoot = (Match2Elements)leftObjectMatchedElements.get(0);
                    Match2Elements rightObjectMatchRoot = (Match2Elements)rightObjectMatchedElements.get(0);
                    subMatchRoot = MatchFactory.eINSTANCE.createMatch3Elements();
                    subMatchRoot.setSimilarity(this.set3WaySimilarity(leftObjectMatchRoot.getLeftElement(), rightObjectMatchRoot.getLeftElement(), rightObjectMatchRoot.getRightElement()));
                    subMatchRoot.setLeftElement(leftObjectMatchRoot.getLeftElement());
                    subMatchRoot.setRightElement(rightObjectMatchRoot.getLeftElement());
                    subMatchRoot.setOriginElement(rightObjectMatchRoot.getRightElement());
                    this.redirectedAdd(root, MATCH_ELEMENT_NAME, subMatchRoot);
                    this.createSub3Match(root, subMatchRoot, leftObjectMatchRoot, rightObjectMatchRoot);
                } else {
                    for (EObject left : leftObjectMatchedElements) {
                        this.stillToFindFromModel1.add(left);
                    }
                    for (EObject right : rightObjectMatchedElements) {
                        this.stillToFindFromModel2.add(right);
                    }
                }
                this.processNotFoundElements(root, subMatchRoot);
                HashSet<EObject> remainingLeft = new HashSet<EObject>();
                HashSet<EObject> remainingRight = new HashSet<EObject>();
                for (EObject unmatched : this.remainingUnmatchedElements) {
                    Object iterator;
                    if (unmatched.eResource() == leftObject.eResource()) {
                        remainingLeft.add(unmatched);
                        iterator = unmatched.eAllContents();
                        while (iterator.hasNext()) {
                            remainingLeft.add((EObject)iterator.next());
                        }
                        continue;
                    }
                    if (unmatched.eResource() != rightObject.eResource()) continue;
                    remainingRight.add(unmatched);
                    iterator = unmatched.eAllContents();
                    while (iterator.hasNext()) {
                        remainingRight.add((EObject)iterator.next());
                    }
                }
                this.stillToFindFromModel1.clear();
                this.stillToFindFromModel2.clear();
                List<Match2Elements> mappings = this.mapLists(new ArrayList<EObject>(remainingLeft), new ArrayList<EObject>(remainingRight), this.structuredOptions.getSearchWindow(), monitor);
                for (Match2Elements map : mappings) {
                    Match3Elements subMatch = MatchFactory.eINSTANCE.createMatch3Elements();
                    subMatch.setLeftElement(map.getLeftElement());
                    subMatch.setRightElement(map.getRightElement());
                    if (subMatchRoot == null) {
                        this.redirectedAdd(root, MATCH_ELEMENT_NAME, subMatch);
                        continue;
                    }
                    this.redirectedAdd(subMatchRoot, SUBMATCH_ELEMENT_NAME, subMatch);
                }
                EMFCompareMap unmatchedElements = new EMFCompareMap();
                for (EObject unmatch : this.stillToFindFromModel1) {
                    unmatchedElements.put(unmatch, false);
                    this.createThreeWayUnmatchElements(root, (Map<EObject, Boolean>)unmatchedElements, true);
                }
                unmatchedElements.clear();
                for (EObject remoteUnmatch : this.stillToFindFromModel2) {
                    unmatchedElements.put(remoteUnmatch, true);
                    this.createThreeWayUnmatchElements(root, (Map<EObject, Boolean>)unmatchedElements, false);
                }
            }
            catch (FactoryException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
            }
            catch (InterruptedException interruptedException) {}
            this.create3WayMatches(leftExternal2WayMappings, rightExternal2WayMappings);
        }
        return root;
    }

    protected AbstractSimilarityChecker prepareChecker() {
        AbstractSimilarityChecker checker = null;
        GenericMatchEngineToCheckerBridge bridge = new GenericMatchEngineToCheckerBridge(){

            public double nameSimilarity(EObject obj1, EObject obj2) {
                return GenericMatchEngine.this.nameSimilarity(obj1, obj2);
            }

            public double contentSimilarity(EObject obj1, EObject obj2) throws FactoryException {
                return GenericMatchEngine.this.contentSimilarity(obj1, obj2);
            }
        };
        checker = !this.structuredOptions.shouldMatchDistinctMetamodels() ? new DistinctEcoreSimilarityChecker(this.filter, bridge) : new StatisticBasedSimilarityChecker(this.filter, bridge);
        if (!this.structuredOptions.isIgnoringID()) {
            checker = new EcoreIDSimilarityChecker(this.filter, checker);
            this.disableMetamodelFilter();
        }
        if (!this.structuredOptions.isIgnoringXMIID()) {
            checker = new XMIIDSimilarityChecker(this.filter, checker);
            this.disableMetamodelFilter();
        }
        return checker;
    }

    private void disableMetamodelFilter() {
        this.filter = new MetamodelFilter(){

            @Override
            public void analyseModel(EObject root) {
            }

            @Override
            public List<EStructuralFeature> getFilteredFeatures(EObject eObj) {
                return eObj.eClass().getEAllStructuralFeatures();
            }
        };
    }

    protected void updateSettings(MatchSettings settings, Map<String, Object> optionMap) {
        if (optionMap != null && optionMap.size() > 0) {
            settings.update(optionMap);
        }
    }

    @Override
    public MatchModel contentMatch(EObject leftObject, EObject rightObject, Map<String, Object> optionMap) {
        this.externalRefMappings.clear();
        this.updateSettings(this.structuredOptions, optionMap);
        this.checker = this.prepareChecker();
        IMatchScopeProvider scopeProvider = MatchScopeProviderUtil.getScopeProvider(optionMap, leftObject, rightObject);
        IMatchScope leftScope = scopeProvider.getLeftScope();
        IMatchScope rightScope = scopeProvider.getRightScope();
        MatchModel result = null;
        if (leftScope.isInScope(leftObject) && rightScope.isInScope(rightObject)) {
            result = this.doContentMatch(leftObject, leftScope, rightObject, rightScope);
        }
        return result;
    }

    private MatchModel doContentMatch(EObject leftObject, IMatchScope leftScope, EObject rightObject, IMatchScope rightScope) {
        Monitor monitor = this.createProgressMonitor();
        MatchModel root = null;
        if (leftScope.isInScope(leftObject) && rightScope.isInScope(rightObject)) {
            root = MatchFactory.eINSTANCE.createMatchModel();
            this.setModelRoots(root, leftObject, rightObject);
            HashSet<EObject> still1 = new HashSet<EObject>();
            HashSet<EObject> still2 = new HashSet<EObject>();
            try {
                this.checker.init(leftObject, rightObject);
                if (this.isSimilar(leftObject, rightObject)) {
                    this.stillToFindFromModel1.clear();
                    this.stillToFindFromModel2.clear();
                    Match2Elements matchModelRoot = this.recursiveMappings(leftObject, leftScope, rightObject, rightScope, monitor);
                    this.redirectedAdd(root, MATCH_ELEMENT_NAME, matchModelRoot);
                    this.createSubMatchElements(matchModelRoot, new ArrayList<EObject>(this.stillToFindFromModel1), leftScope, new ArrayList<EObject>(this.stillToFindFromModel2), rightScope, monitor);
                    still1.addAll(this.stillToFindFromModel1);
                    still2.addAll(this.stillToFindFromModel2);
                    this.createUnmatchElements(root, still1, true, false);
                    this.createUnmatchElements(root, still2, false, false);
                } else {
                    still1.add(leftObject);
                    still2.add(rightObject);
                    this.createUnmatchElements(root, still1, true, false);
                    this.createUnmatchElements(root, still2, false, false);
                }
            }
            catch (FactoryException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
            }
            catch (InterruptedException interruptedException) {}
            root.getMatchedElements().addAll(this.externalRefMappings);
        }
        return root;
    }

    @Override
    public MatchModel modelMatch(EObject leftRoot, EObject rightRoot, EObject ancestor, Map<String, Object> optionMap) throws InterruptedException {
        this.updateSettings(this.structuredOptions, optionMap);
        this.checker = this.prepareChecker();
        MatchModel result = null;
        Monitor monitor = this.createProgressMonitor();
        int size = 1;
        for (EObject root : leftRoot.eResource().getContents()) {
            TreeIterator rootContent = root.eAllContents();
            while (rootContent.hasNext()) {
                rootContent.next();
                ++size;
            }
        }
        this.startMonitor(monitor, size << 1);
        IMatchScopeProvider scopeProvider = MatchScopeProviderUtil.getScopeProvider(optionMap, leftRoot.eResource(), rightRoot.eResource(), ancestor.eResource());
        IMatchScope leftScope = scopeProvider.getLeftScope();
        IMatchScope rightScope = scopeProvider.getRightScope();
        IMatchScope ancestorScope = scopeProvider.getAncestorScope();
        if (leftScope.isInScope(leftRoot.eResource()) && rightScope.isInScope(rightRoot.eResource()) && ancestorScope.isInScope(ancestor.eResource())) {
            result = this.doMatch(leftRoot.eResource(), leftScope, rightRoot.eResource(), rightScope, ancestor.eResource(), ancestorScope, monitor);
        }
        return result;
    }

    @Override
    public MatchModel modelMatch(EObject leftRoot, EObject rightRoot, Map<String, Object> optionMap) throws InterruptedException {
        this.updateSettings(this.structuredOptions, optionMap);
        this.checker = this.prepareChecker();
        MatchModel result = null;
        Monitor monitor = this.createProgressMonitor();
        int size = 1;
        if (leftRoot.eResource() != null && rightRoot.eResource() != null) {
            for (EObject root : leftRoot.eResource().getContents()) {
                TreeIterator rootContent = root.eAllContents();
                while (rootContent.hasNext()) {
                    rootContent.next();
                    ++size;
                }
            }
            this.startMonitor(monitor, size);
            IMatchScopeProvider scopeProvider = MatchScopeProviderUtil.getScopeProvider(optionMap, leftRoot.eResource(), rightRoot.eResource());
            IMatchScope leftScope = scopeProvider.getLeftScope();
            IMatchScope rightScope = scopeProvider.getRightScope();
            if (leftScope.isInScope(leftRoot.eResource()) && rightScope.isInScope(rightRoot.eResource())) {
                result = this.doMatch(leftRoot.eResource(), leftScope, rightRoot.eResource(), rightScope, monitor);
            }
        } else {
            TreeIterator rootContent = leftRoot.eAllContents();
            while (rootContent.hasNext()) {
                rootContent.next();
                ++size;
            }
            this.startMonitor(monitor, size);
            IMatchScope alwaysInScope = new IMatchScope(){

                public boolean isInScope(Resource resource) {
                    return true;
                }

                public boolean isInScope(EObject eObject) {
                    return true;
                }
            };
            result = this.doContentMatch(leftRoot, alwaysInScope, rightRoot, alwaysInScope);
        }
        return result;
    }

    @Override
    public void reset() {
        this.filter.clear();
        this.filter = new MetamodelFilter();
        this.checker = null;
        this.remainingUnmatchedElements.clear();
        this.stillToFindFromModel1.clear();
        this.stillToFindFromModel2.clear();
        this.externalRefMappings.clear();
        this.structuredOptions = new MatchSettings();
    }

    @Override
    public MatchModel resourceMatch(Resource leftResource, Resource rightResource, Map<String, Object> optionMap) throws InterruptedException {
        this.updateSettings(this.structuredOptions, optionMap);
        this.checker = this.prepareChecker();
        MatchModel result = null;
        Monitor monitor = this.createProgressMonitor();
        int size = 1;
        for (EObject root : leftResource.getContents()) {
            TreeIterator rootContent = root.eAllContents();
            while (rootContent.hasNext()) {
                rootContent.next();
                ++size;
            }
        }
        IMatchScopeProvider scopeProvider = MatchScopeProviderUtil.getScopeProvider(optionMap, leftResource, rightResource);
        IMatchScope leftScope = scopeProvider.getLeftScope();
        IMatchScope rightScope = scopeProvider.getRightScope();
        this.startMonitor(monitor, size);
        if (leftScope.isInScope(leftResource) && rightScope.isInScope(rightResource)) {
            result = this.doMatch(leftResource, leftScope, rightResource, rightScope, monitor);
        }
        return result;
    }

    @Override
    public MatchModel resourceMatch(Resource leftResource, Resource rightResource, Resource ancestorResource, Map<String, Object> optionMap) throws InterruptedException {
        this.updateSettings(this.structuredOptions, optionMap);
        this.checker = this.prepareChecker();
        MatchModel result = null;
        Monitor monitor = this.createProgressMonitor();
        int size = 1;
        for (EObject root : leftResource.getContents()) {
            TreeIterator rootContent = root.eAllContents();
            while (rootContent.hasNext()) {
                rootContent.next();
                ++size;
            }
        }
        this.startMonitor(monitor, size << 1);
        IMatchScopeProvider scopeProvider = MatchScopeProviderUtil.getScopeProvider(optionMap, leftResource, rightResource, ancestorResource);
        IMatchScope leftScope = scopeProvider.getLeftScope();
        IMatchScope rightScope = scopeProvider.getRightScope();
        IMatchScope ancestorScope = scopeProvider.getAncestorScope();
        if (leftScope.isInScope(leftResource) && rightScope.isInScope(rightResource) && ancestorScope.isInScope(ancestorResource)) {
            result = this.doMatch(leftResource, leftScope, rightResource, rightScope, ancestorResource, ancestorScope, monitor);
        }
        return result;
    }

    protected EObject findMostSimilar(EObject eObj, List<EObject> list) throws FactoryException {
        double max = 0.0;
        EObject resultObject = null;
        Iterator<EObject> it = list.iterator();
        while (it.hasNext() && max < 1.0) {
            double similarity;
            EObject next = it.next();
            if (!this.structuredOptions.shouldMatchDistinctMetamodels() && !EcoreUtil.equals((EObject)eObj.eClass(), (EObject)next.eClass()) || !((similarity = this.checker.absoluteMetric(eObj, next)) > max)) continue;
            max = similarity;
            resultObject = next;
        }
        return resultObject;
    }

    private Monitor createProgressMonitor() {
        BasicMonitor monitor = new BasicMonitor();
        Object delegateMonitor = this.structuredOptions.getProgressMonitor();
        if (delegateMonitor != null && EMFPlugin.IS_ECLIPSE_RUNNING) {
            monitor = EclipseModelUtils.createProgressMonitor((Object)delegateMonitor);
        }
        return monitor;
    }

    private void createSub3Match(MatchModel root, Match3Elements matchElementRoot, Match2Elements left, Match2Elements right) throws FactoryException {
        EList<MatchElement> leftSubMatches = left.getSubMatchElements();
        EList<MatchElement> rightSubMatches = right.getSubMatchElements();
        ArrayList<MatchElement> leftNotFound = new ArrayList<MatchElement>((Collection<MatchElement>)leftSubMatches);
        ArrayList<MatchElement> rightNotFound = new ArrayList<MatchElement>((Collection<MatchElement>)rightSubMatches);
        for (MatchElement nextLeft : leftSubMatches) {
            Match2Elements nextLeftMatch = (Match2Elements)nextLeft;
            Match2Elements correspondingMatch = null;
            for (MatchElement nextRight : rightNotFound) {
                Match2Elements nextRightMatch = (Match2Elements)nextRight;
                if (!nextRightMatch.getRightElement().equals(nextLeftMatch.getRightElement())) continue;
                correspondingMatch = nextRightMatch;
                break;
            }
            if (correspondingMatch == null) continue;
            Match3Elements match = MatchFactory.eINSTANCE.createMatch3Elements();
            match.setSimilarity(this.set3WaySimilarity(nextLeftMatch.getLeftElement(), correspondingMatch.getLeftElement(), correspondingMatch.getRightElement()));
            match.setLeftElement(nextLeftMatch.getLeftElement());
            match.setRightElement(correspondingMatch.getLeftElement());
            match.setOriginElement(correspondingMatch.getRightElement());
            this.redirectedAdd(matchElementRoot, SUBMATCH_ELEMENT_NAME, match);
            this.createSub3Match(root, matchElementRoot, nextLeftMatch, correspondingMatch);
            leftNotFound.remove(nextLeftMatch);
            rightNotFound.remove(correspondingMatch);
        }
        for (MatchElement nextLeftNotFound : leftNotFound) {
            this.stillToFindFromModel1.add(nextLeftNotFound);
        }
        for (MatchElement nextRightNotFound : rightNotFound) {
            this.stillToFindFromModel2.add(nextRightNotFound);
        }
    }

    private void createSubMatchElements(EObject root, List<EObject> list1, IMatchScope list1Scope, List<EObject> list2, IMatchScope list2Scope, Monitor monitor) throws FactoryException, InterruptedException {
        this.stillToFindFromModel1.clear();
        this.stillToFindFromModel2.clear();
        List<Match2Elements> mappings = this.mapLists(list1, list2, this.structuredOptions.getSearchWindow(), monitor);
        for (Match2Elements map : mappings) {
            Match2Elements match = this.recursiveMappings(map.getLeftElement(), list1Scope, map.getRightElement(), list2Scope, monitor);
            this.redirectedAdd(root, SUBMATCH_ELEMENT_NAME, match);
        }
    }

    private void createThreeWayUnmatchElements(MatchModel root, Map<EObject, Boolean> unmatchedElements, boolean leftSide) throws FactoryException {
        for (Map.Entry<EObject, Boolean> entry : unmatchedElements.entrySet()) {
            if (unmatchedElements.containsKey(entry.getKey().eContainer())) continue;
            UnmatchElement unMap = MatchFactory.eINSTANCE.createUnmatchElement();
            unMap.setElement(entry.getKey());
            if (entry.getValue().booleanValue()) {
                unMap.setRemote(true);
            }
            if (leftSide) {
                unMap.setSide(Side.LEFT);
            } else {
                unMap.setSide(Side.RIGHT);
            }
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unMap);
        }
        unmatchedElements.clear();
    }

    private void createUnmatchElements(MatchModel root, Set<EObject> unmatchedElements, boolean leftSide, boolean remote) throws FactoryException {
        for (EObject element : unmatchedElements) {
            UnmatchElement unMap = MatchFactory.eINSTANCE.createUnmatchElement();
            unMap.setElement(element);
            unMap.setRemote(remote);
            if (leftSide) {
                unMap.setSide(Side.LEFT);
            } else {
                unMap.setSide(Side.RIGHT);
            }
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unMap);
        }
        unmatchedElements.clear();
    }

    private MatchModel doMatch(Resource leftResource, IMatchScope leftScope, Resource rightResource, IMatchScope rightScope, Monitor monitor) throws InterruptedException {
        this.externalRefMappings.clear();
        MatchModel root = MatchFactory.eINSTANCE.createMatchModel();
        EObject leftRoot = null;
        EObject rightRoot = null;
        List<EObject> leftContents = this.getScopeInternalContents(leftResource, leftScope);
        List<EObject> rightContents = this.getScopeInternalContents(rightResource, rightScope);
        if (leftContents.size() > 0) {
            leftRoot = leftContents.get(0);
        }
        if (rightContents.size() > 0) {
            rightRoot = rightContents.get(0);
        }
        this.setModelRoots(root, leftRoot, rightRoot);
        this.filterUnused(leftResource);
        this.filterUnused(rightResource);
        try {
            this.checker.init(leftResource, rightResource);
            monitor.subTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.roots"));
            List<Match2Elements> matchedRoots = this.mapLists(leftContents, rightContents, this.structuredOptions.getSearchWindow(), monitor);
            this.stillToFindFromModel1.clear();
            this.stillToFindFromModel2.clear();
            ArrayList<EObject> unmatchedLeftRoots = new ArrayList<EObject>(leftContents);
            ArrayList<EObject> unmatchedRightRoots = new ArrayList<EObject>(rightContents);
            HashSet<EObject> still1 = new HashSet<EObject>();
            HashSet<EObject> still2 = new HashSet<EObject>();
            if (leftContents.size() > 0 && rightContents.size() > 0) {
                Match2Elements matchModelRoot = MatchFactory.eINSTANCE.createMatch2Elements();
                if (matchedRoots.size() == 0) {
                    Match2Elements rootMapping = MatchFactory.eINSTANCE.createMatch2Elements();
                    rootMapping.setLeftElement(leftContents.get(0));
                    EObject rightElement = this.findMostSimilar(leftContents.get(0), unmatchedRightRoots);
                    if (rightElement == null) {
                        rightElement = (EObject)unmatchedRightRoots.get(0);
                    }
                    rootMapping.setRightElement(rightElement);
                    matchedRoots.add(rootMapping);
                }
                monitor.subTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.rootsContents"));
                for (Match2Elements matchedRoot : matchedRoots) {
                    Match2Elements rootMapping = this.recursiveMappings(matchedRoot.getLeftElement(), leftScope, matchedRoot.getRightElement(), rightScope, monitor);
                    if (matchModelRoot.getLeftElement() == null) {
                        matchModelRoot = rootMapping;
                        this.redirectedAdd(root, MATCH_ELEMENT_NAME, matchModelRoot);
                    } else {
                        this.redirectedAdd(matchModelRoot, SUBMATCH_ELEMENT_NAME, rootMapping);
                    }
                    still1.removeAll(this.stillToFindFromModel1);
                    still2.removeAll(this.stillToFindFromModel2);
                    this.createSubMatchElements(rootMapping, new ArrayList<EObject>(this.stillToFindFromModel1), leftScope, new ArrayList<EObject>(this.stillToFindFromModel2), rightScope, monitor);
                    still1.addAll(this.stillToFindFromModel1);
                    still2.addAll(this.stillToFindFromModel2);
                    unmatchedLeftRoots.remove(matchedRoot.getLeftElement());
                    unmatchedRightRoots.remove(matchedRoot.getRightElement());
                }
                monitor.subTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.unmatchedRoots"));
                this.createSubMatchElements(matchModelRoot, unmatchedLeftRoots, leftScope, unmatchedRightRoots, rightScope, monitor);
            } else {
                still1.addAll(unmatchedLeftRoots);
                still2.addAll(unmatchedRightRoots);
            }
            still1.addAll(this.stillToFindFromModel1);
            still2.addAll(this.stillToFindFromModel2);
            this.createUnmatchElements(root, still1, true, false);
            this.createUnmatchElements(root, still2, false, false);
        }
        catch (FactoryException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        root.getMatchedElements().addAll(this.externalRefMappings);
        return root;
    }

    private MatchModel doMatch(Resource leftResource, IMatchScope leftScope, Resource rightResource, IMatchScope rightScope, Resource ancestorResource, IMatchScope ancestorScope, Monitor monitor) throws InterruptedException {
        MatchModel root = MatchFactory.eINSTANCE.createMatchModel();
        EObject leftRoot = null;
        EObject rightRoot = null;
        EObject ancestorRoot = null;
        List<EObject> leftContents = this.getScopeInternalContents(leftResource, leftScope);
        List<EObject> rightContents = this.getScopeInternalContents(rightResource, rightScope);
        List<EObject> ancestorContents = this.getScopeInternalContents(ancestorResource, ancestorScope);
        if (leftContents.size() > 0) {
            leftRoot = leftContents.get(0);
        }
        if (rightContents.size() > 0) {
            rightRoot = rightContents.get(0);
        }
        if (ancestorContents.size() > 0) {
            ancestorRoot = ancestorContents.get(0);
        }
        this.setModelRoots(root, leftRoot, rightRoot, ancestorRoot);
        MatchModel root1AncestorMatch = this.doMatch(leftResource, leftScope, ancestorResource, ancestorScope, monitor);
        root1AncestorMatch.getMatchedElements().removeAll(this.externalRefMappings);
        ArrayList<Match2Elements> leftExternal2WayMappings = new ArrayList<Match2Elements>(this.externalRefMappings);
        MatchModel root2AncestorMatch = this.doMatch(rightResource, rightScope, ancestorResource, ancestorScope, monitor);
        root2AncestorMatch.getMatchedElements().removeAll(this.externalRefMappings);
        ArrayList<Match2Elements> rightExternal2WayMappings = new ArrayList<Match2Elements>(this.externalRefMappings);
        ArrayList<MatchElement> root1MatchedElements = new ArrayList<MatchElement>((Collection<MatchElement>)root1AncestorMatch.getMatchedElements());
        ArrayList<MatchElement> root2MatchedElements = new ArrayList<MatchElement>((Collection<MatchElement>)root2AncestorMatch.getMatchedElements());
        for (UnmatchElement unmatch : root1AncestorMatch.getUnmatchedElements()) {
            this.remainingUnmatchedElements.add(unmatch);
        }
        for (UnmatchElement unmatch : root2AncestorMatch.getUnmatchedElements()) {
            this.remainingUnmatchedElements.add(unmatch);
        }
        try {
            Match3Elements subMatchRoot = MatchFactory.eINSTANCE.createMatch3Elements();
            if (root2MatchedElements.size() > 0) {
                Match2Elements root1Match = (Match2Elements)root1MatchedElements.get(0);
                Match2Elements root2Match = (Match2Elements)root2MatchedElements.get(0);
                subMatchRoot.setSimilarity(this.set3WaySimilarity(root1Match.getLeftElement(), root2Match.getLeftElement(), root2Match.getRightElement()));
                subMatchRoot.setLeftElement(root1Match.getLeftElement());
                subMatchRoot.setRightElement(root2Match.getLeftElement());
                subMatchRoot.setOriginElement(root2Match.getRightElement());
                this.redirectedAdd(root, MATCH_ELEMENT_NAME, subMatchRoot);
                this.createSub3Match(root, subMatchRoot, root1Match, root2Match);
            } else if (root1MatchedElements.size() > 0) {
                this.stillToFindFromModel1.add((EObject)root1MatchedElements.get(0));
            }
            this.processNotFoundElements(root, subMatchRoot);
            this.processSingleUnmatchedElements(leftResource, rightResource, root, subMatchRoot, monitor);
            this.processUnmatchedMatch2Elements(leftResource, rightResource, root, subMatchRoot);
        }
        catch (FactoryException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        root.getMatchedElements().addAll(this.create3WayMatches(leftExternal2WayMappings, rightExternal2WayMappings));
        return root;
    }

    private List<Match3Elements> create3WayMatches(List<Match2Elements> leftToAncestor, List<Match2Elements> rightToAncestor) {
        ArrayList<Match3Elements> threeWayMappings = new ArrayList<Match3Elements>();
        for (Match2Elements leftExternalMapping : leftToAncestor) {
            Match2Elements rightExternalMapping = rightToAncestor.get(leftToAncestor.indexOf(leftExternalMapping));
            Match3Elements mapping = MatchFactory.eINSTANCE.createMatch3Elements();
            mapping.setLeftElement(leftExternalMapping.getLeftElement());
            mapping.setRightElement(rightExternalMapping.getLeftElement());
            mapping.setOriginElement(rightExternalMapping.getRightElement());
            try {
                mapping.setSimilarity(this.set3WaySimilarity(mapping.getLeftElement(), mapping.getRightElement(), mapping.getOriginElement()));
            }
            catch (FactoryException factoryException) {
                mapping.setSimilarity(1.0);
            }
            threeWayMappings.add(mapping);
        }
        return threeWayMappings;
    }

    private void filterUnused(Resource resource) {
        for (EObject root : resource.getContents()) {
            this.filter.analyseModel(root);
        }
    }

    protected <T> T getOption(String key) throws ClassCastException {
        return (T)this.options.get(key);
    }

    @Deprecated
    protected boolean haveDistinctID(EObject left, EObject right) throws FactoryException {
        return this.checker.isSimilar(left, right);
    }

    @Deprecated
    protected boolean haveDistinctXMIID(EObject left, EObject right) throws FactoryException {
        return this.checker.isSimilar(left, right);
    }

    @Deprecated
    protected double nameSimilarity(EObject obj1, EObject obj2) {
        double similarity = 0.0;
        try {
            similarity = NameSimilarity.nameSimilarityMetric(NameSimilarity.findName(obj1), NameSimilarity.findName(obj2));
        }
        catch (FactoryException factoryException) {}
        return similarity;
    }

    @Deprecated
    protected double contentSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        double similarity = 0.0;
        similarity = NameSimilarity.nameSimilarityMetric(NameSimilarity.contentValue(obj1), NameSimilarity.contentValue(obj2));
        return similarity;
    }

    private List<Match2Elements> mapLists(List<EObject> list1, List<EObject> list2, int window, Monitor monitor) throws FactoryException, InterruptedException {
        ArrayList<Match2Elements> result = new ArrayList<Match2Elements>();
        int curIndex = 0 - window / 2;
        ArrayList<EObject> notFoundList1 = new ArrayList<EObject>(list1);
        ArrayList<EObject> notFoundList2 = new ArrayList<EObject>(list2);
        Iterator<EObject> it1 = list1.iterator();
        while (it1.hasNext() && notFoundList2.size() > 0) {
            EObject obj1 = it1.next();
            EObject obj2 = this.checker.fastLookup(obj1);
            if (obj2 == null) {
                EObject obj1Check;
                int end = Math.min(curIndex + window - (list2.size() - notFoundList2.size()), notFoundList2.size());
                int index = Math.min(Math.max(curIndex - (list2.size() - notFoundList2.size()), 0), end);
                obj2 = this.findMostSimilar(obj1, notFoundList2.subList(index, end));
                if (obj2 != null && (obj1Check = this.findMostSimilar(obj2, notFoundList1)) != obj1 && obj1Check != null && this.isSimilar(obj1Check, obj2)) continue;
            }
            if (notFoundList1.contains(obj1) && notFoundList2.contains(obj2) && this.isSimilar(obj1, obj2)) {
                Match2Elements mapping = MatchFactory.eINSTANCE.createMatch2Elements();
                double metric = this.checker.absoluteMetric(obj1, obj2);
                mapping.setLeftElement(obj1);
                mapping.setRightElement(obj2);
                mapping.setSimilarity(metric);
                result.add(mapping);
                notFoundList1.remove(obj1);
                notFoundList2.remove(obj2);
            }
            ++curIndex;
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
        this.stillToFindFromModel1.addAll(notFoundList1);
        this.stillToFindFromModel2.addAll(notFoundList2);
        return result;
    }

    private void processNotFoundElements(MatchModel root, Match3Elements subMatchRoot) throws FactoryException {
        for (EObject obj1 : new ArrayList<EObject>(this.stillToFindFromModel1)) {
            if (!(obj1 instanceof Match2Elements)) continue;
            Match2Elements match1 = (Match2Elements)obj1;
            for (EObject obj2 : new ArrayList<EObject>(this.stillToFindFromModel2)) {
                if (!(obj2 instanceof Match2Elements)) continue;
                Match2Elements match2 = (Match2Elements)obj2;
                if (match1.getRightElement() != match2.getRightElement()) continue;
                Match3Elements match = MatchFactory.eINSTANCE.createMatch3Elements();
                match.setSimilarity(this.set3WaySimilarity(match1.getLeftElement(), match2.getLeftElement(), match2.getRightElement()));
                match.setLeftElement(match1.getLeftElement());
                match.setRightElement(match2.getLeftElement());
                match.setOriginElement(match2.getRightElement());
                if (subMatchRoot == null) {
                    this.redirectedAdd(root, MATCH_ELEMENT_NAME, match);
                    this.createSub3Match(root, match, match1, match2);
                } else {
                    this.redirectedAdd(subMatchRoot, SUBMATCH_ELEMENT_NAME, match);
                    this.createSub3Match(root, subMatchRoot, match1, match2);
                }
                this.stillToFindFromModel1.remove(match1);
                this.stillToFindFromModel2.remove(match2);
            }
        }
        for (EObject eObj : new ArrayList<EObject>(this.stillToFindFromModel1)) {
            if (!(eObj instanceof Match2Elements)) continue;
            this.remainingUnmatchedElements.add(eObj);
        }
        for (EObject eObj : new ArrayList<EObject>(this.stillToFindFromModel2)) {
            if (!(eObj instanceof Match2Elements)) continue;
            this.remainingUnmatchedElements.add(eObj);
        }
    }

    private double set3WaySimilarity(EObject left, EObject right, EObject ancestor) throws FactoryException {
        double metric1 = this.checker.absoluteMetric(left, right);
        double metric2 = this.checker.absoluteMetric(left, ancestor);
        double metric3 = this.checker.absoluteMetric(right, ancestor);
        return (metric1 + metric2 + metric3) / 3.0;
    }

    private void processUnmatchedMatch2Elements(Resource leftResource, Resource rightResource, MatchModel root, Match3Elements subMatchRoot) throws FactoryException {
        UnmatchElement unmatch;
        HashSet<Match2Elements> remainingLeft = new HashSet<Match2Elements>();
        HashSet<Match2Elements> remainingRight = new HashSet<Match2Elements>();
        for (EObject unmatched : new ArrayList<EObject>(this.remainingUnmatchedElements)) {
            if (!(unmatched instanceof Match2Elements)) continue;
            EObject element = ((Match2Elements)unmatched).getLeftElement();
            if (element.eResource() == leftResource) {
                remainingLeft.add((Match2Elements)unmatched);
            } else if (element.eResource() == rightResource) {
                remainingRight.add((Match2Elements)unmatched);
            }
            this.remainingUnmatchedElements.remove(unmatched);
        }
        block1: for (Match2Elements left : new HashSet(remainingLeft)) {
            for (Match2Elements right : new HashSet(remainingRight)) {
                if (left.getRightElement() != right.getRightElement()) continue;
                Match3Elements subMatch = MatchFactory.eINSTANCE.createMatch3Elements();
                subMatch.setOriginElement(left.getRightElement());
                subMatch.setLeftElement(left.getLeftElement());
                subMatch.setRightElement(right.getLeftElement());
                this.redirectedAdd(subMatchRoot, SUBMATCH_ELEMENT_NAME, subMatch);
                remainingLeft.remove(left);
                remainingRight.remove(right);
                continue block1;
            }
        }
        for (Match2Elements nextLeftUnmatch : remainingLeft) {
            unmatch = MatchFactory.eINSTANCE.createUnmatchElement();
            unmatch.setElement(nextLeftUnmatch.getLeftElement());
            unmatch.setSide(Side.LEFT);
            unmatch.setRemote(true);
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unmatch);
        }
        for (Match2Elements nextRightUnmatch : remainingRight) {
            unmatch = MatchFactory.eINSTANCE.createUnmatchElement();
            unmatch.setElement(nextRightUnmatch.getLeftElement());
            unmatch.setSide(Side.RIGHT);
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unmatch);
        }
    }

    private void processSingleUnmatchedElements(Resource leftResource, Resource rightResource, MatchModel root, Match3Elements subMatchRoot, Monitor monitor) throws InterruptedException, FactoryException {
        UnmatchElement unMap;
        HashSet<EObject> remainingLeft = new HashSet<EObject>();
        HashSet<EObject> remainingRight = new HashSet<EObject>();
        for (EObject unmatched : new ArrayList<EObject>(this.remainingUnmatchedElements)) {
            if (!(unmatched instanceof UnmatchElement)) continue;
            EObject element = ((UnmatchElement)unmatched).getElement();
            if (element.eResource() == leftResource) {
                remainingLeft.add(element);
            } else if (element.eResource() == rightResource) {
                remainingRight.add(element);
            }
            this.remainingUnmatchedElements.remove(unmatched);
        }
        this.stillToFindFromModel1.clear();
        this.stillToFindFromModel2.clear();
        List<Match2Elements> mappings = this.mapLists(new ArrayList<EObject>(remainingLeft), new ArrayList<EObject>(remainingRight), this.structuredOptions.getSearchWindow(), monitor);
        for (Match2Elements map : mappings) {
            Match3Elements subMatch = MatchFactory.eINSTANCE.createMatch3Elements();
            subMatch.setLeftElement(map.getLeftElement());
            subMatch.setRightElement(map.getRightElement());
            this.redirectedAdd(subMatchRoot, SUBMATCH_ELEMENT_NAME, subMatch);
        }
        for (EObject unmatch : this.stillToFindFromModel1) {
            unMap = MatchFactory.eINSTANCE.createUnmatchElement();
            unMap.setElement(unmatch);
            unMap.setSide(Side.LEFT);
            unMap.setRemote(false);
            for (EObject unmatched : this.remainingUnmatchedElements) {
                if (!(unmatched instanceof Match2Elements) || unmatch.eContainer() != ((Match2Elements)unmatched).getLeftElement()) continue;
                unMap.setConflicting(true);
                break;
            }
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unMap);
        }
        for (EObject remoteUnmatch : this.stillToFindFromModel2) {
            unMap = MatchFactory.eINSTANCE.createUnmatchElement();
            unMap.setElement(remoteUnmatch);
            unMap.setSide(Side.RIGHT);
            unMap.setRemote(true);
            for (EObject unmatched : this.remainingUnmatchedElements) {
                if (!(unmatched instanceof Match2Elements) || remoteUnmatch.eContainer() != ((Match2Elements)unmatched).getLeftElement()) continue;
                unMap.setConflicting(true);
                break;
            }
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unMap);
        }
    }

    private Match2Elements recursiveMappings(EObject current1, IMatchScope current1Scope, EObject current2, IMatchScope current2Scope, Monitor monitor) throws FactoryException, InterruptedException {
        Match2Elements mapping = null;
        mapping = MatchFactory.eINSTANCE.createMatch2Elements();
        mapping.setLeftElement(current1);
        mapping.setRightElement(current2);
        mapping.setSimilarity(this.checker.absoluteMetric(current1, current2));
        List<Match2Elements> mapList = this.mapLists(this.getScopeInternalContents(current1, current1Scope), this.getScopeInternalContents(current2, current2Scope), this.structuredOptions.getSearchWindow(), monitor);
        for (Match2Elements subMapping : mapList) {
            EFactory.eAdd((EObject)mapping, (String)SUBMATCH_ELEMENT_NAME, (Object)this.recursiveMappings(subMapping.getLeftElement(), current1Scope, subMapping.getRightElement(), current2Scope, monitor));
        }
        List<EObject> current1ScopeExternalReferences = this.getScopeExternalReferences(current1, current1Scope);
        List<EObject> current2ScopeExternalReferences = this.getScopeExternalReferences(current2, current2Scope);
        for (EObject leftRef : current1ScopeExternalReferences) {
            EObject rightRef = this.findMostSimilar(leftRef, current2ScopeExternalReferences);
            if (rightRef == null || this.findMostSimilar(rightRef, current1ScopeExternalReferences) != leftRef) continue;
            Match2Elements externalRefMapping = MatchFactory.eINSTANCE.createMatch2Elements();
            externalRefMapping.setLeftElement(leftRef);
            externalRefMapping.setRightElement(rightRef);
            externalRefMapping.setSimilarity(this.checker.absoluteMetric(leftRef, rightRef));
            this.externalRefMappings.add(externalRefMapping);
        }
        return mapping;
    }

    private List<EObject> getScopeExternalReferences(EObject eObject, IMatchScope scope) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            Object value = eObject.eGet((EStructuralFeature)reference);
            if (value instanceof Collection) {
                for (Object newValue : (Collection)value) {
                    if (result.contains(newValue) || !(newValue instanceof EObject) || scope.isInScope((EObject)newValue)) continue;
                    result.add((EObject)newValue);
                }
                continue;
            }
            if (result.contains(value) || !(value instanceof EObject) || scope.isInScope((EObject)value)) continue;
            result.add((EObject)value);
        }
        return result;
    }

    private void redirectedAdd(EObject object, String name, Object value) throws FactoryException {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(name);
        if (feature.isMany()) {
            if (value != null) {
                if (value instanceof EObject) {
                    ((BasicEList)object.eGet(feature)).addUnique(value);
                } else {
                    ((List)object.eGet(feature)).add(value);
                }
            }
        } else {
            EFactory.eSet((EObject)object, (String)name, (Object)value);
        }
    }

    protected void setModelRoots(MatchModel modelRoot, EObject left, EObject right) {
        this.setModelRoots(modelRoot, left, right, null);
    }

    protected void setModelRoots(MatchModel modelRoot, EObject left, EObject right, EObject ancestor) {
        if (left != null && left.eResource() != null) {
            modelRoot.getLeftRoots().addAll((Collection)left.eResource().getContents());
        }
        if (right != null && right.eResource() != null) {
            modelRoot.getRightRoots().addAll((Collection)right.eResource().getContents());
        }
        if (ancestor != null && ancestor.eResource() != null) {
            modelRoot.getAncestorRoots().addAll((Collection)ancestor.eResource().getContents());
        }
    }

    private void startMonitor(Monitor monitor, int size) {
        monitor.beginTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.task"), size);
        monitor.subTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.browsing"));
    }

    protected boolean isSimilar(EObject obj1, EObject obj2) throws FactoryException {
        return this.checker.isSimilar(obj1, obj2);
    }

    protected List<EObject> getScopeInternalContents(EObject eObject, IMatchScope scope) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject contents : eObject.eContents()) {
            if (result.contains(contents) || !scope.isInScope(contents)) continue;
            result.add(contents);
        }
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            EObject object;
            if (!reference.isContainment() || !reference.isDerived()) continue;
            Object value = eObject.eGet((EStructuralFeature)reference);
            if (value instanceof Collection) {
                for (Object contents : (Collection)value) {
                    EObject object2;
                    if (result.contains(contents) || !(contents instanceof EObject) || !scope.isInScope(object2 = (EObject)contents)) continue;
                    result.add(object2);
                }
                continue;
            }
            if (result.contains(value) || !(value instanceof EObject) || !scope.isInScope(object = (EObject)value)) continue;
            result.add(object);
        }
        return result;
    }

    private List<EObject> getScopeInternalContents(Resource resource, IMatchScope scope) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject contents : resource.getContents()) {
            if (result.contains(contents) || !scope.isInScope(contents)) continue;
            result.add(contents);
        }
        return result;
    }
}

