/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.structure;

import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.export.ExportMenu;
import org.eclipse.emf.compare.ui.internal.ModelComparator;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureContentProvider;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ModelStructureMergeViewer
extends TreeViewer {
    protected CompareConfiguration configuration;
    protected ExportMenu exportMenu;
    boolean ignoreContentSelection;

    public ModelStructureMergeViewer(Composite parent, CompareConfiguration compareConfiguration) {
        super(parent);
        this.initialize(compareConfiguration);
        this.createToolItems();
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.configuration;
    }

    public String getTitle() {
        return EMFCompareUIMessages.getString("ModelStructureMergeViewer.viewerTitle");
    }

    Widget find(Object element) {
        Widget widget = super.findItem(element);
        return widget;
    }

    protected ModelStructureContentProvider createContentProvider(CompareConfiguration compareConfiguration) {
        return new ModelStructureContentProvider(compareConfiguration);
    }

    protected ModelStructureLabelProvider createLabelProvider(CompareConfiguration compareConfiguration) {
        return new ModelStructureLabelProvider();
    }

    protected void createToolItems() {
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)this.getControl().getParent());
        if (this.exportMenu == null) {
            this.exportMenu = new ExportMenu((Control)tbm.getControl(), this);
        }
        tbm.add((IContributionItem)new Separator("IO"));
        tbm.appendToGroup("IO", (IAction)this.exportMenu);
        tbm.update(true);
    }

    protected void fireOpen(OpenEvent event) {
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.exportMenu.dispose();
    }

    protected void inputChanged(Object input, Object oldInput) {
        TreePath[] expandedPaths = this.getExpandedTreePaths();
        super.inputChanged(input, oldInput);
        if (input != null) {
            if (!(input instanceof ComparisonSnapshot) && input != oldInput) {
                ComparisonResourceSetSnapshot snapshot = ModelComparator.getComparator(this.configuration).getComparisonResult();
                MatchResourceSet match = snapshot.getMatchResourceSet();
                if (match != null) {
                    this.setInput(snapshot);
                } else {
                    this.setInput(null);
                }
            }
            this.updateToolItems();
            this.setExpandedTreePaths(expandedPaths);
        } else {
            this.hideStructurePane();
        }
    }

    protected void updateToolItems() {
        ModelComparator comparator = ModelComparator.getComparator(this.configuration);
        if (comparator != null) {
            this.exportMenu.enableSave(!comparator.isLeftRemote() && !comparator.isRightRemote());
        } else {
            this.exportMenu.enableSave(false);
        }
        CompareViewerPane.getToolBarManager((Composite)this.getControl().getParent()).update(true);
    }

    private void hideStructurePane() {
        this.getControl().getParent().getParent().setVisible(false);
    }

    private void initialize(CompareConfiguration compareConfiguration) {
        this.configuration = compareConfiguration;
        this.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(compareConfiguration));
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)this.createContentProvider(compareConfiguration));
        Tree tree = this.getTree();
        tree.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)this.getTitle());
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArrayList<DiffElement> selectedElements = new ArrayList<DiffElement>(ModelStructureMergeViewer.this.getTree().getSelection().length);
                TreeItem[] treeItemArray = ModelStructureMergeViewer.this.getTree().getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getData() instanceof DiffElement) {
                        selectedElements.add((DiffElement)item.getData());
                    }
                    ++n2;
                }
                ModelStructureMergeViewer.this.ignoreContentSelection = true;
                ModelStructureMergeViewer.this.configuration.setProperty("structure.selection.changed", selectedElements);
            }
        });
        this.configuration.addPropertyChangeListener((IPropertyChangeListener)new ConfigurationPropertyListener());
        IWorkbenchPart part = this.configuration.getContainer().getWorkbenchPart();
        if (part != null) {
            part.getSite().setSelectionProvider((ISelectionProvider)this);
        }
    }

    private class ConfigurationPropertyListener
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("content.selection.changed")) {
                if (ModelStructureMergeViewer.this.ignoreContentSelection) {
                    ModelStructureMergeViewer.this.ignoreContentSelection = false;
                } else {
                    TreeItem item = (TreeItem)ModelStructureMergeViewer.this.find(event.getNewValue());
                    if (item == null) {
                        Object[] expandedElements = ModelStructureMergeViewer.this.getExpandedElements();
                        ModelStructureMergeViewer.this.expandAll();
                        item = (TreeItem)ModelStructureMergeViewer.this.find(event.getNewValue());
                        ModelStructureMergeViewer.this.setExpandedElements(expandedElements);
                    }
                    if (item != null) {
                        ModelStructureMergeViewer.this.setSelection((ISelection)new StructuredSelection(item.getData()), true);
                        ModelStructureMergeViewer.this.expandToLevel(item.getData(), 0);
                    }
                }
            } else if (event.getProperty().equals("content.input.changed")) {
                ModelStructureMergeViewer.this.setInput(event.getNewValue());
            }
        }
    }

    private class ModelStructureLabelProvider
    extends LabelProvider {
        AdapterFactoryLabelProvider adapterProvider = new AdapterFactoryLabelProvider(AdapterUtils.getAdapterFactory());

        public Image getImage(Object object) {
            Image image = null;
            if (object instanceof AbstractDiffExtension) {
                image = (Image)((AbstractDiffExtension)object).getImage();
            }
            if (object instanceof IFile) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            } else if (image == null) {
                image = this.adapterProvider.getImage(object);
            }
            return image;
        }

        public String getText(Object object) {
            String text = null;
            text = object instanceof AbstractDiffExtension ? ((AbstractDiffExtension)object).getText() : (object instanceof IFile ? ((IFile)object).getName() : (object instanceof Resource ? ((Resource)object).getURI().lastSegment() : this.adapterProvider.getText(object)));
            return text;
        }
    }
}

