/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.structure;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.metamodel.util.DiffAdapterFactory;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.internal.ModelComparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ModelStructureContentProvider
implements ITreeContentProvider {
    protected final CompareConfiguration configuration;
    protected Object input;

    public ModelStructureContentProvider(CompareConfiguration compareConfiguration) {
        this.configuration = compareConfiguration;
    }

    public void dispose() {
        ModelComparator.removeComparator(this.configuration);
        this.input = null;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (parentElement instanceof EObject) {
            ArrayList<EObject> childrenList = new ArrayList<EObject>();
            for (EObject child : ((EObject)parentElement).eContents()) {
                if (DiffAdapterFactory.shouldBeHidden((EObject)child)) continue;
                childrenList.add(child);
            }
            children = childrenList.toArray();
        }
        return children;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = null;
        if (inputElement instanceof DiffModel) {
            elements = ((DiffModel)inputElement).getOwnedElements().toArray();
        } else if (this.input instanceof DiffModel) {
            elements = ((DiffModel)this.input).getOwnedElements().toArray();
        } else if (this.input instanceof DiffResourceSet) {
            ArrayList<DiffModel> elementList = new ArrayList<DiffModel>((Collection<DiffModel>)((DiffResourceSet)this.input).getDiffModels());
            elementList.addAll((Collection<DiffModel>)((DiffResourceSet)this.input).getResourceDiffs());
            if (elementList.isEmpty()) {
                DiffModel dummyDiff = DiffFactory.eINSTANCE.createDiffModel();
                dummyDiff.getOwnedElements().add((Object)DiffFactory.eINSTANCE.createDiffGroup());
                elementList.add(dummyDiff);
            }
            elements = elementList.toArray();
        } else {
            elements = new Object[]{};
        }
        return elements;
    }

    public Object getParent(Object element) {
        EObject parent = null;
        if (element instanceof EObject) {
            parent = ((EObject)element).eContainer();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof EObject) {
            hasChildren = !((EObject)element).eContents().isEmpty();
        }
        return hasChildren;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        ((TreeViewer)viewer).getTree().clearAll(true);
        if (newInput == null) {
            return;
        }
        ModelComparator comparator = newInput instanceof ICompareInput ? ModelComparator.getComparator(this.configuration, (ICompareInput)newInput) : ModelComparator.getComparator(this.configuration);
        if (newInput instanceof ComparisonResourceSnapshot) {
            this.input = ((ComparisonResourceSnapshot)newInput).getDiff();
        } else if (newInput instanceof ComparisonResourceSetSnapshot) {
            this.input = ((ComparisonResourceSetSnapshot)newInput).getDiffResourceSet();
        } else if (comparator.getComparisonResult() != null) {
            this.input = comparator.getComparisonResult().getDiffResourceSet();
        } else if (newInput instanceof ModelCompareInput) {
            this.input = ((ModelCompareInput)newInput).getDiff();
        } else if (oldInput != newInput && newInput instanceof ICompareInput) {
            comparator.loadResources((ICompareInput)newInput);
            this.input = comparator.compare(this.configuration).getDiffResourceSet();
        }
    }
}

