/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class EclipseModelUtils {
    private EclipseModelUtils() {
    }

    public static Monitor createProgressMonitor(Object delegate) {
        Object monitor = delegate instanceof IProgressMonitorWithBlocking ? BasicMonitor.toMonitor((IProgressMonitorWithBlocking)((IProgressMonitorWithBlocking)delegate)) : (delegate instanceof IProgressMonitor ? BasicMonitor.toMonitor((IProgressMonitor)((IProgressMonitor)delegate)) : new BasicMonitor());
        return monitor;
    }

    public static String getCommonContentType(URI ... uris) {
        String contentType = null;
        int i = 0;
        while (i < uris.length) {
            if (uris[i] != null && uris[i].isPlatformResource()) {
                Path modelPath = new Path(uris[i].toPlatformString(true));
                String newContentType = null;
                try {
                    newContentType = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)modelPath).getContentDescription().getContentType().getId();
                }
                catch (CoreException coreException) {}
                if (contentType == null) {
                    contentType = newContentType;
                } else if (newContentType != null && !contentType.equals(newContentType)) {
                    return null;
                }
            }
            ++i;
        }
        return contentType;
    }

    public static EObject load(IFile file, ResourceSet resourceSet) throws IOException {
        EObject result = null;
        Resource modelResource = ModelUtils.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true), resourceSet);
        try {
            modelResource.load(Collections.emptyMap());
        }
        catch (IOException e) {
            resourceSet.getResources().remove((Object)modelResource);
            modelResource = ModelUtils.createResource(URI.createPlatformPluginURI((String)file.getFullPath().toOSString(), (boolean)true), resourceSet);
            try {
                modelResource.load(Collections.emptyMap());
            }
            catch (IOException iOException) {
                throw e;
            }
        }
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        return result;
    }

    public static EObject load(IPath path, ResourceSet resourceSet) throws IOException {
        return EclipseModelUtils.load(ResourcesPlugin.getWorkspace().getRoot().getFile(path), resourceSet);
    }
}

