/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine.internal;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.match.engine.AbstractSimilarityChecker;
import org.eclipse.emf.compare.match.statistic.MetamodelFilter;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreIDSimilarityChecker
extends AbstractSimilarityChecker {
    private final Map<EObject, EObject> leftToRight = new EMFCompareMap();
    private final Set<EObject> nonIdentified = new LinkedHashSet<EObject>();
    private AbstractSimilarityChecker delegate;

    public EcoreIDSimilarityChecker(MetamodelFilter filter, AbstractSimilarityChecker fallback) {
        super(filter);
        this.delegate = fallback;
    }

    @Override
    public void init(EObject obj1, EObject obj2) throws FactoryException {
        this.leftToRight.clear();
        this.nonIdentified.clear();
        TreeIterator leftIterator = obj1.eAllContents();
        TreeIterator rightIterator = obj2.eAllContents();
        this.browseComputingId((Iterator<EObject>)leftIterator, (Iterator<EObject>)rightIterator);
        this.delegate.init(obj1, obj2);
    }

    private void browseComputingId(Iterator<EObject> leftIterator, Iterator<EObject> rightIterator) {
        EObjectCouple duo;
        EMFCompareMap matchedByID = new EMFCompareMap();
        while (leftIterator.hasNext()) {
            EObject item1 = leftIterator.next();
            String item1ID = this.computeID(item1);
            if (item1ID == null) {
                this.nonIdentified.add(item1);
                continue;
            }
            duo = this.getOrCreate((Map<String, EObjectCouple>)matchedByID, item1ID);
            duo.setLeft(item1);
        }
        while (rightIterator.hasNext()) {
            EObject item2 = rightIterator.next();
            String item2ID = this.computeID(item2);
            if (item2ID == null) {
                this.nonIdentified.add(item2);
                continue;
            }
            duo = this.getOrCreate((Map<String, EObjectCouple>)matchedByID, item2ID);
            duo.setRight(item2);
        }
        for (EObjectCouple pair : matchedByID.values()) {
            if (pair.getLeft() == null || pair.getRight() == null) continue;
            this.leftToRight.put(pair.getLeft(), pair.getRight());
        }
    }

    private EObjectCouple getOrCreate(Map<String, EObjectCouple> matchedByID, String item1id) {
        EObjectCouple found = matchedByID.get(item1id);
        if (found == null) {
            found = new EObjectCouple();
            matchedByID.put(item1id, found);
        }
        return found;
    }

    @Override
    public void init(Resource left, Resource right) throws FactoryException {
        this.leftToRight.clear();
        this.nonIdentified.clear();
        TreeIterator leftIterator = left.getAllContents();
        TreeIterator rightIterator = right.getAllContents();
        this.browseComputingId((Iterator<EObject>)leftIterator, (Iterator<EObject>)rightIterator);
        this.delegate.init(left, right);
    }

    @Override
    public boolean isSimilar(EObject obj1, EObject obj2) throws FactoryException {
        if (this.nonIdentified.contains(obj1) && this.nonIdentified.contains(obj2)) {
            return this.delegate.isSimilar(obj1, obj2);
        }
        return this.leftToRight.get(obj1) == obj2;
    }

    @Override
    public double absoluteMetric(EObject obj1, EObject obj2) throws FactoryException {
        if (this.nonIdentified.contains(obj1) && this.nonIdentified.contains(obj2)) {
            return this.delegate.absoluteMetric(obj1, obj2);
        }
        if (this.leftToRight.get(obj1) == obj2) {
            return 1.0;
        }
        return 0.0;
    }

    protected String computeID(EObject obj) {
        return EcoreUtil.getID((EObject)obj);
    }

    @Override
    public EObject fastLookup(EObject obj1) {
        return this.leftToRight.get(obj1);
    }

    class EObjectCouple {
        private EObject left;
        private EObject right;

        EObjectCouple() {
        }

        public EObject getLeft() {
            return this.left;
        }

        public void setLeft(EObject passedLeft) {
            this.left = passedLeft;
        }

        public EObject getRight() {
            return this.right;
        }

        public void setRight(EObject passedRight) {
            this.right = passedRight;
        }

        public EObject getOther(EObject obj1) {
            EObject found = null;
            if (this.getLeft() == obj1) {
                found = this.getRight();
            } else if (this.getRight() == obj1) {
                found = this.getLeft();
            }
            return found;
        }
    }
}

