/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.internal;

import java.util.List;
import org.eclipse.emf.compare.EMFCompareException;
import org.eclipse.emf.compare.diff.service.DiffEngineDescriptor;
import org.eclipse.emf.compare.diff.service.IDiffEngineSelector;
import org.eclipse.emf.compare.match.service.IMatchEngineSelector;
import org.eclipse.emf.compare.match.service.MatchEngineDescriptor;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.internal.AbstractReturningRunnable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualEngineSelector
implements IMatchEngineSelector,
IDiffEngineSelector {
    public MatchEngineDescriptor selectMatchEngine(final List<MatchEngineDescriptor> engines) {
        AbstractReturningRunnable runnable = new AbstractReturningRunnable(){

            public Object runImpl() {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new EngineDescriptorLabelProvider());
                dialog.setMessage(EMFCompareUIMessages.getString("VisualEngineSelector.Dialog.Message"));
                dialog.setTitle(EMFCompareUIMessages.getString("VisualEngineSelector.Dialog.Title"));
                dialog.setElements(engines.toArray());
                Object result = null;
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    if (dialog.getResult().length > 0) {
                        result = dialog.getResult()[0];
                    }
                } else {
                    throw new EMFCompareException(EMFCompareUIMessages.getString("VisualEngineSelector.Dialog.Cancel"));
                }
                return result;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (MatchEngineDescriptor)runnable.getResult();
    }

    public DiffEngineDescriptor selectDiffEngine(final List<DiffEngineDescriptor> engines) {
        AbstractReturningRunnable runnable = new AbstractReturningRunnable(){

            public Object runImpl() {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new EngineDescriptorLabelProvider());
                dialog.setMessage(EMFCompareUIMessages.getString("VisualEngineSelector.Dialog.Message"));
                dialog.setTitle(EMFCompareUIMessages.getString("VisualEngineSelector.Dialog.Title"));
                dialog.setElements(engines.toArray());
                Object result = null;
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    if (dialog.getResult().length > 0) {
                        result = dialog.getResult()[0];
                    }
                } else {
                    throw new EMFCompareException(EMFCompareUIMessages.getString("VisualEngineSelector.Dialog.Cancel"));
                }
                return result;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (DiffEngineDescriptor)runnable.getResult();
    }

    protected class EngineDescriptorLabelProvider
    extends LabelProvider {
        protected EngineDescriptorLabelProvider() {
        }

        public Image getImage(Object element) {
            DiffEngineDescriptor descriptor;
            Image image = null;
            if (element instanceof MatchEngineDescriptor) {
                MatchEngineDescriptor descriptor2 = (MatchEngineDescriptor)element;
                if (descriptor2.getIcon().length() > 0) {
                    String contributor = descriptor2.getElement().getDeclaringExtension().getNamespaceIdentifier();
                    image = AbstractUIPlugin.imageDescriptorFromPlugin((String)contributor, (String)descriptor2.getIcon()).createImage();
                }
            } else if (element instanceof DiffEngineDescriptor && (descriptor = (DiffEngineDescriptor)element).getIcon().length() > 0) {
                String contributor = descriptor.getElement().getDeclaringExtension().getNamespaceIdentifier();
                image = AbstractUIPlugin.imageDescriptorFromPlugin((String)contributor, (String)descriptor.getIcon()).createImage();
            }
            return image;
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof MatchEngineDescriptor) {
                MatchEngineDescriptor descriptor = (MatchEngineDescriptor)element;
                text = descriptor.getLabel().length() == 0 ? descriptor.getEngineClassName() : descriptor.getLabel();
            } else if (element instanceof DiffEngineDescriptor) {
                DiffEngineDescriptor descriptor = (DiffEngineDescriptor)element;
                text = descriptor.getLabel().length() == 0 ? descriptor.getEngineClassName() : descriptor.getLabel();
            }
            return text;
        }
    }
}

