/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IndepAddAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddRemReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.IndepMoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateReferenceChange;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.symrefs.Condition;
import org.eclipse.emf.compare.mpatch.symrefs.ElementSetReference;
import org.eclipse.emf.compare.mpatch.symrefs.OclCondition;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeChangesCompare {
    static boolean generalizable(IndepChange change1, IndepChange change2) {
        EClass eClass = change1.eClass();
        if (eClass == null || !eClass.equals(change2.eClass())) {
            return false;
        }
        if (!MergeChangesCompare.areGeneralizableSymbolicReferences(change1.getCorrespondingElement(), change2.getCorrespondingElement())) {
            return false;
        }
        boolean isGeneralizable = MPatchPackage.Literals.INDEP_ADD_ATTRIBUTE_CHANGE.equals(eClass) ? MergeChangesCompare.generzlizableAddRemAttributeChanges((IndepAddRemAttributeChange)((IndepAddAttributeChange)change1), (IndepAddRemAttributeChange)((IndepAddAttributeChange)change2)) : (MPatchPackage.Literals.INDEP_REMOVE_ATTRIBUTE_CHANGE.equals(eClass) ? MergeChangesCompare.generzlizableAddRemAttributeChanges((IndepAddRemAttributeChange)((IndepRemoveAttributeChange)change1), (IndepAddRemAttributeChange)((IndepRemoveAttributeChange)change2)) : (MPatchPackage.Literals.INDEP_UPDATE_ATTRIBUTE_CHANGE.equals(eClass) ? MergeChangesCompare.generzlizableUpdateAttributeChanges((IndepUpdateAttributeChange)change1, (IndepUpdateAttributeChange)change2) : (MPatchPackage.Literals.INDEP_ADD_ELEMENT_CHANGE.equals(eClass) ? MergeChangesCompare.generzlizableAddRemElementChanges((IndepAddRemElementChange)((IndepAddElementChange)change1), (IndepAddRemElementChange)((IndepAddElementChange)change2)) : (MPatchPackage.Literals.INDEP_REMOVE_ELEMENT_CHANGE.equals(eClass) ? MergeChangesCompare.generzlizableAddRemElementChanges((IndepAddRemElementChange)((IndepRemoveElementChange)change1), (IndepAddRemElementChange)((IndepRemoveElementChange)change2)) : (MPatchPackage.Literals.INDEP_MOVE_ELEMENT_CHANGE.equals(eClass) ? MergeChangesCompare.generzlizableMoveElementChanges((IndepMoveElementChange)change1, (IndepMoveElementChange)change2) : (MPatchPackage.Literals.INDEP_ADD_REFERENCE_CHANGE.equals(eClass) ? MergeChangesCompare.generzlizableAddRemReferenceChanges((IndepAddRemReferenceChange)((IndepAddReferenceChange)change1), (IndepAddRemReferenceChange)((IndepAddReferenceChange)change2)) : (MPatchPackage.Literals.INDEP_REMOVE_REFERENCE_CHANGE.equals(eClass) ? MergeChangesCompare.generzlizableAddRemReferenceChanges((IndepAddRemReferenceChange)((IndepRemoveReferenceChange)change1), (IndepAddRemReferenceChange)((IndepRemoveReferenceChange)change2)) : (MPatchPackage.Literals.INDEP_UPDATE_REFERENCE_CHANGE.equals(eClass) ? MergeChangesCompare.generzlizableUpdateReferenceChanges((IndepUpdateReferenceChange)change1, (IndepUpdateReferenceChange)change2) : false))))))));
        return isGeneralizable;
    }

    private static boolean generzlizableAddRemAttributeChanges(IndepAddRemAttributeChange change1, IndepAddRemAttributeChange change2) {
        if (change1.getChangedAttribute() == null || !change1.getChangedAttribute().equals(change2.getChangedAttribute())) {
            return false;
        }
        if (change1.getValue() == null ^ change2.getValue() == null) {
            return false;
        }
        return change1.getValue() == null || change1.getValue().equals(change2.getValue());
    }

    private static boolean generzlizableUpdateAttributeChanges(IndepUpdateAttributeChange change1, IndepUpdateAttributeChange change2) {
        if (change1.getChangedAttribute() == null || !change1.getChangedAttribute().equals(change2.getChangedAttribute())) {
            return false;
        }
        if (!MergeChangesCompare.equalAttributeValues(change1.getOldValue(), change2.getOldValue())) {
            return false;
        }
        return MergeChangesCompare.equalAttributeValues(change1.getNewValue(), change2.getNewValue());
    }

    private static boolean equalAttributeValues(Object value1, Object value2) {
        if (value1 == null ^ value2 == null) {
            return false;
        }
        return value1 == null || value1.equals(value2);
    }

    private static boolean generzlizableAddRemElementChanges(IndepAddRemElementChange change1, IndepAddRemElementChange change2) {
        if (change1.getContainment() == null || !change1.getContainment().equals(change2.getContainment())) {
            return false;
        }
        if (!MergeChangesCompare.areGeneralizableSymbolicReferences(change1.getSubModelReference(), change2.getSubModelReference())) {
            return false;
        }
        if (change1.getSubModel() == null || !change1.getSubModel().describesEqual(change2.getSubModel())) {
            return false;
        }
        EObject mpatch = ExtEcoreUtils.getContainerOfType((EObject)change1, (EClass)MPatchPackage.Literals.MPATCH_MODEL);
        return MergeChangesCompare.sameCrossReferences((EObject)change1, (EObject)change2, mpatch);
    }

    private static boolean sameCrossReferences(EObject obj1, EObject obj2, EObject root) {
        List flat1 = ExtEcoreUtils.flattenEObjects(Collections.singleton(obj1));
        List flat2 = ExtEcoreUtils.flattenEObjects(Collections.singleton(obj2));
        Map refs1 = EcoreUtil.UsageCrossReferencer.findAll((Collection)flat1, (EObject)root);
        Map refs2 = EcoreUtil.UsageCrossReferencer.findAll((Collection)flat2, (EObject)root);
        if (refs1.isEmpty() && refs1.isEmpty()) {
            return true;
        }
        return MergeChangesCompare.onlyDependencyReferences(refs1, flat1) && MergeChangesCompare.onlyDependencyReferences(refs2, flat2);
    }

    private static boolean onlyDependencyReferences(Map<EObject, Collection<EStructuralFeature.Setting>> refs, List<? extends EObject> flat) {
        for (EObject key : refs.keySet()) {
            Collection<EStructuralFeature.Setting> settings = refs.get(key);
            for (EStructuralFeature.Setting setting : settings) {
                if (MPatchPackage.Literals.INDEP_CHANGE__DEPENDANTS.equals(setting.getEStructuralFeature()) || MPatchPackage.Literals.INDEP_CHANGE__DEPENDS_ON.equals(setting.getEStructuralFeature()) || flat.contains(setting.getEObject())) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    protected static boolean exactlySameCrossReferences(EObject obj1, EObject obj2, Map<EObject, Collection<EStructuralFeature.Setting>> refs1, Map<EObject, Collection<EStructuralFeature.Setting>> refs2, List<? extends EObject> flat1, List<? extends EObject> flat2) {
        Map match = CommonUtils.getMatchingObjects((EObject)obj1, (EObject)obj2);
        for (EObject key1 : refs1.keySet()) {
            EObject key2 = (EObject)match.get(key1);
            if (refs2.keySet().contains(key2)) {
                Collection<EStructuralFeature.Setting> settings1 = refs1.get(key1);
                Collection<EStructuralFeature.Setting> settings2 = refs2.get(key2);
                if (settings1 == null && settings2 == null) continue;
                if (settings1 == null ^ settings2 == null) {
                    return false;
                }
                if (settings1 == null || settings2 == null || settings1.size() != settings2.size()) {
                    return false;
                }
                block1: for (EStructuralFeature.Setting setting1 : settings1) {
                    for (EStructuralFeature.Setting setting2 : settings2) {
                        EObject eobj1 = setting1.getEObject();
                        EObject eobj2 = setting2.getEObject();
                        EStructuralFeature feature1 = setting1.getEStructuralFeature();
                        EStructuralFeature feature2 = setting2.getEStructuralFeature();
                        if (flat1.contains(eobj1) && flat2.contains(eobj2) || eobj1.equals(eobj2) && feature1.equals(feature2)) continue block1;
                    }
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean generzlizableMoveElementChanges(IndepMoveElementChange change1, IndepMoveElementChange change2) {
        if (change1.getOldParent() == null || change1.getNewParent() == null || change2.getOldParent() == null || change2.getNewParent() == null) {
            return false;
        }
        if (change1.getOldContainment() == null || change1.getNewContainment() == null || change2.getOldContainment() == null || change2.getNewContainment() == null) {
            return false;
        }
        if (!change1.getOldParent().resolvesEqual(change2.getOldParent())) {
            return false;
        }
        if (!change1.getNewParent().resolvesEqual(change2.getNewParent())) {
            return false;
        }
        if (!change1.getOldContainment().equals(change2.getOldContainment())) {
            return false;
        }
        return change1.getNewContainment().equals(change2.getNewContainment());
    }

    private static boolean generzlizableAddRemReferenceChanges(IndepAddRemReferenceChange change1, IndepAddRemReferenceChange change2) {
        if (change1.getReference() == null || !change1.getReference().equals(change2.getReference())) {
            return false;
        }
        return change1.getChangedReference().resolvesEqual(change2.getChangedReference());
    }

    private static boolean generzlizableUpdateReferenceChanges(IndepUpdateReferenceChange change1, IndepUpdateReferenceChange change2) {
        if (change1.getReference() == null || !change1.getReference().equals(change2.getReference())) {
            return false;
        }
        if (change1.getOldReference() == null ^ change2.getOldReference() == null) {
            return false;
        }
        if (change1.getNewReference() == null ^ change2.getNewReference() == null) {
            return false;
        }
        if (change1.getOldReference() != null && !change1.getOldReference().resolvesEqual(change2.getOldReference())) {
            return false;
        }
        return change1.getNewReference() == null || change1.getNewReference().resolvesEqual(change2.getNewReference());
    }

    private static boolean areGeneralizableSymbolicReferences(IElementReference symref1, IElementReference symref2) {
        if (!(symref1 instanceof ElementSetReference) || !(symref2 instanceof ElementSetReference)) {
            return false;
        }
        ElementSetReference setref1 = (ElementSetReference)symref1;
        ElementSetReference setref2 = (ElementSetReference)symref2;
        if (setref1.getConditions().size() != 1 || setref2.getConditions().size() != 1) {
            return false;
        }
        for (Condition condition : setref1.getConditions()) {
            if (condition instanceof OclCondition) continue;
            return false;
        }
        for (Condition condition : setref2.getConditions()) {
            if (condition instanceof OclCondition) continue;
            return false;
        }
        if (!symref1.getType().equals(symref2.getType())) {
            return false;
        }
        if (setref1.getContext() == null ^ setref2.getContext() == null) {
            return false;
        }
        return setref1.getContext() == null || MergeChangesCompare.areGeneralizableSymbolicReferences(setref1.getContext(), setref2.getContext());
    }
}

