/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.IndepAddAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepAddElementChange;
import org.eclipse.emf.compare.mpatch.IndepAddReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.IndepMoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveElementChange;
import org.eclipse.emf.compare.mpatch.IndepRemoveReferenceChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateAttributeChange;
import org.eclipse.emf.compare.mpatch.IndepUpdateReferenceChange;
import org.eclipse.emf.compare.mpatch.MPatchFactory;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.UnknownChange;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.compare.mpatch.util.ExtEcoreUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ReverseMPatch
implements IMPatchTransformation {
    public static final String LABEL = "Reverse MPatch";
    private static final String DESCRIPTION = "This transformation reverses an MPatch. This is an optional transformation and makes the MPatch applicable in the other direction.\n\nBy default, an MPatch P created from a Model A which is the unchanged version of a Model B can be used to reproduce Model B out of Model A, and not vice versa! So P is directed and cannot be used to create Model A out of Model B.\nThis transformation reverses P and creates P_r such that P_r applied to Model B yields Model A.";

    public String getLabel() {
        return LABEL;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getPriority() {
        return 80;
    }

    public boolean isOptional() {
        return true;
    }

    public int transform(MPatchModel mpatch) {
        return ReverseMPatch.reverse(mpatch);
    }

    public static int reverse(MPatchModel mpatch) {
        List allChanges = ExtEcoreUtils.collectTypedElements((List)mpatch.getChanges(), Collections.singleton(MPatchPackage.Literals.INDEP_CHANGE), (boolean)true);
        ArrayList<IndepChange> newChanges = new ArrayList<IndepChange>(allChanges.size());
        int counter = 0;
        for (EObject change : allChanges) {
            IndepChange oldChange = (IndepChange)change;
            IndepChange newChange = ReverseMPatch.reverseChangeDispatch(oldChange);
            newChanges.add(newChange == null ? oldChange : newChange);
            if (newChange == null) continue;
            ++counter;
        }
        LinkedHashMap deps = new LinkedHashMap();
        for (EObject eObject : newChanges) {
            IndepChange indepChange = (IndepChange)eObject;
            deps.put(indepChange, new ArrayList(indepChange.getDependsOn()));
        }
        for (IndepChange indepChange : deps.keySet()) {
            indepChange.getDependants().clear();
            indepChange.getDependants().addAll((Collection)deps.get(indepChange));
        }
        return counter;
    }

    protected static IndepChange reverseChangeDispatch(IndepChange change) {
        if (change instanceof IndepAddElementChange) {
            return ReverseMPatch.reverseAddElementChange((IndepAddElementChange)change);
        }
        if (change instanceof IndepRemoveElementChange) {
            return ReverseMPatch.reverseRemoveElementChange((IndepRemoveElementChange)change);
        }
        if (change instanceof IndepMoveElementChange) {
            return ReverseMPatch.reverseMoveElementChange((IndepMoveElementChange)change);
        }
        if (change instanceof IndepAddAttributeChange) {
            return ReverseMPatch.reverseAddAttributeChange((IndepAddAttributeChange)change);
        }
        if (change instanceof IndepRemoveAttributeChange) {
            return ReverseMPatch.reverseRemoveAttributeChange((IndepRemoveAttributeChange)change);
        }
        if (change instanceof IndepUpdateAttributeChange) {
            return ReverseMPatch.reverseUpdateAttributeChange((IndepUpdateAttributeChange)change);
        }
        if (change instanceof IndepAddReferenceChange) {
            return ReverseMPatch.reverseAddReferenceChange((IndepAddReferenceChange)change);
        }
        if (change instanceof IndepRemoveReferenceChange) {
            return ReverseMPatch.reverseRemoveReferenceChange((IndepRemoveReferenceChange)change);
        }
        if (change instanceof IndepUpdateReferenceChange) {
            return ReverseMPatch.reverseUpdateReferenceChange((IndepUpdateReferenceChange)change);
        }
        if (change instanceof UnknownChange || change instanceof ChangeGroup) {
            return null;
        }
        throw new IllegalArgumentException("Please implement reversal for unknown change type: " + change.eClass().getName());
    }

    private static IndepChange reverseAddElementChange(IndepAddElementChange change) {
        IndepRemoveElementChange newChange = MPatchFactory.eINSTANCE.createIndepRemoveElementChange();
        newChange.setContainment(change.getContainment());
        newChange.setSubModel(change.getSubModel());
        return ReverseMPatch.reverseIndepChangeAndReplace((IndepChange)change, (IndepChange)newChange);
    }

    private static IndepChange reverseRemoveElementChange(IndepRemoveElementChange change) {
        IndepAddElementChange newChange = MPatchFactory.eINSTANCE.createIndepAddElementChange();
        newChange.setContainment(change.getContainment());
        newChange.setSubModel(change.getSubModel());
        return ReverseMPatch.reverseIndepChangeAndReplace((IndepChange)change, (IndepChange)newChange);
    }

    private static IndepChange reverseMoveElementChange(IndepMoveElementChange change) {
        IndepMoveElementChange newChange = MPatchFactory.eINSTANCE.createIndepMoveElementChange();
        newChange.setOldContainment(change.getNewContainment());
        newChange.setNewContainment(change.getOldContainment());
        newChange.setOldParent(change.getNewParent());
        newChange.setNewParent(change.getOldParent());
        return ReverseMPatch.reverseIndepChangeAndReplace((IndepChange)change, (IndepChange)newChange);
    }

    private static IndepChange reverseAddAttributeChange(IndepAddAttributeChange change) {
        IndepRemoveAttributeChange newChange = MPatchFactory.eINSTANCE.createIndepRemoveAttributeChange();
        newChange.setChangedAttribute(change.getChangedAttribute());
        newChange.setValue(change.getValue());
        return ReverseMPatch.reverseIndepChangeAndReplace((IndepChange)change, (IndepChange)newChange);
    }

    private static IndepChange reverseRemoveAttributeChange(IndepRemoveAttributeChange change) {
        IndepAddAttributeChange newChange = MPatchFactory.eINSTANCE.createIndepAddAttributeChange();
        newChange.setChangedAttribute(change.getChangedAttribute());
        newChange.setValue(change.getValue());
        return ReverseMPatch.reverseIndepChangeAndReplace((IndepChange)change, (IndepChange)newChange);
    }

    private static IndepChange reverseUpdateAttributeChange(IndepUpdateAttributeChange change) {
        IndepUpdateAttributeChange newChange = MPatchFactory.eINSTANCE.createIndepUpdateAttributeChange();
        newChange.setChangedAttribute(change.getChangedAttribute());
        newChange.setOldValue(change.getNewValue());
        newChange.setNewValue(change.getOldValue());
        return ReverseMPatch.reverseIndepChangeAndReplace((IndepChange)change, (IndepChange)newChange);
    }

    private static IndepChange reverseAddReferenceChange(IndepAddReferenceChange change) {
        IndepRemoveReferenceChange newChange = MPatchFactory.eINSTANCE.createIndepRemoveReferenceChange();
        newChange.setChangedReference(change.getChangedReference());
        newChange.setReference(change.getReference());
        return ReverseMPatch.reverseIndepChangeAndReplace((IndepChange)change, (IndepChange)newChange);
    }

    private static IndepChange reverseRemoveReferenceChange(IndepRemoveReferenceChange change) {
        IndepAddReferenceChange newChange = MPatchFactory.eINSTANCE.createIndepAddReferenceChange();
        newChange.setChangedReference(change.getChangedReference());
        newChange.setReference(change.getReference());
        return ReverseMPatch.reverseIndepChangeAndReplace((IndepChange)change, (IndepChange)newChange);
    }

    private static IndepChange reverseUpdateReferenceChange(IndepUpdateReferenceChange change) {
        IndepUpdateReferenceChange newChange = MPatchFactory.eINSTANCE.createIndepUpdateReferenceChange();
        newChange.setOldReference(change.getNewReference());
        newChange.setNewReference(change.getOldReference());
        newChange.setReference(change.getReference());
        return ReverseMPatch.reverseIndepChangeAndReplace((IndepChange)change, (IndepChange)newChange);
    }

    private static IndepChange reverseIndepChangeAndReplace(IndepChange oldChange, IndepChange newChange) {
        if (oldChange.getResultingElement() != null) {
            newChange.setCorrespondingElement(oldChange.getResultingElement());
            newChange.setResultingElement(oldChange.getCorrespondingElement());
        } else {
            newChange.setCorrespondingElement(oldChange.getCorrespondingElement());
        }
        newChange.getDependants().addAll((Collection)oldChange.getDependants());
        newChange.getDependsOn().addAll((Collection)oldChange.getDependsOn());
        oldChange.getDependants().clear();
        oldChange.getDependsOn().clear();
        if (oldChange.eContainer() == null) {
            throw new IllegalStateException("The change must be contained somewhere: " + oldChange);
        }
        EcoreUtil.replace((EObject)oldChange, (EObject)newChange);
        return newChange;
    }
}

