/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.impl;

import java.util.regex.Pattern;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.compare.mpatch.symrefs.Condition;
import org.eclipse.emf.compare.mpatch.symrefs.ElementSetReference;
import org.eclipse.emf.compare.mpatch.symrefs.OclCondition;
import org.eclipse.emf.compare.mpatch.transform.impl.WeakeningHelper;

public class ScopeExpansion
implements IMPatchTransformation {
    protected static final String EQUAL_REPLACE = "([a-zA-Z0-9]+)\\s*=\\s*'([^']*)'";
    protected static final String EQUAL_REPLACEMENT = "$1.checkSimilarity('$2', 0.7)";
    protected static final Pattern EQUAL_PATTERN = Pattern.compile("([a-zA-Z0-9]+)\\s*=\\s*'([^']*)'");
    protected static final String UML_REPLACE = "and\\s*qualifiedName\\s*=\\s*'[^']*'";
    protected static final String UML_REPLACEMENT = "";
    protected static final Pattern UML_PATTERN = Pattern.compile("and\\s*qualifiedName\\s*=\\s*'[^']*'");
    private static final String LABEL = "Scope Expansion";
    private static final String DESCRIPTION = "This transformation expands the scope of changes by weakening the OCL condition of ElementSetReferences (consition-based Symbolic References). This is an optional transformation and might change the result of MPatch application!\n\nIt widens the conditions for applying changes which makes changes also applicable to slightly different models. The default OCL condition produced for condition-based symbolic references is strictly bound to the original model element by primarily checking its attributes; this transformation weakens the conditions from equality to a similarity check.\nExample: \"self.name = 'Library'\" becomes \"self.name.checkSimilarity('Library', 0.7)\"";

    public String getLabel() {
        return LABEL;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getPriority() {
        return 20;
    }

    public boolean isOptional() {
        return true;
    }

    public int transform(MPatchModel mpatch) {
        return ScopeExpansion.weakenOCLConditions(mpatch);
    }

    public static int weakenOCLConditions(MPatchModel mpatch) {
        int counter = 0;
        for (IElementReference ref : WeakeningHelper.getWeakenableSymbolicReferences(mpatch)) {
            if (!(ref instanceof ElementSetReference)) continue;
            for (Condition condition : ((ElementSetReference)ref).getConditions()) {
                if (!ScopeExpansion.weakenStringCondition(condition)) continue;
                ++counter;
            }
        }
        return counter;
    }

    protected static boolean weakenStringCondition(Condition condition) {
        OclCondition oclCondition;
        String oldExpr;
        String umlExpr;
        String equalExpr;
        if (condition instanceof OclCondition && !(equalExpr = EQUAL_PATTERN.matcher(umlExpr = UML_PATTERN.matcher(oldExpr = (oclCondition = (OclCondition)condition).getExpression()).replaceAll(UML_REPLACEMENT)).replaceAll(EQUAL_REPLACEMENT)).equals(oldExpr)) {
            oclCondition.setExpression(equalExpr);
            return true;
        }
        return false;
    }
}

