/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChangeType implements Enumerator
{
    ELEMENT(0, "element", "element"),
    ATTRIBUTE(1, "attribute", "attribute"),
    REFERENCE(2, "reference", "reference"),
    GROUP(3, "group", "group"),
    UNKNOWN(4, "unknown", "unknown");

    public static final String copyright = "Copyright (c) 2010, 2011 Technical University of Denmark.\r\nAll rights reserved. This program and the accompanying materials \r\nare made available under the terms of the Eclipse Public License v1.0 \r\nwhich accompanies this distribution, and is available at \r\nhttp://www.eclipse.org/legal/epl-v10.html \r\n\r\nContributors:\r\n   Patrick Koenemann, DTU Informatics - initial API and implementation";
    public static final int ELEMENT_VALUE = 0;
    public static final int ATTRIBUTE_VALUE = 1;
    public static final int REFERENCE_VALUE = 2;
    public static final int GROUP_VALUE = 3;
    public static final int UNKNOWN_VALUE = 4;
    private static final ChangeType[] VALUES_ARRAY;
    public static final List<ChangeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ChangeType[]{ELEMENT, ATTRIBUTE, REFERENCE, GROUP, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ChangeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeType get(int value) {
        switch (value) {
            case 0: {
                return ELEMENT;
            }
            case 1: {
                return ATTRIBUTE;
            }
            case 2: {
                return REFERENCE;
            }
            case 3: {
                return GROUP;
            }
            case 4: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private ChangeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

