/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.filter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.EMFCompareUIPlugin;
import org.eclipse.emf.compare.ui.viewer.filter.IDifferenceFilter;

public final class DifferenceFilterDescriptor {
    public static final String ID_PROPERTY = "id";
    public static final String NAME_PROPERTY = "name";
    public static final String CLASS_PROPERTY = "class";
    private final IConfigurationElement element;
    private final String id;
    private final String name;
    private final String classname;
    private IDifferenceFilter extension;

    public DifferenceFilterDescriptor(IConfigurationElement e) {
        this.element = e;
        this.id = e.getAttribute(ID_PROPERTY, "");
        this.name = e.getAttribute(NAME_PROPERTY, "");
        this.classname = e.getAttribute(CLASS_PROPERTY, null);
        DifferenceFilterDescriptor.checks(this);
    }

    public String getID() {
        return this.id;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getName() {
        return this.name;
    }

    private static void checks(DifferenceFilterDescriptor d) {
        if (d.element == null) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("DifferenceFilterDescriptor.nullConfigurationElementException"));
        }
        String missingPropertyKey = "DifferenceFilterDescriptor.missingMandatoryPropertyException";
        if (DifferenceFilterDescriptor.nullOrEmpty(d.getID())) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("DifferenceFilterDescriptor.missingMandatoryPropertyException", ID_PROPERTY));
        }
        if (DifferenceFilterDescriptor.nullOrEmpty(d.getName())) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("DifferenceFilterDescriptor.missingMandatoryPropertyException", NAME_PROPERTY));
        }
        if (DifferenceFilterDescriptor.nullOrEmpty(d.getClassname())) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("DifferenceFilterDescriptor.missingMandatoryPropertyException", CLASS_PROPERTY));
        }
    }

    public IDifferenceFilter getExtension() {
        if (this.extension == null) {
            try {
                this.extension = (IDifferenceFilter)this.element.createExecutableExtension(CLASS_PROPERTY);
            }
            catch (CoreException e) {
                EMFCompareUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.ui", e.getMessage(), (Throwable)e));
            }
        }
        return this.extension;
    }

    private static boolean nullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

