/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff.internal.extension;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.uml2.diff.DiffOfSwitch;
import org.eclipse.emf.compare.uml2.diff.UML2DiffEngine;
import org.eclipse.emf.compare.uml2.diff.internal.extension.IDiffExtensionFactory;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractDiffExtensionFactory
implements IDiffExtensionFactory {
    private UML2DiffEngine fEngine;

    public AbstractDiffExtensionFactory(UML2DiffEngine engine) {
        this.fEngine = engine;
    }

    public UML2DiffEngine getEngine() {
        return this.fEngine;
    }

    public DiffElement getParentDiff(DiffElement input) {
        return (DiffElement)input.eContainer();
    }

    DiffElement findOrCreateDiffElementFor(DiffGroup from, EObject left, EObject right) {
        DiffGroup ret = null;
        if (left == null && right == null) {
            if (!from.getSubDiffElements().isEmpty()) {
                ret = (DiffElement)from.getSubDiffElements().get(0);
            } else {
                ret = DiffFactory.eINSTANCE.createDiffGroup();
                from.getSubDiffElements().add((Object)ret);
            }
        } else {
            DiffElement element = this.findDiffElementFor(from, left, right);
            if (element != null) {
                ret = element;
            } else {
                DiffElement diffParent = this.findOrCreateDiffElementFor(from, this.eContainerIfNotNull(left), this.eContainerIfNotNull(right));
                DiffGroup retGroup = DiffFactory.eINSTANCE.createDiffGroup();
                retGroup.setRightParent(right);
                diffParent.getSubDiffElements().add((Object)retGroup);
                ret = retGroup;
            }
        }
        return ret;
    }

    private EObject eContainerIfNotNull(EObject eObject) {
        return eObject == null ? null : eObject.eContainer();
    }

    DiffElement findDiffElementFor(DiffGroup from, EObject left, EObject right) {
        if (left == null && right == null) {
            return null;
        }
        TreeIterator it = from.eAllContents();
        while (it.hasNext()) {
            DiffElement element = (DiffElement)it.next();
            this.getEngine();
            DiffOfSwitch diffOfSwitch = new DiffOfSwitch(left, right);
            Boolean doSwitch = (Boolean)diffOfSwitch.doSwitch((EObject)element);
            if (doSwitch == null || !doSwitch.booleanValue()) continue;
            return element;
        }
        return null;
    }
}

