/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.match;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.match.engine.GenericMatchEngine;
import org.eclipse.emf.compare.match.engine.GenericMatchScopeProvider;
import org.eclipse.emf.compare.match.engine.IMatchScope;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2MatchEngine
extends GenericMatchEngine {
    public MatchModel resourceMatch(Resource leftResource, Resource rightResource, Map<String, Object> optionMap) throws InterruptedException {
        optionMap.put("match.scope.provider", (Object)new UML2MatchScopeProvider(leftResource, rightResource));
        return super.resourceMatch(leftResource, rightResource, optionMap);
    }

    protected List<EObject> getScopeInternalContents(EObject eObject, IMatchScope scope) {
        ArrayList<EObject> result = new ArrayList<EObject>(super.getScopeInternalContents(eObject, scope));
        result.addAll(this.getStereotypeApplications(eObject));
        return result;
    }

    private List<EObject> getStereotypeApplications(EObject eObject) {
        if (eObject instanceof Element) {
            return ((Element)eObject).getStereotypeApplications();
        }
        return Collections.emptyList();
    }

    private static class UML2MatchScope
    implements IMatchScope {
        private final IMatchScope fParentScope;

        private UML2MatchScope(IMatchScope scope) {
            this.fParentScope = scope;
        }

        public boolean isInScope(EObject eObject) {
            return this.fParentScope.isInScope(eObject) && UMLUtil.getStereotype((EObject)eObject) == null;
        }

        public boolean isInScope(Resource resource) {
            return this.fParentScope.isInScope(resource);
        }
    }

    private static class UML2MatchScopeProvider
    extends GenericMatchScopeProvider {
        public UML2MatchScopeProvider(Resource leftResource, Resource rightResource) {
            super(leftResource, rightResource);
        }

        public IMatchScope getLeftScope() {
            return new UML2MatchScope(super.getLeftScope());
        }

        public IMatchScope getRightScope() {
            return new UML2MatchScope(super.getRightScope());
        }

        public IMatchScope getAncestorScope() {
            return new UML2MatchScope(super.getAncestorScope());
        }
    }
}

