/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.symrefs.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.generic.Activator;
import org.eclipse.emf.compare.mpatch.symrefs.OclCondition;
import org.eclipse.emf.compare.mpatch.symrefs.util.RegexEnvironmentFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.handlers.PruneHandler;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.OCLExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLConditionHelper {
    protected static final OCL ocl = OCL.newInstance((EnvironmentFactory)new RegexEnvironmentFactory());
    private static final Map<String, EObjectCondition> cachedConditions = new HashMap<String, EObjectCondition>();

    public static Collection<EObject> collectValidElements(OclCondition condition, EObject model) {
        IQueryResult result;
        EObjectCondition whereCondition = OCLConditionHelper.getWhereCondition(condition);
        if (whereCondition == null) {
            return Collections.emptyList();
        }
        try {
            result = new SELECT(new FROM(model), new WHERE(whereCondition)).execute();
        }
        catch (Exception e) {
            Activator.getDefault().logError("Error while executing OCL statement with condition: " + whereCondition, e);
            return Collections.emptyList();
        }
        return result;
    }

    public static EObjectCondition getWhereCondition(OclCondition condition) {
        String key = String.valueOf(condition.getElementReference().getType().getInstanceClassName()) + (condition.isCheckType() ? "?" : "!") + condition.getExpression();
        EObjectCondition whereCondition = cachedConditions.get(key);
        if (whereCondition == null) {
            OCL.Query query;
            OCL.Helper helper = ocl.createOCLHelper();
            helper.setContext((Object)condition.getElementReference().getType());
            try {
                OCLExpression oclExpression = helper.createQuery(condition.getExpression());
                query = ocl.createQuery(oclExpression);
            }
            catch (ParserException e) {
                Activator.getDefault().logError("Error while parsing ocl condition: " + condition.getExpression(), e);
                return null;
            }
            whereCondition = new BooleanOCLCondition(ocl.getEnvironment(), (Query)query, (Object)(condition.isCheckType() ? condition.getElementReference().getType() : null), PruneHandler.NEVER);
            cachedConditions.put(key, whereCondition);
        }
        return whereCondition;
    }
}

