/**
 * Copyright (c) 2011 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 */
package org.eclipse.emf.compare.uml2diff.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.compare.uml2diff.util.UML2DiffAdapterFactory;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class UML2DiffItemProviderAdapterFactory extends UML2DiffAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UML2DiffItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.uml2diff.UMLAbstractionChangeLeftTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLAbstractionChangeLeftTargetItemProvider umlAbstractionChangeLeftTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.uml2diff.UMLAbstractionChangeLeftTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUMLAbstractionChangeLeftTargetAdapter() {
		if (umlAbstractionChangeLeftTargetItemProvider == null) {
			umlAbstractionChangeLeftTargetItemProvider = new UMLAbstractionChangeLeftTargetItemProvider(this);
		}

		return umlAbstractionChangeLeftTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.uml2diff.UMLAbstractionChangeRightTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLAbstractionChangeRightTargetItemProvider umlAbstractionChangeRightTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.uml2diff.UMLAbstractionChangeRightTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUMLAbstractionChangeRightTargetAdapter() {
		if (umlAbstractionChangeRightTargetItemProvider == null) {
			umlAbstractionChangeRightTargetItemProvider = new UMLAbstractionChangeRightTargetItemProvider(this);
		}

		return umlAbstractionChangeRightTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.uml2diff.UMLAssociationChangeLeftTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLAssociationChangeLeftTargetItemProvider umlAssociationChangeLeftTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.uml2diff.UMLAssociationChangeLeftTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUMLAssociationChangeLeftTargetAdapter() {
		if (umlAssociationChangeLeftTargetItemProvider == null) {
			umlAssociationChangeLeftTargetItemProvider = new UMLAssociationChangeLeftTargetItemProvider(this);
		}

		return umlAssociationChangeLeftTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.uml2diff.UMLAssociationChangeRightTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLAssociationChangeRightTargetItemProvider umlAssociationChangeRightTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.uml2diff.UMLAssociationChangeRightTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUMLAssociationChangeRightTargetAdapter() {
		if (umlAssociationChangeRightTargetItemProvider == null) {
			umlAssociationChangeRightTargetItemProvider = new UMLAssociationChangeRightTargetItemProvider(this);
		}

		return umlAssociationChangeRightTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeAttributeChangeLeftTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLStereotypeAttributeChangeLeftTargetItemProvider umlStereotypeAttributeChangeLeftTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeAttributeChangeLeftTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUMLStereotypeAttributeChangeLeftTargetAdapter() {
		if (umlStereotypeAttributeChangeLeftTargetItemProvider == null) {
			umlStereotypeAttributeChangeLeftTargetItemProvider = new UMLStereotypeAttributeChangeLeftTargetItemProvider(this);
		}

		return umlStereotypeAttributeChangeLeftTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeAttributeChangeRightTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLStereotypeAttributeChangeRightTargetItemProvider umlStereotypeAttributeChangeRightTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeAttributeChangeRightTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUMLStereotypeAttributeChangeRightTargetAdapter() {
		if (umlStereotypeAttributeChangeRightTargetItemProvider == null) {
			umlStereotypeAttributeChangeRightTargetItemProvider = new UMLStereotypeAttributeChangeRightTargetItemProvider(this);
		}

		return umlStereotypeAttributeChangeRightTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeUpdateAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLStereotypeUpdateAttributeItemProvider umlStereotypeUpdateAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeUpdateAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUMLStereotypeUpdateAttributeAdapter() {
		if (umlStereotypeUpdateAttributeItemProvider == null) {
			umlStereotypeUpdateAttributeItemProvider = new UMLStereotypeUpdateAttributeItemProvider(this);
		}

		return umlStereotypeUpdateAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeApplicationAddition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLStereotypeApplicationAdditionItemProvider umlStereotypeApplicationAdditionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeApplicationAddition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUMLStereotypeApplicationAdditionAdapter() {
		if (umlStereotypeApplicationAdditionItemProvider == null) {
			umlStereotypeApplicationAdditionItemProvider = new UMLStereotypeApplicationAdditionItemProvider(this);
		}

		return umlStereotypeApplicationAdditionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeApplicationRemoval} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLStereotypeApplicationRemovalItemProvider umlStereotypeApplicationRemovalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.compare.uml2diff.UMLStereotypeApplicationRemoval}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUMLStereotypeApplicationRemovalAdapter() {
		if (umlStereotypeApplicationRemovalItemProvider == null) {
			umlStereotypeApplicationRemovalItemProvider = new UMLStereotypeApplicationRemovalItemProvider(this);
		}

		return umlStereotypeApplicationRemovalItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (umlAbstractionChangeLeftTargetItemProvider != null) umlAbstractionChangeLeftTargetItemProvider.dispose();
		if (umlAbstractionChangeRightTargetItemProvider != null) umlAbstractionChangeRightTargetItemProvider.dispose();
		if (umlAssociationChangeLeftTargetItemProvider != null) umlAssociationChangeLeftTargetItemProvider.dispose();
		if (umlAssociationChangeRightTargetItemProvider != null) umlAssociationChangeRightTargetItemProvider.dispose();
		if (umlStereotypeAttributeChangeLeftTargetItemProvider != null) umlStereotypeAttributeChangeLeftTargetItemProvider.dispose();
		if (umlStereotypeAttributeChangeRightTargetItemProvider != null) umlStereotypeAttributeChangeRightTargetItemProvider.dispose();
		if (umlStereotypeUpdateAttributeItemProvider != null) umlStereotypeUpdateAttributeItemProvider.dispose();
		if (umlStereotypeApplicationAdditionItemProvider != null) umlStereotypeApplicationAdditionItemProvider.dispose();
		if (umlStereotypeApplicationRemovalItemProvider != null) umlStereotypeApplicationRemovalItemProvider.dispose();
	}

}
