/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.common.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private static final Point IMAGE_SIZE = new Point(16, 16);
    private final Image originalImage;
    private final ImageDescriptor overlayDescriptor;

    public OverlayImageDescriptor(Image originalImage, ImageDescriptor overlayDescriptor) {
        this.originalImage = originalImage;
        this.overlayDescriptor = overlayDescriptor;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData backgroundData = this.originalImage.getImageData();
        ImageData overlayData = this.overlayDescriptor.getImageData();
        if (backgroundData != null) {
            this.drawImage(backgroundData, 0, 0);
        }
        if (overlayData != null) {
            this.drawImage(overlayData, 0, OverlayImageDescriptor.IMAGE_SIZE.y - overlayData.height);
        }
    }

    protected Point getSize() {
        return IMAGE_SIZE;
    }
}

