/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.ui.viewer.filter.IDifferenceFilter;
import org.eclipse.emf.compare.ui.viewer.group.IDifferenceGroupingFacility;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedStructureContentProvider
extends ModelStructureContentProvider {
    private static IDifferenceGroupingFacility mSelectedGroupFacility;
    private static List<IDifferenceFilter> mSelectedFilters;

    public ParameterizedStructureContentProvider(CompareConfiguration compareConfiguration) {
        super(compareConfiguration);
    }

    public ParameterizedStructureContentProvider(CompareConfiguration compareConfiguration, IDifferenceGroupingFacility selectedGroupFacility, List<IDifferenceFilter> selectedFilters) {
        this(compareConfiguration);
        mSelectedGroupFacility = selectedGroupFacility;
        mSelectedFilters = selectedFilters;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (mSelectedGroupFacility == null) {
            return super.getElements(inputElement);
        }
        return this.getGroupsWithChildren().toArray();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        Object[] result = this.groupElements(parentElement);
        return this.filterElements(result);
    }

    @Override
    public boolean hasChildren(Object element) {
        return super.hasChildren(element) || element instanceof IDifferenceGroupingFacility.UIDifferenceGroup;
    }

    protected Object[] groupElements(Object parentElement) {
        if (parentElement instanceof IDifferenceGroupingFacility.UIDifferenceGroup && mSelectedGroupFacility != null) {
            ArrayList<DiffElement> diffs = new ArrayList<DiffElement>();
            if (this.input instanceof DiffModel) {
                for (DiffElement diff : ((DiffModel)this.input).getDifferences()) {
                    if (!parentElement.equals(mSelectedGroupFacility.belongsTo(diff))) continue;
                    diffs.add(diff);
                }
            }
            return diffs.toArray();
        }
        return super.getChildren(parentElement);
    }

    protected Object[] filterElements(Object[] elements) {
        List<Object> lResult = Arrays.asList(elements);
        ArrayList<Object> filteredResult = new ArrayList<Object>();
        filteredResult.addAll(lResult);
        for (Object obj : lResult) {
            if (!(obj instanceof DiffElement) || !ParameterizedStructureContentProvider.isHidden((DiffElement)obj)) continue;
            filteredResult.remove(obj);
        }
        return filteredResult.toArray();
    }

    public static boolean isHidden(DiffElement element) {
        if (mSelectedFilters != null) {
            for (IDifferenceFilter diffFilter : mSelectedFilters) {
                if (!diffFilter.hides(element)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<IDifferenceGroupingFacility.UIDifferenceGroup> getGroupsWithChildren() {
        ArrayList<IDifferenceGroupingFacility.UIDifferenceGroup> result = new ArrayList<IDifferenceGroupingFacility.UIDifferenceGroup>();
        if (mSelectedGroupFacility != null) {
            for (IDifferenceGroupingFacility.UIDifferenceGroup group : mSelectedGroupFacility.allGroups()) {
                if (this.getChildren(group).length <= 0) continue;
                result.add(group);
            }
        }
        return result;
    }

    public static void setSelectedGroupFacility(IDifferenceGroupingFacility groupingFacility) {
        mSelectedGroupFacility = groupingFacility;
    }

    public void addSelectedFilter(IDifferenceFilter filter) {
        if (mSelectedFilters == null) {
            mSelectedFilters = new ArrayList<IDifferenceFilter>();
        }
        mSelectedFilters.add(filter);
    }

    public void removeSelectedFilter(IDifferenceFilter filter) {
        if (mSelectedFilters != null) {
            mSelectedFilters.remove(filter);
        }
    }
}

