/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.common.util.ExtensionManager;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.Emfdiff2mpatchActivator;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.util.TransformationLauncher;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.compare.mpatch.extension.IModelDescriptorCreator;
import org.eclipse.emf.compare.mpatch.extension.ISymbolicReferenceCreator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BatchCreateMPatchAction
implements IObjectActionDelegate {
    private static final String DEFAULT_FILE_NAME = "result.mpatch";
    private Shell shell;
    private int successes = 0;
    private int failures = 0;
    private final List<IContainer> containers = new ArrayList<IContainer>();

    public void run(IAction action) {
        this.failures = 0;
        this.successes = 0;
        for (IContainer container : this.containers) {
            try {
                container.refreshLocal(2, null);
                this.processContainer(container);
            }
            catch (CoreException e) {
                Emfdiff2mpatchActivator.getDefault().logError("Error processing container " + container.getName(), e);
                ++this.failures;
            }
        }
        String msg = String.valueOf(this.successes) + " files successfully created.";
        if (this.failures > 0) {
            msg = String.valueOf(msg) + "\n" + this.failures + " errors occured. Please check error log.";
        }
        MessageDialog.openInformation((Shell)this.shell, (String)"MPatch Creation results", (String)msg);
    }

    private void processContainer(IContainer container) throws CoreException {
        IResource unchanged = null;
        IResource changed = null;
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            if (child instanceof IContainer) {
                this.processContainer((IContainer)child);
            } else if (!child.getName().endsWith("_diagram") && !child.getName().endsWith(".umlclass")) {
                if (child.getName().startsWith("unchanged.")) {
                    unchanged = child;
                } else if (child.getName().startsWith("changed.")) {
                    changed = child;
                }
            }
            ++n2;
        }
        if (changed != null && unchanged != null && unchanged.getFileExtension().equals(changed.getFileExtension())) {
            this.createMPatch(container, unchanged, changed);
        }
    }

    private void createMPatch(IContainer container, IResource unchanged, IResource changed) {
        try {
            IMPatchTransformation trans;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource oldResource = resourceSet.getResource(URI.createFileURI((String)unchanged.getFullPath().toString()), true);
            Resource newResource = resourceSet.getResource(URI.createFileURI((String)changed.getFullPath().toString()), true);
            EObject oldModel = (EObject)oldResource.getContents().get(0);
            EObject newModel = (EObject)newResource.getContents().get(0);
            ComparisonResourceSnapshot emfdiff = CommonUtils.createEmfdiff((EObject)newModel, (EObject)oldModel, (boolean)false);
            ISymbolicReferenceCreator symrefCreator = ExtensionManager.getSelectedSymbolicReferenceCreator();
            IModelDescriptorCreator descriptorCreator = ExtensionManager.getSelectedModelDescriptorCreator();
            MPatchModel mpatch = TransformationLauncher.transform((ComparisonSnapshot)emfdiff, null, symrefCreator, descriptorCreator);
            for (String label : ExtensionManager.getMandatoryTransformations()) {
                trans = (IMPatchTransformation)ExtensionManager.getAllTransformations().get(label);
                trans.transform(mpatch);
            }
            for (String label : ExtensionManager.getSelectedOptionalTransformations()) {
                trans = (IMPatchTransformation)ExtensionManager.getAllTransformations().get(label);
                trans.transform(mpatch);
            }
            IPath mPatchPath = container.getFullPath().append(DEFAULT_FILE_NAME);
            ResourceSetImpl newResourceSet = new ResourceSetImpl();
            Resource resource = newResourceSet.createResource(URI.createFileURI((String)mPatchPath.toString()));
            resource.getContents().add((Object)mpatch);
            resource.save(null);
            ++this.successes;
        }
        catch (Exception e) {
            Emfdiff2mpatchActivator.getDefault().logError("Error creating MPatch for " + unchanged.getName() + " and " + changed.getName(), e);
            ++this.failures;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.containers.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IContainer) {
                    this.containers.add((IContainer)obj);
                }
                ++n2;
            }
        }
        action.setEnabled(!this.containers.isEmpty());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

