/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.emfdiff2mpatch.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.mpatch.emfdiff2mpatch.wizards.EmfdiffExportWizard;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class StartTransformationAction
implements IObjectActionDelegate {
    private IFile file;
    private Shell shell;

    public void run(IAction action) {
        if (this.file != null) {
            Resource emfdiffResource = new ResourceSetImpl().getResource(URI.createFileURI((String)this.file.getFullPath().toString()), true);
            if (emfdiffResource.getContents().size() > 0 && emfdiffResource.getContents().get(0) instanceof ComparisonSnapshot) {
                ComparisonSnapshot snapshot = (ComparisonSnapshot)emfdiffResource.getContents().get(0);
                EmfdiffExportWizard wizard = new EmfdiffExportWizard();
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, (IStructuredSelection)new StructuredSelection((Object)snapshot));
                WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
                dialog.open();
            } else {
                MessageDialog.openWarning((Shell)this.shell, (String)"Invalid emfdiff", (String)"Cannot find a ComparisonSnapshot in the emfdiff file! Please make sure the file is not corrupt.");
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof IFile) {
                this.file = (IFile)structuredSelection.getFirstElement();
                if (!"emfdiff".equals(this.file.getFileExtension())) {
                    this.file = null;
                }
            } else {
                this.file = null;
            }
        } else {
            this.file = null;
        }
        action.setEnabled(this.file != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

