/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.apply.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.apply.wizards.ApplyWizard;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ApplyWizardSelectMPatchPage
extends WizardPage {
    private URI uri;
    private Text uriText;
    private TreeViewer viewer;
    private final AdapterFactory adapterFactory;

    public ApplyWizardSelectMPatchPage(String pageName, IFile file, AdapterFactory adapterFactory) {
        super(pageName);
        if (file != null) {
            this.uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        }
        this.setTitle(pageName);
        this.setDescription("Select MPatch");
        this.adapterFactory = adapterFactory;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&MPatch:");
        this.uriText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.uriText.setLayoutData((Object)gd);
        this.uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApplyWizardSelectMPatchPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("B&rowse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplyWizardSelectMPatchPage.this.handleBrowse();
            }
        });
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = 3;
        Label infoLabel = new Label(container, 0);
        infoLabel.setLayoutData((Object)gd1);
        infoLabel.setText("Contents of the selected resource:");
        GridData gd2 = new GridData(272);
        gd2.horizontalSpan = 3;
        gd2.grabExcessHorizontalSpace = true;
        gd2.grabExcessVerticalSpace = true;
        this.viewer = new TreeViewer(container, 2818);
        this.viewer.getTree().setLayoutData((Object)gd2);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.initialize();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.uri != null && this.uriText.getText().length() == 0) {
            this.uriText.setText(this.uri.toString());
        } else {
            this.uriText.setText("");
        }
    }

    private void handleBrowse() {
        ResourceDialog dialog = new ResourceDialog(this.getShell(), "Select MPatch", 4100);
        if (dialog.open() == 0) {
            if (dialog.getURIs().size() >= 1) {
                this.uri = (URI)dialog.getURIs().get(0);
                this.uriText.setText(this.uri.toString());
            } else {
                this.uri = null;
                this.uriText.setText("");
            }
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void dialogChanged() {
        block5: {
            String fileUri = this.uriText.getText().trim();
            this.viewer.setInput(null);
            if (fileUri.length() > 0) {
                try {
                    this.uri = URI.createURI((String)fileUri);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource diffResource = resourceSet.getResource(this.uri, true);
                    if (diffResource.getContents().get(0) instanceof MPatchModel) {
                        MPatchModel mpatch = (MPatchModel)diffResource.getContents().get(0);
                        ((ApplyWizard)this.getWizard()).setMPatch(mpatch);
                        this.viewer.setInput((Object)diffResource);
                        this.updateStatus(null);
                        break block5;
                    }
                    this.updateStatus("The selected resource does not contain valid MPatch!");
                    this.uri = null;
                }
                catch (RuntimeException e) {
                    this.updateStatus("Exception loading resource: " + e.getMessage() + " " + e.getStackTrace()[0] + "...");
                }
            } else {
                this.updateStatus("Please select an input file.");
            }
        }
    }
}

