/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.mpatch.ChangeGroup;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IModelDescriptor;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchFactory;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.UnknownChange;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMPatchGrouping
implements IMPatchTransformation {
    public static final String LABEL = "Intuitive Grouping";
    private static final String DESCRIPTION = "This transformation introduces groups in the MPatch for structuring the changes. This is an optional transformation and makes the MPatch easier to read.\n\nThe groups do not have any functional aspect but are introduced for convenience only.\nThe grouping strategy is a heuristic algorithm which works as follows.\nAssumption: each change in the MPatch as well as all model elements (defined by their URI) are nodes in a graph, and all Symbolic References are (undirected) arcs.\nThen the changes of each *connected component* are put into one group.";

    public String getLabel() {
        return LABEL;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getPriority() {
        return 40;
    }

    public boolean isOptional() {
        return true;
    }

    public int transform(MPatchModel mpatch) {
        return DefaultMPatchGrouping.group(mpatch);
    }

    public static int group(MPatchModel mpatch) throws IllegalArgumentException {
        Set<IndepChange> changes = DefaultMPatchGrouping.checkModel(mpatch);
        Set<Set<IndepChange>> groups = DefaultMPatchGrouping.analyzeChanges(changes);
        return DefaultMPatchGrouping.regroup(mpatch, groups);
    }

    protected static Set<IndepChange> checkModel(MPatchModel mpatch) throws IllegalArgumentException {
        HashSet<IndepChange> changes = new HashSet<IndepChange>();
        for (IndepChange change : mpatch.getChanges()) {
            if (change instanceof ChangeGroup) {
                throw new IllegalArgumentException("Input expected not to contain groups, but it already does:\n" + change);
            }
            changes.add(change);
        }
        if (changes.size() == 0) {
            throw new IllegalArgumentException("Input is empty!");
        }
        return changes;
    }

    protected static Set<Set<IndepChange>> analyzeChanges(Set<IndepChange> changes) {
        T2<Map<IndepChange, Set<String>>, Map<String, Set<IndepChange>>> maps = DefaultMPatchGrouping.fillMaps(changes);
        HashSet<Set<IndepChange>> groups = new HashSet<Set<IndepChange>>();
        LinkedList<IndepChange> queue = new LinkedList<IndepChange>();
        HashSet processed = new HashSet();
        for (IndepChange change : ((Map)maps.s).keySet()) {
            if (processed.contains(change)) continue;
            HashSet<IndepChange> group = new HashSet<IndepChange>();
            groups.add(group);
            queue.add(change);
            while (!queue.isEmpty()) {
                IndepChange current = (IndepChange)queue.remove();
                group.add(current);
                for (String ref : (Set)((Map)maps.s).get(current)) {
                    for (IndepChange refChange : (Set)((Map)maps.t).get(ref)) {
                        if (group.contains(refChange) || queue.contains(refChange)) continue;
                        queue.add(refChange);
                    }
                }
            }
            processed.addAll(group);
        }
        return groups;
    }

    protected static T2<Map<IndepChange, Set<String>>, Map<String, Set<IndepChange>>> fillMaps(Set<IndepChange> changes) {
        HashMap changeToRefMap = new HashMap();
        HashMap refToChangeMap = new HashMap();
        for (IndepChange change : changes) {
            if (change instanceof UnknownChange) {
                DefaultMPatchGrouping.addElementToSetMap("<unknown>", change, refToChangeMap);
                DefaultMPatchGrouping.addElementToSetMap(change, "<unknown>", changeToRefMap);
                continue;
            }
            HashSet<String> references = new HashSet<String>();
            for (EReference containment : change.eClass().getEAllContainments()) {
                ArrayList<EObject> children = new ArrayList<EObject>();
                if (containment.isMany()) {
                    children.addAll((List)change.eGet((EStructuralFeature)containment));
                } else {
                    children.add((EObject)change.eGet((EStructuralFeature)containment));
                }
                for (EObject eObject : children) {
                    if (eObject instanceof IModelDescriptor) {
                        IModelDescriptor descriptor = (IModelDescriptor)eObject;
                        ArrayList descriptorReferences = new ArrayList();
                        descriptorReferences.addAll(descriptor.getAllCrossReferences());
                        descriptorReferences.addAll(descriptor.getAllSelfReferences());
                        for (IElementReference ref : descriptorReferences) {
                            references.add(DefaultMPatchGrouping.getSymbolicReferenceRepresentative(ref));
                            DefaultMPatchGrouping.addElementToSetMap(DefaultMPatchGrouping.getSymbolicReferenceRepresentative(ref), change, refToChangeMap);
                        }
                        continue;
                    }
                    if (!(eObject instanceof IElementReference)) continue;
                    references.add(DefaultMPatchGrouping.getSymbolicReferenceRepresentative((IElementReference)eObject));
                    DefaultMPatchGrouping.addElementToSetMap(DefaultMPatchGrouping.getSymbolicReferenceRepresentative((IElementReference)eObject), change, refToChangeMap);
                }
            }
            changeToRefMap.put(change, references);
        }
        return new T2<Map<IndepChange, Set<String>>, Map<String, Set<IndepChange>>>(changeToRefMap, refToChangeMap);
    }

    protected static <T, S> void addElementToSetMap(T key, S element, Map<T, Set<S>> map) {
        Set<S> set = map.get(key);
        if (set == null) {
            set = new HashSet<S>();
            map.put(key, set);
        }
        set.add(element);
    }

    protected static String getSymbolicReferenceRepresentative(IElementReference reference) {
        String uriReference = reference.getUriReference();
        if (uriReference.indexOf("#") > 0) {
            return uriReference.substring(uriReference.indexOf("#"));
        }
        return uriReference;
    }

    protected static int regroup(MPatchModel mpatch, Set<Set<IndepChange>> changeGroups) {
        for (Set<IndepChange> group : changeGroups) {
            ChangeGroup changeGroup = MPatchFactory.eINSTANCE.createChangeGroup();
            mpatch.getChanges().add((Object)changeGroup);
            changeGroup.getSubChanges().addAll(group);
        }
        return changeGroups.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class T2<S, T> {
        public final S s;
        public final T t;

        public T2(S s, T t) {
            this.s = s;
            this.t = t;
        }
    }
}

