/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.actions;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.common.actions.AbstractCompareAction;
import org.eclipse.emf.compare.mpatch.extension.IMPatchTransformation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class AbstractGeneralizationAction
extends AbstractCompareAction {
    private static final String ACTION_NAME = "Generalization";
    private static final String inputFileExtension = "mpatch";
    private static final String outputFileExtension = "mpatch";
    private static final String jobTitle = "Generalization of MPatch...";

    public AbstractGeneralizationAction() {
        super("mpatch", "mpatch", jobTitle);
    }

    protected abstract IMPatchTransformation getTransformation();

    protected final Status runAction(Resource input, Resource output, IProgressMonitor monitor) {
        Exception exception;
        int code;
        String message;
        block7: {
            message = "";
            code = 0;
            exception = null;
            EObject content = (EObject)input.getContents().get(0);
            if (content instanceof MPatchModel) {
                MPatchModel mpatch = (MPatchModel)content;
                try {
                    int modifications = this.getTransformation().transform(mpatch);
                    if (modifications > 0) {
                        output.getContents().add((Object)mpatch);
                        try {
                            output.save(null);
                            message = "Generalization successfully finished: " + modifications + " modifications.";
                        }
                        catch (IOException e) {
                            code = 4;
                            message = "Could not save generalized MPatch!";
                            exception = e;
                        }
                        break block7;
                    }
                    message = "Generalization finished but did not change anything.";
                }
                catch (Exception e) {
                    message = "An exception occured during transformation: Generalization";
                    code = 4;
                    exception = e;
                }
            } else {
                code = 4;
                message = "Could not find MPatch in:\n\n" + content;
            }
        }
        return new Status(code, "org.eclipse.emf.compare.mpatch.transform", message, (Throwable)exception);
    }
}

