/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.merge.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.internal.merge.DefaultMergerProvider;
import org.eclipse.emf.compare.diff.merge.DefaultMerger;
import org.eclipse.emf.compare.diff.merge.IMerger;
import org.eclipse.emf.compare.diff.merge.service.MergerProviderDescriptor;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.util.ClassUtils;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MergeFactory {
    private static final String ALL_EXTENSIONS = "*";
    private static String lastExtension = "";
    private static final String MERGER_PROVIDER_EXTENSION_POINT = "org.eclipse.emf.compare.diff.mergerprovider";
    private static final Map<Class<? extends DiffElement>, Class<? extends IMerger>> MERGER_TYPES = new EMFCompareMap();
    private static final Map<String, ArrayList<MergerProviderDescriptor>> PARSED_PROVIDERS = new EMFCompareMap();
    private static final String TAG_PROVIDER = "mergerprovider";
    private static final int[] MERGER_PRIORITIES = new int[]{1, 2, 3, 4, 5};

    static {
        MergeFactory.parseExtensionMetadata();
    }

    private MergeFactory() {
    }

    public static IMerger createMerger(DiffElement element) {
        IMerger elementMerger = null;
        if (element instanceof AbstractDiffExtension) {
            elementMerger = ((AbstractDiffExtension)((Object)element)).provideMerger();
        }
        if (elementMerger == null) {
            try {
                Class<? extends IMerger> mergerClass = MergeFactory.getBestMerger(element);
                elementMerger = mergerClass.newInstance();
            }
            catch (InstantiationException e) {
                EMFComparePlugin.log((String)e.getMessage(), (boolean)false);
            }
            catch (IllegalAccessException e) {
                EMFComparePlugin.log((String)e.getMessage(), (boolean)false);
            }
        }
        if (elementMerger != null) {
            elementMerger.setDiffElement(element);
        }
        return elementMerger;
    }

    private static Class<? extends IMerger> getBestMerger(DiffElement element) {
        Map<Class<? extends DiffElement>, Class<? extends IMerger>> mergersMap;
        Class mergerClass = DefaultMerger.class;
        EObject rightElement = (EObject)ClassUtils.invokeMethod((Object)element, (String)"getRightElement", (Object[])new Object[0]);
        if (rightElement == null) {
            rightElement = (EObject)ClassUtils.invokeMethod((Object)element, (String)"getRightParent", (Object[])new Object[0]);
        }
        String resourceFileExtension = null;
        if (rightElement != null && rightElement.eResource() != null) {
            resourceFileExtension = rightElement.eResource().getURI().fileExtension();
        }
        if (resourceFileExtension == null) {
            resourceFileExtension = ALL_EXTENSIONS;
        }
        if ((mergersMap = EMFPlugin.IS_ECLIPSE_RUNNING ? MergeFactory.getMergerTypes(resourceFileExtension) : MERGER_TYPES).containsKey(element.getClass())) {
            mergerClass = mergersMap.get(element.getClass());
        } else {
            for (Map.Entry<Class<? extends DiffElement>, Class<? extends IMerger>> entry : mergersMap.entrySet()) {
                if (!entry.getKey().isInstance(element)) continue;
                mergerClass = entry.getValue();
                break;
            }
        }
        return mergerClass;
    }

    private static Map<Class<? extends DiffElement>, Class<? extends IMerger>> getMergerTypes(String fileExtension) {
        if (!fileExtension.equals(lastExtension)) {
            lastExtension = fileExtension;
            MERGER_TYPES.clear();
            int[] nArray = MERGER_PRIORITIES;
            int n = MERGER_PRIORITIES.length;
            int n2 = 0;
            while (n2 < n) {
                List list;
                int priority = nArray[n2];
                EMFCompareMap mergers = new EMFCompareMap();
                if (PARSED_PROVIDERS.containsKey(ALL_EXTENSIONS)) {
                    list = PARSED_PROVIDERS.get(ALL_EXTENSIONS);
                    Collections.sort(list);
                    for (MergerProviderDescriptor descriptor : list) {
                        if (descriptor.getPriorityValue(descriptor.priority) != priority) continue;
                        mergers.putAll(descriptor.getMergerProviderInstance().getMergers());
                    }
                }
                if (PARSED_PROVIDERS.containsKey(fileExtension)) {
                    list = PARSED_PROVIDERS.get(fileExtension);
                    Collections.sort(list);
                    for (MergerProviderDescriptor descriptor : list) {
                        if (descriptor.getPriorityValue(descriptor.priority) != priority) continue;
                        mergers.putAll(descriptor.getMergerProviderInstance().getMergers());
                    }
                }
                MERGER_TYPES.putAll((Map<Class<? extends DiffElement>, Class<? extends IMerger>>)mergers);
                ++n2;
            }
        }
        return MERGER_TYPES;
    }

    private static void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(MERGER_PROVIDER_EXTENSION_POINT).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    MergerProviderDescriptor desc = MergeFactory.parseProvider(configElements[j]);
                    MergeFactory.storeProviderDescriptor(desc);
                    ++j;
                }
                ++i;
            }
        } else {
            MERGER_TYPES.putAll(new DefaultMergerProvider().getMergers());
        }
    }

    private static MergerProviderDescriptor parseProvider(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_PROVIDER)) {
            return null;
        }
        MergerProviderDescriptor desc = new MergerProviderDescriptor(configElement);
        return desc;
    }

    private static void storeProviderDescriptor(MergerProviderDescriptor desc) {
        String[] extensions;
        if (desc.getFileExtension() == null) {
            return;
        }
        String[] stringArray = extensions = desc.getFileExtension().split(",");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String mergerExtension = stringArray[n2];
            if (!PARSED_PROVIDERS.containsKey(mergerExtension)) {
                PARSED_PROVIDERS.put(mergerExtension, new ArrayList());
            }
            List set = PARSED_PROVIDERS.get(mergerExtension);
            set.add(desc);
            ++n2;
        }
    }
}

