/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff.internal.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffPackage;
import org.eclipse.emf.compare.uml2.diff.UML2DiffEngine;
import org.eclipse.emf.compare.uml2.diff.internal.extension.IDiffExtensionFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiffExtensionFactory
implements IDiffExtensionFactory {
    private UML2DiffEngine fEngine;
    private EcoreUtil.CrossReferencer fCrossReferencer;
    private static final UMLPredicate<?> ALWAYS_TRUE = new UMLPredicate<Object>(){

        @Override
        public boolean apply(Object input) {
            return true;
        }
    };

    protected AbstractDiffExtensionFactory(UML2DiffEngine engine, EcoreUtil.CrossReferencer crossReferencer) {
        this.fEngine = engine;
        this.fCrossReferencer = crossReferencer;
    }

    protected final UML2DiffEngine getEngine() {
        return this.fEngine;
    }

    protected final EcoreUtil.CrossReferencer getCrossReferencer() {
        return this.fCrossReferencer;
    }

    @Override
    public DiffElement getParentDiff(DiffElement input) {
        return (DiffElement)input.eContainer();
    }

    protected final DiffGroup findOrCreateDiffGroup(DiffModel diffModel, EObject right) {
        DiffGroup referencingDiffGroup = this.firstReferencingDiffGroup((Collection)this.getCrossReferencer().get((Object)right));
        if (referencingDiffGroup == null) {
            List<EObject> ancestors = this.ancestors(right);
            for (EObject ancestor : ancestors) {
                referencingDiffGroup = this.firstReferencingDiffGroup((Collection)this.getCrossReferencer().get((Object)ancestor));
                if (referencingDiffGroup == null) continue;
                ArrayList<EObject> ancestorsAndSelf = new ArrayList<EObject>(ancestors);
                ancestorsAndSelf.add(0, right);
                referencingDiffGroup = this.createSubTreeOfDiffGroup(referencingDiffGroup, ancestorsAndSelf);
                break;
            }
            if (referencingDiffGroup == null) {
                if (diffModel.getRightRoots().contains((Object)ancestors.get(ancestors.size() - 1)) && !diffModel.getOwnedElements().isEmpty()) {
                    referencingDiffGroup = (DiffGroup)diffModel.getOwnedElements().get(0);
                } else {
                    referencingDiffGroup = DiffFactory.eINSTANCE.createDiffGroup();
                    diffModel.getOwnedElements().add((Object)referencingDiffGroup);
                }
            }
        }
        return referencingDiffGroup;
    }

    private DiffGroup createSubTreeOfDiffGroup(DiffGroup referencingDiffGroup, List<EObject> ancestors) {
        List<EObject> subList = ancestors.subList(0, ancestors.indexOf(referencingDiffGroup.getRightParent()));
        DiffGroup createdGroup = referencingDiffGroup;
        ListIterator<EObject> it = subList.listIterator(subList.size());
        while (it.hasPrevious()) {
            EObject previous = it.previous();
            DiffGroup newGroup = DiffFactory.eINSTANCE.createDiffGroup();
            createdGroup.getSubDiffElements().add((Object)newGroup);
            newGroup.setRightParent(previous);
            newGroup.setRemote(createdGroup.isRemote());
            createdGroup = newGroup;
        }
        return createdGroup;
    }

    private List<EObject> ancestors(EObject eObject) {
        ArrayList<EObject> ret = new ArrayList<EObject>();
        EObject eContainer = eObject.eContainer();
        while (eContainer != null) {
            ret.add(eContainer);
            eContainer = eContainer.eContainer();
        }
        return ret;
    }

    private final DiffGroup firstReferencingDiffGroup(Collection<EStructuralFeature.Setting> settings) {
        if (settings != null) {
            for (EStructuralFeature.Setting setting : settings) {
                EObject eObject = setting.getEObject();
                if (setting.getEStructuralFeature() != DiffPackage.Literals.DIFF_GROUP__RIGHT_PARENT || !(eObject instanceof DiffGroup)) continue;
                return (DiffGroup)eObject;
            }
        }
        return null;
    }

    protected static final List<EObject> getInverseReferences(EObject lookup, EStructuralFeature inFeature) {
        return AbstractDiffExtensionFactory.getInverseReferences(lookup, inFeature, AbstractDiffExtensionFactory.alwaysTrue());
    }

    protected static final List<EObject> getInverseReferences(EObject lookup, EStructuralFeature inFeature, UMLPredicate<EStructuralFeature.Setting> alwaysTrue) {
        ArrayList<EObject> ret = new ArrayList<EObject>();
        for (EStructuralFeature.Setting setting : UML2Util.getInverseReferences((EObject)lookup)) {
            if (setting.getEStructuralFeature() != inFeature) continue;
            ret.add(setting.getEObject());
        }
        return ret;
    }

    protected static final List<EObject> getNonNavigableInverseReferences(EObject lookup, EStructuralFeature inFeature) {
        return AbstractDiffExtensionFactory.getNonNavigableInverseReferences(lookup, inFeature, AbstractDiffExtensionFactory.alwaysTrue());
    }

    protected static final List<EObject> getNonNavigableInverseReferences(EObject lookup, EStructuralFeature inFeature, UMLPredicate<EStructuralFeature.Setting> alwaysTrue) {
        ArrayList<EObject> ret = new ArrayList<EObject>();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)lookup)) {
            if (setting.getEStructuralFeature() != inFeature) continue;
            ret.add(setting.getEObject());
        }
        return ret;
    }

    protected final List<DiffElement> findCrossReferences(EObject lookup, EStructuralFeature inFeature) {
        return this.findCrossReferences(lookup, inFeature, AbstractDiffExtensionFactory.alwaysTrue());
    }

    protected final List<DiffElement> findCrossReferences(EObject lookup, EStructuralFeature inFeature, UMLPredicate<EStructuralFeature.Setting> p) {
        ArrayList<DiffElement> ret = new ArrayList<DiffElement>();
        Collection settings = (Collection)this.getCrossReferencer().get((Object)lookup);
        if (settings != null) {
            for (EStructuralFeature.Setting setting : settings) {
                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                if (eStructuralFeature != inFeature || !p.apply(setting)) continue;
                ret.add((DiffElement)setting.getEObject());
            }
        }
        return ret;
    }

    protected final void hideCrossReferences(EObject lookup, EStructuralFeature inFeature, AbstractDiffExtension hiddingExtension, UMLPredicate<EStructuralFeature.Setting> p) {
        for (DiffElement diffElement : this.findCrossReferences(lookup, inFeature, p)) {
            hiddingExtension.getHideElements().add((Object)diffElement);
        }
    }

    protected final void hideCrossReferences(EObject lookup, EStructuralFeature inFeature, AbstractDiffExtension hiddingExtension) {
        this.hideCrossReferences(lookup, inFeature, hiddingExtension, AbstractDiffExtensionFactory.alwaysTrue());
    }

    private static final UMLPredicate<EStructuralFeature.Setting> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface UMLPredicate<T> {
        public boolean apply(T var1);
    }
}

