/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchModel;
import org.eclipse.emf.compare.mpatch.binding.BindingFactory;
import org.eclipse.emf.compare.mpatch.binding.MPatchModelBinding;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResolvedSymbolicReferences {
    private final MPatchModel mpatch;
    private final EObject model;
    private final int direction;
    private final Map<IndepChange, Map<IElementReference, List<EObject>>> resolution;
    private final Map<IndepChange, ValidationResult> validation;
    private final Map<IElementReference, List<EObject>> resolutionRaw;
    private final Map<IElementReference, List<IElementReference>> equallyResolvingReferences;
    private final MPatchModelBinding binding;
    public static final int RESOLVE_UNCHANGED = 1;
    public static final int RESOLVE_CHANGED = 2;
    public static final Map<ValidationResult, String> VALIDATION_RESULTS;

    static {
        HashMap<ValidationResult, String> messageMap = new HashMap<ValidationResult, String>();
        messageMap.put(ValidationResult.STATE_BEFORE, "ok");
        messageMap.put(ValidationResult.STATE_AFTER, "applied");
        messageMap.put(ValidationResult.STATE_INVALID, "invalid state in model");
        messageMap.put(ValidationResult.REFERENCE, "check reference resolutions");
        messageMap.put(ValidationResult.UNKNOWN_CHANGE, "unknown change");
        VALIDATION_RESULTS = Collections.unmodifiableMap(messageMap);
    }

    public ResolvedSymbolicReferences(MPatchModel mpatch, EObject model, int direction, Map<IndepChange, Map<IElementReference, List<EObject>>> resolution, Map<IElementReference, List<EObject>> resolutionRaw, Map<IElementReference, List<IElementReference>> equallyResolvingReferences, Map<IndepChange, ValidationResult> validation) {
        this.mpatch = mpatch;
        this.direction = direction;
        this.model = model;
        this.resolution = resolution;
        this.resolutionRaw = resolutionRaw;
        this.equallyResolvingReferences = equallyResolvingReferences;
        this.validation = validation;
        this.binding = BindingFactory.eINSTANCE.createMPatchModelBinding();
        this.binding.setMPatchModel(mpatch);
        this.binding.setModel(model);
    }

    public MPatchModel getMPatchModel() {
        return this.mpatch;
    }

    public int getDirection() {
        return this.direction;
    }

    public MPatchModelBinding getMPatchModelBinding() {
        return this.binding;
    }

    public EObject getModel() {
        return this.model;
    }

    public Map<IElementReference, List<IElementReference>> getEquallyResolvingReferences() {
        return this.equallyResolvingReferences;
    }

    public List<IElementReference> getEquallyResolvingReferences(IElementReference reference) {
        if (!this.getEquallyResolvingReferences().containsKey(reference)) {
            throw new IllegalArgumentException("Reference not found in equally resolved references. Make sure that it belongs to the differences! " + reference);
        }
        ArrayList<IElementReference> list = new ArrayList<IElementReference>((Collection)this.getEquallyResolvingReferences().get(reference));
        list.remove(reference);
        return list;
    }

    public Map<IElementReference, List<EObject>> getRawResolution() {
        return this.resolutionRaw;
    }

    public Map<IndepChange, Map<IElementReference, List<EObject>>> getResolutionByChange() {
        return this.resolution;
    }

    public Map<IndepChange, ValidationResult> getValidation() {
        return this.validation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationResult {
        STATE_BEFORE,
        STATE_AFTER,
        STATE_INVALID,
        REFERENCE,
        UNKNOWN_CHANGE;

    }
}

