/*******************************************************************************
 * Copyright (c) 2010, 2011 Technical University of Denmark.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *    Patrick Koenemann, DTU Informatics - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.compare.mpatch.common.util;

/**
 * Commonly used constants in the differencing framework.
 * 
 * This class is not intended to be subclassed.
 * 
 * @author Patrick Koenemann (pk@imm.dtu.dk)
 */
public final class MPatchConstants {

	/**
	 * Our file extension.
	 */
	public static final String FILE_EXTENSION_MPATCH = "mpatch";
	
	/**
	 * EMF Compare file extension.
	 */
	public static final String FILE_EXTENSION_EMF_COMPARE = "emfdiff";
	
	/**
	 * File extension for binding.
	 */
	public static final String FILE_EXTENSION_MPATCH_BINDING = "binding";
	
	/**
	 * Name for symbolic references (plural).
	 */
	public static final String SYMBOLIC_REFERENCES_NAME = "Symbolic References";
	
	/**
	 * Name for symbolic reference (singular).
	 */
	public static final String SYMBOLIC_REFERENCE_NAME = "Symbolic Reference";
	
	/**
	 * The long name of the differences.
	 * 
	 * PK: Was previously "Model-independent Differences"
	 */
	public static final String MPATCH_LONG_NAME = "MPatch";
	
	/**
	 * The long name of the differences.
	 * 
	 * PK: Was previously "IndepDiff"
	 */
	public static final String MPATCH_SHORT_NAME = "MPatch";
	
}
