/**
 * Copyright (c) 2011 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 */
package org.eclipse.emf.compare.uml2diff;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.compare.uml2diff.UML2DiffPackage
 * @generated
 */
public interface UML2DiffFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	UML2DiffFactory eINSTANCE = org.eclipse.emf.compare.uml2diff.impl.UML2DiffFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>UML Association Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Association Change Left Target</em>'.
	 * @generated
	 */
	UMLAssociationChangeLeftTarget createUMLAssociationChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Association Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Association Change Right Target</em>'.
	 * @generated
	 */
	UMLAssociationChangeRightTarget createUMLAssociationChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Association Branch Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Association Branch Change Left Target</em>'.
	 * @generated
	 */
	UMLAssociationBranchChangeLeftTarget createUMLAssociationBranchChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Association Branch Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Association Branch Change Right Target</em>'.
	 * @generated
	 */
	UMLAssociationBranchChangeRightTarget createUMLAssociationBranchChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Dependency Branch Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Dependency Branch Change Left Target</em>'.
	 * @generated
	 */
	UMLDependencyBranchChangeLeftTarget createUMLDependencyBranchChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Dependency Branch Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Dependency Branch Change Right Target</em>'.
	 * @generated
	 */
	UMLDependencyBranchChangeRightTarget createUMLDependencyBranchChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Generalization Set Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Generalization Set Change Left Target</em>'.
	 * @generated
	 */
	UMLGeneralizationSetChangeLeftTarget createUMLGeneralizationSetChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Generalization Set Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Generalization Set Change Right Target</em>'.
	 * @generated
	 */
	UMLGeneralizationSetChangeRightTarget createUMLGeneralizationSetChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Dependency Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Dependency Change Left Target</em>'.
	 * @generated
	 */
	UMLDependencyChangeLeftTarget createUMLDependencyChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Dependency Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Dependency Change Right Target</em>'.
	 * @generated
	 */
	UMLDependencyChangeRightTarget createUMLDependencyChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Extend Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Extend Change Left Target</em>'.
	 * @generated
	 */
	UMLExtendChangeLeftTarget createUMLExtendChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Extend Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Extend Change Right Target</em>'.
	 * @generated
	 */
	UMLExtendChangeRightTarget createUMLExtendChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Execution Specification Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Execution Specification Change Left Target</em>'.
	 * @generated
	 */
	UMLExecutionSpecificationChangeLeftTarget createUMLExecutionSpecificationChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Execution Specification Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Execution Specification Change Right Target</em>'.
	 * @generated
	 */
	UMLExecutionSpecificationChangeRightTarget createUMLExecutionSpecificationChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Destruction Event Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Destruction Event Change Left Target</em>'.
	 * @generated
	 */
	UMLDestructionEventChangeLeftTarget createUMLDestructionEventChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Destruction Event Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Destruction Event Change Right Target</em>'.
	 * @generated
	 */
	UMLDestructionEventChangeRightTarget createUMLDestructionEventChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Interval Constraint Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Interval Constraint Change Left Target</em>'.
	 * @generated
	 */
	UMLIntervalConstraintChangeLeftTarget createUMLIntervalConstraintChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Interval Constraint Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Interval Constraint Change Right Target</em>'.
	 * @generated
	 */
	UMLIntervalConstraintChangeRightTarget createUMLIntervalConstraintChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Message Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Message Change Left Target</em>'.
	 * @generated
	 */
	UMLMessageChangeLeftTarget createUMLMessageChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Message Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Message Change Right Target</em>'.
	 * @generated
	 */
	UMLMessageChangeRightTarget createUMLMessageChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Stereotype Attribute Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Stereotype Attribute Change Left Target</em>'.
	 * @generated
	 */
	UMLStereotypeAttributeChangeLeftTarget createUMLStereotypeAttributeChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Stereotype Attribute Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Stereotype Attribute Change Right Target</em>'.
	 * @generated
	 */
	UMLStereotypeAttributeChangeRightTarget createUMLStereotypeAttributeChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Stereotype Update Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Stereotype Update Attribute</em>'.
	 * @generated
	 */
	UMLStereotypeUpdateAttribute createUMLStereotypeUpdateAttribute();

	/**
	 * Returns a new object of class '<em>UML Stereotype Application Addition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Stereotype Application Addition</em>'.
	 * @generated
	 */
	UMLStereotypeApplicationAddition createUMLStereotypeApplicationAddition();

	/**
	 * Returns a new object of class '<em>UML Stereotype Application Removal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Stereotype Application Removal</em>'.
	 * @generated
	 */
	UMLStereotypeApplicationRemoval createUMLStereotypeApplicationRemoval();

	/**
	 * Returns a new object of class '<em>UML Stereotype Reference Change Left Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Stereotype Reference Change Left Target</em>'.
	 * @generated
	 */
	UMLStereotypeReferenceChangeLeftTarget createUMLStereotypeReferenceChangeLeftTarget();

	/**
	 * Returns a new object of class '<em>UML Stereotype Reference Change Right Target</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Stereotype Reference Change Right Target</em>'.
	 * @generated
	 */
	UMLStereotypeReferenceChangeRightTarget createUMLStereotypeReferenceChangeRightTarget();

	/**
	 * Returns a new object of class '<em>UML Stereotype Update Reference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Stereotype Update Reference</em>'.
	 * @generated
	 */
	UMLStereotypeUpdateReference createUMLStereotypeUpdateReference();

	/**
	 * Returns a new object of class '<em>UML Stereotype Reference Order Change</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>UML Stereotype Reference Order Change</em>'.
	 * @generated
	 */
	UMLStereotypeReferenceOrderChange createUMLStereotypeReferenceOrderChange();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	UML2DiffPackage getUML2DiffPackage();

} //UML2DiffFactory
