/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.content;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class ModelContentMergeContentProvider
implements IMergeViewerContentProvider {
    private final CompareConfiguration configuration;

    public ModelContentMergeContentProvider(CompareConfiguration cc) {
        this.configuration = cc;
    }

    public void dispose() {
    }

    public Object getAncestorContent(Object element) {
        Object content = null;
        if (element instanceof ModelCompareInput) {
            Object diff = ((ModelCompareInput)element).getDiff();
            Resource res = ((ModelCompareInput)element).getAncestorResource();
            if (diff instanceof DiffResourceSet) {
                content = res != null && res.getResourceSet() != null ? new ArrayList(res.getResourceSet().getResources()) : ((ModelCompareInput)element).getAncestor();
            } else if (diff instanceof DiffModel) {
                content = res == null ? ((ModelCompareInput)element).getAncestor() : res;
            }
        } else if (element instanceof ICompareInput) {
            content = ((ICompareInput)element).getAncestor();
        }
        return content;
    }

    public Image getAncestorImage(Object element) {
        return this.configuration.getAncestorImage(element);
    }

    public String getAncestorLabel(Object element) {
        return this.configuration.getAncestorLabel(element);
    }

    public Object getLeftContent(Object element) {
        Object content = null;
        if (element instanceof ModelCompareInput) {
            Object diff = ((ModelCompareInput)element).getDiff();
            Resource res = ((ModelCompareInput)element).getLeftResource();
            if (diff instanceof DiffResourceSet) {
                content = res != null && res.getResourceSet() != null ? new ArrayList(res.getResourceSet().getResources()) : ((ModelCompareInput)element).getLeft();
            } else if (diff instanceof DiffModel) {
                content = res == null ? ((ModelCompareInput)element).getLeft() : res;
            }
        } else if (element instanceof ICompareInput) {
            content = ((ICompareInput)element).getLeft();
        }
        return content;
    }

    private boolean hasChanged(Resource res, DiffResourceSet diffResourceSet, Side side) {
        boolean changed = false;
        Iterator diffIterator = diffResourceSet.getDiffModels().iterator();
        while (!changed && diffIterator.hasNext()) {
            DiffModel diffModel = (DiffModel)diffIterator.next();
            if (side == Side.LEFT) {
                if (!res.getContents().containsAll((Collection)diffModel.getLeftRoots())) continue;
                changed = diffModel.getSubchanges() != 0;
                continue;
            }
            if (side == Side.RIGHT) {
                if (!res.getContents().containsAll((Collection)diffModel.getRightRoots())) continue;
                changed = diffModel.getSubchanges() != 0;
                continue;
            }
            if (!res.getContents().containsAll((Collection)diffModel.getAncestorRoots())) continue;
            boolean bl = changed = diffModel.getSubchanges() != 0;
        }
        return changed;
    }

    public Image getLeftImage(Object element) {
        return this.configuration.getLeftImage(element);
    }

    public String getLeftLabel(Object element) {
        return this.configuration.getLeftLabel(element);
    }

    public Object getRightContent(Object element) {
        Object content = null;
        if (element instanceof ModelCompareInput) {
            Object diff = ((ModelCompareInput)element).getDiff();
            Resource res = ((ModelCompareInput)element).getRightResource();
            if (diff instanceof DiffResourceSet) {
                content = res != null && res.getResourceSet() != null ? new ArrayList(res.getResourceSet().getResources()) : ((ModelCompareInput)element).getRight();
            } else if (diff instanceof DiffModel) {
                content = res == null ? ((ModelCompareInput)element).getRight() : res;
            }
        } else if (element instanceof ICompareInput) {
            content = ((ICompareInput)element).getRight();
        }
        return content;
    }

    public Image getRightImage(Object element) {
        return this.configuration.getRightImage(element);
    }

    public String getRightLabel(Object element) {
        return this.configuration.getRightLabel(element);
    }

    public void inputChanged(Viewer v, Object o1, Object o2) {
    }

    public boolean isLeftEditable(Object element) {
        return this.configuration.isLeftEditable();
    }

    public boolean isRightEditable(Object element) {
        return this.configuration.isRightEditable();
    }

    public void saveLeftContent(Object element, byte[] bytes) {
        ModelCompareInput input;
        if (element instanceof ModelCompareInput && (input = (ModelCompareInput)element).getLeftResource() != null) {
            try {
                input.getLeftResource().save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                EMFComparePlugin.log((String)e.getMessage(), (boolean)false);
            }
        }
    }

    public void saveRightContent(Object element, byte[] bytes) {
        ModelCompareInput input;
        if (element instanceof ModelCompareInput && (input = (ModelCompareInput)element).getRightResource() != null) {
            try {
                input.getRightResource().save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                EMFComparePlugin.log((String)e.getMessage(), (boolean)false);
            }
        }
    }

    public boolean showAncestor(Object element) {
        return element instanceof ICompareInput;
    }
}

