/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.mpatch.transform.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.compare.mpatch.IElementReference;
import org.eclipse.emf.compare.mpatch.IndepAddRemElementChange;
import org.eclipse.emf.compare.mpatch.IndepChange;
import org.eclipse.emf.compare.mpatch.MPatchPackage;
import org.eclipse.emf.compare.mpatch.common.util.CommonUtils;
import org.eclipse.emf.compare.mpatch.symrefs.Condition;
import org.eclipse.emf.compare.mpatch.symrefs.ElementSetReference;
import org.eclipse.emf.compare.mpatch.symrefs.OclCondition;
import org.eclipse.emf.compare.mpatch.symrefs.SymrefsFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeChangesGeneralizer {
    static IndepChange generalizeChanges(List<IndepChange> changes) {
        if (changes == null || changes.size() < 2) {
            return null;
        }
        IndepChange generalizedChange = (IndepChange)EcoreUtil.copy((EObject)changes.get(0));
        MergeChangesGeneralizer.mergeCorrespondingElement(generalizedChange, changes, MPatchPackage.Literals.INDEP_CHANGE__CORRESPONDING_ELEMENT);
        if (changes.get(0).getResultingElement() != null) {
            MergeChangesGeneralizer.mergeCorrespondingElement(generalizedChange, changes, MPatchPackage.Literals.INDEP_CHANGE__RESULTING_ELEMENT);
        }
        if (MPatchPackage.Literals.INDEP_ADD_REM_ELEMENT_CHANGE.isInstance((Object)generalizedChange)) {
            MergeChangesGeneralizer.mergeSelfReferences((IndepAddRemElementChange)generalizedChange, changes);
        }
        return generalizedChange;
    }

    private static void mergeSelfReferences(IndepAddRemElementChange generalizedChange, List<IndepChange> changes) {
        ArrayList<IElementReference> unmergedSelfSymrefs = new ArrayList<IElementReference>();
        for (IndepChange change : changes) {
            unmergedSelfSymrefs.add(((IndepAddRemElementChange)change).getSubModel().getSelfReference());
        }
        IElementReference mergedSelfSymref = MergeChangesGeneralizer.mergeSymbolicReferences(unmergedSelfSymrefs);
        generalizedChange.getSubModel().setSelfReference(mergedSelfSymref);
    }

    private static void mergeCorrespondingElement(IndepChange generalizedChange, List<IndepChange> changes, EReference feature) {
        if (!MPatchPackage.Literals.IELEMENT_REFERENCE.equals(feature.getEType())) {
            throw new IllegalArgumentException("The given feature does not contain symbolic references: " + feature.getName());
        }
        ArrayList<IElementReference> unmergedSymrefs = new ArrayList<IElementReference>();
        for (IndepChange change : changes) {
            unmergedSymrefs.add((IElementReference)change.eGet((EStructuralFeature)feature));
        }
        IElementReference mergedSymref = MergeChangesGeneralizer.mergeSymbolicReferences(unmergedSymrefs);
        generalizedChange.eSet((EStructuralFeature)feature, (Object)mergedSymref);
    }

    private static IElementReference mergeSymbolicReferences(List<IElementReference> unmergedSymrefs) {
        int upperBound = 0;
        ArrayList<IElementReference> contexts = new ArrayList<IElementReference>();
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> uris = new ArrayList<String>();
        for (IElementReference symref : unmergedSymrefs) {
            IElementReference context = ((ElementSetReference)symref).getContext();
            if (context != null) {
                contexts.add(context);
            }
            upperBound = upperBound == -1 || symref.getUpperBound() == -1 ? -1 : upperBound + symref.getUpperBound();
            labels.add(symref.getLabel());
            uris.add(symref.getUriReference());
        }
        if (!contexts.isEmpty() && contexts.size() != unmergedSymrefs.size()) {
            throw new IllegalArgumentException("Either all or no symbolic reference must have a context!");
        }
        List<String> conditions = MergeChangesGeneralizer.collectConditions(unmergedSymrefs);
        OclCondition condition = SymrefsFactory.eINSTANCE.createOclCondition();
        String mergedExpression = MergeChangesGeneralizer.mergeConditions(conditions);
        condition.setExpression(mergedExpression);
        ElementSetReference mergedSymbolicReference = SymrefsFactory.eINSTANCE.createElementSetReference();
        mergedSymbolicReference.setUpperBound(upperBound);
        mergedSymbolicReference.getConditions().add((Object)condition);
        mergedSymbolicReference.setType(unmergedSymrefs.get(0).getType());
        mergedSymbolicReference.setLabel(MergeChangesGeneralizer.createMergedLabel(labels));
        mergedSymbolicReference.setUriReference("Merged: " + CommonUtils.join(uris, (CharSequence)", "));
        if (!contexts.isEmpty()) {
            IElementReference context = MergeChangesGeneralizer.mergeSymbolicReferences(contexts);
            mergedSymbolicReference.setContext(context);
        }
        return mergedSymbolicReference;
    }

    private static String createMergedLabel(List<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return "";
        }
        HashSet<String> lab = new HashSet<String>(labels);
        return "Merged: " + CommonUtils.join(new ArrayList<String>(lab), (CharSequence)", ");
    }

    private static String mergeConditions(List<String> conditions) {
        String expression3;
        LinkedHashMap<String, Integer> expressions = new LinkedHashMap<String, Integer>();
        int max = conditions.size();
        for (String condition : conditions) {
            String[] stringArray = condition.split("and");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String expression2 = stringArray[n2];
                String trimmedExpression = expression2.trim();
                if (trimmedExpression.length() > 0) {
                    Integer counter = (Integer)expressions.get(trimmedExpression);
                    if (counter == null) {
                        expressions.put(trimmedExpression, 1);
                    } else {
                        expressions.put(trimmedExpression, counter + 1);
                    }
                }
                ++n2;
            }
        }
        ArrayList<String> commonExpressions = new ArrayList<String>();
        for (String expression3 : expressions.keySet()) {
            if ((Integer)expressions.get(expression3) != max) continue;
            commonExpressions.add(expression3);
        }
        expression3 = !commonExpressions.isEmpty() ? CommonUtils.join(commonExpressions, (CharSequence)" and ") : "true";
        return expression3;
    }

    private static List<String> collectConditions(List<IElementReference> symrefs) {
        ArrayList<String> conditions = new ArrayList<String>();
        for (IElementReference symref : symrefs) {
            if (symref instanceof ElementSetReference) {
                ElementSetReference setSymref = (ElementSetReference)symref;
                if (setSymref.getConditions().size() == 1) {
                    Condition condition = (Condition)setSymref.getConditions().get(0);
                    if (condition instanceof OclCondition) {
                        conditions.add(((OclCondition)condition).getExpression());
                        continue;
                    }
                    throw new IllegalArgumentException("Only OCL conditions are supported at the moment, not: " + condition);
                }
                throw new IllegalArgumentException("Symbolic references must contain one condition only, but here, " + setSymref.getConditions().size() + " are found: " + setSymref);
            }
            throw new IllegalArgumentException("Symbolic references must be of type ElementSetReference! But found: " + symref);
        }
        if (conditions.size() != symrefs.size()) {
            throw new IllegalArgumentException("Number of collected conditions and number of unmerged symbolic references differ! Aborting...");
        }
        return conditions;
    }
}

